/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableComparator;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.ResultSetOutOfScanRangeException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.DescVarLengthFastByteComparisons;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.AllVersionsIndexRebuildFilter;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.filter.EmptyColumnOnlyFilter;
import org.apache.phoenix.filter.EncodedQualifiersColumnProjectionFilter;
import org.apache.phoenix.filter.MultiEncodedCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.PagingFilter;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.CDCTableInfo;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.TransformClient;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanUtil.class);
    public static final int[] SINGLE_COLUMN_SLOT_SPAN = new int[1];
    public static final int UNKNOWN_CLIENT_VERSION = VersionUtil.encodeVersion(4, 4, 0);
    private static final byte[] ZERO_BYTE_ARRAY = new byte[1024];
    private static final String RESULT_IS_OUT_OF_SCAN_START_KEY = "Row key of the result is out of scan start key range";
    private static final String RESULT_IS_OUT_OF_SCAN_STOP_KEY = "Row key of the result is out of scan stop key range";
    private static final BytesComparator DESC_VAR_WIDTH_COMPARATOR = new BytesComparator(){

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return DescVarLengthFastByteComparisons.compareTo(b1, s1, l1, b2, s2, l2);
        }
    };
    private static final BytesComparator ASC_FIXED_WIDTH_COMPARATOR = new BytesComparator(){

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return WritableComparator.compareBytes((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
        }
    };

    private ScanUtil() {
    }

    public static void setTenantId(Scan scan, byte[] tenantId) {
        scan.setAttribute("TenantId", tenantId);
    }

    public static void setLocalIndex(Scan scan) {
        scan.setAttribute("_LocalIndex", PDataType.TRUE_BYTES);
    }

    public static void setUncoveredGlobalIndex(Scan scan) {
        scan.setAttribute("_UncoveredGlobalIndex", PDataType.TRUE_BYTES);
    }

    public static boolean isLocalIndex(Scan scan) {
        return scan.getAttribute("_LocalIndex") != null;
    }

    public static boolean isUncoveredGlobalIndex(Scan scan) {
        return scan.getAttribute("_UncoveredGlobalIndex") != null;
    }

    public static boolean isLocalOrUncoveredGlobalIndex(Scan scan) {
        return ScanUtil.isLocalIndex(scan) || ScanUtil.isUncoveredGlobalIndex(scan);
    }

    public static boolean isNonAggregateScan(Scan scan) {
        return scan.getAttribute("_NonAggregateQuery") != null;
    }

    public static boolean isSimpleScan(Scan scan) {
        return ScanUtil.isNonAggregateScan(scan) && scan.getAttribute("_TopN") == null && scan.getAttribute("_RowOffset") == null;
    }

    public static ImmutableBytesPtr getTenantId(Scan scan) {
        byte[] tenantId = scan.getAttribute("TenantId");
        if (tenantId == null) {
            return null;
        }
        return new ImmutableBytesPtr(tenantId);
    }

    public static void setCustomAnnotations(Scan scan, byte[] annotations) {
        scan.setAttribute("_Annot", annotations);
    }

    public static byte[] getCustomAnnotations(Scan scan) {
        return scan.getAttribute("_Annot");
    }

    public static Scan newScan(Scan scan) {
        try {
            Scan newScan = new Scan(scan);
            TreeMap existingMap = (TreeMap)scan.getFamilyMap();
            TreeMap clonedMap = new TreeMap(existingMap);
            newScan.setFamilyMap(clonedMap);
            newScan.setReversed(scan.isReversed());
            if (scan.getReadType() == Scan.ReadType.PREAD) {
                newScan.setReadType(Scan.ReadType.PREAD);
            }
            return newScan;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey) {
        return ScanUtil.intersectScanRange(scan, startKey, stopKey, false);
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey, boolean useSkipScan) {
        boolean mayHaveRows = false;
        int offset = 0;
        if (ScanUtil.isLocalIndex(scan)) {
            offset = startKey.length != 0 ? startKey.length : stopKey.length;
        }
        byte[] existingStartKey = scan.getStartRow();
        byte[] existingStopKey = scan.getStopRow();
        if (existingStartKey.length > 0) {
            if (startKey.length == 0 || Bytes.compareTo((byte[])existingStartKey, (byte[])startKey) > 0) {
                startKey = existingStartKey;
            }
        } else {
            mayHaveRows = true;
        }
        if (existingStopKey.length > 0) {
            if (stopKey.length == 0 || Bytes.compareTo((byte[])existingStopKey, (byte[])stopKey) < 0) {
                stopKey = existingStopKey;
            }
        } else {
            mayHaveRows = true;
        }
        scan.withStartRow(startKey);
        scan.withStopRow(stopKey);
        if (offset > 0 && useSkipScan) {
            byte[] temp = null;
            if (startKey.length != 0) {
                temp = new byte[startKey.length - offset];
                System.arraycopy(startKey, offset, temp, 0, startKey.length - offset);
                startKey = temp;
            }
            if (stopKey.length != 0) {
                temp = new byte[stopKey.length - offset];
                System.arraycopy(stopKey, offset, temp, 0, stopKey.length - offset);
                stopKey = temp;
            }
        }
        boolean bl = mayHaveRows = mayHaveRows || Bytes.compareTo((byte[])scan.getStartRow(), (byte[])scan.getStopRow()) < 0;
        if (mayHaveRows && useSkipScan) {
            Filter filter = scan.getFilter();
            if (filter instanceof SkipScanFilter) {
                SkipScanFilter oldFilter = (SkipScanFilter)filter;
                SkipScanFilter newFilter = oldFilter.intersect(startKey, stopKey);
                if (newFilter == null) {
                    return false;
                }
                scan.setFilter((Filter)newFilter);
            } else if (filter instanceof FilterList) {
                FilterList oldList = (FilterList)filter;
                FilterList newList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                for (Filter f : oldList.getFilters()) {
                    if (f instanceof SkipScanFilter) {
                        SkipScanFilter newFilter = ((SkipScanFilter)f).intersect(startKey, stopKey);
                        if (newFilter == null) {
                            return false;
                        }
                        newList.addFilter((Filter)newFilter);
                        continue;
                    }
                    newList.addFilter(f);
                }
                scan.setFilter((Filter)newList);
            }
        }
        return mayHaveRows;
    }

    public static void andFilterAtBeginning(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.add(andWithFilter);
            allFilters.addAll(filterList.getFilters());
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(andWithFilter, filter)));
        }
    }

    public static void andFilterAtEnd(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.addAll(filterList.getFilters());
            allFilters.add(andWithFilter);
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filter, andWithFilter)));
        }
    }

    public static void setQualifierRangesOnFilter(Scan scan, Pair<Integer, Integer> minMaxQualifiers) {
        Filter filter = scan.getFilter();
        if (filter != null) {
            if (filter instanceof FilterList) {
                for (Filter f : ((FilterList)filter).getFilters()) {
                    if (!(f instanceof MultiEncodedCQKeyValueComparisonFilter)) continue;
                    ((MultiEncodedCQKeyValueComparisonFilter)f).setMinMaxQualifierRange(minMaxQualifiers);
                }
            } else if (filter instanceof MultiEncodedCQKeyValueComparisonFilter) {
                ((MultiEncodedCQKeyValueComparisonFilter)filter).setMinMaxQualifierRange(minMaxQualifiers);
            }
        }
    }

    public static void setTimeRange(Scan scan, long ts) {
        try {
            scan.setTimeRange(0L, ts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setTimeRange(Scan scan, TimeRange range) {
        try {
            scan.setTimeRange(range.getMin(), range.getMax());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setTimeRange(Scan scan, long minStamp, long maxStamp) {
        try {
            scan.setTimeRange(minStamp, maxStamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getMinKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan) {
        return ScanUtil.getKey(schema, slots, slotSpan, KeyRange.Bound.LOWER);
    }

    public static byte[] getMaxKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan) {
        return ScanUtil.getKey(schema, slots, slotSpan, KeyRange.Bound.UPPER);
    }

    private static byte[] getKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, KeyRange.Bound bound) {
        if (slots.isEmpty()) {
            return KeyRange.UNBOUND;
        }
        int[] position = new int[slots.size()];
        int maxLength = 0;
        int slotEndingFieldPos = -1;
        for (int i = 0; i < position.length; ++i) {
            position[i] = bound == KeyRange.Bound.LOWER ? 0 : slots.get(i).size() - 1;
            KeyRange range = slots.get(i).get(position[i]);
            slotEndingFieldPos = slotEndingFieldPos + slotSpan[i] + 1;
            ValueSchema.Field field = schema.getField(slotEndingFieldPos);
            int keyLength = range.getRange(bound).length;
            if (!field.getDataType().isFixedWidth()) {
                if (field.getDataType() != PVarbinaryEncoded.INSTANCE) {
                    ++keyLength;
                    if (range.isUnbound(bound) && !range.isInclusive(bound) && field.getSortOrder() == SortOrder.DESC) {
                        ++keyLength;
                    }
                } else {
                    keyLength += 2;
                    if (range.isUnbound(bound) && !range.isInclusive(bound) && field.getSortOrder() == SortOrder.DESC) {
                        keyLength += 2;
                    }
                }
            }
            maxLength += keyLength;
        }
        byte[] key = new byte[maxLength];
        int length = ScanUtil.setKey(schema, slots, slotSpan, position, bound, key, 0, 0, position.length);
        if (length == 0) {
            return KeyRange.UNBOUND;
        }
        if (length == maxLength) {
            return key;
        }
        byte[] keyCopy = new byte[length];
        System.arraycopy(key, 0, keyCopy, 0, length);
        return keyCopy;
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex) {
        return ScanUtil.setKey(schema, slots, slotSpan, position, bound, key, byteOffset, slotStartIndex, slotEndIndex, slotStartIndex);
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex, int schemaStartIndex) {
        int offset = byteOffset;
        boolean lastInclusiveUpperSingleKey = false;
        boolean anyInclusiveUpperRangeKey = false;
        boolean lastUnboundUpper = false;
        ValueSchema.Field field = null;
        int i = slotStartIndex;
        int fieldIndex = ScanUtil.getRowKeyPosition(slotSpan, slotStartIndex);
        for (i = slotStartIndex; i < slotEndIndex; ++i) {
            KeyRange range = slots.get(i).get(position[i]);
            field = schema.getField(fieldIndex + slotSpan[i]);
            boolean isFixedWidth = field.getDataType().isFixedWidth();
            lastUnboundUpper = false;
            if (range.isUnbound(bound) && (bound == KeyRange.Bound.UPPER || isFixedWidth)) {
                lastUnboundUpper = bound == KeyRange.Bound.UPPER;
                break;
            }
            byte[] bytes = range.getRange(bound);
            System.arraycopy(bytes, 0, key, offset, bytes.length);
            offset += bytes.length;
            boolean inclusiveUpper = range.isUpperInclusive() && bound == KeyRange.Bound.UPPER;
            boolean exclusiveLower = !range.isLowerInclusive() && bound == KeyRange.Bound.LOWER && range != KeyRange.EVERYTHING_RANGE;
            boolean exclusiveUpper = !range.isUpperInclusive() && bound == KeyRange.Bound.UPPER;
            lastInclusiveUpperSingleKey = range.isSingleKey() && inclusiveUpper;
            anyInclusiveUpperRangeKey |= !range.isSingleKey() && inclusiveUpper;
            if (field.getDataType() != PVarbinaryEncoded.INSTANCE) {
                byte sepByte = SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), bytes.length == 0, field);
                if (!isFixedWidth && (sepByte == QueryConstants.DESC_SEPARATOR_BYTE || !exclusiveUpper && (fieldIndex < schema.getMaxFields() || inclusiveUpper || exclusiveLower))) {
                    key[offset++] = sepByte;
                    if (sepByte != QueryConstants.DESC_SEPARATOR_BYTE) {
                        lastInclusiveUpperSingleKey &= fieldIndex + slotSpan[i] < schema.getMaxFields() - 1;
                    }
                }
            } else {
                byte[] sepBytes = SchemaUtil.getSeparatorBytesForVarBinaryEncoded(schema.rowKeyOrderOptimizable(), bytes.length == 0, field.getSortOrder());
                if (!isFixedWidth && (sepBytes == QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES || !exclusiveUpper && (fieldIndex < schema.getMaxFields() || inclusiveUpper || exclusiveLower))) {
                    key[offset++] = sepBytes[0];
                    key[offset++] = sepBytes[1];
                    if (sepBytes != QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES) {
                        lastInclusiveUpperSingleKey &= fieldIndex + slotSpan[i] < schema.getMaxFields() - 1;
                    }
                }
            }
            if (exclusiveUpper) break;
            if (exclusiveLower) {
                if (!ByteUtil.nextKey(key, offset)) {
                    return -byteOffset;
                }
                if (field.getDataType() != PVarbinaryEncoded.INSTANCE) {
                    if (!isFixedWidth && bytes.length == 0 && SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), false, field) == QueryConstants.DESC_SEPARATOR_BYTE) {
                        key[offset++] = QueryConstants.DESC_SEPARATOR_BYTE;
                    }
                } else if (!isFixedWidth && bytes.length == 0 && SchemaUtil.getSeparatorBytesForVarBinaryEncoded(schema.rowKeyOrderOptimizable(), false, field.getSortOrder()) == QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES) {
                    key[offset++] = QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES[0];
                    key[offset++] = QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES[1];
                }
            }
            fieldIndex += slotSpan[i] + 1;
        }
        if ((lastInclusiveUpperSingleKey || anyInclusiveUpperRangeKey || lastUnboundUpper) && !ByteUtil.nextKey(key, offset)) {
            return -byteOffset;
        }
        if (bound == KeyRange.Bound.LOWER) {
            while (--i >= schemaStartIndex && offset > byteOffset && !(field = schema.getField(--fieldIndex)).getDataType().isFixedWidth() && field.getSortOrder() == SortOrder.ASC && ScanUtil.hasSeparatorBytes(key, field, offset)) {
                if (field.getDataType() != PVarbinaryEncoded.INSTANCE) {
                    --offset;
                    fieldIndex -= slotSpan[i];
                    continue;
                }
                offset -= 2;
                fieldIndex -= slotSpan[i];
            }
        }
        return offset - byteOffset;
    }

    private static boolean hasSeparatorBytes(byte[] key, ValueSchema.Field field, int offset) {
        return field.getDataType() != PVarbinaryEncoded.INSTANCE && key[offset - 1] == 0 || field.getDataType() == PVarbinaryEncoded.INSTANCE && offset >= 2 && key[offset - 1] == QueryConstants.VARBINARY_ENCODED_SEPARATOR_BYTES[1] && key[offset - 2] == QueryConstants.VARBINARY_ENCODED_SEPARATOR_BYTES[0];
    }

    public static boolean adjustScanFilterForGlobalIndexRegionScanner(Scan scan) {
        Filter filter = scan.getFilter();
        if (filter instanceof PagingFilter) {
            PagingFilter pageFilter = (PagingFilter)filter;
            Filter delegateFilter = pageFilter.getDelegateFilter();
            if (delegateFilter instanceof EmptyColumnOnlyFilter) {
                pageFilter.setDelegateFilter(null);
            } else {
                if (delegateFilter instanceof FirstKeyOnlyFilter) {
                    scan.setFilter(null);
                    return true;
                }
                if (delegateFilter != null) {
                    pageFilter.setDelegateFilter((Filter)new AllVersionsIndexRebuildFilter(delegateFilter));
                }
            }
        } else {
            if (filter instanceof EmptyColumnOnlyFilter) {
                scan.setFilter(null);
                return true;
            }
            if (filter instanceof FirstKeyOnlyFilter) {
                scan.setFilter(null);
                return true;
            }
            if (filter != null) {
                scan.setFilter((Filter)new AllVersionsIndexRebuildFilter(filter));
            }
        }
        return false;
    }

    public static void adjustScanFilterForCDC(Scan scan) {
        Filter originalFilter = scan.getFilter();
        if (originalFilter instanceof FilterList) {
            FilterList filterList = (FilterList)originalFilter;
            List filters = filterList.getFilters();
            ArrayList<Filter> newFilters = new ArrayList<Filter>();
            boolean filtersRemoved = false;
            for (Filter filter : filters) {
                if (!(filter instanceof EmptyColumnOnlyFilter) && !(filter instanceof FirstKeyOnlyFilter)) {
                    newFilters.add(filter);
                    continue;
                }
                filtersRemoved = true;
            }
            if (filtersRemoved) {
                if (newFilters.isEmpty()) {
                    scan.setFilter(null);
                } else if (newFilters.size() == 1) {
                    scan.setFilter((Filter)newFilters.get(0));
                } else {
                    FilterList newFilterList = new FilterList(filterList.getOperator(), newFilters);
                    scan.setFilter((Filter)newFilterList);
                }
            }
        } else {
            ScanUtil.adjustScanFilterForGlobalIndexRegionScanner(scan);
        }
    }

    public static BytesComparator getComparator(boolean isFixedWidth, SortOrder sortOrder) {
        return isFixedWidth || sortOrder == SortOrder.ASC ? ASC_FIXED_WIDTH_COMPARATOR : DESC_VAR_WIDTH_COMPARATOR;
    }

    public static BytesComparator getComparator(ValueSchema.Field field) {
        return ScanUtil.getComparator(field.getDataType().isFixedWidth(), field.getSortOrder());
    }

    public static int searchClosestKeyRangeWithUpperHigherThanPtr(List<KeyRange> slots, ImmutableBytesWritable ptr, int lower, ValueSchema.Field field) {
        int mid;
        int upper = slots.size() - 1;
        BytesComparator comparator = ScanUtil.getComparator(field.getDataType().isFixedWidth(), field.getSortOrder());
        while (lower <= upper) {
            mid = (lower + upper) / 2;
            int cmp = slots.get(mid).compareUpperToLowerBound(ptr, true, comparator);
            if (cmp < 0) {
                lower = mid + 1;
                continue;
            }
            if (cmp > 0) {
                upper = mid - 1;
                continue;
            }
            return mid;
        }
        mid = (lower + upper) / 2;
        if (mid == 0 && slots.get(mid).compareUpperToLowerBound(ptr, true, comparator) > 0) {
            return mid;
        }
        return ++mid;
    }

    public static ScanRanges newScanRanges(List<? extends Mutation> mutations) throws SQLException {
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)mutations.size());
        for (Mutation mutation : mutations) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(mutation.getRow(), SortOrder.ASC));
        }
        ScanRanges keyRanges = ScanRanges.createPointLookup(keys);
        return keyRanges;
    }

    public static KeyRange convertToInclusiveExclusiveRange(KeyRange partialRange, RowKeySchema schema, ImmutableBytesWritable ptr) {
        byte[] lowerRange = partialRange.getLowerRange();
        if (!partialRange.lowerUnbound() && !partialRange.isLowerInclusive()) {
            lowerRange = ScanUtil.nextKey(lowerRange, schema, ptr);
        }
        byte[] upperRange = partialRange.getUpperRange();
        if (!partialRange.upperUnbound() && partialRange.isUpperInclusive()) {
            upperRange = ScanUtil.nextKey(upperRange, schema, ptr);
        }
        if (partialRange.getLowerRange() != lowerRange || partialRange.getUpperRange() != upperRange) {
            partialRange = KeyRange.getKeyRange(lowerRange, upperRange);
        }
        return partialRange;
    }

    private static byte[] nextKey(byte[] key, RowKeySchema schema, ImmutableBytesWritable ptr) {
        int pos = 0;
        int maxOffset = schema.iterator(key, ptr);
        while (schema.next(ptr, pos, maxOffset) != null) {
            ++pos;
        }
        ValueSchema.Field field = schema.getField(pos - 1);
        if (!field.getDataType().isFixedWidth()) {
            if (field.getDataType() != PVarbinaryEncoded.INSTANCE) {
                byte[] newLowerRange = new byte[key.length + 1];
                System.arraycopy(key, 0, newLowerRange, 0, key.length);
                newLowerRange[key.length] = SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), key.length == 0, field);
                key = newLowerRange;
            } else {
                byte[] newLowerRange = new byte[key.length + 2];
                System.arraycopy(key, 0, newLowerRange, 0, key.length);
                byte[] sepBytes = SchemaUtil.getSeparatorBytesForVarBinaryEncoded(schema.rowKeyOrderOptimizable(), key.length == 0, field.getSortOrder());
                newLowerRange[key.length] = sepBytes[0];
                newLowerRange[key.length + 1] = sepBytes[1];
                key = newLowerRange;
            }
        } else {
            key = Arrays.copyOf(key, key.length);
        }
        ByteUtil.nextKey(key, key.length);
        return key;
    }

    public static boolean isReversed(Scan scan) {
        return scan.getAttribute("_ReverseScan") != null;
    }

    public static void setReversed(Scan scan) {
        scan.setAttribute("_ReverseScan", PDataType.TRUE_BYTES);
        scan.setLoadColumnFamiliesOnDemand(false);
    }

    public static void unsetReversed(Scan scan) {
        scan.setAttribute("_ReverseScan", PDataType.FALSE_BYTES);
        scan.setLoadColumnFamiliesOnDemand(true);
    }

    public static void setupReverseScan(Scan scan) {
        if (ScanUtil.isReversed(scan) && !scan.isReversed()) {
            byte[] tmpStartRow = scan.getStartRow();
            boolean tmpIncludeStartRow = scan.includeStartRow();
            scan.withStartRow(scan.getStopRow(), scan.includeStopRow());
            scan.withStopRow(tmpStartRow, tmpIncludeStartRow);
            scan.setReversed(true);
        }
    }

    public static void setupLocalIndexScan(Scan scan) {
        int prefixLength;
        byte[] prefix = scan.getStartRow().length == 0 ? new byte[scan.getStopRow().length] : scan.getStartRow();
        int n = prefixLength = scan.getStartRow().length == 0 ? scan.getStopRow().length : scan.getStartRow().length;
        if (scan.getAttribute("_ScanStartRowSuffix") != null) {
            scan.withStartRow(ScanRanges.prefixKey(scan.getAttribute("_ScanStartRowSuffix"), 0, prefix, prefixLength));
        }
        if (scan.getAttribute("_ScanStopRowSuffix") != null) {
            scan.withStopRow(ScanRanges.prefixKey(scan.getAttribute("_ScanStopRowSuffix"), 0, prefix, prefixLength));
        }
    }

    public static byte[] getActualStartRow(Scan localIndexScan, RegionInfo regionInfo) {
        return localIndexScan.getAttribute("_ScanStartRowSuffix") == null ? localIndexScan.getStartRow() : ScanRanges.prefixKey(localIndexScan.getAttribute("_ScanStartRowSuffix"), 0, regionInfo.getStartKey().length == 0 ? new byte[regionInfo.getEndKey().length] : regionInfo.getStartKey(), regionInfo.getStartKey().length == 0 ? regionInfo.getEndKey().length : regionInfo.getStartKey().length);
    }

    public static void setLocalIndexAttributes(Scan newScan, int keyOffset, byte[] regionStartKey, byte[] regionEndKey, byte[] startRowSuffix, byte[] stopRowSuffix) {
        if (ScanUtil.isLocalIndex(newScan)) {
            newScan.setAttribute("_ScanActualStartRow", regionStartKey);
            newScan.withStartRow(regionStartKey);
            newScan.withStopRow(regionEndKey);
            if (keyOffset > 0) {
                newScan.setAttribute("_ScanStartRowSuffix", ScanRanges.stripPrefix(startRowSuffix, keyOffset));
            } else {
                newScan.setAttribute("_ScanStartRowSuffix", startRowSuffix);
            }
            if (keyOffset > 0) {
                newScan.setAttribute("_ScanStopRowSuffix", ScanRanges.stripPrefix(stopRowSuffix, keyOffset));
            } else {
                newScan.setAttribute("_ScanStopRowSuffix", stopRowSuffix);
            }
        }
    }

    public static boolean isContextScan(Scan scan, StatementContext context) {
        return Bytes.compareTo((byte[])context.getScan().getStartRow(), (byte[])scan.getStartRow()) == 0 && Bytes.compareTo((byte[])context.getScan().getStopRow(), (byte[])scan.getStopRow()) == 0;
    }

    public static int getRowKeyOffset(byte[] regionStartKey, byte[] regionEndKey) {
        return regionStartKey.length > 0 ? regionStartKey.length : regionEndKey.length;
    }

    private static void setRowKeyOffset(Filter filter, int offset) {
        if (filter instanceof BooleanExpressionFilter) {
            BooleanExpressionFilter boolFilter = (BooleanExpressionFilter)filter;
            IndexUtil.setRowKeyExpressionOffset(boolFilter.getExpression(), offset);
        } else if (filter instanceof SkipScanFilter) {
            SkipScanFilter skipScanFilter = (SkipScanFilter)filter;
            skipScanFilter.setOffset(offset);
        } else if (filter instanceof DistinctPrefixFilter) {
            DistinctPrefixFilter prefixFilter = (DistinctPrefixFilter)filter;
            prefixFilter.setOffset(offset);
        }
    }

    public static void setRowKeyOffset(Scan scan, int offset) {
        Filter filter = scan.getFilter();
        if (filter == null) {
            return;
        }
        if (filter instanceof PagingFilter && (filter = ((PagingFilter)filter).getDelegateFilter()) == null) {
            return;
        }
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            for (Filter childFilter : filterList.getFilters()) {
                ScanUtil.setRowKeyOffset(childFilter, offset);
            }
        } else {
            ScanUtil.setRowKeyOffset(filter, offset);
        }
    }

    public static int[] getDefaultSlotSpans(int nSlots) {
        return new int[nSlots];
    }

    public static int getRowKeyPosition(int[] slotSpan, int slotPosition) {
        int offset = 0;
        for (int i = 0; i < slotPosition; ++i) {
            offset += slotSpan[i];
        }
        return offset + slotPosition;
    }

    public static boolean isAnalyzeTable(Scan scan) {
        return scan.getAttribute("_ANALYZETABLE") != null;
    }

    public static boolean crossesPrefixBoundary(byte[] key, byte[] prefixBytes, int prefixLength) {
        if (key.length < prefixLength) {
            return true;
        }
        if (prefixBytes.length >= prefixLength) {
            return Bytes.compareTo((byte[])prefixBytes, (int)0, (int)prefixLength, (byte[])key, (int)0, (int)prefixLength) != 0;
        }
        return ScanUtil.hasNonZeroLeadingBytes(key, prefixLength);
    }

    public static byte[] getPrefix(byte[] startKey, int prefixLength) {
        return startKey.length >= prefixLength ? startKey : ByteUtil.EMPTY_BYTE_ARRAY;
    }

    private static boolean hasNonZeroLeadingBytes(byte[] key, int nBytesToCheck) {
        if (nBytesToCheck > ZERO_BYTE_ARRAY.length) {
            do {
                if (Bytes.compareTo((byte[])key, (int)(nBytesToCheck - ZERO_BYTE_ARRAY.length), (int)ZERO_BYTE_ARRAY.length, (byte[])ZERO_BYTE_ARRAY, (int)0, (int)ZERO_BYTE_ARRAY.length) == 0) continue;
                return true;
            } while ((nBytesToCheck -= ZERO_BYTE_ARRAY.length) > ZERO_BYTE_ARRAY.length);
        }
        return Bytes.compareTo((byte[])key, (int)0, (int)nBytesToCheck, (byte[])ZERO_BYTE_ARRAY, (int)0, (int)nBytesToCheck) != 0;
    }

    public static byte[] getTenantIdBytes(RowKeySchema schema, boolean isSalted, PName tenantId, boolean isMultiTenantTable, boolean isSharedIndex) throws SQLException {
        return isMultiTenantTable ? ScanUtil.getTenantIdBytes(schema, isSalted, tenantId, isSharedIndex) : tenantId.getBytes();
    }

    public static byte[] getTenantIdBytes(RowKeySchema schema, boolean isSalted, PName tenantId, boolean isSharedIndex) throws SQLException {
        byte[] convertedValue;
        int pkPos = (isSalted ? 1 : 0) + (isSharedIndex ? 1 : 0);
        ValueSchema.Field field = schema.getField(pkPos);
        PDataType dataType = field.getDataType();
        try {
            Object value = dataType.toObject(tenantId.getString());
            convertedValue = dataType.toBytes(value);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable(convertedValue);
            dataType.pad(ptr, field.getMaxLength(), field.getSortOrder());
            convertedValue = ByteUtil.copyKeyBytesIfNecessary(ptr);
        }
        catch (IllegalDataException ex) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TENANTID_IS_OF_WRONG_TYPE).build().buildException();
        }
        return convertedValue;
    }

    public static Iterator<Filter> getFilterIterator(Scan scan) {
        Filter topLevelFilter = scan.getFilter();
        Object filterIterator = topLevelFilter == null ? Collections.emptyIterator() : (topLevelFilter instanceof FilterList ? ((FilterList)topLevelFilter).getFilters().iterator() : Iterators.singletonIterator((Object)topLevelFilter));
        return filterIterator;
    }

    public static boolean isRoundRobinPossible(OrderByCompiler.OrderBy orderBy, StatementContext context) throws SQLException {
        int fetchSize = context.getStatement().getFetchSize();
        return fetchSize > 1 && !ScanUtil.shouldRowsBeInRowKeyOrder(orderBy, context) && orderBy.getOrderByExpressions().isEmpty();
    }

    public static boolean forceRowKeyOrder(StatementContext context) {
        return context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.force.rowkeyorder", false);
    }

    public static boolean shouldRowsBeInRowKeyOrder(OrderByCompiler.OrderBy orderBy, StatementContext context) {
        return ScanUtil.forceRowKeyOrder(context) || orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY;
    }

    public static TimeRange intersectTimeRange(TimeRange rowTimestampColRange, TimeRange scanTimeRange, Long scn) throws IOException, SQLException {
        long scnToUse = scn == null ? Long.MAX_VALUE : scn;
        long lowerRangeToBe = 0L;
        long upperRangeToBe = scnToUse;
        if (rowTimestampColRange != null) {
            long minRowTimestamp = rowTimestampColRange.getMin();
            long maxRowTimestamp = rowTimestampColRange.getMax();
            if (lowerRangeToBe > maxRowTimestamp || upperRangeToBe < minRowTimestamp) {
                return null;
            }
            lowerRangeToBe = Math.max(lowerRangeToBe, minRowTimestamp);
            upperRangeToBe = Math.min(upperRangeToBe, maxRowTimestamp);
        }
        if (scanTimeRange != null) {
            long minScanTimeRange = scanTimeRange.getMin();
            long maxScanTimeRange = scanTimeRange.getMax();
            if (lowerRangeToBe > maxScanTimeRange || upperRangeToBe < lowerRangeToBe) {
                return null;
            }
            lowerRangeToBe = Math.max(lowerRangeToBe, minScanTimeRange);
            upperRangeToBe = Math.min(upperRangeToBe, maxScanTimeRange);
        }
        return TimeRange.between((long)lowerRangeToBe, (long)upperRangeToBe);
    }

    public static boolean isDefaultTimeRange(TimeRange range) {
        return range.getMin() == 0L && range.getMax() == Long.MAX_VALUE;
    }

    public static boolean isPacingScannersPossible(StatementContext context) {
        return context.getConnection().getQueryServices().isRenewingLeasesEnabled();
    }

    public static void addOffsetAttribute(Scan scan, Integer offset) {
        scan.setAttribute("_RowOffset", Bytes.toBytes((int)offset));
    }

    public static final boolean canQueryBeExecutedSerially(PTable table, OrderByCompiler.OrderBy orderBy, StatementContext context) {
        return orderBy.getOrderByExpressions().isEmpty() && (table.getBucketNum() == null && table.getIndexType() != PTable.IndexType.LOCAL || !ScanUtil.shouldRowsBeInRowKeyOrder(orderBy, context));
    }

    public static boolean hasDynamicColumns(PTable table) {
        for (PColumn col : table.getColumns()) {
            if (!col.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isIndexRebuild(Scan scan) {
        return scan.getAttribute("_RebuildIndexes") != null;
    }

    public static int getClientVersion(Scan scan) {
        int clientVersion = UNKNOWN_CLIENT_VERSION;
        byte[] clientVersionBytes = scan.getAttribute("_ClientVersion");
        if (clientVersionBytes != null) {
            clientVersion = Bytes.toInt((byte[])clientVersionBytes);
        } else {
            LOGGER.warn("Scan attribute {} not found. Scan attributes: {}", (Object)"_ClientVersion", (Object)scan.getAttributesMap());
        }
        return clientVersion;
    }

    public static void setClientVersion(Scan scan, int version) {
        scan.setAttribute("_ClientVersion", Bytes.toBytes((int)version));
    }

    public static boolean getStatsForParallelizationProp(PhoenixConnection conn, PTable table) throws SQLException {
        Boolean useStats = table.useStatsForParallelization();
        if (useStats != null) {
            return useStats;
        }
        PName tenantId = conn.getTenantId();
        int retryCount = 0;
        while (retryCount++ < 2) {
            if (table.getType() != PTableType.INDEX || table.getParentName() == null) continue;
            String parentTableName = table.getParentName().getString();
            try {
                PTable parentTable = conn.getTable(new PTableKey(tenantId, parentTableName));
                useStats = parentTable.useStatsForParallelization();
                if (useStats == null) continue;
                return useStats;
            }
            catch (TableNotFoundException e) {
                if (tenantId != null) {
                    tenantId = null;
                    continue;
                }
                LOGGER.warn("Unable to find parent table \"" + parentTableName + "\" of table \"" + table.getName().getString() + "\" to determine USE_STATS_FOR_PARALLELIZATION", (Throwable)e);
            }
        }
        return conn.getQueryServices().getConfiguration().getBoolean("phoenix.use.stats.parallelization", true);
    }

    public static CompiledTTLExpression getTTLExpression(Scan scan) throws IOException {
        byte[] phoenixTTL = scan.getAttribute("_TTL");
        if (phoenixTTL == null) {
            return null;
        }
        return TTLExpressionFactory.create(phoenixTTL);
    }

    public static boolean isPhoenixCompactionEnabled(Configuration conf) {
        return conf.getBoolean("phoenix.table.ttl.enabled", true) && conf.getBoolean("phoenix.compaction.enabled", true);
    }

    public static boolean isStrictTTL(Scan scan) {
        byte[] isStrictTTLBytes = scan.getAttribute("_IS_STRICT_TTL");
        if (isStrictTTLBytes != null) {
            try {
                return (Boolean)PBoolean.INSTANCE.toObject(isStrictTTLBytes);
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse isStrictTTL bytes, use default value for strict TTL {}", (Object)true, (Object)e);
                return true;
            }
        }
        return true;
    }

    public static boolean isEmptyColumn(Cell cell, byte[] emptyCF, byte[] emptyCQ) {
        return CellUtil.matchingFamily((Cell)cell, (byte[])emptyCF, (int)0, (int)emptyCF.length) && CellUtil.matchingQualifier((Cell)cell, (byte[])emptyCQ, (int)0, (int)emptyCQ.length);
    }

    public static long getMaxTimestamp(List<Cell> cellList) {
        long maxTs = 0L;
        long ts = 0L;
        for (Cell cell : cellList) {
            ts = cell.getTimestamp();
            if (ts <= maxTs) continue;
            maxTs = ts;
        }
        return maxTs;
    }

    private static boolean shouldAddEmptyColumn(Scan scan, byte[] emptyCF) {
        Map familyMap = scan.getFamilyMap();
        if (familyMap == null || familyMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            byte[] cf = (byte[])entry.getKey();
            if (!Arrays.equals(cf, emptyCF)) continue;
            NavigableSet family = (NavigableSet)entry.getValue();
            return family != null && !family.isEmpty();
        }
        return true;
    }

    private static void addEmptyColumnToFilter(Filter filter, byte[] emptyCF, byte[] emptyCQ) {
        if (filter instanceof EncodedQualifiersColumnProjectionFilter) {
            ((EncodedQualifiersColumnProjectionFilter)filter).addTrackedColumn(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
        } else if (filter instanceof ColumnProjectionFilter) {
            ((ColumnProjectionFilter)filter).addTrackedColumn(new ImmutableBytesPtr(emptyCF), new ImmutableBytesPtr(emptyCQ));
        } else if (filter instanceof MultiEncodedCQKeyValueComparisonFilter) {
            ((MultiEncodedCQKeyValueComparisonFilter)filter).setMinQualifier(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
        }
    }

    private static void addEmptyColumnToFilterList(FilterList filterList, byte[] emptyCF, byte[] emptyCQ) {
        for (Filter filter : filterList.getFilters()) {
            if (filter instanceof FilterList) {
                ScanUtil.addEmptyColumnToFilterList((FilterList)filter, emptyCF, emptyCQ);
                continue;
            }
            ScanUtil.addEmptyColumnToFilter(filter, emptyCF, emptyCQ);
        }
    }

    public static void addEmptyColumnToScan(Scan scan, byte[] emptyCF, byte[] emptyCQ) {
        Filter filter = scan.getFilter();
        if (filter != null) {
            if (filter instanceof FilterList) {
                ScanUtil.addEmptyColumnToFilterList((FilterList)filter, emptyCF, emptyCQ);
            } else {
                ScanUtil.addEmptyColumnToFilter(filter, emptyCF, emptyCQ);
            }
        }
        if (ScanUtil.shouldAddEmptyColumn(scan, emptyCF)) {
            scan.addColumn(emptyCF, emptyCQ);
        }
    }

    public static PTable getDataTable(PTable index, PhoenixConnection conn) throws SQLException {
        String schemaName = index.getParentSchemaName().getString();
        String tableName = index.getParentTableName().getString();
        try {
            PTable dataTable = conn.getTable(SchemaUtil.getTableName(schemaName, tableName));
            return dataTable;
        }
        catch (TableNotFoundException e) {
            return null;
        }
    }

    public static void setScanAttributesForIndexReadRepair(Scan scan, PTable table, PhoenixConnection phoenixConnection, StatementContext context) throws SQLException {
        boolean isTransforming = table.getTransformingNewTable() != null;
        PTable indexTable = table;
        if (!phoenixConnection.isClosed() && table.getType() == PTableType.TABLE && isTransforming) {
            SystemTransformRecord systemTransformRecord = TransformClient.getTransformRecord(indexTable.getSchemaName(), indexTable.getTableName(), null, phoenixConnection.getTenantId(), phoenixConnection);
            if (systemTransformRecord == null) {
                return;
            }
            if (!systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.COMPLETED.name())) {
                return;
            }
            byte[] oldTableBytes = systemTransformRecord.getOldMetadata();
            if (oldTableBytes == null || oldTableBytes.length == 0) {
                return;
            }
            PTable oldTable = null;
            try {
                oldTable = PTableImpl.createFromProto(PTableProtos.PTable.parseFrom(oldTableBytes));
            }
            catch (IOException e) {
                LOGGER.error("Cannot parse old table info for read repair for table " + table.getName());
                return;
            }
            TransformMaintainer indexMaintainer = indexTable.getTransformMaintainer(oldTable, phoenixConnection);
            scan.setAttribute("INDEX_IDX_MAINTAINER", indexTable.getTableName().getBytes());
            ScanUtil.annotateScanWithMetadataAttributes(oldTable, scan);
            if (scan.getAttribute("IdxProtoMD") == null) {
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                TransformMaintainer.serialize(oldTable, ptr, indexTable, phoenixConnection);
                scan.setAttribute("IdxProtoMD", ByteUtil.copyKeyBytesIfNecessary(ptr));
            }
            scan.setAttribute("_CheckVerifyColumn", PDataType.TRUE_BYTES);
            scan.setAttribute("_PhysicalDataTableName", oldTable.getPhysicalName().getBytes());
            byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
            byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
            scan.setAttribute("_EmptyCFName", emptyCF);
            scan.setAttribute("_EmptyCQName", emptyCQ);
            scan.setAttribute("_ReadRepairTransformingTable", PDataType.TRUE_BYTES);
        } else {
            PTable dataTable;
            if (table.getType() != PTableType.INDEX || !IndexUtil.isGlobalIndex(indexTable)) {
                return;
            }
            if (table.isTransactional() && table.getIndexType() == PTable.IndexType.UNCOVERED_GLOBAL) {
                return;
            }
            PTable pTable = dataTable = context.getCDCDataTableRef() != null ? context.getCDCDataTableRef().getTable() : ScanUtil.getDataTable(indexTable, phoenixConnection);
            if (dataTable == null) {
                return;
            }
            if (indexTable.getViewIndexId() != null && indexTable.getName().getString().contains("#")) {
                int lastIndexOf = indexTable.getName().getString().lastIndexOf("#");
                String indexName = indexTable.getName().getString().substring(lastIndexOf + 1);
                indexTable = phoenixConnection.getTable(indexName);
            }
            if (!dataTable.getIndexes().contains(indexTable)) {
                return;
            }
            scan.setAttribute("INDEX_IDX_MAINTAINER", indexTable.getTableName().getBytes());
            ScanUtil.annotateScanWithMetadataAttributes(dataTable, scan);
            if (scan.getAttribute("IdxProtoMD") == null) {
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                IndexMaintainer.serialize(dataTable, ptr, Collections.singletonList(indexTable), phoenixConnection);
                scan.setAttribute("IdxProtoMD", ByteUtil.copyKeyBytesIfNecessary(ptr));
            }
            if (IndexUtil.isCoveredGlobalIndex(indexTable)) {
                if (!ScanUtil.isIndexRebuild(scan)) {
                    scan.setAttribute("_CheckVerifyColumn", PDataType.TRUE_BYTES);
                }
            } else {
                scan.setAttribute("_UncoveredGlobalIndex", PDataType.TRUE_BYTES);
            }
            scan.setAttribute("_PhysicalDataTableName", dataTable.getPhysicalName().getBytes());
            IndexMaintainer indexMaintainer = indexTable.getIndexMaintainer(dataTable, phoenixConnection);
            byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
            byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
            scan.setAttribute("_EmptyCFName", emptyCF);
            scan.setAttribute("_EmptyCQName", emptyCQ);
            if (scan.getAttribute("_ViewConstants") == null) {
                BaseQueryPlan.serializeViewConstantsIntoScan(scan, dataTable);
            }
        }
    }

    public static void setScanAttributesForPhoenixTTL(Scan scan, PTable table, PhoenixConnection phoenixConnection) throws SQLException {
        CompiledTTLExpression ttlExpr;
        byte[] ttlForScan;
        if (!table.isStrictTTL()) {
            scan.setAttribute("_IS_STRICT_TTL", PBoolean.INSTANCE.toBytes(table.isStrictTTL()));
        }
        if (table.getType() == PTableType.VIEW && !phoenixConnection.getQueryServices().getConfiguration().getBoolean("phoenix.view.ttl.enabled", true)) {
            return;
        }
        if (!ScanUtil.isPhoenixCompactionEnabled(phoenixConnection.getQueryServices().getConfiguration()) || SchemaUtil.isSystemTable(SchemaUtil.getTableNameAsBytes(table.getSchemaName().getString(), table.getTableName().getString())) && !MetaDataUtil.SYSTEM_TABLES_WITH_TTL_SUPPORTED.contains(table.getName().getString())) {
            byte[] ttlForScan2 = LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR.serialize();
            scan.setAttribute("_TTL", ttlForScan2);
            return;
        }
        PTable dataTable = table;
        String tableName = table.getTableName().getString();
        if (table.getType() == PTableType.INDEX && table.getParentName() != null) {
            String parentSchemaName = table.getParentSchemaName().getString();
            String parentTableName = table.getParentTableName().getString();
            if (tableName.contains("#")) {
                String parentViewName = SchemaUtil.getSchemaNameFromFullName(tableName, "#");
                parentSchemaName = SchemaUtil.getSchemaNameFromFullName(parentViewName);
                parentTableName = SchemaUtil.getTableNameFromFullName(parentViewName);
            }
            try {
                dataTable = phoenixConnection.getTable(SchemaUtil.getTableName(parentSchemaName, parentTableName));
            }
            catch (TableNotFoundException e) {
                return;
            }
        }
        if (!dataTable.isStrictTTL()) {
            scan.setAttribute("_IS_STRICT_TTL", PBoolean.INSTANCE.toBytes(dataTable.isStrictTTL()));
        }
        if ((ttlForScan = (ttlExpr = table.getCompiledTTLExpression(phoenixConnection)).serialize()) != null) {
            byte[] emptyColumnFamilyName = SchemaUtil.getEmptyColumnFamily(table);
            byte[] emptyColumnName = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
            scan.setAttribute("_EmptyCFName", emptyColumnFamilyName);
            scan.setAttribute("_EmptyCQName", emptyColumnName);
            scan.setAttribute("_TTL", ttlForScan);
            if (ScanUtil.isLocalIndex(scan)) {
                byte[] actualStartRow = scan.getAttribute("_ScanActualStartRow") != null ? scan.getAttribute("_ScanActualStartRow") : HConstants.EMPTY_BYTE_ARRAY;
                ScanUtil.setLocalIndexAttributes(scan, 0, actualStartRow, HConstants.EMPTY_BYTE_ARRAY, scan.getStartRow(), scan.getStopRow());
            }
        }
    }

    public static void setScanAttributesForClient(Scan scan, PTable table, StatementContext context) throws SQLException {
        PhoenixConnection phoenixConnection = context.getConnection();
        ScanUtil.setScanAttributesForIndexReadRepair(scan, table, phoenixConnection, context);
        ScanUtil.setScanAttributesForPhoenixTTL(scan, table, phoenixConnection);
        byte[] emptyCF = scan.getAttribute("_EmptyCFName");
        byte[] emptyCQ = scan.getAttribute("_EmptyCQName");
        if (emptyCF != null && emptyCQ != null) {
            ScanUtil.addEmptyColumnToScan(scan, emptyCF, emptyCQ);
        } else if (!ScanUtil.isAnalyzeTable(scan)) {
            emptyCF = SchemaUtil.getEmptyColumnFamily(table);
            emptyCQ = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
            scan.setAttribute("_EmptyCFName", emptyCF);
            scan.setAttribute("_EmptyCQName", emptyCQ);
            ScanUtil.addEmptyColumnToScan(scan, emptyCF, emptyCQ);
        }
        ScanUtil.setScanAttributeForPaging(scan, phoenixConnection);
        scan.setAttribute("_ScanServerValidRowKey", Bytes.toBytes((boolean)true));
        if (context.getCDCTableRef() != null) {
            scan.setAttribute("_CdcDataTableDef", CDCTableInfo.toProto(context).toByteArray());
        }
    }

    public static void setScanAttributeForPaging(Scan scan, PhoenixConnection phoenixConnection) {
        if (phoenixConnection.getQueryServices().getProps().getBoolean("phoenix.server.paging.enabled", true)) {
            long pageSizeMs = phoenixConnection.getQueryServices().getProps().getInt("phoenix.server.page.size.ms", -1);
            if (pageSizeMs == -1L) {
                pageSizeMs = (long)((double)phoenixConnection.getQueryServices().getProps().getLong("hbase.rpc.timeout", 60000L) * 0.5);
            }
            scan.setAttribute("_ServerPageSizeMs", Bytes.toBytes((long)pageSizeMs));
        }
    }

    public static void getDummyResult(byte[] rowKey, List<Cell> result) {
        Cell keyValue = PhoenixKeyValueUtil.newKeyValue(rowKey, 0, rowKey.length, ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY, 0L, ByteUtil.EMPTY_BYTE_ARRAY, 0, ByteUtil.EMPTY_BYTE_ARRAY.length);
        result.add(keyValue);
    }

    public static Tuple getDummyTuple(byte[] rowKey) {
        ArrayList<Cell> result = new ArrayList<Cell>(1);
        ScanUtil.getDummyResult(rowKey, result);
        return new ResultTuple(Result.create(result));
    }

    public static Tuple getDummyTuple(Tuple tuple) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        tuple.getKey(ptr);
        return ScanUtil.getDummyTuple(ptr.copyBytes());
    }

    public static boolean isDummy(Cell cell) {
        return CellUtil.matchingColumn((Cell)cell, (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public static boolean isDummy(Result result) {
        if (result.rawCells().length != 1) {
            return false;
        }
        Cell cell = result.rawCells()[0];
        return ScanUtil.isDummy(cell);
    }

    public static boolean isDummy(List<Cell> result) {
        if (result.size() != 1) {
            return false;
        }
        Cell cell = result.get(0);
        return ScanUtil.isDummy(cell);
    }

    public static boolean isDummy(Tuple tuple) {
        if (tuple instanceof ResultTuple) {
            return ScanUtil.isDummy(((ResultTuple)tuple).getResult());
        }
        return false;
    }

    public static PagingFilter getPhoenixPagingFilter(Scan scan) {
        Filter filter = scan.getFilter();
        if (filter != null && filter instanceof PagingFilter) {
            PagingFilter pageFilter = (PagingFilter)filter;
            return pageFilter;
        }
        return null;
    }

    private static long getPageSizeMs(Scan scan, double factor) {
        long pageSizeMs = Long.MAX_VALUE;
        byte[] pageSizeMsBytes = scan.getAttribute("_ServerPageSizeMs");
        if (pageSizeMsBytes != null) {
            pageSizeMs = Bytes.toLong((byte[])pageSizeMsBytes);
            pageSizeMs = (long)((double)pageSizeMs * factor);
        }
        return pageSizeMs;
    }

    public static long getPageSizeMsForRegionScanner(Scan scan) {
        return ScanUtil.getPageSizeMs(scan, 0.6);
    }

    public static long getPageSizeMsForFilter(Scan scan) {
        return ScanUtil.getPageSizeMs(scan, 0.3);
    }

    public static void annotateScanWithMetadataAttributes(PTable table, Scan scan) {
        if (table.getTenantId() != null) {
            scan.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), table.getTenantId().getBytes());
        }
        scan.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), table.getSchemaName().getBytes());
        scan.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), table.getTableName().getBytes());
        scan.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), table.getType().getValue().getBytes());
        if (table.getLastDDLTimestamp() != null) {
            scan.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), Bytes.toBytes((long)table.getLastDDLTimestamp()));
        }
        if (table.isChangeDetectionEnabled() && table.getExternalSchemaId() != null) {
            scan.setAttribute(MutationState.MutationMetadataType.EXTERNAL_SCHEMA_ID.toString(), Bytes.toBytes((String)table.getExternalSchemaId()));
        }
    }

    public static void annotateMutationWithMetadataAttributes(byte[] tenantId, byte[] schemaName, byte[] logicalTableName, byte[] tableType, byte[] timestamp, Mutation mutation) {
        if (tenantId != null) {
            mutation.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), tenantId);
        }
        mutation.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), schemaName);
        mutation.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), logicalTableName);
        mutation.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), tableType);
        if (timestamp != null) {
            mutation.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), timestamp);
        }
    }

    public static void annotateScanWithMetadataAttributes(Scan oldScan, Scan newScan) {
        byte[] tenantId = oldScan.getAttribute(MutationState.MutationMetadataType.TENANT_ID.toString());
        byte[] schemaName = oldScan.getAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString());
        byte[] logicalTableName = oldScan.getAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString());
        byte[] tableType = oldScan.getAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString());
        byte[] timestamp = oldScan.getAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString());
        if (tenantId != null) {
            newScan.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), tenantId);
        }
        if (schemaName != null) {
            newScan.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), schemaName);
        }
        if (logicalTableName != null) {
            newScan.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), logicalTableName);
        }
        if (tableType != null) {
            newScan.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), tableType);
        }
        if (timestamp != null) {
            newScan.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), timestamp);
        }
    }

    public static void annotateMutationWithMetadataAttributes(PTable table, Mutation mutation) {
        if (table.getTenantId() != null) {
            mutation.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), table.getTenantId().getBytes());
        }
        mutation.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), table.getSchemaName().getBytes());
        mutation.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), table.getTableName().getBytes());
        mutation.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), table.getType().getValue().getBytes());
        if (table.getLastDDLTimestamp() != null) {
            mutation.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), Bytes.toBytes((long)table.getLastDDLTimestamp()));
        }
    }

    public static void annotateMutationWithConditionalTTL(PhoenixConnection connection, PTable table, List<? extends Mutation> mutations) throws SQLException {
        if (!table.hasConditionalTTL()) {
            return;
        }
        if (table.isImmutableRows()) {
            return;
        }
        CompiledTTLExpression ttlExpr = table.getCompiledTTLExpression(connection);
        byte[] ttl = ttlExpr.serialize();
        for (Mutation mutation : mutations) {
            mutation.setAttribute("_TTL", ttl);
            if (table.isStrictTTL()) continue;
            mutation.setAttribute("_IS_STRICT_TTL", PBoolean.INSTANCE.toBytes(table.isStrictTTL()));
        }
    }

    public static PageFilter removePageFilterFromFilterList(FilterList filterList) {
        Iterator filterIterator = filterList.getFilters().iterator();
        while (filterIterator.hasNext()) {
            PageFilter pageFilter;
            Filter filter = (Filter)filterIterator.next();
            if (filter instanceof PageFilter) {
                filterIterator.remove();
                return (PageFilter)filter;
            }
            if (!(filter instanceof FilterList) || (pageFilter = ScanUtil.removePageFilterFromFilterList((FilterList)filter)) == null) continue;
            return pageFilter;
        }
        return null;
    }

    public static boolean isIncompatibleClientForServerReturnValidRowKey(Scan scan) {
        return scan.getAttribute("_ScanServerValidRowKey") == null;
    }

    public static PageFilter removePageFilter(Scan scan) {
        Filter filter = scan.getFilter();
        if (filter != null) {
            PagingFilter pagingFilter = null;
            if (filter instanceof PagingFilter && (filter = (pagingFilter = (PagingFilter)filter).getDelegateFilter()) == null) {
                return null;
            }
            if (filter instanceof PageFilter) {
                if (pagingFilter != null) {
                    pagingFilter.setDelegateFilter(null);
                    scan.setFilter((Filter)pagingFilter);
                } else {
                    scan.setFilter(null);
                }
                return (PageFilter)filter;
            }
            if (filter instanceof FilterList) {
                return ScanUtil.removePageFilterFromFilterList((FilterList)filter);
            }
        }
        return null;
    }

    public static SkipScanFilter removeSkipScanFilterFromFilterList(FilterList filterList) {
        Iterator filterIterator = filterList.getFilters().iterator();
        while (filterIterator.hasNext()) {
            SkipScanFilter skipScanFilter;
            Filter filter = (Filter)filterIterator.next();
            if (filter instanceof SkipScanFilter && ((SkipScanFilter)filter).isMultiKeyPointLookup()) {
                filterIterator.remove();
                return (SkipScanFilter)filter;
            }
            if (!(filter instanceof FilterList) || (skipScanFilter = ScanUtil.removeSkipScanFilterFromFilterList((FilterList)filter)) == null) continue;
            return skipScanFilter;
        }
        return null;
    }

    public static SkipScanFilter removeSkipScanFilter(Scan scan) {
        Filter filter = scan.getFilter();
        if (filter != null) {
            PagingFilter pagingFilter = null;
            if (filter instanceof PagingFilter && (filter = (pagingFilter = (PagingFilter)filter).getDelegateFilter()) == null) {
                return null;
            }
            if (filter instanceof SkipScanFilter && ((SkipScanFilter)filter).isMultiKeyPointLookup()) {
                if (pagingFilter != null) {
                    pagingFilter.setDelegateFilter(null);
                    scan.setFilter((Filter)pagingFilter);
                } else {
                    scan.setFilter(null);
                }
                return (SkipScanFilter)filter;
            }
            if (filter instanceof FilterList) {
                return ScanUtil.removeSkipScanFilterFromFilterList((FilterList)filter);
            }
        }
        return null;
    }

    public static void verifyKeyInScanRange(ImmutableBytesWritable ptr, Scan scan) throws ResultSetOutOfScanRangeException {
        try {
            if (scan.isReversed()) {
                ScanUtil.verifyScanRangesForReverseScan(ptr, scan, scan.getStartRow(), scan.getStopRow());
            } else {
                ScanUtil.verifyScanRanges(ptr, scan, scan.getStartRow(), scan.getStopRow());
            }
        }
        catch (ResultSetOutOfScanRangeException e) {
            if (ScanUtil.isLocalIndex(scan)) {
                ScanUtil.verifyScanRanges(ptr, scan, scan.getAttribute("_ScanStartRowSuffix"), scan.getAttribute("_ScanStopRowSuffix"));
                return;
            }
            if (scan.getAttribute("_ScanActualStartRow") == null) {
                throw e;
            }
            ScanUtil.verifyScanRanges(ptr, scan, scan.getAttribute("_ScanActualStartRow"), scan.getStopRow());
        }
    }

    private static void verifyScanRanges(ImmutableBytesWritable ptr, Scan scan, byte[] startRow, byte[] stopRow) throws ResultSetOutOfScanRangeException {
        if (startRow != null && Bytes.compareTo((byte[])startRow, (byte[])HConstants.EMPTY_START_ROW) != 0 && (scan.includeStartRow() ? Bytes.compareTo((byte[])startRow, (byte[])ptr.get()) > 0 : Bytes.compareTo((byte[])startRow, (byte[])ptr.get()) >= 0)) {
            throw new ResultSetOutOfScanRangeException(RESULT_IS_OUT_OF_SCAN_START_KEY);
        }
        if (stopRow != null && Bytes.compareTo((byte[])stopRow, (byte[])HConstants.EMPTY_END_ROW) != 0 && (scan.includeStopRow() ? Bytes.compareTo((byte[])stopRow, (byte[])ptr.get()) < 0 : Bytes.compareTo((byte[])stopRow, (byte[])ptr.get()) <= 0)) {
            throw new ResultSetOutOfScanRangeException(RESULT_IS_OUT_OF_SCAN_STOP_KEY);
        }
    }

    private static void verifyScanRangesForReverseScan(ImmutableBytesWritable ptr, Scan scan, byte[] startRow, byte[] stopRow) throws ResultSetOutOfScanRangeException {
        if (stopRow != null && Bytes.compareTo((byte[])stopRow, (byte[])HConstants.EMPTY_START_ROW) != 0 && (scan.includeStopRow() ? Bytes.compareTo((byte[])stopRow, (byte[])ptr.get()) > 0 : Bytes.compareTo((byte[])stopRow, (byte[])ptr.get()) >= 0)) {
            throw new ResultSetOutOfScanRangeException(RESULT_IS_OUT_OF_SCAN_START_KEY);
        }
        if (startRow != null && Bytes.compareTo((byte[])startRow, (byte[])HConstants.EMPTY_END_ROW) != 0 && (scan.includeStartRow() ? Bytes.compareTo((byte[])startRow, (byte[])ptr.get()) < 0 : Bytes.compareTo((byte[])startRow, (byte[])ptr.get()) <= 0)) {
            throw new ResultSetOutOfScanRangeException(RESULT_IS_OUT_OF_SCAN_STOP_KEY);
        }
    }

    public static interface BytesComparator {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

