/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Put;

public class MutationUtil {
    private MutationUtil() {
    }

    public static Put copyPut(Put original) throws IOException {
        return MutationUtil.copyPut(original, false);
    }

    public static Put copyPut(Put original, boolean skipAttributes) throws IOException {
        Put copy = new Put(original.getRow());
        copy.setTimestamp(original.getTimestamp());
        copy.setDurability(original.getDurability());
        if (!skipAttributes) {
            for (Map.Entry entry : original.getAttributesMap().entrySet()) {
                copy.setAttribute((String)entry.getKey(), (byte[])((byte[])entry.getValue()).clone());
            }
        }
        copy.setPriority(original.getPriority());
        for (List cells : original.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                copy.add(CellUtil.cloneIfNecessary((Cell)cell));
            }
        }
        return copy;
    }
}

