/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ConditionalTTLExpression;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MajorMinorVersion;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataUtil.class);
    public static final String VIEW_INDEX_TABLE_PREFIX = "_IDX_";
    public static final String LOCAL_INDEX_TABLE_PREFIX = "_LOCAL_IDX_";
    public static final String VIEW_INDEX_SEQUENCE_PREFIX = "_SEQ_";
    public static final String VIEW_INDEX_SEQUENCE_NAME_PREFIX = "_ID_";
    public static final byte[] VIEW_INDEX_SEQUENCE_PREFIX_BYTES = Bytes.toBytes((String)"_SEQ_");
    public static final String VIEW_INDEX_ID_COLUMN_NAME = "_INDEX_ID";
    public static final String PARENT_TABLE_KEY = "PARENT_TABLE";
    public static final String IS_VIEW_INDEX_TABLE_PROP_NAME = "IS_VIEW_INDEX_TABLE";
    public static final byte[] IS_VIEW_INDEX_TABLE_PROP_BYTES = Bytes.toBytes((String)"IS_VIEW_INDEX_TABLE");
    public static final String IS_LOCAL_INDEX_TABLE_PROP_NAME = "IS_LOCAL_INDEX_TABLE";
    public static final byte[] IS_LOCAL_INDEX_TABLE_PROP_BYTES = Bytes.toBytes((String)"IS_LOCAL_INDEX_TABLE");
    public static final String DATA_TABLE_NAME_PROP_NAME = "DATA_TABLE_NAME";
    public static final byte[] DATA_TABLE_NAME_PROP_BYTES = Bytes.toBytes((String)"DATA_TABLE_NAME");
    private static final Map<MajorMinorVersion, MajorMinorVersion> ALLOWED_SERVER_CLIENT_MAJOR_VERSION = ImmutableMap.of((Object)new MajorMinorVersion(5, 1), (Object)new MajorMinorVersion(4, 16));
    public static final List<String> SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES = ImmutableList.of((Object)"TTL", (Object)"KEEP_DELETED_CELLS", (Object)"REPLICATION_SCOPE");
    public static final List<String> SYSTEM_TABLES_WITH_TTL_SUPPORTED = Arrays.asList(SchemaUtil.getTableName("SYSTEM", "CDC_STREAM"), SchemaUtil.getTableName("SYSTEM", "CDC_STREAM_STATUS"));

    public static Put getLastDDLTimestampUpdate(byte[] tableHeaderRowKey, long clientTimestamp, long lastDDLTimestamp) {
        Put p = new Put(tableHeaderRowKey, clientTimestamp);
        byte[] lastDDLTimestampBytes = PLong.INSTANCE.toBytes(lastDDLTimestamp);
        p.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LAST_DDL_TIMESTAMP_BYTES, lastDDLTimestampBytes);
        return p;
    }

    public static Put getExternalSchemaIdUpdate(byte[] tableHeaderRowKey, String externalSchemaId) {
        Put p = new Put(tableHeaderRowKey);
        byte[] externalSchemaIdBytes = PVarchar.INSTANCE.toBytes(externalSchemaId);
        p.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.EXTERNAL_SCHEMA_ID_BYTES, externalSchemaIdBytes);
        return p;
    }

    public static boolean isTableDirectlyQueried(PTableType tableType) {
        return tableType.equals((Object)PTableType.TABLE) || tableType.equals((Object)PTableType.VIEW);
    }

    public static ClientServerCompatibility areClientAndServerCompatible(long serverHBaseAndPhoenixVersion) {
        return MetaDataUtil.areClientAndServerCompatible(MetaDataUtil.decodePhoenixVersion(serverHBaseAndPhoenixVersion), 5, 3);
    }

    @VisibleForTesting
    static ClientServerCompatibility areClientAndServerCompatible(int serverVersion, int clientMajorVersion, int clientMinorVersion) {
        MajorMinorVersion serverMajorMinorVersion;
        MajorMinorVersion clientMajorMinorVersion;
        ClientServerCompatibility compatibility = new ClientServerCompatibility();
        if (VersionUtil.encodeMinPatchVersion(clientMajorVersion, clientMinorVersion) > serverVersion) {
            compatibility.setErrorCode(SQLExceptionCode.OUTDATED_JARS.getErrorCode());
            compatibility.setCompatible(false);
            return compatibility;
        }
        if (VersionUtil.encodeMaxMinorVersion(clientMajorVersion) < serverVersion && !(clientMajorMinorVersion = new MajorMinorVersion(clientMajorVersion, clientMinorVersion)).equals(ALLOWED_SERVER_CLIENT_MAJOR_VERSION.get(serverMajorMinorVersion = new MajorMinorVersion(VersionUtil.decodeMajorVersion(serverVersion), VersionUtil.decodeMinorVersion(serverVersion))))) {
            compatibility.setErrorCode(SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode());
            compatibility.setCompatible(false);
            return compatibility;
        }
        compatibility.setCompatible(true);
        return compatibility;
    }

    public static int decodePhoenixVersion(long version) {
        return (int)(version << 32 >>> 40);
    }

    public static long encodeHasIndexWALCodec(long version, boolean isValid) {
        if (!isValid) {
            return version | 1L;
        }
        return version;
    }

    public static boolean decodeHasIndexWALCodec(long version) {
        return (version & 0xFL) == 0L;
    }

    public static int decodeHBaseVersion(long version) {
        return (int)(version >>> 40);
    }

    public static String decodeHBaseVersionAsString(int version) {
        int major = version >>> 16 & 0xFF;
        int minor = version >>> 8 & 0xFF;
        int patch = version & 0xFF;
        return major + "." + minor + "." + patch;
    }

    public static boolean decodeTableNamespaceMappingEnabled(long version) {
        return ((int)(version << 24 >>> 56) & 1) != 0;
    }

    public static long encodeVersion(String hbaseVersionStr, Configuration config) {
        long hbaseVersion = VersionUtil.encodeVersion(hbaseVersionStr);
        long isTableNamespaceMappingEnabled = SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, new ReadOnlyProps(config.iterator())) ? 1L : 0L;
        long phoenixVersion = VersionUtil.encodeVersion(5, 3, 0);
        long walCodec = IndexManagementUtil.isWALEditCodecSet(config) ? 0L : 1L;
        long version = hbaseVersion << 40 | isTableNamespaceMappingEnabled << 32 | phoenixVersion << 8 | walCodec;
        return version;
    }

    public static byte[] getTenantIdAndSchemaAndTableName(Mutation someRow) {
        byte[][] rowKeyMetaData = new byte[3][];
        SchemaUtil.getVarChars(someRow.getRow(), 3, rowKeyMetaData);
        return ByteUtil.concat(rowKeyMetaData[0], rowKeyMetaData[1], rowKeyMetaData[2]);
    }

    public static byte[] getTenantIdAndSchemaAndTableName(Result result) {
        byte[][] rowKeyMetaData = new byte[3][];
        SchemaUtil.getVarChars(result.getRow(), 3, rowKeyMetaData);
        return ByteUtil.concat(rowKeyMetaData[0], rowKeyMetaData[1], rowKeyMetaData[2]);
    }

    public static void getTenantIdAndSchemaAndTableName(List<Mutation> tableMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
    }

    public static int getBaseColumnCount(List<Mutation> tableMetadata) {
        int result = -1;
        for (Mutation mutation : tableMetadata) {
            for (List cells : mutation.getFamilyCellMap().values()) {
                for (Cell cell : cells) {
                    if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES, (int)0, (int)PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES.length) != 0 || !Bytes.contains((byte[])cell.getQualifierArray(), (byte[])PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES)) continue;
                    result = PInteger.INSTANCE.getCodec().decodeInt(cell.getValueArray(), cell.getValueOffset(), SortOrder.ASC);
                }
            }
        }
        return result;
    }

    public static void mutatePutValue(Put somePut, byte[] family, byte[] qualifier, byte[] newValue) {
        NavigableMap familyCellMap = somePut.getFamilyCellMap();
        List cells = (List)familyCellMap.get(family);
        ArrayList newCells = Lists.newArrayList();
        if (cells != null) {
            for (Cell cell : cells) {
                if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])qualifier, (int)0, (int)qualifier.length) == 0) {
                    KeyValue replacementCell = new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getType().getCode()), newValue, 0, newValue.length);
                    newCells.add(replacementCell);
                    continue;
                }
                newCells.add(cell);
            }
            familyCellMap.put(family, newCells);
        }
    }

    public static void conditionallyAddTagsToPutCells(Put somePut, byte[] family, byte[] qualifier, ExtendedCellBuilder cellBuilder, byte[] valueArray, byte[] tagArray) {
        NavigableMap familyCellMap = somePut.getFamilyCellMap();
        List cells = (List)familyCellMap.get(family);
        ArrayList newCells = Lists.newArrayList();
        if (cells != null) {
            for (Cell cell : cells) {
                if (!(Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])qualifier, (int)0, (int)qualifier.length) != 0 || valueArray != null && CellUtil.matchingValue((Cell)cell, (byte[])valueArray))) {
                    ExtendedCell extendedCell = cellBuilder.setRow(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength()).setFamily(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength()).setQualifier(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()).setValue(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()).setTimestamp(cell.getTimestamp()).setType(cell.getType()).setTags(TagUtil.concatTags((byte[])tagArray, (Cell)cell)).build();
                    newCells.add(extendedCell);
                    continue;
                }
                newCells.add(cell);
            }
            familyCellMap.put(family, newCells);
        }
    }

    public static Put cloneDeleteToPutAndAddColumn(Delete delete, byte[] family, byte[] qualifier, byte[] value) {
        NavigableMap familyCellMap = delete.getFamilyCellMap();
        List cells = (List)familyCellMap.get(family);
        Cell cell = (Cell)Iterables.getFirst((Iterable)cells, null);
        if (cell == null) {
            throw new RuntimeException("Empty cells for delete for family: " + Bytes.toStringBinary((byte[])family));
        }
        byte[] rowArray = new byte[cell.getRowLength()];
        System.arraycopy(cell.getRowArray(), cell.getRowOffset(), rowArray, 0, cell.getRowLength());
        Put put = new Put(rowArray, delete.getTimestamp());
        put.addColumn(family, qualifier, delete.getTimestamp(), value);
        return put;
    }

    public static void getTenantIdAndFunctionName(List<Mutation> functionMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(functionMetadata);
        SchemaUtil.getVarChars(m.getRow(), 2, rowKeyMetaData);
    }

    public static byte[] getParentTableName(List<Mutation> tableMetadata) {
        if (tableMetadata.size() == 1) {
            return null;
        }
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        byte[] tenantId = rowKeyMetaData[0];
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        Mutation m = MetaDataUtil.getParentTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
        if (Bytes.compareTo((byte[])tenantId, (byte[])rowKeyMetaData[0]) == 0 && Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) {
            return null;
        }
        return rowKeyMetaData[2];
    }

    public static long getSequenceNumber(Mutation tableMutation) {
        List kvs = (List)tableMutation.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell kv : kvs) {
                if (!MetaDataUtil.isSequenceNumber(kv)) continue;
                return PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
            }
        }
        throw new IllegalStateException();
    }

    public static long getSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData));
    }

    public static boolean isSequenceNumber(Mutation m) {
        boolean foundSequenceNumber = false;
        for (Cell kv : (List)m.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)) {
            if (!MetaDataUtil.isSequenceNumber(kv)) continue;
            foundSequenceNumber = true;
            break;
        }
        return foundSequenceNumber;
    }

    public static boolean isSequenceNumber(Cell kv) {
        return CellUtil.matchingQualifier((Cell)kv, (byte[])PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES);
    }

    public static PTableType getTableType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, builder, value)) {
            return PTableType.fromSerializedValue(value.get()[value.getOffset()]);
        }
        return null;
    }

    public static boolean isNameSpaceMapped(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES, builder, value)) {
            return (Boolean)PBoolean.INSTANCE.toObject(ByteUtil.copyKeyBytesIfNecessary(value));
        }
        return false;
    }

    public static int getSaltBuckets(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES, builder, value)) {
            return PInteger.INSTANCE.getCodec().decodeInt(value, SortOrder.getDefault());
        }
        return 0;
    }

    public static long getParentSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber(MetaDataUtil.getParentTableHeaderRow(tableMetaData));
    }

    public static Mutation getTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(0);
    }

    public static boolean getMutationValue(Mutation headerRow, byte[] key, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        List kvs = (List)headerRow.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell cell : kvs) {
                KeyValue kv = PhoenixKeyValueUtil.maybeCopyCell(cell);
                if (builder.compareQualifier((Cell)kv, key, 0, key.length) != 0) continue;
                builder.getValueAsPtr((Cell)kv, ptr);
                return true;
            }
        }
        return false;
    }

    public static KeyValue getMutationValue(Mutation headerRow, byte[] key, KeyValueBuilder builder) {
        List kvs = (List)headerRow.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell cell : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (builder.compareQualifier((Cell)kv, key, 0, key.length) != 0) continue;
                return kv;
            }
        }
        return null;
    }

    public static boolean setMutationValue(Mutation headerRow, byte[] key, KeyValueBuilder builder, KeyValue keyValue) {
        List kvs = (List)headerRow.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell cell : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (builder.compareQualifier((Cell)kv, key, 0, key.length) != 0) continue;
                KeyValueBuilder.addQuietly(headerRow, keyValue);
                return true;
            }
        }
        return false;
    }

    public static List<Cell> getTableCellsFromMutations(List<Mutation> tableMetaData) {
        ArrayList tableCells = Lists.newArrayList();
        byte[] tableKey = tableMetaData.get(0).getRow();
        for (int k = 0; k < tableMetaData.size(); ++k) {
            Mutation m = tableMetaData.get(k);
            if (!Bytes.equals((byte[])m.getRow(), (byte[])tableKey)) continue;
            tableCells.addAll(MetaDataUtil.getCellList(m));
        }
        return tableCells;
    }

    public static List<List<Cell>> getColumnAndLinkCellsFromMutations(List<Mutation> tableMetaData) {
        ArrayList allColumnsCellList = Lists.newArrayList();
        byte[] tableKey = tableMetaData.get(0).getRow();
        for (int k = 1; k < tableMetaData.size(); ++k) {
            List<Cell> listToAdd;
            Mutation m = tableMetaData.get(k);
            if (Bytes.equals((byte[])m.getRow(), (byte[])tableKey) || !MetaDataUtil.isLinkType(m) && MetaDataUtil.isSequenceNumber(m) && !MetaDataUtil.isParentTableColumnQualifierCounter(m, tableKey) || (listToAdd = MetaDataUtil.getCellList(m)) == null || listToAdd.size() <= 0) continue;
            allColumnsCellList.add(listToAdd);
        }
        return allColumnsCellList;
    }

    private static List<Cell> getCellList(Mutation m) {
        ArrayList cellList = Lists.newArrayList();
        for (Cell c : (List)m.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)) {
            if (c == null || CellUtil.isDelete((Cell)c)) continue;
            cellList.add(c);
        }
        return cellList;
    }

    public static Put getPutOnlyTableHeaderRow(List<Mutation> tableMetaData) {
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put)) continue;
            return (Put)m;
        }
        throw new IllegalStateException("No table header row found in table metadata");
    }

    public static Put getPutOnlyAutoPartitionColumn(PTable parentTable, List<Mutation> tableMetaData) {
        int autoPartitionPutIndex = parentTable.isMultiTenant() ? 2 : 1;
        int i = 0;
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put) || i++ != autoPartitionPutIndex) continue;
            return (Put)m;
        }
        throw new IllegalStateException("No auto partition column row found in table metadata");
    }

    public static Mutation getParentTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(tableMetaData.size() - 1);
    }

    public static long getClientTimeStamp(List<Mutation> tableMetadata) {
        Mutation m = tableMetadata.get(0);
        return MetaDataUtil.getClientTimeStamp(m);
    }

    public static long getClientTimeStamp(Mutation m) {
        Collection kvs = m.getFamilyCellMap().values();
        return kvs.isEmpty() ? m.getTimestamp() : ((Cell)((List)kvs.iterator().next()).get(0)).getTimestamp();
    }

    public static byte[] getParentLinkKey(String tenantId, String schemaName, String tableName, String indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)tableName), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)indexName));
    }

    public static byte[] getParentLinkKey(byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : schemaName, QueryConstants.SEPARATOR_BYTE_ARRAY, tableName, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, indexName);
    }

    public static byte[] getChildLinkKey(PName parentTenantId, PName parentSchemaName, PName parentTableName, PName viewTenantId, PName viewName) {
        return ByteUtil.concat(parentTenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : parentTenantId.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, parentSchemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : parentSchemaName.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, parentTableName.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, viewTenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : viewTenantId.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, viewName.getBytes());
    }

    public static Cell getCell(List<Cell> cells, byte[] cq) {
        for (Cell cell : cells) {
            if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])cq, (int)0, (int)cq.length) != 0) continue;
            return cell;
        }
        return null;
    }

    public static boolean isMultiTenant(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, builder, ptr)) {
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr));
        }
        return false;
    }

    public static boolean isTransactional(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.TRANSACTIONAL_BYTES, builder, ptr)) {
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr));
        }
        return false;
    }

    public static boolean isSalted(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        return MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES, builder, ptr);
    }

    public static byte[] getViewIndexPhysicalName(byte[] physicalTableName) {
        return MetaDataUtil.getIndexPhysicalName(physicalTableName, VIEW_INDEX_TABLE_PREFIX);
    }

    public static String getViewIndexPhysicalName(String physicalTableName) {
        return MetaDataUtil.getIndexPhysicalName(physicalTableName, VIEW_INDEX_TABLE_PREFIX);
    }

    public static String getNamespaceMappedName(PName tableName, boolean isNamespaceMapped) {
        String logicalName = tableName.getString();
        if (isNamespaceMapped) {
            logicalName = logicalName.replace(".", ":");
        }
        return logicalName;
    }

    public static String getViewIndexPhysicalName(PName logicalTableName, boolean isNamespaceMapped) {
        String logicalName = MetaDataUtil.getNamespaceMappedName(logicalTableName, isNamespaceMapped);
        return MetaDataUtil.getIndexPhysicalName(logicalName, VIEW_INDEX_TABLE_PREFIX);
    }

    private static byte[] getIndexPhysicalName(byte[] physicalTableName, String indexPrefix) {
        return Bytes.toBytes((String)MetaDataUtil.getIndexPhysicalName(Bytes.toString((byte[])physicalTableName), indexPrefix));
    }

    private static String getIndexPhysicalName(String physicalTableName, String indexPrefix) {
        if (physicalTableName.contains(":")) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(physicalTableName, ":");
            String tableName = SchemaUtil.getTableNameFromFullName(physicalTableName, ":");
            return schemaName + ":" + indexPrefix + tableName;
        }
        return indexPrefix + physicalTableName;
    }

    public static byte[] getLocalIndexPhysicalName(byte[] physicalTableName) {
        return MetaDataUtil.getIndexPhysicalName(physicalTableName, LOCAL_INDEX_TABLE_PREFIX);
    }

    public static String getLocalIndexTableName(String tableName) {
        return LOCAL_INDEX_TABLE_PREFIX + tableName;
    }

    public static String getLocalIndexSchemaName(String schemaName) {
        return schemaName;
    }

    public static String getLocalIndexUserTableName(String localIndexTableName) {
        if (localIndexTableName.contains(":")) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(localIndexTableName, ":");
            String tableName = SchemaUtil.getTableNameFromFullName(localIndexTableName, ":");
            String userTableName = tableName.substring(LOCAL_INDEX_TABLE_PREFIX.length());
            return schemaName + ":" + userTableName;
        }
        String schemaName = SchemaUtil.getSchemaNameFromFullName(localIndexTableName);
        if (!schemaName.isEmpty()) {
            schemaName = schemaName.substring(LOCAL_INDEX_TABLE_PREFIX.length());
        }
        String tableName = localIndexTableName.substring((schemaName.isEmpty() ? 0 : schemaName.length() + ".".length()) + LOCAL_INDEX_TABLE_PREFIX.length());
        return SchemaUtil.getTableName(schemaName, tableName);
    }

    public static String getViewIndexUserTableName(String viewIndexTableName) {
        if (viewIndexTableName.contains(":")) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(viewIndexTableName, ":");
            String tableName = SchemaUtil.getTableNameFromFullName(viewIndexTableName, ":");
            String userTableName = tableName.substring(VIEW_INDEX_TABLE_PREFIX.length());
            return schemaName + ":" + userTableName;
        }
        String schemaName = SchemaUtil.getSchemaNameFromFullName(viewIndexTableName);
        if (!schemaName.isEmpty()) {
            schemaName = schemaName.substring(VIEW_INDEX_TABLE_PREFIX.length());
        }
        String tableName = viewIndexTableName.substring((schemaName.isEmpty() ? 0 : schemaName.length() + ".".length()) + VIEW_INDEX_TABLE_PREFIX.length());
        return SchemaUtil.getTableName(schemaName, tableName);
    }

    public static String getOldViewIndexSequenceSchemaName(PName physicalName, boolean isNamespaceMapped) {
        if (!isNamespaceMapped) {
            return VIEW_INDEX_SEQUENCE_PREFIX + physicalName.getString();
        }
        return SchemaUtil.getSchemaNameFromFullName(physicalName.toString());
    }

    public static String getOldViewIndexSequenceName(PName physicalName, PName tenantId, boolean isNamespaceMapped) {
        if (!isNamespaceMapped) {
            return VIEW_INDEX_SEQUENCE_NAME_PREFIX + (tenantId == null ? "" : tenantId);
        }
        return SchemaUtil.getTableNameFromFullName(physicalName.toString()) + VIEW_INDEX_SEQUENCE_NAME_PREFIX;
    }

    public static SequenceKey getOldViewIndexSequenceKey(String tenantId, PName physicalName, int nSaltBuckets, boolean isNamespaceMapped) {
        String schemaName = MetaDataUtil.getOldViewIndexSequenceSchemaName(physicalName, isNamespaceMapped);
        String tableName = MetaDataUtil.getOldViewIndexSequenceName(physicalName, PNameFactory.newName(tenantId), isNamespaceMapped);
        return new SequenceKey(isNamespaceMapped ? tenantId : null, schemaName, tableName, nSaltBuckets);
    }

    public static String getViewIndexSequenceSchemaName(PName logicalBaseTableName, boolean isNamespaceMapped) {
        if (!isNamespaceMapped) {
            String baseTableName = SchemaUtil.getParentTableNameFromIndexTable(logicalBaseTableName.getString(), VIEW_INDEX_TABLE_PREFIX);
            return SchemaUtil.getSchemaNameFromFullName(baseTableName);
        }
        return SchemaUtil.getSchemaNameFromFullName(logicalBaseTableName.toString());
    }

    public static String getViewIndexSequenceName(PName physicalName, PName tenantId, boolean isNamespaceMapped) {
        return SchemaUtil.getTableNameFromFullName(physicalName.toString()) + VIEW_INDEX_SEQUENCE_NAME_PREFIX;
    }

    public static SequenceKey getViewIndexSequenceKey(String tenantId, PName physicalName, int nSaltBuckets, boolean isNamespaceMapped) {
        String schemaName = MetaDataUtil.getViewIndexSequenceSchemaName(physicalName, isNamespaceMapped);
        String tableName = MetaDataUtil.getViewIndexSequenceName(physicalName, null, isNamespaceMapped);
        return new SequenceKey(null, schemaName, tableName, nSaltBuckets);
    }

    public static PDataType getViewIndexIdDataType() {
        return PLong.INSTANCE;
    }

    public static PDataType getLegacyViewIndexIdDataType() {
        return PSmallint.INSTANCE;
    }

    public static String getViewIndexIdColumnName() {
        return VIEW_INDEX_ID_COLUMN_NAME;
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, PName physicalName) throws SQLException {
        return MetaDataUtil.hasViewIndexTable(connection, physicalName.getBytes());
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, byte[] physicalTableName) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        try {
            TableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalIndexName);
            return desc != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(IS_VIEW_INDEX_TABLE_PROP_BYTES)));
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, PName physicalName) throws SQLException {
        return MetaDataUtil.hasLocalIndexTable(connection, physicalName.getBytes());
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, byte[] physicalTableName) throws SQLException {
        try {
            TableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalTableName);
            if (desc == null) {
                return false;
            }
            return MetaDataUtil.hasLocalIndexColumnFamily(desc);
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static boolean hasLocalIndexColumnFamily(TableDescriptor desc) {
        for (ColumnFamilyDescriptor cf : desc.getColumnFamilies()) {
            if (!cf.getNameAsString().startsWith("L#")) continue;
            return true;
        }
        return false;
    }

    public static List<byte[]> getNonLocalIndexColumnFamilies(TableDescriptor desc) {
        ArrayList<byte[]> families = new ArrayList<byte[]>(desc.getColumnFamilies().length);
        for (ColumnFamilyDescriptor cf : desc.getColumnFamilies()) {
            if (cf.getNameAsString().startsWith("L#")) continue;
            families.add(cf.getName());
        }
        return families;
    }

    public static List<byte[]> getLocalIndexColumnFamilies(PhoenixConnection conn, byte[] physicalTableName) throws SQLException {
        TableDescriptor desc = conn.getQueryServices().getTableDescriptor(physicalTableName);
        if (desc == null) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> families = new ArrayList<byte[]>(desc.getColumnFamilies().length / 2);
        for (ColumnFamilyDescriptor cf : desc.getColumnFamilies()) {
            if (!cf.getNameAsString().startsWith("L#")) continue;
            families.add(cf.getName());
        }
        return families;
    }

    public static void deleteViewIndexSequences(PhoenixConnection connection, PName name, boolean isNamespaceMapped) throws SQLException {
        String schemaName = MetaDataUtil.getViewIndexSequenceSchemaName(name, isNamespaceMapped);
        String sequenceName = MetaDataUtil.getViewIndexSequenceName(name, null, isNamespaceMapped);
        String delQuery = String.format(" DELETE FROM SYSTEM.\"SEQUENCE\" WHERE SEQUENCE_SCHEMA %s AND SEQUENCE_NAME = ? ", schemaName.length() > 0 ? "= ? " : " IS NULL");
        try (PreparedStatement delSeqStmt = connection.prepareStatement(delQuery);){
            if (schemaName.length() > 0) {
                delSeqStmt.setString(1, schemaName);
                delSeqStmt.setString(2, sequenceName);
            } else {
                delSeqStmt.setString(1, sequenceName);
            }
            delSeqStmt.executeUpdate();
        }
    }

    public static boolean propertyNotAllowedToBeOutOfSync(String colFamProp) {
        return SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES.contains(colFamProp);
    }

    public static Map<String, Object> getSyncedProps(ColumnFamilyDescriptor defaultCFDesc) {
        HashMap<String, Object> syncedProps = new HashMap<String, Object>();
        if (defaultCFDesc != null) {
            for (String propToKeepInSync : SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
                syncedProps.put(propToKeepInSync, Bytes.toString((byte[])defaultCFDesc.getValue(Bytes.toBytes((String)propToKeepInSync))));
            }
        }
        return syncedProps;
    }

    public static Scan newTableRowsScan(byte[] key, long startTimeStamp, long stopTimeStamp) {
        return MetaDataUtil.newTableRowsScan(key, null, startTimeStamp, stopTimeStamp);
    }

    public static Scan newTableRowsScan(byte[] startKey, byte[] stopKey, long startTimeStamp, long stopTimeStamp) {
        Scan scan = new Scan();
        ScanUtil.setTimeRange(scan, startTimeStamp, stopTimeStamp);
        scan.withStartRow(startKey);
        if (stopKey == null) {
            stopKey = ByteUtil.concat(startKey, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
        }
        scan.withStopRow(stopKey);
        return scan;
    }

    public static PTable.LinkType getLinkType(Mutation tableMutation) {
        return MetaDataUtil.getLinkType((Collection)tableMutation.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES));
    }

    public static PTable.LinkType getLinkType(Collection<Cell> kvs) {
        if (kvs != null) {
            for (Cell kv : kvs) {
                if (!MetaDataUtil.isLinkType(kv)) continue;
                return PTable.LinkType.fromSerializedValue(PUnsignedTinyint.INSTANCE.getCodec().decodeByte(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault()));
            }
        }
        return null;
    }

    public static boolean isLocalIndex(String physicalName) {
        return physicalName.contains(LOCAL_INDEX_TABLE_PREFIX);
    }

    public static boolean isLinkType(Cell kv) {
        return CellUtil.matchingQualifier((Cell)kv, (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
    }

    public static boolean isLinkType(Mutation m) {
        boolean foundLinkType = false;
        for (Cell kv : (List)m.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)) {
            if (!MetaDataUtil.isLinkType(kv)) continue;
            foundLinkType = true;
            break;
        }
        return foundLinkType;
    }

    public static boolean isParentTableColumnQualifierCounter(Mutation m, byte[] tableRow) {
        boolean foundCQCounter = false;
        for (Cell kv : (List)m.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)) {
            if (!MetaDataUtil.isParentTableColumnQualifierCounter(kv, tableRow)) continue;
            foundCQCounter = true;
            break;
        }
        return foundCQCounter;
    }

    public static boolean isParentTableColumnQualifierCounter(Cell kv, byte[] tableRow) {
        byte[] columnTableName;
        byte[][] tableRowKeyMetaData = new byte[5][];
        SchemaUtil.getVarChars(tableRow, tableRowKeyMetaData);
        byte[] tableName = tableRowKeyMetaData[2];
        byte[][] columnRowKeyMetaData = new byte[5][];
        int nColumns = SchemaUtil.getVarChars(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), 0, columnRowKeyMetaData);
        if (nColumns == 5 && !Bytes.equals((byte[])tableName, (byte[])(columnTableName = columnRowKeyMetaData[2]))) {
            return CellUtil.matchingQualifier((Cell)kv, (byte[])PhoenixDatabaseMetaData.COLUMN_QUALIFIER_BYTES);
        }
        return false;
    }

    public static boolean isViewIndex(String physicalName) {
        if (physicalName.contains(":")) {
            return SchemaUtil.getTableNameFromFullName(physicalName).startsWith(VIEW_INDEX_TABLE_PREFIX);
        }
        return physicalName.startsWith(VIEW_INDEX_TABLE_PREFIX);
    }

    public static String getAutoPartitionColumnName(PTable parentTable) {
        List<PColumn> parentTableColumns = parentTable.getPKColumns();
        PColumn column = parentTableColumns.get(MetaDataUtil.getAutoPartitionColIndex(parentTable));
        return column.getName().getString();
    }

    public static int getAutoPartitionColIndex(PTable parentTable) {
        boolean isSalted;
        boolean isMultiTenant = parentTable.isMultiTenant();
        boolean bl = isSalted = parentTable.getBucketNum() != null;
        return isMultiTenant && isSalted ? 2 : (isMultiTenant || isSalted ? 1 : 0);
    }

    public static boolean isHColumnProperty(String propName) {
        return ColumnFamilyDescriptorBuilder.getDefaultValues().containsKey(propName);
    }

    public static boolean isHTableProperty(String propName) {
        return !MetaDataUtil.isHColumnProperty(propName) && !TableProperty.isPhoenixTableProperty(propName);
    }

    public static boolean isLocalIndexFamily(ImmutableBytesPtr cfPtr) {
        return cfPtr.getLength() >= QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES.length && Bytes.compareTo((byte[])cfPtr.get(), (int)cfPtr.getOffset(), (int)QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES.length, (byte[])QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES, (int)0, (int)QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES.length) == 0;
    }

    public static boolean isLocalIndexFamily(byte[] cf) {
        return Bytes.startsWith((byte[])cf, (byte[])QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES);
    }

    public static final byte[] getPhysicalTableRowForView(PTable view) {
        byte[] physicalTableSchemaName = Bytes.toBytes((String)SchemaUtil.getSchemaNameFromFullName(view.getPhysicalName().getString()));
        byte[] physicalTableName = Bytes.toBytes((String)SchemaUtil.getTableNameFromFullName(view.getPhysicalName().getString()));
        return SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, physicalTableSchemaName, physicalTableName);
    }

    public static List<Mutation> removeChildLinkMutations(List<Mutation> metadataMutations) {
        ArrayList childLinkMutations = Lists.newArrayList();
        Iterator<Mutation> iter = metadataMutations.iterator();
        while (iter.hasNext()) {
            Mutation m = iter.next();
            for (Cell kv : (List)m.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)) {
                if (Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length) != 0 || Bytes.compareTo((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])PTable.LinkType.CHILD_TABLE.getSerializedValueAsByteArray(), (int)0, (int)PTable.LinkType.CHILD_TABLE.getSerializedValueAsByteArray().length) != 0) continue;
                childLinkMutations.add(m);
                iter.remove();
            }
        }
        return childLinkMutations;
    }

    public static PTable.IndexType getIndexType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.INDEX_TYPE_BYTES, builder, value)) {
            return PTable.IndexType.fromSerializedValue(value.get()[value.getOffset()]);
        }
        return null;
    }

    public static PDataType<?> getIndexDataType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.VIEW_INDEX_ID_DATA_TYPE_BYTES, builder, value)) {
            return PDataType.fromTypeId(PInteger.INSTANCE.getCodec().decodeInt(value, SortOrder.getDefault()));
        }
        return MetaDataUtil.getLegacyViewIndexIdDataType();
    }

    public static boolean getChangeDetectionEnabled(List<Mutation> tableMetaData) {
        KeyValueBuilder builder = GenericKeyValueBuilder.INSTANCE;
        ImmutableBytesWritable value = new ImmutableBytesWritable();
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.CHANGE_DETECTION_ENABLED_BYTES, builder, value)) {
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(value.get(), value.getOffset(), value.getLength()));
        }
        return false;
    }

    public static PColumn getColumn(int pkCount, byte[][] rowKeyMetaData, PTable table) throws ColumnFamilyNotFoundException, ColumnNotFoundException {
        PColumn col = null;
        if (pkCount > 4 && rowKeyMetaData[4].length > 0) {
            PColumnFamily family = table.getColumnFamily(rowKeyMetaData[4]);
            col = family.getPColumnForColumnNameBytes(rowKeyMetaData[3]);
        } else if (pkCount > 3 && rowKeyMetaData[3].length > 0) {
            col = table.getPKColumn(new String(rowKeyMetaData[3], StandardCharsets.UTF_8));
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromStatsTable(PhoenixConnection connection, PTable table, List<byte[]> physicalTableNames, List<MetaDataProtocol.SharedTableState> sharedTableStates) throws SQLException {
        boolean isAutoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            HashSet<String> physicalTablesSet = new HashSet<String>();
            physicalTablesSet.add(table.getPhysicalName().getString());
            for (byte[] physicalTableName : physicalTableNames) {
                physicalTablesSet.add(Bytes.toString((byte[])physicalTableName));
            }
            for (MetaDataProtocol.SharedTableState s : sharedTableStates) {
                physicalTablesSet.add(s.getPhysicalNames().get(0).getString());
            }
            StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.STATS WHERE PHYSICAL_NAME IN (");
            for (int i = 0; i < physicalTablesSet.size(); ++i) {
                buf.append(" ?,");
            }
            buf.setCharAt(buf.length() - 1, ')');
            if (table.getIndexType() == PTable.IndexType.LOCAL) {
                buf.append(" AND COLUMN_FAMILY IN(");
                if (table.getColumnFamilies().isEmpty()) {
                    buf.append("'L#0',");
                } else {
                    buf.append(QueryUtil.generateInListParams(table.getColumnFamilies().size()));
                }
                buf.setCharAt(buf.length() - 1, ')');
            }
            try (PreparedStatement delStatsStmt = connection.prepareStatement(buf.toString());){
                int param = 0;
                Iterator itr = physicalTablesSet.iterator();
                while (itr.hasNext()) {
                    delStatsStmt.setString(++param, itr.next().toString());
                }
                if (table.getIndexType() == PTable.IndexType.LOCAL && !table.getColumnFamilies().isEmpty()) {
                    for (PColumnFamily cf : table.getColumnFamilies()) {
                        delStatsStmt.setString(++param, cf.getName().getString());
                    }
                }
                delStatsStmt.execute();
            }
        }
        finally {
            connection.setAutoCommit(isAutoCommit);
        }
    }

    public static boolean avoidMetadataRPC(PhoenixConnection connection, PTable table, PTableRef tableRef, long effectiveUpdateCacheFreq) {
        return table.getRowTimestampColPos() == -1 && connection.getMetaDataCache().getAge(tableRef) < effectiveUpdateCacheFreq;
    }

    public static TTLExpression convertForeverAndNoneTTLValue(Object propValue, boolean forSystemCatalog) {
        if (propValue == null) {
            return forSystemCatalog ? LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED : LiteralTTLExpression.TTL_EXPRESSION_FOREVER;
        }
        if (propValue instanceof String) {
            String strValue = (String)propValue;
            if ("FOREVER".equalsIgnoreCase(strValue) || "NONE".equalsIgnoreCase(strValue) || "0".equalsIgnoreCase(strValue)) {
                propValue = forSystemCatalog ? 0 : Integer.MAX_VALUE;
            }
        } else if (propValue instanceof Integer && propValue.equals(0)) {
            propValue = forSystemCatalog ? 0 : Integer.MAX_VALUE;
        }
        return (TTLExpression)TableProperty.TTL.getValue(propValue);
    }

    public static TTLExpression getCompatibleTTLExpression(TTLExpression expression, PTableType tableType, PTable.ViewType viewType, String tableName) throws SQLException {
        if (!MetaDataUtil.isTTLSupported(tableType, viewType, tableName)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TTL_SUPPORTED_FOR_TABLES_AND_VIEWS_ONLY).build().buildException();
        }
        TTLExpression ttl = tableType != PTableType.TABLE || expression instanceof ConditionalTTLExpression ? expression : (expression.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) || expression.equals(LiteralTTLExpression.TTL_EXPRESSION_FOREVER) ? LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED : LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR);
        return ttl;
    }

    public static boolean isTTLSupported(PTableType tableType, PTable.ViewType viewType, String tableName) {
        return tableType == PTableType.TABLE || tableType == PTableType.VIEW && viewType == PTable.ViewType.UPDATABLE || tableType == PTableType.SYSTEM && SYSTEM_TABLES_WITH_TTL_SUPPORTED.contains(tableName);
    }

    public static class ClientServerCompatibility {
        private int errorCode = 0;
        private boolean isCompatible;

        ClientServerCompatibility() {
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public boolean getIsCompatible() {
            return this.isCompatible;
        }

        void setCompatible(boolean isCompatible) {
            this.isCompatible = isCompatible;
        }
    }
}

