/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.phoenix.jdbc.AbstractRPCConnectionInfo;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.ZKConnectionInfo;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;

public class JDBCUtil {
    private JDBCUtil() {
    }

    public static String findProperty(String url, Properties info, String propName) {
        int begIndex;
        String urlPropName = ";" + propName.toUpperCase() + "=";
        String upperCaseURL = url.toUpperCase();
        String propValue = info.getProperty(propName);
        if (propValue == null && (begIndex = upperCaseURL.indexOf(urlPropName)) >= 0) {
            int endIndex = upperCaseURL.indexOf(59, begIndex + urlPropName.length());
            if (endIndex < 0) {
                endIndex = url.length();
            }
            propValue = url.substring(begIndex + urlPropName.length(), endIndex);
        }
        return propValue;
    }

    public static String removeProperty(String url, String propName) {
        String urlPropName = ";" + propName.toUpperCase() + "=";
        String upperCaseURL = url.toUpperCase();
        int begIndex = upperCaseURL.indexOf(urlPropName);
        if (begIndex >= 0) {
            int endIndex = upperCaseURL.indexOf(59, begIndex + urlPropName.length());
            if (endIndex < 0) {
                endIndex = url.length();
            }
            String prefix = url.substring(0, begIndex);
            String suffix = url.substring(endIndex, url.length());
            return prefix + suffix;
        }
        return url;
    }

    private static Map<String, String> getCombinedConnectionProperties(String url, Properties info) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)info.size());
        for (String propName : info.stringPropertyNames()) {
            result.put(propName, info.getProperty(propName));
        }
        String[] urlPropNameValues = url.split(Character.toString(';'));
        if (urlPropNameValues.length > 1) {
            for (int i = 1; i < urlPropNameValues.length; ++i) {
                String[] urlPropNameValue = urlPropNameValues[i].split("=");
                if (urlPropNameValue.length != 2) continue;
                result.put(urlPropNameValue[0], urlPropNameValue[1]);
            }
        }
        return result;
    }

    public static Map<String, String> getAnnotations(@NonNull String url, @NonNull Properties info) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)info);
        Map<String, String> combinedProperties = JDBCUtil.getCombinedConnectionProperties(url, info);
        HashMap result = Maps.newHashMapWithExpectedSize((int)combinedProperties.size());
        for (Map.Entry<String, String> prop : combinedProperties.entrySet()) {
            if (!prop.getKey().startsWith("phoenix.annotation.") || prop.getKey().length() <= "phoenix.annotation.".length()) continue;
            result.put(prop.getKey().substring("phoenix.annotation.".length()), prop.getValue());
        }
        return result;
    }

    public static Long getCurrentSCN(String url, Properties info) throws SQLException {
        String scnStr = JDBCUtil.findProperty(url, info, "CurrentSCN");
        return scnStr == null ? null : Long.valueOf(Long.parseLong(scnStr));
    }

    public static Long getBuildIndexSCN(String url, Properties info) throws SQLException {
        String scnStr = JDBCUtil.findProperty(url, info, "BuildIndexAt");
        return scnStr == null ? null : Long.valueOf(Long.parseLong(scnStr));
    }

    public static int getMutateBatchSize(String url, Properties info, ReadOnlyProps props) throws SQLException {
        String batchSizeStr = JDBCUtil.findProperty(url, info, "UpsertBatchSize");
        return batchSizeStr == null ? props.getInt("phoenix.mutate.batchSize", 100) : Integer.parseInt(batchSizeStr);
    }

    public static long getMutateBatchSizeBytes(String url, Properties info, ReadOnlyProps props) throws SQLException {
        String batchSizeStr = JDBCUtil.findProperty(url, info, "UpsertBatchSizeBytes");
        return batchSizeStr == null ? props.getLongBytes("phoenix.mutate.batchSizeBytes", 0x200000L) : Long.parseLong(batchSizeStr);
    }

    @Nullable
    public static PName getTenantId(String url, Properties info) throws SQLException {
        String tenantId = JDBCUtil.findProperty(url, info, "TenantId");
        return tenantId == null ? null : PNameFactory.newName(tenantId);
    }

    public static boolean getAutoCommit(String url, Properties info, boolean defaultValue) {
        String autoCommit = JDBCUtil.findProperty(url, info, "AutoCommit");
        if (autoCommit == null) {
            return defaultValue;
        }
        return Boolean.valueOf(autoCommit);
    }

    public static Consistency getConsistencyLevel(String url, Properties info, String defaultValue) {
        String consistency = JDBCUtil.findProperty(url, info, "Consistency");
        if (consistency != null && consistency.equalsIgnoreCase(Consistency.TIMELINE.toString())) {
            return Consistency.TIMELINE;
        }
        return Consistency.STRONG;
    }

    public static boolean isCollectingRequestLevelMetricsEnabled(String url, Properties overrideProps, ReadOnlyProps queryServicesProps) throws SQLException {
        String batchSizeStr = JDBCUtil.findProperty(url, overrideProps, "RequestMetric");
        return batchSizeStr == null ? queryServicesProps.getBoolean("phoenix.query.request.metrics.enabled", false) : Boolean.parseBoolean(batchSizeStr);
    }

    public static String getSchema(String url, Properties info, String defaultValue) {
        String schema = JDBCUtil.findProperty(url, info, "schema");
        return schema == null || schema.equals("") ? defaultValue : schema;
    }

    public static String formatUrl(String jdbcUrl) {
        try {
            ConnectionInfo connInfo = ConnectionInfo.create(jdbcUrl, null, null);
            StringBuilder sb = new StringBuilder();
            if (connInfo instanceof AbstractRPCConnectionInfo) {
                AbstractRPCConnectionInfo rpcInfo = (AbstractRPCConnectionInfo)connInfo;
                sb.append(rpcInfo.getBoostrapServers().replaceAll(":", "\\\\:"));
            } else {
                ZKConnectionInfo zkInfo = (ZKConnectionInfo)connInfo;
                sb.append(zkInfo.getZkHosts().replaceAll(":", "\\\\:")).append("::").append(zkInfo.getZkRootNode());
            }
            return sb.toString();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatUrl(String url, ClusterRoleRecord.RegistryType registryType) {
        if (!url.startsWith("jdbc:phoenix")) {
            switch (registryType) {
                case ZK: {
                    return JDBCUtil.formatUrl("jdbc:phoenix+zk:" + url);
                }
                case MASTER: {
                    return JDBCUtil.formatUrl("jdbc:phoenix+master:" + url);
                }
                case RPC: {
                    return JDBCUtil.formatUrl("jdbc:phoenix+rpc:" + url);
                }
            }
            return JDBCUtil.formatUrl("jdbc:phoenix:" + url);
        }
        return JDBCUtil.formatUrl(url);
    }
}

