/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.visitor.RowKeyExpressionVisitor;
import org.apache.phoenix.hbase.index.AbstractValueGetter;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class IndexUtil {
    public static final String INDEX_COLUMN_NAME_SEP = ":";
    public static final byte[] INDEX_COLUMN_NAME_SEP_BYTES = Bytes.toBytes((String)":");
    public static final String CODEC_CLASS_NAME_KEY = "org.apache.hadoop.hbase.index.codec.class";
    public static final String PHOENIX_INDEX_BUILDER_CLASSNAME = "org.apache.phoenix.index.PhoenixIndexBuilder";
    public static final String INDEX_BUILDER_CONF_KEY = "index.builder";
    private static final Cache<String, Boolean> indexNameGlobalIndexCheckerEnabledMap = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    private IndexUtil() {
    }

    public static PDataType getIndexColumnDataType(PColumn dataColumn) throws SQLException {
        PDataType type = IndexUtil.getIndexColumnDataType(dataColumn.isNullable(), dataColumn.getDataType());
        if (type == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_INDEX_COLUMN_ON_TYPE).setColumnName(dataColumn.getName().getString()).setMessage("Type=" + dataColumn.getDataType()).build().buildException();
        }
        return type;
    }

    public static PDataType getIndexColumnDataType(boolean isNullable, PDataType dataType) {
        if (dataType == null || !isNullable || !dataType.isFixedWidth()) {
            return dataType;
        }
        if (dataType.isCastableTo(PDecimal.INSTANCE)) {
            return PDecimal.INSTANCE;
        }
        if (dataType.isCoercibleTo(PVarchar.INSTANCE)) {
            return PVarchar.INSTANCE;
        }
        if (PBinary.INSTANCE.equals(dataType)) {
            return PVarbinary.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported non nullable type " + dataType);
    }

    public static String getDataColumnName(String name) {
        return name.substring(name.indexOf(INDEX_COLUMN_NAME_SEP) + 1);
    }

    public static String getDataColumnFamilyName(String name) {
        return name.substring(0, name.indexOf(INDEX_COLUMN_NAME_SEP));
    }

    public static String getActualColumnFamilyName(String name) {
        if (name.startsWith("L#")) {
            return name.substring("L#".length());
        }
        return name;
    }

    public static String getCaseSensitiveDataColumnFullName(String name) {
        int index = name.indexOf(INDEX_COLUMN_NAME_SEP);
        return SchemaUtil.getCaseSensitiveColumnDisplayName(IndexUtil.getDataColumnFamilyName(name), name.substring(index + 1));
    }

    public static String getIndexColumnName(String dataColumnFamilyName, String dataColumnName) {
        return (dataColumnFamilyName == null ? "" : dataColumnFamilyName) + INDEX_COLUMN_NAME_SEP + dataColumnName;
    }

    public static byte[] getIndexColumnName(byte[] dataColumnFamilyName, byte[] dataColumnName) {
        return ByteUtil.concat(dataColumnFamilyName == null ? ByteUtil.EMPTY_BYTE_ARRAY : dataColumnFamilyName, INDEX_COLUMN_NAME_SEP_BYTES, dataColumnName);
    }

    public static String getIndexColumnName(PColumn dataColumn) {
        String dataColumnFamilyName = SchemaUtil.isPKColumn(dataColumn) ? null : dataColumn.getFamilyName().getString();
        return IndexUtil.getIndexColumnName(dataColumnFamilyName, dataColumn.getName().getString());
    }

    public static PColumn getIndexPKColumn(int position, PColumn dataColumn) {
        assert (SchemaUtil.isPKColumn(dataColumn));
        PName indexColumnName = PNameFactory.newName(IndexUtil.getIndexColumnName(null, dataColumn.getName().getString()));
        PColumnImpl column = new PColumnImpl(indexColumnName, null, dataColumn.getDataType(), dataColumn.getMaxLength(), dataColumn.getScale(), dataColumn.isNullable(), position, dataColumn.getSortOrder(), dataColumn.getArraySize(), null, false, dataColumn.getExpressionStr(), dataColumn.isRowTimestamp(), false, null, Long.MAX_VALUE);
        return column;
    }

    public static String getLocalIndexColumnFamily(String dataColumnFamilyName) {
        return dataColumnFamilyName == null ? null : "L#" + dataColumnFamilyName;
    }

    public static byte[] getLocalIndexColumnFamily(byte[] dataColumnFamilyBytes) {
        String dataCF = Bytes.toString((byte[])dataColumnFamilyBytes);
        return IndexUtil.getLocalIndexColumnFamily(dataCF).getBytes(StandardCharsets.UTF_8);
    }

    public static PColumn getDataColumn(PTable dataTable, String indexColumnName) {
        PColumn column = IndexUtil.getDataColumnOrNull(dataTable, indexColumnName);
        if (column == null) {
            throw new IllegalArgumentException("Could not find column \"" + SchemaUtil.getColumnName(IndexUtil.getDataColumnFamilyName(indexColumnName), IndexUtil.getDataColumnName(indexColumnName)) + " in " + dataTable);
        }
        return column;
    }

    public static PColumn getDataColumnOrNull(PTable dataTable, String indexColumnName) {
        PColumnFamily family;
        int pos = indexColumnName.indexOf(INDEX_COLUMN_NAME_SEP);
        if (pos < 0) {
            return null;
        }
        if (pos == 0) {
            try {
                return dataTable.getPKColumn(indexColumnName.substring(1));
            }
            catch (ColumnNotFoundException e) {
                return null;
            }
        }
        try {
            family = dataTable.getColumnFamily(IndexUtil.getDataColumnFamilyName(indexColumnName));
        }
        catch (ColumnFamilyNotFoundException e) {
            return null;
        }
        try {
            return family.getPColumnForColumnName(indexColumnName.substring(pos + 1));
        }
        catch (ColumnNotFoundException e) {
            return null;
        }
    }

    public static List<PColumn> getDataColumns(String dataTableName, List<PColumn> indexColumns, PhoenixConnection conn) throws SQLException {
        PTable dataTable = conn.getTable(dataTableName);
        ArrayList<PColumn> dataColumns = new ArrayList<PColumn>(indexColumns.size());
        for (PColumn indexColumn : indexColumns) {
            dataColumns.add(IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString()));
        }
        return dataColumns;
    }

    public static boolean isEmptyKeyValue(PTable table, ColumnReference ref) {
        byte[] emptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(table);
        byte[] emptyKeyValueQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst();
        return Bytes.compareTo((byte[])emptyKeyValueCF, (int)0, (int)emptyKeyValueCF.length, (byte[])ref.getFamilyWritable().get(), (int)ref.getFamilyWritable().getOffset(), (int)ref.getFamilyWritable().getLength()) == 0 && Bytes.compareTo((byte[])emptyKeyValueQualifier, (int)0, (int)emptyKeyValueQualifier.length, (byte[])ref.getQualifierWritable().get(), (int)ref.getQualifierWritable().getOffset(), (int)ref.getQualifierWritable().getLength()) == 0;
    }

    public static boolean isGlobalIndexCheckerEnabled(PhoenixConnection connection, PName index) throws SQLException {
        String indexName = index.getString();
        Boolean entry = (Boolean)indexNameGlobalIndexCheckerEnabledMap.getIfPresent((Object)indexName);
        if (entry != null) {
            return entry;
        }
        boolean result = false;
        try {
            TableDescriptor desc = connection.getQueryServices().getTableDescriptor(index.getBytes());
            if (desc != null && desc.hasCoprocessor("org.apache.phoenix.index.GlobalIndexChecker")) {
                result = true;
            }
            indexNameGlobalIndexCheckerEnabledMap.put((Object)indexName, (Object)result);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static List<Mutation> generateIndexData(final PTable table, PTable index, MutationState.MultiRowMutationState multiRowMutationState, List<Mutation> dataMutations, final KeyValueBuilder kvBuilder, PhoenixConnection connection) throws SQLException, IOException {
        try {
            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
            IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
            ArrayList indexMutations = Lists.newArrayListWithExpectedSize((int)dataMutations.size());
            for (final Mutation dataMutation : dataMutations) {
                long ts = MetaDataUtil.getClientTimeStamp(dataMutation);
                ptr.set(dataMutation.getRow());
                if (!(dataMutation instanceof Put)) continue;
                AbstractValueGetter valueGetter = new AbstractValueGetter(){

                    @Override
                    public byte[] getRowKey() {
                        return dataMutation.getRow();
                    }

                    @Override
                    public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) {
                        if (IndexUtil.isEmptyKeyValue(table, ref)) {
                            return null;
                        }
                        byte[] family = ref.getFamily();
                        byte[] qualifier = ref.getQualifier();
                        NavigableMap familyMap = dataMutation.getFamilyCellMap();
                        List kvs = (List)familyMap.get(family);
                        if (kvs == null) {
                            return null;
                        }
                        for (Cell kv : kvs) {
                            if (Bytes.compareTo((byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])family, (int)0, (int)family.length) != 0 || Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])qualifier, (int)0, (int)qualifier.length) != 0) continue;
                            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                            kvBuilder.getValueAsPtr(kv, ptr);
                            return ptr;
                        }
                        return null;
                    }
                };
                byte[] regionStartKey = null;
                byte[] regionEndkey = null;
                if (maintainer.isLocalIndex()) {
                    HRegionLocation tableRegionLocation = connection.getQueryServices().getTableRegionLocation(table.getPhysicalName().getBytes(), dataMutation.getRow());
                    regionStartKey = tableRegionLocation.getRegion().getStartKey();
                    regionEndkey = tableRegionLocation.getRegion().getEndKey();
                }
                indexMutations.add(maintainer.buildUpdateMutation(kvBuilder, valueGetter, ptr, ts, regionStartKey, regionEndkey, false));
            }
            return indexMutations;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static boolean isDataPKColumn(PColumn column) {
        return column.getName().getString().startsWith(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean isIndexColumn(String name) {
        return name.contains(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean getViewConstantValue(PColumn column, ImmutableBytesWritable ptr) {
        byte[] value = column.getViewConstant();
        if (value != null) {
            ptr.set(value, 0, value.length - 1);
            return true;
        }
        return false;
    }

    public static void setRowKeyExpressionOffset(Expression rootExpression, final int offset) {
        rootExpression.accept(new RowKeyExpressionVisitor(){

            @Override
            public Void visit(RowKeyColumnExpression node) {
                node.setOffset(offset);
                return null;
            }
        });
    }

    public static ColumnReference[] deserializeDataTableColumnsToJoin(Scan scan) {
        byte[] columnsBytes = scan.getAttribute("_DataTableColumnsToJoin");
        if (columnsBytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(columnsBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            int numColumns = WritableUtils.readVInt((DataInput)input);
            ColumnReference[] dataColumns = new ColumnReference[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                dataColumns[i] = new ColumnReference(Bytes.readByteArray((DataInput)input), Bytes.readByteArray((DataInput)input));
            }
            ColumnReference[] columnReferenceArray = dataColumns;
            return columnReferenceArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<IndexMaintainer> deSerializeIndexMaintainersFromScan(Scan scan) {
        boolean useProto = false;
        byte[] indexBytes = scan.getAttribute("_LocalIndexBuild");
        boolean bl = useProto = indexBytes != null;
        if (indexBytes == null) {
            indexBytes = scan.getAttribute("_LocalIndexBuild");
        }
        if (indexBytes == null) {
            indexBytes = scan.getAttribute("IdxProtoMD");
            boolean bl2 = useProto = indexBytes != null;
        }
        if (indexBytes == null) {
            indexBytes = scan.getAttribute("IdxMD");
        }
        List<IndexMaintainer> indexMaintainers = indexBytes == null ? null : IndexMaintainer.deserialize(indexBytes, useProto);
        return indexMaintainers;
    }

    public static byte[][] deserializeViewConstantsFromScan(Scan scan) {
        byte[] bytes = scan.getAttribute("_ViewConstants");
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            int numConstants = WritableUtils.readVInt((DataInput)input);
            byte[][] viewConstants = new byte[numConstants][];
            for (int i = 0; i < numConstants; ++i) {
                viewConstants[i] = Bytes.readByteArray((DataInput)input);
            }
            byte[][] byArrayArray = viewConstants;
            return byArrayArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static KeyValueSchema deserializeLocalIndexJoinSchemaFromScan(Scan scan) {
        byte[] schemaBytes = scan.getAttribute("_LocalIndexJoinSchema");
        if (schemaBytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(schemaBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            KeyValueSchema schema = new KeyValueSchema();
            schema.readFields(input);
            KeyValueSchema keyValueSchema = schema;
            return keyValueSchema;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static TupleProjector getTupleProjector(Scan scan, ColumnReference[] dataColumns) {
        if (dataColumns != null && dataColumns.length != 0) {
            KeyValueSchema keyValueSchema = IndexUtil.deserializeLocalIndexJoinSchemaFromScan(scan);
            boolean storeColsInSingleCell = scan.getAttribute("_ColumnsStoredInSingleCell") != null;
            PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
            PTable.ImmutableStorageScheme immutableStorageScheme = EncodedColumnsUtil.getImmutableStorageScheme(scan);
            Expression[] colExpressions = storeColsInSingleCell ? new SingleCellColumnExpression[dataColumns.length] : new KeyValueColumnExpression[dataColumns.length];
            for (int i = 0; i < dataColumns.length; ++i) {
                byte[] family = dataColumns[i].getFamily();
                byte[] qualifier = dataColumns[i].getQualifier();
                ValueSchema.Field field = keyValueSchema.getField(i);
                KeyValueColumnExpression dataColumnExpr = storeColsInSingleCell ? new SingleCellColumnExpression(field, family, qualifier, encodingScheme, immutableStorageScheme) : new KeyValueColumnExpression(field, family, qualifier);
                colExpressions[i] = dataColumnExpr;
            }
            return new TupleProjector(keyValueSchema, colExpressions);
        }
        return null;
    }

    public static String rewriteViewStatement(PhoenixConnection conn, PTable index, PTable table, String viewStatement) throws SQLException {
        if (viewStatement == null) {
            return null;
        }
        SelectStatement select = new SQLParser(viewStatement).parseQuery();
        ColumnResolver resolver = FromCompiler.getResolver(new TableRef(table));
        SelectStatement translatedSelect = IndexStatementRewriter.translate(select, resolver);
        ParseNode whereNode = translatedSelect.getWhere();
        PhoenixStatement statement = new PhoenixStatement(conn);
        TableRef indexTableRef = new TableRef(index){

            @Override
            public String getColumnDisplayName(ColumnRef ref, boolean schemaNameCaseSensitive, boolean colNameCaseSensitive) {
                return "\"" + ref.getColumn().getName().getString() + "\"";
            }
        };
        ColumnResolver indexResolver = FromCompiler.getResolver(indexTableRef);
        StatementContext context = new StatementContext(statement, indexResolver);
        WhereCompiler.compile(context, whereNode);
        StringBuilder buf = new StringBuilder();
        whereNode.toSQL(indexResolver, buf);
        return QueryUtil.getViewStatement(index.getSchemaName().getString(), index.getTableName().getString(), buf.toString());
    }

    public static void addTupleAsOneCell(List<Cell> result, Tuple tuple, TupleProjector tupleProjector, ImmutableBytesWritable ptr) {
        byte[] value = tupleProjector.getSchema().toBytes(tuple, tupleProjector.getExpressions(), tupleProjector.getValueBitSet(), ptr);
        Cell firstCell = result.get(0);
        Cell keyValue = PhoenixKeyValueUtil.newKeyValue(firstCell.getRowArray(), firstCell.getRowOffset(), firstCell.getRowLength(), QueryConstants.VALUE_COLUMN_FAMILY, QueryConstants.VALUE_COLUMN_QUALIFIER, firstCell.getTimestamp(), value, 0, value.length);
        result.add(keyValue);
    }

    public static String getIndexColumnExpressionStr(PColumn col) {
        return col.getExpressionStr() == null ? IndexUtil.getCaseSensitiveDataColumnFullName(col.getName().getString()) : col.getExpressionStr();
    }

    public static byte[][] getViewConstants(PTable dataTable) {
        if (dataTable.getType() != PTableType.VIEW && dataTable.getType() != PTableType.PROJECTED) {
            return null;
        }
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ArrayList<byte[]> viewConstants = new ArrayList<byte[]>();
        List<PColumn> dataPkColumns = dataTable.getPKColumns();
        for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
            PColumn dataPKColumn = dataPkColumns.get(i);
            if (dataPKColumn.getViewConstant() == null) continue;
            if (IndexUtil.getViewConstantValue(dataPKColumn, ptr)) {
                viewConstants.add(ByteUtil.copyKeyBytesIfNecessary(ptr));
                continue;
            }
            throw new IllegalStateException();
        }
        return viewConstants.isEmpty() ? null : (byte[][])viewConstants.toArray((T[])new byte[viewConstants.size()][]);
    }

    public static MetaDataProtocol.MetaDataMutationResult updateIndexState(String indexTableName, long minTimeStamp, Table metaTable, PIndexState newState) throws Throwable {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(indexTableName);
        return IndexUtil.updateIndexState(indexTableKey, minTimeStamp, metaTable, newState);
    }

    public static MetaDataProtocol.MetaDataMutationResult updateIndexState(byte[] indexTableKey, long minTimeStamp, Table metaTable, PIndexState newState) throws Throwable {
        Put put = new Put(indexTableKey);
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, newState.getSerializedBytes());
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(minTimeStamp));
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ASYNC_REBUILD_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(0));
        final List<Put> tableMetadata = Collections.singletonList(put);
        Map results = metaTable.coprocessorService(MetaDataProtos.MetaDataService.class, indexTableKey, indexTableKey, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetadata) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.updateIndexState((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        if (results.isEmpty()) {
            throw new IOException("Didn't get expected result size");
        }
        MetaDataProtos.MetaDataResponse tmpResponse = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
        return MetaDataProtocol.MetaDataMutationResult.constructFromProto(tmpResponse);
    }

    public static boolean matchingSplitKeys(byte[][] splitKeys1, byte[][] splitKeys2) {
        if (splitKeys1 != null && splitKeys2 != null && splitKeys1.length == splitKeys2.length) {
            for (int i = 0; i < splitKeys1.length; ++i) {
                if (Bytes.compareTo((byte[])splitKeys1[i], (byte[])splitKeys2[i]) == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static PTable getPDataTable(PhoenixConnection conn, TableDescriptor tableDesc) throws SQLException {
        String dataTableName = Bytes.toString((byte[])tableDesc.getValue(MetaDataUtil.DATA_TABLE_NAME_PROP_BYTES));
        String physicalTableName = tableDesc.getTableName().getNameAsString();
        PTable pDataTable = null;
        if (dataTableName == null) {
            if (physicalTableName.contains(INDEX_COLUMN_NAME_SEP)) {
                try {
                    pDataTable = conn.getTable(physicalTableName.replace(INDEX_COLUMN_NAME_SEP, "."));
                }
                catch (TableNotFoundException e) {
                    pDataTable = conn.getTable(physicalTableName);
                }
            } else {
                pDataTable = conn.getTable(physicalTableName);
            }
        } else {
            pDataTable = conn.getTable(dataTableName);
        }
        return pDataTable;
    }

    public static boolean isLocalIndexFamily(String family) {
        return family.indexOf("L#") != -1;
    }

    public static void updateIndexState(PhoenixConnection conn, String indexTableName, PIndexState newState, Long indexDisableTimestamp) throws SQLException {
        IndexUtil.updateIndexState(conn, indexTableName, newState, indexDisableTimestamp, Long.MAX_VALUE);
    }

    public static void updateIndexState(PhoenixConnection conn, String indexTableName, PIndexState newState, Long indexDisableTimestamp, Long expectedMaxTimestamp) throws SQLException {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(indexTableName);
        String schemaName = SchemaUtil.getSchemaNameFromFullName(indexTableName);
        String indexName = SchemaUtil.getTableNameFromFullName(indexTableName);
        Put put = new Put(indexTableKey);
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, expectedMaxTimestamp.longValue(), newState.getSerializedBytes());
        if (indexDisableTimestamp != null) {
            put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, expectedMaxTimestamp.longValue(), PLong.INSTANCE.toBytes(indexDisableTimestamp));
        }
        if (newState == PIndexState.ACTIVE) {
            put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ASYNC_REBUILD_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(0));
        }
        List<Put> tableMetadata = Collections.singletonList(put);
        MetaDataProtocol.MetaDataMutationResult result = conn.getQueryServices().updateIndexState(tableMetadata, null);
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
            throw new TableNotFoundException(schemaName, indexName);
        }
        if (code == MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION).setMessage("indexState=" + newState).setSchemaName(schemaName).setTableName(indexName).build().buildException();
        }
    }

    public static List<PTable> getClientMaintainedIndexes(PTable table) {
        Iterator indexIterator = table.isTransactional() && table.getTransactionProvider().getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.MAINTAIN_LOCAL_INDEX_ON_SERVER) ? IndexMaintainer.maintainedIndexes(table.getIndexes().iterator()) : (table.isImmutableRows() || table.isTransactional() ? IndexMaintainer.maintainedGlobalIndexesWithMatchingStorageScheme(table, table.getIndexes().iterator()) : Collections.emptyIterator());
        return Lists.newArrayList(indexIterator);
    }

    public static Result incrementCounterForIndex(PhoenixConnection conn, String failedIndexTable, long amount) throws IOException {
        Result result;
        block8: {
            byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(failedIndexTable);
            Increment incr = new Increment(indexTableKey);
            incr.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES, amount);
            Table table = conn.getQueryServices().getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, conn.getQueryServices().getProps()).getName());
            try {
                result = table.increment(incr);
                if (table == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            table.close();
        }
        return result;
    }

    public static long getIndexPendingDisableCount(PhoenixConnection conn, String failedIndexTable) throws IOException {
        long l;
        block8: {
            byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(failedIndexTable);
            Get get = new Get(indexTableKey);
            get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES);
            Table table = conn.getQueryServices().getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, conn.getQueryServices().getProps()).getName());
            try {
                Result result = table.get(get);
                l = Bytes.toLong((byte[])result.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES));
                if (table == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            table.close();
        }
        return l;
    }

    public static long getIndexPendingDisableCountLastUpdatedTimestamp(PhoenixConnection conn, String failedIndexTable) throws IOException {
        long l;
        block8: {
            byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(failedIndexTable);
            Get get = new Get(indexTableKey);
            get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES);
            byte[] systemCatalog = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, conn.getQueryServices().getProps()).getName();
            Table table = conn.getQueryServices().getTable(systemCatalog);
            try {
                Result result = table.get(get);
                Cell cell = (Cell)result.listCells().get(0);
                l = cell.getTimestamp();
                if (table == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            table.close();
        }
        return l;
    }

    public static boolean isCoveredGlobalIndex(PTable table) {
        return table.getIndexType() == PTable.IndexType.GLOBAL;
    }

    public static boolean isGlobalIndex(PTable table) {
        return table.getIndexType() == PTable.IndexType.GLOBAL || table.getIndexType() == PTable.IndexType.UNCOVERED_GLOBAL;
    }

    public static boolean shouldIndexBeUsedForUncoveredQuery(TableRef tableRef) {
        PTable table = tableRef.getTable();
        return table.getType() == PTableType.INDEX && (table.getIndexType() == PTable.IndexType.LOCAL || table.getIndexType() == PTable.IndexType.UNCOVERED_GLOBAL || tableRef.isHinted());
    }

    public static long getMaxTimestamp(Mutation m) {
        long ts = 0L;
        for (List cells : m.getFamilyCellMap().values()) {
            if (cells == null) continue;
            for (Cell cell : cells) {
                if (ts >= cell.getTimestamp()) continue;
                ts = cell.getTimestamp();
            }
        }
        return ts;
    }

    public static int getIndexPriority(Configuration conf) {
        return conf.getInt("phoenix.index.rpc.priority", 1000);
    }

    public static int getMetadataPriority(Configuration conf) {
        return conf.getInt("phoenix.metadata.rpc.priority", 2000);
    }

    public static int getServerSidePriority(Configuration conf) {
        return conf.getInt("phoenix.serverside.rpc.priority", 500);
    }

    public static int getInvalidateMetadataCachePriority(Configuration conf) {
        return conf.getInt("phoenix.invalidate.metadata.cache.rpc.priority", 3000);
    }

    public static void removeEmptyColumn(Mutation m, byte[] emptyCF, byte[] emptyCQ) {
        List cellList = (List)m.getFamilyCellMap().get(emptyCF);
        if (cellList == null) {
            return;
        }
        Iterator cellIterator = cellList.iterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])emptyCQ, (int)0, (int)emptyCQ.length) != 0) continue;
            cellIterator.remove();
            return;
        }
    }

    public static void enableIndexing(TableDescriptorBuilder descBuilder, String indexBuilderClassName, Map<String, String> properties, int priority, String coprocessorClassName) throws IOException {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(INDEX_BUILDER_CONF_KEY, indexBuilderClassName);
        descBuilder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)coprocessorClassName).setPriority(priority).setProperties(properties).build());
    }

    public static List<Cell> readColumnsFromRow(Put row, Set<ColumnReference> cols) {
        if (row == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList columns = Lists.newArrayList();
        if (cols.isEmpty()) {
            for (List cells : row.getFamilyCellMap().values()) {
                if (cells == null || cells.isEmpty()) continue;
                columns.add((Cell)cells.get(0));
                break;
            }
            return columns;
        }
        SimpleValueGetter valueGetter = new SimpleValueGetter(row);
        for (ColumnReference colRef : cols) {
            Cell cell = valueGetter.getLatestCell(colRef, Long.MAX_VALUE);
            if (cell == null) continue;
            columns.add(cell);
        }
        return columns;
    }

    public static boolean isDeleteFamily(Mutation mutation) {
        if (!(mutation instanceof Delete)) {
            return false;
        }
        for (List cells : mutation.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                if (cell.getType() != Cell.Type.DeleteFamily) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDeleteColumn(Mutation mutation) {
        if (!(mutation instanceof Delete)) {
            return false;
        }
        for (List cells : mutation.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                if (cell.getType() != Cell.Type.DeleteColumn) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDeleteFamilyOrDeleteColumn(Mutation mutation) {
        return IndexUtil.isDeleteFamily(mutation) || IndexUtil.isDeleteColumn(mutation);
    }

    public static class SimpleValueGetter
    implements ValueGetter {
        final ImmutableBytesWritable valuePtr = new ImmutableBytesWritable();
        final Put put;

        public SimpleValueGetter(Put put) {
            this.put = put;
        }

        @Override
        public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) {
            Cell cell = this.getLatestCell(ref, ts);
            if (cell == null) {
                return null;
            }
            this.valuePtr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            return this.valuePtr;
        }

        public Cell getLatestCell(ColumnReference ref, long ts) {
            List cellList = this.put.get(ref.getFamily(), ref.getQualifier());
            if (cellList == null || cellList.isEmpty()) {
                return null;
            }
            return (Cell)cellList.get(0);
        }

        @Override
        public KeyValue getLatestKeyValue(ColumnReference ref, long ts) {
            Cell cell = this.getLatestCell(ref, ts);
            KeyValue kv = cell == null ? null : new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getType().getCode()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            return kv;
        }

        @Override
        public byte[] getRowKey() {
            return this.put.getRow();
        }
    }

    public static class IndexStatusUpdater {
        private final byte[] emptyKeyValueCF;
        private final int emptyKeyValueCFLength;
        private final byte[] emptyKeyValueQualifier;
        private final int emptyKeyValueQualifierLength;

        public IndexStatusUpdater(byte[] emptyKeyValueCF, byte[] emptyKeyValueQualifier) {
            this.emptyKeyValueCF = emptyKeyValueCF;
            this.emptyKeyValueQualifier = emptyKeyValueQualifier;
            this.emptyKeyValueCFLength = emptyKeyValueCF.length;
            this.emptyKeyValueQualifierLength = emptyKeyValueQualifier.length;
        }

        public void setVerified(List<Cell> keyValues) {
            for (int i = 0; i < keyValues.size(); ++i) {
                this.updateVerified(keyValues.get(i));
            }
        }

        public void setVerified(CellScanner cellScanner) throws IOException {
            while (cellScanner.advance()) {
                this.updateVerified(cellScanner.current());
            }
        }

        private void updateVerified(Cell cell) {
            if (CellUtil.compareFamilies((Cell)cell, (byte[])this.emptyKeyValueCF, (int)0, (int)this.emptyKeyValueCFLength) == 0 && CellUtil.compareQualifiers((Cell)cell, (byte[])this.emptyKeyValueQualifier, (int)0, (int)this.emptyKeyValueQualifierLength) == 0) {
                if (cell.getValueLength() != 1) {
                    throw new IllegalArgumentException("Empty cell value length is not 1");
                }
                cell.getValueArray()[cell.getValueOffset()] = 1;
            }
        }
    }
}

