/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

public final class DeferredStringBuilder
implements Appendable,
CharSequence {
    private StringBuilder buf;
    private int pos;
    private final CharSequence source;

    public DeferredStringBuilder(CharSequence source) {
        if (source == null) {
            this.buf = new StringBuilder(16);
        }
        this.source = source;
    }

    @Override
    public DeferredStringBuilder append(char c) {
        if (this.buf == null) {
            if (this.pos < this.source.length() && c == this.source.charAt(this.pos)) {
                ++this.pos;
            } else {
                this.buf = new StringBuilder(this.source.length() + 16);
                this.buf.append(this.source.subSequence(0, this.pos));
                this.buf.append(c);
            }
        } else {
            this.buf.append(c);
        }
        return this;
    }

    @Override
    public DeferredStringBuilder append(CharSequence csq) {
        if (csq == null) {
            return this;
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public DeferredStringBuilder append(CharSequence csq, int start, int end) {
        if (csq != null) {
            if (this.buf == null) {
                int chars = end - start;
                if (chars < 10 || this.pos + chars > this.source.length()) {
                    for (int i = start; i < end; ++i) {
                        this.append(csq.charAt(i));
                    }
                } else {
                    CharSequence subSeq = csq.subSequence(start, end);
                    if (this.source.subSequence(this.pos, this.pos + chars).equals(subSeq)) {
                        this.pos += chars;
                    } else {
                        this.buf = new StringBuilder(this.source.length() + 16);
                        this.buf.append(this.source.subSequence(0, this.pos));
                        this.buf.append(subSeq);
                    }
                }
            } else {
                this.buf.append(csq, start, end);
            }
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        if (this.buf != null) {
            return this.buf.charAt(index);
        }
        if (index < this.pos) {
            return this.source.charAt(index);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.buf != null) {
            return this.buf.subSequence(start, end);
        }
        if (end <= this.pos) {
            return this.source.subSequence(start, end);
        }
        throw new StringIndexOutOfBoundsException(end);
    }

    @Override
    public String toString() {
        if (this.buf != null) {
            return this.buf.toString();
        }
        if (this.pos == this.source.length()) {
            return this.source.toString();
        }
        return this.source.subSequence(0, this.pos).toString();
    }

    @Override
    public int length() {
        return this.buf != null ? this.buf.length() : this.pos;
    }
}

