/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.DescVarLengthFastByteComparisons;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.bson.RawBsonDocument;

public class CDCUtil {
    public static final String CDC_INDEX_PREFIX = "PHOENIX_CDC_INDEX_";
    public static String CDC_STREAM_NAME_FORMAT = "phoenix/cdc/stream/%s/%s/%d/%s";

    public static Set<PTable.CDCChangeScope> makeChangeScopeEnumsFromString(String includeScopes) throws SQLException {
        HashSet<PTable.CDCChangeScope> cdcChangeScopes = new HashSet<PTable.CDCChangeScope>();
        if (includeScopes != null) {
            StringTokenizer st = new StringTokenizer(includeScopes, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                try {
                    cdcChangeScopes.add(PTable.CDCChangeScope.valueOf(tok.trim().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNKNOWN_INCLUDE_CHANGE_SCOPE).setCdcChangeScope(tok).build().buildException();
                }
            }
        }
        return cdcChangeScopes;
    }

    public static String makeChangeScopeStringFromEnums(Set<PTable.CDCChangeScope> includeScopes) {
        String cdcChangeScopes = null;
        if (includeScopes != null) {
            Iterable tmpStream = () -> includeScopes.stream().sorted().map(s -> s.name()).iterator();
            cdcChangeScopes = StringUtils.join((CharSequence)",", tmpStream);
        }
        return cdcChangeScopes;
    }

    public static String getCDCIndexName(String cdcName) {
        return CDC_INDEX_PREFIX + SchemaUtil.getTableNameFromFullName(cdcName);
    }

    public static boolean isCDCIndex(String indexName) {
        return indexName.startsWith(CDC_INDEX_PREFIX);
    }

    public static boolean isCDCIndex(byte[] indexNameBytes) {
        String indexName = Bytes.toString((byte[])indexNameBytes);
        return CDCUtil.isCDCIndex(indexName);
    }

    public static byte[] getCdcObjectName(byte[] cdcIndexName) {
        return Arrays.copyOfRange(cdcIndexName, CDC_INDEX_PREFIX.length(), cdcIndexName.length);
    }

    public static boolean isCDCIndex(PTable indexTable) {
        return CDCUtil.isCDCIndex(indexTable.getTableName().getString());
    }

    public static boolean isCDCIndexActive(PTable indexTable) {
        return CDCUtil.isCDCIndex(indexTable.getTableName().getString()) && indexTable.getIndexState() == PIndexState.ACTIVE;
    }

    public static boolean hasActiveCDCIndex(PTable table) {
        if (table == null || table.getIndexes() == null) {
            return false;
        }
        return table.getIndexes().stream().anyMatch(CDCUtil::isCDCIndexActive);
    }

    public static PTable getActiveCDCIndex(PTable dataTable) {
        return dataTable.getIndexes().stream().filter(CDCUtil::isCDCIndexActive).findFirst().orElse(null);
    }

    public static boolean hasCDCIndex(PTable table) {
        if (table == null || table.getIndexes() == null) {
            return false;
        }
        return table.getIndexes().stream().anyMatch(CDCUtil::isCDCIndex);
    }

    public static Scan setupScanForCDC(Scan scan) {
        scan.setRaw(true);
        scan.readAllVersions();
        scan.setCacheBlocks(false);
        Map familyMap = scan.getFamilyMap();
        if (!familyMap.isEmpty()) {
            familyMap.clear();
        }
        return scan;
    }

    public static int compareCellFamilyAndQualifier(byte[] columnFamily1, byte[] columnQual1, byte[] columnFamily2, byte[] columnQual2) {
        int familyNameComparison = DescVarLengthFastByteComparisons.compareTo(columnFamily1, 0, columnFamily1.length, columnFamily2, 0, columnFamily2.length);
        if (familyNameComparison != 0) {
            return familyNameComparison;
        }
        return DescVarLengthFastByteComparisons.compareTo(columnQual1, 0, columnQual1.length, columnQual2, 0, columnQual2.length);
    }

    public static Object getColumnEncodedValue(Object value, PDataType dataType) {
        if (value != null) {
            if (dataType.getSqlType() == 7000) {
                value = ByteUtil.toBytes(((RawBsonDocument)value).getByteBuffer().asNIO());
            } else if (CDCUtil.isBinaryType(dataType)) {
                value = Base64.getEncoder().encodeToString((byte[])value);
            } else {
                int sqlType = dataType.getSqlType();
                if (sqlType == 91 || sqlType == 93 || sqlType == 92 || sqlType == 2013 || dataType.isArrayType() || sqlType == 5000 || sqlType == 2014) {
                    value = value.toString();
                }
            }
        }
        return value;
    }

    public static boolean isBinaryType(PDataType dataType) {
        int sqlType = dataType.getSqlType();
        return sqlType == -2 || sqlType == -3 || sqlType == -4 || dataType.getSqlType() == 9000;
    }

    public static long getCDCCreationTimestamp(PTable table) {
        for (PTable index : table.getIndexes()) {
            if (!CDCUtil.isCDCIndex(index)) continue;
            return index.getTimeStamp();
        }
        return -1L;
    }

    public static String getCDCCreationUTCDateTime(long timestamp) {
        Date date = new Date(timestamp);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        return format.format(date);
    }

    public static enum CdcStreamStatus {
        ENABLED("ENABLED"),
        ENABLING("ENABLING"),
        DISABLED("DISABLED"),
        DISABLING("DISABLING");

        private final String serializedValue;

        private CdcStreamStatus(String value) {
            this.serializedValue = value;
        }

        public String getSerializedValue() {
            return this.serializedValue;
        }
    }
}

