/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteUtil.class);
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ImmutableBytesPtr EMPTY_BYTE_ARRAY_PTR = new ImmutableBytesPtr(EMPTY_BYTE_ARRAY);
    public static final ImmutableBytesWritable EMPTY_IMMUTABLE_BYTE_ARRAY = new ImmutableBytesWritable(EMPTY_BYTE_ARRAY);
    private static final int BIT_0 = 1;
    private static final int BIT_1 = 2;
    private static final int BIT_2 = 4;
    private static final int BIT_3 = 8;
    private static final int BIT_4 = 16;
    private static final int BIT_5 = 32;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    private static final int[] BITS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final byte[] ZERO_BYTE = Bytes.toBytesBinary((String)"\\x00");
    public static final Comparator<ImmutableBytesPtr> BYTES_PTR_COMPARATOR = new Comparator<ImmutableBytesPtr>(){

        @Override
        public int compare(ImmutableBytesPtr o1, ImmutableBytesPtr o2) {
            return Bytes.compareTo((byte[])o1.get(), (int)o1.getOffset(), (int)o1.getLength(), (byte[])o2.get(), (int)o2.getOffset(), (int)o2.getLength());
        }
    };

    public static byte[] toBytes(byte[][] byteArrays) {
        int size = 0;
        for (byte[] b : byteArrays) {
            if (b == null) {
                ++size;
                continue;
            }
            size += b.length;
            size += WritableUtils.getVIntSize((long)b.length);
        }
        TrustedByteArrayOutputStream bytesOut = new TrustedByteArrayOutputStream(size);
        DataOutputStream out = new DataOutputStream(bytesOut);
        try {
            for (byte[] b : byteArrays) {
                if (b == null) {
                    WritableUtils.writeVInt((DataOutput)out, (int)0);
                    continue;
                }
                WritableUtils.writeVInt((DataOutput)out, (int)b.length);
                out.write(b);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return bytesOut.getBuffer();
    }

    public static byte[][] toByteArrays(byte[] b, int length) {
        return ByteUtil.toByteArrays(b, 0, length);
    }

    public static byte[][] toByteArrays(byte[] b, int offset, int length) {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(b, offset, b.length - offset);
        DataInputStream in = new DataInputStream(bytesIn);
        byte[][] byteArrays = new byte[length][];
        try {
            for (int i = 0; i < length; ++i) {
                int bLength = WritableUtils.readVInt((DataInput)in);
                if (bLength == 0) {
                    byteArrays[i] = null;
                    continue;
                }
                byteArrays[i] = new byte[bLength];
                int rLength = in.read(byteArrays[i], 0, bLength);
                assert (rLength == bLength);
            }
            if (in.read() != -1) {
                throw new IllegalStateException("Expected only " + length + " byte arrays, but found more");
            }
            byte[][] i = byteArrays;
            return i;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] serializeVIntArray(int[] intArray) {
        return ByteUtil.serializeVIntArray(intArray, intArray.length);
    }

    public static byte[] serializeVIntArray(int[] intArray, int encodedLength) {
        int size = WritableUtils.getVIntSize((long)encodedLength);
        for (int i = 0; i < intArray.length; ++i) {
            size += WritableUtils.getVIntSize((long)intArray[i]);
        }
        int offset = 0;
        byte[] out = new byte[size];
        offset += ByteUtil.vintToBytes(out, offset, size);
        for (int i = 0; i < intArray.length; ++i) {
            offset += ByteUtil.vintToBytes(out, offset, intArray[i]);
        }
        return out;
    }

    public static void serializeVIntArray(DataOutput output, int[] intArray) throws IOException {
        ByteUtil.serializeVIntArray(output, intArray, intArray.length);
    }

    public static void serializeVIntArray(DataOutput output, int[] intArray, int encodedLength) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)encodedLength);
        for (int i = 0; i < intArray.length; ++i) {
            WritableUtils.writeVInt((DataOutput)output, (int)intArray[i]);
        }
    }

    public static long[] readFixedLengthLongArray(DataInput input, int length) throws IOException {
        long[] longArray = new long[length];
        for (int i = 0; i < length; ++i) {
            longArray[i] = input.readLong();
        }
        return longArray;
    }

    public static void writeFixedLengthLongArray(DataOutput output, long[] longArray) throws IOException {
        for (int i = 0; i < longArray.length; ++i) {
            output.writeLong(longArray[i]);
        }
    }

    public static int[] deserializeVIntArray(byte[] b) {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bytesIn);
        try {
            int length = WritableUtils.readVInt((DataInput)in);
            int[] nArray = ByteUtil.deserializeVIntArray(in, length);
            return nArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static int[] deserializeVIntArray(DataInput in) throws IOException {
        return ByteUtil.deserializeVIntArray(in, WritableUtils.readVInt((DataInput)in));
    }

    public static int[] deserializeVIntArray(DataInput in, int length) throws IOException {
        int i = 0;
        int[] intArray = new int[length];
        while (i < length) {
            intArray[i++] = WritableUtils.readVInt((DataInput)in);
        }
        return intArray;
    }

    public static int[] deserializeVIntArray(byte[] b, int length) {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bytesIn);
        try {
            return ByteUtil.deserializeVIntArray(in, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] concat(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        for (byte[] array : rest) {
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static <T> T[] concat(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] concat(SortOrder sortOrder, ImmutableBytesWritable ... writables) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        int totalLength = 0;
        for (ImmutableBytesWritable writable : writables) {
            totalLength += writable.getLength();
        }
        byte[] result = new byte[totalLength];
        int totalOffset = 0;
        for (ImmutableBytesWritable array : writables) {
            byte[] bytes = array.get();
            int offset = array.getOffset();
            if (sortOrder == SortOrder.DESC) {
                bytes = SortOrder.invert(bytes, offset, new byte[array.getLength()], 0, array.getLength());
                offset = 0;
            }
            System.arraycopy(bytes, offset, result, totalOffset, array.getLength());
            totalOffset += array.getLength();
        }
        return result;
    }

    public static int vintFromBytes(byte[] buffer, int offset) {
        return (int)Bytes.readAsVLong((byte[])buffer, (int)offset);
    }

    public static int vintFromBytes(ImmutableBytesWritable ptr) {
        return (int)ByteUtil.vlongFromBytes(ptr);
    }

    public static long vlongFromBytes(ImmutableBytesWritable ptr) {
        int offset;
        byte[] buffer = ptr.get();
        byte firstByte = buffer[offset = ptr.getOffset()];
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            ptr.set(buffer, offset + 1, ptr.getLength());
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        ptr.set(buffer, offset + len, ptr.getLength());
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int vintToBytes(byte[] result, int offset, long vint) {
        long i = vint;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return 1;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return len + 1;
    }

    public static byte[] nextKey(byte[] key) {
        byte[] nextStartRow = new byte[key.length];
        System.arraycopy(key, 0, nextStartRow, 0, key.length);
        if (!ByteUtil.nextKey(nextStartRow, nextStartRow.length)) {
            return null;
        }
        return nextStartRow;
    }

    public static boolean nextKey(byte[] key, int length) {
        return ByteUtil.nextKey(key, 0, length);
    }

    public static boolean nextKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        int i = offset + length - 1;
        while (key[i] == -1) {
            key[i] = 0;
            if (--i >= offset) continue;
            do {
                key[++i] = -1;
            } while (i < offset + length - 1);
            return false;
        }
        key[i] = (byte)(key[i] + 1);
        return true;
    }

    public static byte[] previousKey(byte[] key) {
        byte[] previousKey = new byte[key.length];
        System.arraycopy(key, 0, previousKey, 0, key.length);
        if (!ByteUtil.previousKey(previousKey, previousKey.length)) {
            return null;
        }
        return previousKey;
    }

    public static byte[] getLargestPossibleRowKeyInRange(byte[] startKey, byte[] endKey) {
        byte[] rowKey;
        if (startKey.length == 0 && endKey.length == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        try {
            if (startKey.length > 0 && endKey.length > 0) {
                int commonBytesIdx;
                for (commonBytesIdx = 0; commonBytesIdx < startKey.length && commonBytesIdx < endKey.length && startKey[commonBytesIdx] == endKey[commonBytesIdx]; ++commonBytesIdx) {
                }
                if (commonBytesIdx == 0) {
                    rowKey = ByteUtil.previousKeyWithLength(ByteUtil.concat(endKey, new byte[][]{new byte[startKey.length + 1]}), Math.max(endKey.length, startKey.length) + 1);
                } else {
                    byte[] newEndKey;
                    byte[] newStartKey;
                    if (commonBytesIdx < startKey.length) {
                        newStartKey = new byte[startKey.length - commonBytesIdx];
                        System.arraycopy(startKey, commonBytesIdx, newStartKey, 0, newStartKey.length);
                    } else {
                        newStartKey = startKey;
                    }
                    if (commonBytesIdx < endKey.length) {
                        newEndKey = new byte[endKey.length - commonBytesIdx];
                        System.arraycopy(endKey, commonBytesIdx, newEndKey, 0, newEndKey.length);
                    } else {
                        newEndKey = endKey;
                    }
                    byte[] commonBytes = new byte[commonBytesIdx];
                    System.arraycopy(startKey, 0, commonBytes, 0, commonBytesIdx);
                    byte[] tmpRowKey = ByteUtil.previousKeyWithLength(ByteUtil.concat(newEndKey, new byte[][]{new byte[newStartKey.length + 1]}), Math.max(newEndKey.length, newStartKey.length) + 1);
                    if (tmpRowKey == null) {
                        tmpRowKey = new byte[newEndKey.length - 1];
                        System.arraycopy(newEndKey, 0, tmpRowKey, 0, tmpRowKey.length);
                        rowKey = ByteUtil.concat(commonBytes, new byte[][]{tmpRowKey});
                    } else {
                        rowKey = ByteUtil.concat(commonBytes, new byte[][]{tmpRowKey});
                    }
                }
            } else {
                rowKey = endKey.length > 0 ? ByteUtil.previousKeyWithLength(ByteUtil.concat(endKey, new byte[][]{new byte[1]}), endKey.length + 1) : ByteUtil.nextKeyWithLength(ByteUtil.concat(startKey, new byte[][]{new byte[1]}), startKey.length + 1);
            }
            if (rowKey == null) {
                LOGGER.error("Unexpected result while retrieving rowkey in range ({} , {})", (Object)Bytes.toStringBinary((byte[])startKey), (Object)Bytes.toStringBinary((byte[])endKey));
                return null;
            }
            if (Bytes.compareTo((byte[])startKey, (byte[])rowKey) >= 0 || Bytes.compareTo((byte[])rowKey, (byte[])endKey) >= 0) {
                LOGGER.error("Unexpected result while comparing result rowkey in range ({} , {}) , rowKey: {}", new Object[]{Bytes.toStringBinary((byte[])startKey), Bytes.toStringBinary((byte[])endKey), Bytes.toStringBinary((byte[])rowKey)});
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while retrieving rowkey in range ({} , {})", (Object)Bytes.toStringBinary((byte[])startKey), (Object)Bytes.toStringBinary((byte[])endKey));
            return null;
        }
        return rowKey;
    }

    public static byte[] previousKeyWithLength(byte[] key, int length) {
        Preconditions.checkArgument((key.length >= length ? 1 : 0) != 0, (Object)("Key length " + key.length + " is less than least expected length " + length));
        byte[] previousKey = new byte[length];
        System.arraycopy(key, 0, previousKey, 0, length);
        if (!ByteUtil.previousKey(previousKey, length)) {
            return null;
        }
        return previousKey;
    }

    public static byte[] nextKeyWithLength(byte[] key, int length) {
        Preconditions.checkArgument((key.length >= length ? 1 : 0) != 0, (Object)("Key length " + key.length + " is less than least expected length " + length));
        byte[] nextStartRow = new byte[length];
        System.arraycopy(key, 0, nextStartRow, 0, length);
        if (!ByteUtil.nextKey(nextStartRow, length)) {
            return null;
        }
        return nextStartRow;
    }

    public static boolean previousKey(byte[] key, int length) {
        return ByteUtil.previousKey(key, 0, length);
    }

    public static boolean previousKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        int i = offset + length - 1;
        while (key[i] == 0) {
            key[i] = -1;
            if (--i >= offset) continue;
            do {
                key[++i] = 0;
            } while (i < offset + length - 1);
            return false;
        }
        key[i] = (byte)(key[i] - 1);
        return true;
    }

    public static byte[] fillKey(byte[] key, int length) {
        if (key.length > length) {
            throw new IllegalStateException();
        }
        if (key.length == length) {
            return key;
        }
        byte[] newBound = new byte[length];
        System.arraycopy(key, 0, newBound, 0, key.length);
        return newBound;
    }

    public static boolean isEmptyOrNull(byte[] b, int offset, int length) {
        if (b == null || Bytes.compareTo((byte[])b, (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
            return true;
        }
        if (b.length < offset + length) {
            throw new IllegalStateException();
        }
        boolean result = true;
        for (int i = offset + length - 1; i >= offset; --i) {
            if (b[i] == 0) continue;
            result = false;
            break;
        }
        return result;
    }

    public static void nullPad(ImmutableBytesWritable ptr, int length) {
        if (ptr.getLength() > length) {
            throw new IllegalStateException();
        }
        if (ptr.getLength() == length) {
            return;
        }
        byte[] newBound = new byte[length];
        System.arraycopy(ptr.get(), ptr.getOffset(), newBound, 0, ptr.getLength());
        ptr.set(newBound);
    }

    public static int getSize(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static boolean isInclusive(CompareOperator op) {
        switch (op) {
            case LESS: 
            case GREATER: {
                return false;
            }
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_OR_EQUAL: 
            case GREATER_OR_EQUAL: {
                return true;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static boolean compare(CompareOperator op, int compareResult) {
        switch (op) {
            case LESS: {
                return compareResult < 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult <= 0;
            }
            case EQUAL: {
                return compareResult == 0;
            }
            case NOT_EQUAL: {
                return compareResult != 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult >= 0;
            }
            case GREATER: {
                return compareResult > 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static byte[] copyKeyBytesIfNecessary(ImmutableBytesWritable ptr) {
        if (ptr.getOffset() == 0 && ptr.getLength() == ptr.get().length) {
            return ptr.get();
        }
        return ptr.copyBytes();
    }

    public static KeyRange getKeyRange(byte[] key, SortOrder order, CompareOperator op, PDataType type) {
        op = order.transform(op);
        switch (op) {
            case EQUAL: {
                return type.getKeyRange(key, true, key, true, order);
            }
            case GREATER: {
                return type.getKeyRange(key, false, KeyRange.UNBOUND, false, order);
            }
            case GREATER_OR_EQUAL: {
                return type.getKeyRange(key, true, KeyRange.UNBOUND, false, order);
            }
            case LESS: {
                return type.getKeyRange(KeyRange.UNBOUND, false, key, false, order);
            }
            case LESS_OR_EQUAL: {
                return type.getKeyRange(KeyRange.UNBOUND, false, key, true, order);
            }
        }
        throw new IllegalArgumentException("Unknown operator " + op);
    }

    public static boolean contains(Collection<byte[]> keys, byte[] key) {
        for (byte[] k : keys) {
            if (!Arrays.equals(k, key)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<ImmutableBytesPtr> keys, ImmutableBytesPtr key) {
        for (ImmutableBytesPtr k : keys) {
            if (key.compareTo(k) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean match(Set<byte[]> keys, Set<byte[]> keys2) {
        if (keys == keys2) {
            return true;
        }
        if (keys == null || keys2 == null) {
            return false;
        }
        int size = keys.size();
        if (keys2.size() != size) {
            return false;
        }
        for (byte[] k : keys) {
            if (ByteUtil.contains(keys2, k)) continue;
            return false;
        }
        return true;
    }

    public static byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    public static byte[][] splitArrayBySeparator(byte[] src, byte separator) {
        ArrayList<Integer> separatorLocations = new ArrayList<Integer>();
        for (int k = 0; k < src.length; ++k) {
            if (src[k] != separator) continue;
            separatorLocations.add(k);
        }
        byte[][] dst = new byte[separatorLocations.size() + 1][];
        int previousSepartor = -1;
        for (int j = 0; j < separatorLocations.size(); ++j) {
            int separatorLocation = (Integer)separatorLocations.get(j);
            dst[j] = Bytes.copy((byte[])src, (int)(previousSepartor + 1), (int)(separatorLocation - previousSepartor - 1));
            previousSepartor = separatorLocation;
        }
        if (previousSepartor < src.length) {
            dst[separatorLocations.size()] = Bytes.copy((byte[])src, (int)(previousSepartor + 1), (int)(src.length - previousSepartor - 1));
        }
        return dst;
    }

    public static byte[] fromAscii(char[] ascii) {
        if (ascii == null || ascii.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int asciiLength = ascii.length;
        byte[] l_raw = new byte[asciiLength >> 3];
        int ii = 0;
        int jj = 0;
        while (ii < l_raw.length) {
            for (int bits = 0; bits < BITS.length; ++bits) {
                if (ascii[jj + bits] != '1') continue;
                int n = ii;
                l_raw[n] = (byte)(l_raw[n] | BITS[bits]);
            }
            ++ii;
            jj += 8;
        }
        return l_raw;
    }

    public static byte[] closestPossibleRowAfter(byte[] row) {
        return Arrays.copyOf(row, row.length + 1);
    }

    public static byte[] toBytes(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        byte[] result = new byte[dup.remaining()];
        dup.get(result);
        return result;
    }
}

