/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.omid.transaction.TTable;
import org.apache.omid.transaction.Transaction;
import org.apache.phoenix.compat.hbase.CompatOmidTransactionTable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.transaction.OmidTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionContext;

public class OmidTransactionTable
extends CompatOmidTransactionTable
implements Table {
    static final Result EMPTY_RESULT_EXISTS_TRUE = Result.create(null, (Boolean)true);
    private TTable tTable;
    private Transaction tx;
    private final boolean addShadowCells;

    public OmidTransactionTable() throws SQLException {
        this.tTable = null;
        this.tx = null;
        this.addShadowCells = false;
    }

    public OmidTransactionTable(PhoenixTransactionContext ctx, Table hTable) throws SQLException {
        this(ctx, hTable, false);
    }

    public OmidTransactionTable(PhoenixTransactionContext ctx, Table hTable, boolean isConflictFree) throws SQLException {
        this(ctx, hTable, isConflictFree, false);
    }

    public OmidTransactionTable(PhoenixTransactionContext ctx, Table hTable, boolean isConflictFree, boolean addShadowCells) throws SQLException {
        assert (ctx instanceof OmidTransactionContext);
        OmidTransactionContext omidTransactionContext = (OmidTransactionContext)ctx;
        this.addShadowCells = addShadowCells;
        try {
            this.tTable = new TTable(hTable, true, isConflictFree);
        }
        catch (IOException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
        this.tx = omidTransactionContext.getTransaction();
    }

    public Result get(Get get) throws IOException {
        return this.tTable.get(this.tx, get);
    }

    public void put(Put put) throws IOException {
        this.tTable.put(this.tx, put, this.addShadowCells);
    }

    public void delete(Delete delete) throws IOException {
        this.tTable.delete(this.tx, delete);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        scan.setTimeRange(0L, Long.MAX_VALUE);
        return this.tTable.getScanner(this.tx, scan);
    }

    public Configuration getConfiguration() {
        return this.tTable.getConfiguration();
    }

    public boolean exists(Get get) throws IOException {
        return this.tTable.exists(this.tx, get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        return this.tTable.get(this.tx, gets);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.tTable.getScanner(this.tx, family);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.tTable.getScanner(this.tx, family, qualifier);
    }

    public void put(List<Put> puts) throws IOException {
        this.tTable.put(this.tx, puts, this.addShadowCells);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.tTable.delete(this.tx, deletes);
    }

    public void close() throws IOException {
        this.tTable.close();
    }

    public TableName getName() {
        byte[] name = this.tTable.getTableName();
        return TableName.valueOf((byte[])name);
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        this.tTable.batch(this.tx, actions, this.addShadowCells);
        if (results != null) {
            Arrays.fill(results, EMPTY_RESULT_EXISTS_TRUE);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Result append(Append append) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Result increment(Increment increment) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        throw new UnsupportedOperationException();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException();
    }

    public int getRpcTimeout() {
        throw new UnsupportedOperationException();
    }

    public void setOperationTimeout(int arg0) {
        throw new UnsupportedOperationException();
    }

    public void setRpcTimeout(int arg0) {
        throw new UnsupportedOperationException();
    }

    public int getWriteRpcTimeout() {
        throw new UnsupportedOperationException();
    }

    public void setWriteRpcTimeout(int writeRpcTimeout) {
        throw new UnsupportedOperationException();
    }

    public int getReadRpcTimeout() {
        throw new UnsupportedOperationException();
    }

    public void setReadRpcTimeout(int readRpcTimeout) {
        throw new UnsupportedOperationException();
    }

    public TableDescriptor getDescriptor() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public long getOperationTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public RegionLocator getRegionLocator() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Result mutateRow(RowMutations rm) throws IOException {
        throw new UnsupportedOperationException();
    }
}

