/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.metrics.MetricInfo;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Longs;
import org.apache.phoenix.trace.TraceWriter;
import org.apache.phoenix.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceReader.class);
    private final Joiner comma = Joiner.on((char)',');
    private String knownColumns;
    private Connection conn;
    private String table;
    private int pageSize;

    public TraceReader(Connection conn, String tracingTableName) throws SQLException {
        this.knownColumns = this.comma.join((Object)MetricInfo.TRACE.columnName, (Object)MetricInfo.PARENT.columnName, new Object[]{MetricInfo.SPAN.columnName, MetricInfo.DESCRIPTION.columnName, MetricInfo.START.columnName, MetricInfo.END.columnName, MetricInfo.HOSTNAME.columnName, TraceWriter.TAG_COUNT, TraceWriter.ANNOTATION_COUNT});
        this.conn = conn;
        this.table = tracingTableName;
        String ps = conn.getClientInfo("phoenix.trace.read.pagesize");
        this.pageSize = ps == null ? 100 : Integer.parseInt(ps);
    }

    public Collection<TraceHolder> readAll(int limit) throws SQLException {
        HashSet<TraceHolder> traces = new HashSet<TraceHolder>();
        String query = "SELECT " + this.knownColumns + " FROM " + this.table + " ORDER BY " + MetricInfo.TRACE.columnName + " DESC, " + MetricInfo.START.columnName + " ASC LIMIT " + this.pageSize;
        int resultCount = 0;
        try (PreparedStatement stmt = this.conn.prepareStatement(query);
             ResultSet results = stmt.executeQuery();){
            TraceHolder trace = null;
            ArrayList<SpanInfo> orphans = null;
            while (results.next()) {
                int index = 1;
                long traceid = results.getLong(index++);
                long parent = results.getLong(index++);
                long span = results.getLong(index++);
                String desc = results.getString(index++);
                long start = results.getLong(index++);
                long end = results.getLong(index++);
                String host = results.getString(index++);
                int tagCount = results.getInt(index++);
                int annotationCount = results.getInt(index++);
                if (trace == null || traceid != trace.traceid) {
                    if (trace != null) {
                        ++resultCount;
                    }
                    if (resultCount >= limit) {
                        break;
                    }
                    trace = new TraceHolder();
                    orphans = new ArrayList<SpanInfo>();
                    trace.orphans = orphans;
                    trace.traceid = traceid;
                    traces.add(trace);
                }
                SpanInfo parentSpan = null;
                if (parent != 477902L) {
                    for (SpanInfo p : trace.spans) {
                        if (p.id != parent) continue;
                        parentSpan = p;
                        break;
                    }
                }
                SpanInfo spanInfo = new SpanInfo(parentSpan, parent, span, desc, start, end, host, tagCount, annotationCount);
                for (int i = 0; i < orphans.size(); ++i) {
                    SpanInfo orphan = (SpanInfo)orphans.get(i);
                    if (orphan.parentId != span) continue;
                    orphan.parent = spanInfo;
                    spanInfo.children.add(orphan);
                    LOGGER.trace(this.addCustomAnnotations("Found parent for span: " + span));
                    orphans.remove(i--);
                }
                if (parentSpan != null) {
                    parentSpan.children.add(spanInfo);
                } else if (parent != 477902L) {
                    LOGGER.info(this.addCustomAnnotations("No parent span found for span: " + span + " (root span id: 477902)"));
                    orphans.add(spanInfo);
                }
                trace.spans.add(spanInfo);
                spanInfo.tags.addAll(this.getTags(traceid, parent, span, tagCount));
                spanInfo.annotations.addAll(this.getAnnotations(traceid, parent, span, annotationCount));
            }
        }
        return traces;
    }

    private Collection<? extends String> getTags(long traceid, long parent, long span, int count) throws SQLException {
        return this.getDynamicCountColumns(traceid, parent, span, count, "tags", MetricInfo.TAG.columnName);
    }

    private Collection<? extends String> getAnnotations(long traceid, long parent, long span, int count) throws SQLException {
        return this.getDynamicCountColumns(traceid, parent, span, count, "annotations", MetricInfo.ANNOTATION.columnName);
    }

    private Collection<? extends String> getDynamicCountColumns(long traceid, long parent, long span, int count, String family, String columnName) throws SQLException {
        if (count == 0) {
            return Collections.emptyList();
        }
        Object[] parts = new String[count];
        for (int i = 0; i < count; ++i) {
            parts[i] = TraceWriter.getDynamicColumnName(family, columnName, i);
        }
        String columns = this.comma.join(parts);
        for (int i = 0; i < count; ++i) {
            parts[i] = (String)parts[i] + " VARCHAR";
        }
        String dynamicColumns = this.comma.join(parts);
        String request = "SELECT " + columns + " from " + this.table + "(" + dynamicColumns + ") WHERE " + MetricInfo.TRACE.columnName + "=" + traceid + " AND " + MetricInfo.PARENT.columnName + "=" + parent + " AND " + MetricInfo.SPAN.columnName + "=" + span;
        LOGGER.trace(this.addCustomAnnotations("Requesting columns with: " + request));
        ResultSet results = this.conn.createStatement().executeQuery(request);
        ArrayList<String> cols = new ArrayList<String>();
        while (results.next()) {
            for (int index = 1; index <= count; ++index) {
                cols.add(results.getString(index));
            }
        }
        if (cols.size() < count) {
            LOGGER.error(this.addCustomAnnotations("Missing tags! Expected " + count + ", but only got " + cols.size() + " tags from rquest " + request));
        }
        return cols;
    }

    private String addCustomAnnotations(String logLine) throws SQLException {
        if (this.conn.isWrapperFor(PhoenixConnection.class)) {
            PhoenixConnection phxConn = this.conn.unwrap(PhoenixConnection.class);
            logLine = LogUtil.addCustomAnnotations(logLine, phxConn);
        }
        return logLine;
    }

    public static class TraceHolder {
        public List<SpanInfo> orphans;
        public long traceid;
        public TreeSet<SpanInfo> spans = new TreeSet();

        public int hashCode() {
            return new Long(this.traceid).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TraceHolder) {
                return this.traceid == ((TraceHolder)o).traceid;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Trace: " + this.traceid + "\n");
            SpanInfo root = this.spans.iterator().next();
            if (root.parent != null) {
                sb.append("Root span not present! Just printing found spans\n");
                for (SpanInfo span : this.spans) {
                    sb.append(span.toString() + "\n");
                }
            } else {
                ArrayList<SpanInfo> toPrint = new ArrayList<SpanInfo>();
                toPrint.add(root);
                while (!toPrint.isEmpty()) {
                    SpanInfo span = (SpanInfo)toPrint.remove(0);
                    sb.append(span.toString() + "\n");
                    toPrint.addAll(span.children);
                }
            }
            if (this.orphans.size() > 0) {
                sb.append("Found orphan spans:\n" + this.orphans);
            }
            return sb.toString();
        }
    }

    public static class SpanInfo
    implements Comparable<SpanInfo> {
        public SpanInfo parent;
        public List<SpanInfo> children = new ArrayList<SpanInfo>();
        public String description;
        public long id;
        public long start;
        public long end;
        public String hostname;
        public int tagCount;
        public List<String> tags = new ArrayList<String>();
        public int annotationCount;
        public List<String> annotations = new ArrayList<String>();
        private long parentId;

        public SpanInfo(SpanInfo parent, long parentid, long span, String desc, long start, long end, String host, int tagCount, int annotationCount) {
            this.parent = parent;
            this.parentId = parentid;
            this.id = span;
            this.description = desc;
            this.start = start;
            this.end = end;
            this.hostname = host;
            this.tagCount = tagCount;
            this.annotationCount = annotationCount;
        }

        public int hashCode() {
            return new Long(this.id).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SpanInfo) {
                return this.id == ((SpanInfo)o).id;
            }
            return false;
        }

        @Override
        public int compareTo(SpanInfo o) {
            if (this.parentId == 477902L) {
                return -1;
            }
            if (o.parentId == 477902L) {
                return 1;
            }
            int compare = Longs.compare((long)this.start, (long)o.start);
            if (compare == 0 && (compare = Longs.compare((long)this.end, (long)o.end)) == 0) {
                return Longs.compare((long)this.id, (long)o.id);
            }
            return compare;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Span: " + this.id + "\n");
            sb.append("\tdescription=" + this.description);
            sb.append("\n");
            sb.append("\tparent=" + (Serializable)(this.parent == null ? (this.parentId == 477902L ? "ROOT" : "[orphan - id: " + this.parentId + "]") : Long.valueOf(this.parent.id)));
            sb.append("\n");
            sb.append("\tstart,end=" + this.start + "," + this.end);
            sb.append("\n");
            sb.append("\telapsed=" + (this.end - this.start));
            sb.append("\n");
            sb.append("\thostname=" + this.hostname);
            sb.append("\n");
            sb.append("\ttags=(" + this.tagCount + ") " + this.tags);
            sb.append("\n");
            sb.append("\tannotations=(" + this.annotationCount + ") " + this.annotations);
            sb.append("\n");
            sb.append("\tchildren=");
            for (SpanInfo child : this.children) {
                sb.append(child.id + ", ");
            }
            sb.append("\n");
            return sb.toString();
        }

        public long getParentIdForTesting() {
            return this.parentId;
        }
    }
}

