/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.metrics.MetricInfo;
import org.apache.phoenix.metrics.Metrics;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixMetricsSink
implements MetricsSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixMetricsSink.class);
    private static final String VARIABLE_VALUE = "?";
    private static final Joiner COLUMN_JOIN = Joiner.on((String)".");
    static final String TAG_FAMILY = "tags";
    static final String TAG_COUNT = COLUMN_JOIN.join((Object)"tags", (Object)"count", new Object[0]);
    static final String ANNOTATION_FAMILY = "annotations";
    static final String ANNOTATION_COUNT = COLUMN_JOIN.join((Object)"annotations", (Object)"count", new Object[0]);
    private static final Joiner COMMAS = Joiner.on((char)',');
    private Connection conn;
    private String table;

    public PhoenixMetricsSink() {
        LOGGER.info("Writing tracing metrics to phoenix table");
    }

    public void init(SubsetConfiguration config) {
        Metrics.markSinkInitialized();
        LOGGER.info("Phoenix tracing writer started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitialize() {
        PhoenixMetricsSink phoenixMetricsSink = this;
        synchronized (phoenixMetricsSink) {
            if (this.conn != null) {
                return;
            }
            try {
                Properties props = new Properties();
                props.setProperty("phoenix.trace.frequency", Tracing.Frequency.NEVER.getKey());
                Configuration conf = HBaseConfiguration.create();
                Connection conn = QueryUtil.getConnectionOnServer(props, conf);
                conn.setAutoCommit(true);
                String tableName = conf.get("phoenix.trace.statsTableName", "SYSTEM.TRACING_STATS");
                this.initializeInternal(conn, tableName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initializeInternal(Connection conn, String tableName) throws SQLException {
        this.conn = conn;
        if (!this.traceTableExists(conn, tableName)) {
            this.createTable(conn, tableName);
        }
        this.table = tableName;
    }

    private boolean traceTableExists(Connection conn, String traceTableName) throws SQLException {
        try {
            conn.unwrap(PhoenixConnection.class).getTable(traceTableName);
            return true;
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    @VisibleForTesting
    public void initForTesting(Connection conn, String tableName) throws SQLException {
        this.initializeInternal(conn, tableName);
    }

    private void createTable(Connection conn, String table) throws SQLException {
        String ddl = "create table if not exists " + table + "( " + MetricInfo.TRACE.columnName + " bigint not null, " + MetricInfo.PARENT.columnName + " bigint not null, " + MetricInfo.SPAN.columnName + " bigint not null, " + MetricInfo.DESCRIPTION.columnName + " varchar, " + MetricInfo.START.columnName + " bigint, " + MetricInfo.END.columnName + " bigint, " + MetricInfo.HOSTNAME.columnName + " varchar, " + TAG_COUNT + " smallint, " + ANNOTATION_COUNT + " smallint  CONSTRAINT pk PRIMARY KEY (" + MetricInfo.TRACE.columnName + ", " + MetricInfo.PARENT.columnName + ", " + MetricInfo.SPAN.columnName + "))\nTRANSACTIONAL=" + Boolean.FALSE;
        try (PreparedStatement stmt = conn.prepareStatement(ddl);){
            stmt.execute();
        }
    }

    public void flush() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Failed to commit changes to table", (Throwable)e);
        }
    }

    public void putMetrics(MetricsRecord record) {
        if (!record.name().startsWith("phoenix.")) {
            return;
        }
        this.lazyInitialize();
        String stmt = "UPSERT INTO " + this.table + " (";
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> variableValues = new ArrayList<String>(record.tags().size());
        keys.add(MetricInfo.TRACE.columnName);
        values.add(Long.parseLong(record.name().substring("phoenix.".length())));
        keys.add(MetricInfo.DESCRIPTION.columnName);
        values.add(VARIABLE_VALUE);
        variableValues.add(record.description());
        for (AbstractMetric metric : record.metrics()) {
            keys.add(MetricInfo.getColumnName(metric.name()));
            values.add(metric.value());
        }
        int annotationCount = 0;
        int tagCount = 0;
        for (MetricsTag tag : record.tags()) {
            if (tag.name().equals(MetricInfo.ANNOTATION.traceName)) {
                this.addDynamicEntry(keys, values, variableValues, ANNOTATION_FAMILY, tag, MetricInfo.ANNOTATION, annotationCount);
                ++annotationCount;
                continue;
            }
            if (tag.name().equals(MetricInfo.TAG.traceName)) {
                this.addDynamicEntry(keys, values, variableValues, TAG_FAMILY, tag, MetricInfo.TAG, tagCount);
                ++tagCount;
                continue;
            }
            if (tag.name().equals(MetricInfo.HOSTNAME.traceName)) {
                keys.add(MetricInfo.HOSTNAME.columnName);
                values.add(VARIABLE_VALUE);
                variableValues.add(tag.value());
                continue;
            }
            if (tag.name().equals("Context")) continue;
            LOGGER.error("Got an unexpected tag: " + tag);
        }
        keys.add(TAG_COUNT);
        values.add(tagCount);
        keys.add(ANNOTATION_COUNT);
        values.add(annotationCount);
        stmt = stmt + COMMAS.join(keys);
        stmt = stmt + ") VALUES (" + COMMAS.join(values) + ")";
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Logging metrics to phoenix table via: " + stmt);
            LOGGER.trace("With tags: " + variableValues);
        }
        try (PreparedStatement ps = this.conn.prepareStatement(stmt);){
            int index = 1;
            for (String tag : variableValues) {
                ps.setString(index++, tag);
            }
            MutationPlan plan = ps.unwrap(PhoenixPreparedStatement.class).compileMutation(stmt);
            MutationState state = this.conn.unwrap(PhoenixConnection.class).getMutationState();
            MutationState newState = plan.execute();
            state.join(newState);
        }
        catch (SQLException e) {
            LOGGER.error("Could not write metric: \n" + record + " to prepared statement:\n" + stmt, (Throwable)e);
        }
    }

    public static String getDynamicColumnName(String family, String column, int count) {
        return COLUMN_JOIN.join((Object)family, (Object)column, new Object[0]) + count;
    }

    private void addDynamicEntry(List<String> keys, List<Object> values, List<String> variableValues, String family, MetricsTag tag, MetricInfo metric, int count) {
        keys.add(PhoenixMetricsSink.getDynamicColumnName(family, metric.columnName, count) + " VARCHAR");
        String val = tag.description() + " - " + tag.value();
        values.add(VARIABLE_VALUE);
        variableValues.add(val);
    }

    @VisibleForTesting
    public void clearForTesting() throws SQLException {
        this.conn.rollback();
    }
}

