/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.Time;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedTimeArray
extends PArrayDataType<Time[]> {
    public static final PUnsignedTimeArray INSTANCE = new PUnsignedTimeArray();

    private PUnsignedTimeArray() {
        super("UNSIGNED_TIME ARRAY", 3000 + PUnsignedTime.INSTANCE.getSqlType(), PhoenixArray.class, null, 39);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedTime.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, (PDataType)PUnsignedTime.INSTANCE, sortOrder, maxLength, scale, PUnsignedTime.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        Object[] timeArr;
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        for (Object i : timeArr = (Object[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PUnsignedTime.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedTime.INSTANCE, arrayLength, maxLength);
    }
}

