/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.SQLException;
import java.sql.Time;
import java.text.Format;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;

public class PUnsignedTime
extends PDataType<Time> {
    public static final PUnsignedTime INSTANCE = new PUnsignedTime();

    private PUnsignedTime() {
        super("UNSIGNED_TIME", 18, Time.class, new PUnsignedDate.UnsignedDateCodec(), 13);
    }

    @Override
    public byte[] toBytes(Object object) {
        return PUnsignedDate.INSTANCE.toBytes(object);
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        return PUnsignedDate.INSTANCE.toBytes(object, bytes, offset);
    }

    @Override
    public Time toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Time t = (Time)PTime.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedTime.throwIfNonNegativeDate(t);
        return t;
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale, Class jdbcType) throws SQLException {
        Time sqlTime = this.toObject(bytes, offset, length, actualType, sortOrder, maxLength, scale);
        return PTime.INSTANCE.timeToClass(sqlTime, actualType, jdbcType);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Time t = (Time)PTime.INSTANCE.toObject(object, actualType);
        PUnsignedTime.throwIfNonNegativeDate(t);
        return t;
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PUnsignedDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PUnsignedDate.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PTime.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PTime.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public Object toObject(String value) {
        return PTime.INSTANCE.toObject(value);
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType == PUnsignedDate.INSTANCE || otherType == PUnsignedTimestamp.INSTANCE;
    }

    @Override
    public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
        return PUnsignedDate.INSTANCE.toStringLiteral(b, offset, length, formatter);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        return PUnsignedDate.INSTANCE.toStringLiteral(o, formatter);
    }

    @Override
    public int getResultSetSqlType() {
        return 92;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Time((Long)PUnsignedLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }
}

