/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.DateUtil;

public class PTime
extends PDataType<Time> {
    public static final PTime INSTANCE = new PTime();

    private PTime() {
        super("TIME", 92, Time.class, new PDate.DateCodec(), 10);
    }

    @Override
    public byte[] toBytes(Object object) {
        return PDate.INSTANCE.toBytes(object);
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        return PDate.INSTANCE.toBytes(object, bytes, offset);
    }

    @Override
    public Time toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l == 0) {
            return null;
        }
        if (PTime.equalsAny(actualType, PTimestamp.INSTANCE, PUnsignedTimestamp.INSTANCE, PDate.INSTANCE, PUnsignedDate.INSTANCE, INSTANCE, PUnsignedTime.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Time(DateUtil.getCodecFor(actualType).decodeLong(b, o, sortOrder));
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return new Time(bd.longValueExact());
        }
        PTime.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PTime.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE)) {
            return new Time(((java.util.Date)object).getTime());
        }
        if (PTime.equalsAny(actualType, PTimestamp.INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            return new Time(((Timestamp)object).getTime());
        }
        if (PTime.equalsAny(actualType, INSTANCE, PUnsignedTime.INSTANCE)) {
            return object;
        }
        if (PTime.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Time((Long)object);
        }
        if (actualType == PDecimal.INSTANCE) {
            return new Time(((BigDecimal)object).longValueExact());
        }
        if (actualType == PVarchar.INSTANCE) {
            return DateUtil.parseTime((String)object);
        }
        return PTime.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale, Class jdbcType) throws SQLException {
        Time sqlTime = this.toObject(bytes, offset, length, actualType, sortOrder, maxLength, scale);
        return this.timeToClass(sqlTime, actualType, jdbcType);
    }

    Object timeToClass(Time sqlTime, PDataType actualType, Class jdbcType) throws SQLException {
        if (jdbcType == LocalTime.class) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(sqlTime.getTime()), ZoneOffset.UTC).toLocalTime();
        }
        if (jdbcType == LocalDateTime.class) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(sqlTime.getTime()), ZoneOffset.UTC);
        }
        if (jdbcType == LocalDate.class) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(sqlTime.getTime()), ZoneOffset.UTC).toLocalDate();
        }
        if (jdbcType == Time.class) {
            return sqlTime;
        }
        if (jdbcType == Date.class) {
            return new Date(sqlTime.getTime());
        }
        if (jdbcType == Timestamp.class) {
            return new Timestamp(sqlTime.getTime());
        }
        if (jdbcType == java.util.Date.class) {
            return new java.util.Date(sqlTime.getTime());
        }
        throw PTime.newMismatchException(actualType, jdbcType);
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PDate.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return PDate.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PDate.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return DateUtil.parseTime(value);
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType == PDate.INSTANCE || otherType == PTimestamp.INSTANCE || otherType == PLong.INSTANCE;
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null) {
            formatter = DateUtil.DEFAULT_TIME_FORMATTER;
        }
        return "'" + super.toStringLiteral(o, formatter) + "'";
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Time((Long)PLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }
}

