/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDataTypeFactory;

public abstract class PNumericType<T>
extends PDataType<T> {
    protected PNumericType(String sqlTypeName, int sqlType, Class clazz, PDataType.PDataCodec codec, int ordinal) {
        super(sqlTypeName, sqlType, clazz, codec, ordinal);
    }

    public final int signum(byte[] bytes, int offset, int length, SortOrder sortOrder) {
        return this.signum(bytes, offset, length, sortOrder, null, null);
    }

    public final int signum(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        return this.signum(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder);
    }

    public abstract int signum(byte[] var1, int var2, int var3, SortOrder var4, Integer var5, Integer var6);

    public abstract void abs(byte[] var1, int var2, int var3, SortOrder var4, ImmutableBytesWritable var5);

    public final void abs(ImmutableBytesWritable ptr, SortOrder sortOrder, ImmutableBytesWritable outPtr) {
        this.abs(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder, outPtr);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale, Class jdbcType) throws SQLException {
        PDataType pType = PDataTypeFactory.getInstance().instanceFromJavaClass(jdbcType, this);
        if (pType == null || !PNumericType.class.isAssignableFrom(pType.getClass())) {
            throw PNumericType.newMismatchException(actualType, jdbcType);
        }
        return pType.toObject(bytes, offset, length, actualType, sortOrder, maxLength, scale);
    }
}

