/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Format;
import java.util.Date;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PRealNumber;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.NumberUtil;

public class PDecimal
extends PRealNumber<BigDecimal> {
    public static final PDecimal INSTANCE = new PDecimal();
    private static final BigDecimal MIN_DOUBLE_AS_BIG_DECIMAL = BigDecimal.valueOf(-1.7976931348623157E308);
    private static final BigDecimal MAX_DOUBLE_AS_BIG_DECIMAL = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal MIN_FLOAT_AS_BIG_DECIMAL = BigDecimal.valueOf(-3.4028234663852886E38);
    private static final BigDecimal MAX_FLOAT_AS_BIG_DECIMAL = BigDecimal.valueOf(3.4028234663852886E38);

    private PDecimal() {
        super("DECIMAL", 3, BigDecimal.class, null, 8);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        BigDecimal v = (BigDecimal)object;
        v = NumberUtil.normalize(v);
        int len = this.getLength(v);
        byte[] result = new byte[Math.min(len, MAX_BIG_DECIMAL_BYTES)];
        PDataType.toBytes(v, result, 0, len);
        return result;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            return 0;
        }
        BigDecimal v = (BigDecimal)object;
        v = NumberUtil.normalize(v);
        int len = this.getLength(v);
        return PDataType.toBytes(v, bytes, offset, len);
    }

    private int getLength(BigDecimal v) {
        int signum = v.signum();
        if (signum == 0) {
            return 1;
        }
        return (signum < 0 ? 2 : 1) + (v.precision() + 1 + (v.scale() % 2 == 0 ? 0 : 1)) / 2;
    }

    @Override
    public int estimateByteSize(Object o) {
        if (o == null) {
            return 1;
        }
        BigDecimal v = (BigDecimal)o;
        return Math.min(this.getLength(v), MAX_BIG_DECIMAL_BYTES);
    }

    @Override
    public Integer getMaxLength(Object o) {
        if (o == null) {
            return 38;
        }
        BigDecimal v = (BigDecimal)o;
        return v.precision();
    }

    @Override
    public Integer getScale(Object o) {
        return null;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        if (l == 0) {
            return null;
        }
        if (actualType == INSTANCE) {
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[l], 0, l);
                o = 0;
            }
            return PDecimal.toBigDecimal(b, o, l);
        }
        if (PDecimal.equalsAny(actualType, PDate.INSTANCE, PTime.INSTANCE, PUnsignedDate.INSTANCE, PUnsignedTime.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE, PInteger.INSTANCE, PUnsignedInt.INSTANCE, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            return BigDecimal.valueOf(actualType.getCodec().decodeLong(b, o, sortOrder));
        }
        if (PDecimal.equalsAny(actualType, PFloat.INSTANCE, PUnsignedFloat.INSTANCE)) {
            return BigDecimal.valueOf(actualType.getCodec().decodeFloat(b, o, sortOrder));
        }
        if (PDecimal.equalsAny(actualType, PDouble.INSTANCE, PUnsignedDouble.INSTANCE)) {
            return BigDecimal.valueOf(actualType.getCodec().decodeDouble(b, o, sortOrder));
        }
        if (PDecimal.equalsAny(actualType, PTimestamp.INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            long millisPart = DateUtil.getCodecFor(actualType).decodeLong(b, o, sortOrder);
            int nanoPart = PUnsignedInt.INSTANCE.getCodec().decodeInt(b, o + 8, sortOrder);
            BigDecimal nanosPart = BigDecimal.valueOf((double)nanoPart % QueryConstants.MILLIS_TO_NANOS_CONVERTOR / QueryConstants.MILLIS_TO_NANOS_CONVERTOR);
            return BigDecimal.valueOf(millisPart).add(nanosPart);
        }
        if (actualType == PBoolean.INSTANCE) {
            return (Boolean)PBoolean.INSTANCE.toObject(b, o, l, actualType, sortOrder) != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return PDecimal.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PDecimal.equalsAny(actualType, PInteger.INSTANCE, PUnsignedInt.INSTANCE)) {
            return BigDecimal.valueOf(((Integer)object).intValue());
        }
        if (PDecimal.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return BigDecimal.valueOf((Long)object);
        }
        if (PDecimal.equalsAny(actualType, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE)) {
            return BigDecimal.valueOf(((Short)object).shortValue());
        }
        if (PDecimal.equalsAny(actualType, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            return BigDecimal.valueOf(((Byte)object).byteValue());
        }
        if (PDecimal.equalsAny(actualType, PFloat.INSTANCE, PUnsignedFloat.INSTANCE)) {
            return BigDecimal.valueOf(((Float)object).floatValue());
        }
        if (PDecimal.equalsAny(actualType, PDouble.INSTANCE, PUnsignedDouble.INSTANCE)) {
            return BigDecimal.valueOf((Double)object);
        }
        if (actualType == INSTANCE) {
            return object;
        }
        if (PDecimal.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE)) {
            Date d = (Date)object;
            return BigDecimal.valueOf(d.getTime());
        }
        if (PDecimal.equalsAny(actualType, PTimestamp.INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            Timestamp ts = (Timestamp)object;
            long millisPart = ts.getTime();
            BigDecimal nanosPart = BigDecimal.valueOf((double)ts.getNanos() % QueryConstants.MILLIS_TO_NANOS_CONVERTOR / QueryConstants.MILLIS_TO_NANOS_CONVERTOR);
            BigDecimal value = BigDecimal.valueOf(millisPart).add(nanosPart);
            return value;
        }
        if (actualType == PBoolean.INSTANCE) {
            return (Boolean)object != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return PDecimal.throwConstraintViolationException(actualType, this);
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public Integer getByteSize() {
        return MAX_BIG_DECIMAL_BYTES;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhsType == INSTANCE) {
            return ((BigDecimal)lhs).compareTo((BigDecimal)rhs);
        }
        return -rhsType.compareTo(rhs, lhs, this);
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return super.isCastableTo(targetType) || targetType.isCoercibleTo(PTimestamp.INSTANCE) || targetType.equals(PBoolean.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            if (PDecimal.equalsAny(targetType, PUnsignedLong.INSTANCE, PUnsignedInt.INSTANCE, PUnsignedSmallint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
                BigDecimal bd = (BigDecimal)value;
                if (bd.signum() == -1) {
                    return false;
                }
            } else {
                if (targetType.equals(PLong.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        bd.longValueExact();
                        return true;
                    }
                    catch (ArithmeticException e) {
                        return false;
                    }
                }
                if (targetType.equals(PInteger.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        bd.intValueExact();
                        return true;
                    }
                    catch (ArithmeticException e) {
                        return false;
                    }
                }
                if (targetType.equals(PSmallint.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        bd.shortValueExact();
                        return true;
                    }
                    catch (ArithmeticException e) {
                        return false;
                    }
                }
                if (targetType.equals(PTinyint.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        bd.byteValueExact();
                        return true;
                    }
                    catch (ArithmeticException e) {
                        return false;
                    }
                }
                if (targetType.equals(PUnsignedFloat.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        BigDecimal maxFloat = MAX_FLOAT_AS_BIG_DECIMAL;
                        boolean isNegtive = bd.signum() == -1;
                        return bd.compareTo(maxFloat) <= 0 && !isNegtive;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (targetType.equals(PFloat.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        BigDecimal maxFloat = MAX_FLOAT_AS_BIG_DECIMAL;
                        BigDecimal minFloat = MIN_FLOAT_AS_BIG_DECIMAL;
                        return bd.compareTo(maxFloat) <= 0 && bd.compareTo(minFloat) >= 0;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (targetType.equals(PUnsignedDouble.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        BigDecimal maxDouble = MAX_DOUBLE_AS_BIG_DECIMAL;
                        boolean isNegtive = bd.signum() == -1;
                        return bd.compareTo(maxDouble) <= 0 && !isNegtive;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (targetType.equals(PDouble.INSTANCE)) {
                    BigDecimal bd = (BigDecimal)value;
                    try {
                        BigDecimal maxDouble = MAX_DOUBLE_AS_BIG_DECIMAL;
                        BigDecimal minDouble = MIN_DOUBLE_AS_BIG_DECIMAL;
                        return bd.compareTo(maxDouble) <= 0 && bd.compareTo(minDouble) >= 0;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, SortOrder sortOrder, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        if (ptr.getLength() == 0) {
            return true;
        }
        if (srcType != INSTANCE) {
            if (!srcType.isCoercibleTo(this)) {
                throw new IllegalArgumentException(TypeMismatchException.newException(srcType, this));
            }
            return true;
        }
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            maxLength = v.precision();
            scale = v.scale();
        } else {
            this.coerceBytes(ptr, value, srcType, maxLength, scale, sortOrder, desiredMaxLength, desiredScale, sortOrder, true);
            int[] v = PDecimal.getDecimalPrecisionAndScale(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder);
            maxLength = v[0];
            scale = v[1];
        }
        return desiredMaxLength == null || desiredScale == null || maxLength == null || scale == null || desiredMaxLength - desiredScale >= maxLength - scale;
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        if (desiredScale == null) {
            super.coerceBytes(ptr, object, actualType, maxLength, scale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
            return;
        }
        if (ptr.getLength() == 0) {
            return;
        }
        if (scale == null) {
            if (object != null) {
                v = (BigDecimal)object;
                scale = ((BigDecimal)v).scale();
            } else {
                v = PDecimal.getDecimalPrecisionAndScale(ptr.get(), ptr.getOffset(), ptr.getLength(), actualModifier);
                scale = (int)v[1];
            }
        }
        if (this == actualType && scale <= desiredScale) {
            return;
        }
        BigDecimal decimal = object != null ? (BigDecimal)this.toObject(object, actualType) : (BigDecimal)this.toObject(ptr);
        decimal = decimal.setScale((int)desiredScale, 1);
        ptr.set(this.toBytes(decimal));
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw PDecimal.newIllegalDataException(e);
        }
    }

    @Override
    public Integer estimateByteSizeFromLength(Integer length) {
        return null;
    }

    @Override
    public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
        if (formatter == null) {
            BigDecimal o = (BigDecimal)this.toObject(b, offset, length);
            return o.toPlainString();
        }
        return super.toStringLiteral(b, offset, length, formatter);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null) {
            if (o == null) {
                return String.valueOf(o);
            }
            return ((BigDecimal)o).toPlainString();
        }
        return super.toStringLiteral(o, formatter);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new BigDecimal((Long)PLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    @Override
    public int signum(byte[] bytes, int offset, int length, SortOrder sortOrder, Integer maxLength, Integer scale) {
        byte signByte = sortOrder == SortOrder.DESC ? SortOrder.invert(bytes[offset]) : bytes[offset];
        if (length == 1 && signByte == -128) {
            return 0;
        }
        return (signByte & 0x80) == 0 ? -1 : 1;
    }

    @Override
    public void abs(byte[] bytes, int offset, int length, SortOrder sortOrder, ImmutableBytesWritable outPtr) {
        if (sortOrder == SortOrder.DESC) {
            bytes = SortOrder.invert(bytes, offset, new byte[length], 0, length);
            offset = 0;
        }
        BigDecimal bigDecimal = PDecimal.toBigDecimal(bytes, offset, length);
        outPtr.set(this.toBytes(bigDecimal.abs()));
    }
}

