/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.text.Format;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;

public class PBson
extends PVarbinary {
    public static final PBson INSTANCE = new PBson();

    private PBson() {
        super("BSON", 7000, byte[].class, null, 49);
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            return 0;
        }
        byte[] b = this.toBytes(object);
        System.arraycopy(b, 0, bytes, offset, b.length);
        return b.length;
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        if (!(object instanceof BsonDocument)) {
            throw new IllegalArgumentException("The object should be of type BsonDocument");
        }
        if (object instanceof RawBsonDocument) {
            return ByteUtil.toBytes(((RawBsonDocument)object).getByteBuffer().asNIO());
        }
        RawBsonDocument rawBsonDocument = new RawBsonDocument((Object)((BsonDocument)object), (Codec)new BsonDocumentCodec());
        return ByteUtil.toBytes(rawBsonDocument.getByteBuffer().asNIO());
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (length == 0) {
            return null;
        }
        return new RawBsonDocument(bytes, offset, length);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PBson.equalsAny(actualType, PVarchar.INSTANCE)) {
            return this.toObject((String)object);
        }
        return object;
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return RawBsonDocument.parse((String)value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PBson.equalsAny(targetType, this, PBinary.INSTANCE, PVarbinary.INSTANCE);
    }

    @Override
    public int estimateByteSize(Object o) {
        byte[] value = this.toBytes(o);
        return value == null ? 1 : value.length;
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return otherType == PVarbinary.INSTANCE || otherType == INSTANCE;
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        return ((BsonDocument)o).toJson();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        String mapStr = "{\"map\":{\"attr_0\":{\"s\":\"val_0\"}}}";
        return this.toObject(mapStr);
    }
}

