/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class PositionBasedMultiKeyValueTuple
extends BaseTuple {
    private EncodedColumnQualiferCellsList values;

    public PositionBasedMultiKeyValueTuple() {
    }

    public PositionBasedMultiKeyValueTuple(List<Cell> values) {
        Preconditions.checkArgument((boolean)(values instanceof EncodedColumnQualiferCellsList), (Object)"PositionBasedMultiKeyValueTuple only works with lists of type EncodedColumnQualiferCellsList");
        this.values = (EncodedColumnQualiferCellsList)values;
    }

    @Override
    public void setKeyValues(List<Cell> values) {
        Preconditions.checkArgument((boolean)(values instanceof EncodedColumnQualiferCellsList), (Object)"PositionBasedMultiKeyValueTuple only works with lists of type EncodedColumnQualiferCellsList");
        this.values = (EncodedColumnQualiferCellsList)values;
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        Cell value = this.values.getFirstCell();
        ptr.set(value.getRowArray(), value.getRowOffset(), (int)value.getRowLength());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public Cell getValue(byte[] family, byte[] qualifier) {
        return this.values.getCellForColumnQualifier(qualifier);
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Cell getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        Cell kv = this.getValue(family, qualifier);
        if (kv == null) {
            return false;
        }
        ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }

    @Override
    public long getSerializedSize() {
        if (this.values == null || this.values.isEmpty()) {
            return 0L;
        }
        long totalSize = 0L;
        for (Cell cell : this.values) {
            totalSize += (long)cell.getSerializedSize();
        }
        return totalSize;
    }
}

