/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class TransformMaintainer
extends IndexMaintainer {
    private boolean isMultiTenant;
    private List<Expression> newTableExpressions;
    private Set<ColumnReference> newTableColumns;
    private List<PDataType> newTableColumnTypes;
    private int newTableColumnCount;
    private byte[] newTableName;
    private int nNewTableSaltBuckets;
    private byte[] oldTableEmptyKeyValueCF;
    private ImmutableBytesPtr emptyKeyValueCFPtr;
    private int nOldTableCFs;
    private boolean newTableWALDisabled;
    private boolean newTableImmutableRows;
    private Set<ColumnReference> allColumns;
    private final boolean isOldTableSalted;
    private final RowKeySchema oldTableRowKeySchema;
    private int estimatedNewTableRowKeyBytes;
    private ColumnReference newTableEmptyKeyValueRef;
    private ColumnReference oldTableEmptyKeyValueRef;
    private boolean newTableRowKeyOrderOptimizable;
    private PTable.QualifierEncodingScheme newTableEncodingScheme;
    private PTable.ImmutableStorageScheme newTableImmutableStorageScheme;
    private PTable.QualifierEncodingScheme oldTableEncodingScheme;
    private PTable.ImmutableStorageScheme oldTableImmutableStorageScheme;
    private Set<Pair<String, String>> newTableColumnsInfo;
    private Map<ColumnReference, ColumnReference> coveredColumnsMap;
    private String logicalNewTableName;

    public static TransformMaintainer create(PTable oldTable, PTable newTable, PhoenixConnection connection) {
        if (oldTable.getType() == PTableType.INDEX) {
            throw new IllegalArgumentException();
        }
        TransformMaintainer maintainer = new TransformMaintainer(oldTable, newTable, connection);
        return maintainer;
    }

    private TransformMaintainer(RowKeySchema oldRowKeySchema, boolean isOldTableSalted) {
        super(oldRowKeySchema, isOldTableSalted);
        this.oldTableRowKeySchema = oldRowKeySchema;
        this.isOldTableSalted = isOldTableSalted;
    }

    @Override
    public Set<ColumnReference> getAllColumns() {
        return this.allColumns;
    }

    @Override
    public Set<ColumnReference> getCoveredColumns() {
        return this.coveredColumnsMap.keySet();
    }

    private TransformMaintainer(PTable oldTable, PTable newTable, PhoenixConnection connection) {
        this(oldTable.getRowKeySchema(), oldTable.getBucketNum() != null);
        this.newTableRowKeyOrderOptimizable = newTable.rowKeyOrderOptimizable();
        this.isMultiTenant = oldTable.isMultiTenant();
        this.newTableEncodingScheme = newTable.getEncodingScheme() == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : newTable.getEncodingScheme();
        this.newTableImmutableStorageScheme = newTable.getImmutableStorageScheme() == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : newTable.getImmutableStorageScheme();
        this.oldTableEncodingScheme = oldTable.getEncodingScheme() == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : oldTable.getEncodingScheme();
        this.oldTableImmutableStorageScheme = oldTable.getImmutableStorageScheme() == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : oldTable.getImmutableStorageScheme();
        this.newTableName = newTable.getPhysicalName().getBytes();
        boolean newTableWALDisabled = newTable.isWALDisabled();
        int nNewTableColumns = newTable.getColumns().size();
        int nNewTablePKColumns = newTable.getPKColumns().size();
        List<PColumn> oldTablePKColumns = oldTable.getPKColumns();
        this.newTableColumnCount = oldTablePKColumns.size();
        this.newTableColumnTypes = Lists.newArrayListWithExpectedSize((int)nNewTablePKColumns);
        this.newTableExpressions = Lists.newArrayListWithExpectedSize((int)nNewTableColumns);
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)(nNewTableColumns - nNewTablePKColumns));
        this.nNewTableSaltBuckets = newTable.getBucketNum() == null ? 0 : newTable.getBucketNum();
        this.oldTableEmptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(oldTable);
        this.emptyKeyValueCFPtr = SchemaUtil.getEmptyColumnFamilyPtr(newTable);
        this.nOldTableCFs = oldTable.getColumnFamilies().size();
        this.newTableWALDisabled = newTableWALDisabled;
        this.newTableImmutableRows = newTable.isImmutableRows();
        this.newTableColumnsInfo = Sets.newHashSetWithExpectedSize((int)(nNewTableColumns - nNewTablePKColumns));
        for (int i = 0; i < newTable.getColumnFamilies().size(); ++i) {
            PColumnFamily family = newTable.getColumnFamilies().get(i);
            for (PColumn newColumn : family.getColumns()) {
                PColumn oldColumn = TransformMaintainer.getColumnOrNull(oldTable, newColumn.getName().getString(), newColumn.getFamilyName().getString());
                if (oldColumn == null) continue;
                byte[] oldColumnCq = oldColumn.getColumnQualifierBytes();
                byte[] newColumnCq = newColumn.getColumnQualifierBytes();
                this.coveredColumnsMap.put(new ColumnReference(oldColumn.getFamilyName().getBytes(), oldColumnCq), new ColumnReference(newColumn.getFamilyName().getBytes(), newColumnCq));
            }
        }
        this.logicalNewTableName = newTable.getName().getString();
        this.initCachedState();
    }

    public static PColumn getColumnOrNull(PTable table, String columnName, String familyName) {
        PColumnFamily family;
        try {
            family = table.getColumnFamily(familyName);
        }
        catch (ColumnFamilyNotFoundException e) {
            return null;
        }
        try {
            return family.getPColumnForColumnName(columnName);
        }
        catch (ColumnNotFoundException e) {
            return null;
        }
    }

    @Override
    public Set<ColumnReference> getAllColumnsForDataTable() {
        LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)(this.newTableExpressions.size() + this.coveredColumnsMap.size()));
        result.addAll(this.newTableColumns);
        for (ColumnReference colRef : this.coveredColumnsMap.keySet()) {
            if (this.oldTableImmutableStorageScheme == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                result.add(colRef);
                continue;
            }
            result.add(new ColumnReference(colRef.getFamily(), QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES));
        }
        return result;
    }

    @Override
    public byte[] buildDataRowKey(ImmutableBytesWritable indexRowKeyPtr, byte[][] viewConstants) {
        return this.buildDataRowKey(indexRowKeyPtr, viewConstants, false);
    }

    public byte[] buildDataRowKey(ImmutableBytesWritable indexRowKeyPtr, byte[][] viewConstants, boolean truncateEndSeparators) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedNewTableRowKeyBytes);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            byte[] oldTableRowKey;
            int dataPosOffset = 0;
            int maxRowKeyOffset = indexRowKeyPtr.getLength();
            this.oldTableRowKeySchema.iterator(indexRowKeyPtr, ptr, 0);
            while (this.oldTableRowKeySchema.next(ptr, dataPosOffset, maxRowKeyOffset) != null) {
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.oldTableRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(SchemaUtil.getSeparatorByte(this.oldTableRowKeySchema.rowKeyOrderOptimizable(), ptr.getLength() == 0, this.oldTableRowKeySchema.getField(dataPosOffset)));
                }
                ++dataPosOffset;
            }
            byte[] byArray = oldTableRowKey = stream.getBuffer();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initCachedState() {
        this.allColumns = Sets.newLinkedHashSetWithExpectedSize((int)(this.newTableExpressions.size() + this.coveredColumnsMap.size()));
        byte[] newTableEmptyKvQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(this.newTableEncodingScheme).getFirst();
        byte[] oldTableEmptyKvQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(this.oldTableEncodingScheme).getFirst();
        this.newTableEmptyKeyValueRef = new ColumnReference(this.oldTableEmptyKeyValueCF, newTableEmptyKvQualifier);
        this.oldTableEmptyKeyValueRef = new ColumnReference(this.oldTableEmptyKeyValueCF, oldTableEmptyKvQualifier);
        this.newTableColumns = Sets.newLinkedHashSetWithExpectedSize((int)this.newTableColumnCount);
        for (ColumnReference colRef : this.coveredColumnsMap.keySet()) {
            if (this.newTableImmutableStorageScheme == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                this.newTableColumns.add(colRef);
                continue;
            }
            this.newTableColumns.add(new ColumnReference(colRef.getFamily(), QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES));
        }
    }

    public static void serialize(PTable oldTable, ImmutableBytesWritable ptr, PTable newTable, PhoenixConnection connection) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        try {
            WritableUtils.writeVInt((DataOutput)output, (int)(oldTable.getBucketNum() == null ? 1 : -1));
            oldTable.getRowKeySchema().write(output);
            ServerCachingProtos.TransformMaintainer proto = TransformMaintainer.toProto(newTable.getTransformMaintainer(oldTable, connection));
            byte[] protoBytes = proto.toByteArray();
            WritableUtils.writeVInt((DataOutput)output, (int)protoBytes.length);
            output.write(protoBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ptr.set(stream.toByteArray(), 0, stream.size());
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.newTableColumns.iterator();
    }

    public static ServerCachingProtos.TransformMaintainer toProto(TransformMaintainer maintainer) throws IOException {
        ServerCachingProtos.ColumnReference.Builder cRefBuilder;
        ServerCachingProtos.TransformMaintainer.Builder builder = ServerCachingProtos.TransformMaintainer.newBuilder();
        builder.setSaltBuckets(maintainer.nNewTableSaltBuckets);
        builder.setIsMultiTenant(maintainer.isMultiTenant);
        for (ColumnReference columnReference : maintainer.newTableColumns) {
            cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            cRefBuilder.setFamily(ByteStringer.wrap((byte[])columnReference.getFamily()));
            cRefBuilder.setQualifier(ByteStringer.wrap((byte[])columnReference.getQualifier()));
            builder.addNewTableColumns(cRefBuilder.build());
        }
        for (Map.Entry entry : maintainer.coveredColumnsMap.entrySet()) {
            cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            ColumnReference dataTableColRef = (ColumnReference)entry.getKey();
            cRefBuilder.setFamily(ByteStringer.wrap((byte[])dataTableColRef.getFamily()));
            cRefBuilder.setQualifier(ByteStringer.wrap((byte[])dataTableColRef.getQualifier()));
            builder.addOldTableColRefForCoveredColumns(cRefBuilder.build());
            ColumnReference newTableColRef = (ColumnReference)entry.getValue();
            cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            cRefBuilder.setFamily(ByteStringer.wrap((byte[])newTableColRef.getFamily()));
            cRefBuilder.setQualifier(ByteStringer.wrap((byte[])newTableColRef.getQualifier()));
            builder.addNewTableColRefForCoveredColumns(cRefBuilder.build());
        }
        builder.setNewTableColumnCount(maintainer.newTableColumnCount);
        builder.setNewTableName(ByteStringer.wrap((byte[])maintainer.newTableName));
        builder.setNewTableRowKeyOrderOptimizable(maintainer.newTableRowKeyOrderOptimizable);
        builder.setOldTableEmptyKeyValueColFamily(ByteStringer.wrap((byte[])maintainer.oldTableEmptyKeyValueCF));
        ServerCachingProtos.ImmutableBytesWritable.Builder ibwBuilder = ServerCachingProtos.ImmutableBytesWritable.newBuilder();
        ibwBuilder.setByteArray(ByteStringer.wrap((byte[])maintainer.emptyKeyValueCFPtr.get()));
        ibwBuilder.setLength(maintainer.emptyKeyValueCFPtr.getLength());
        ibwBuilder.setOffset(maintainer.emptyKeyValueCFPtr.getOffset());
        builder.setEmptyKeyValueColFamily(ibwBuilder.build());
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            for (Expression expression : maintainer.newTableExpressions) {
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(output);
            }
            builder.setNewTableExpressions(ByteStringer.wrap((byte[])byteArrayOutputStream.toByteArray()));
        }
        builder.setNumDataTableColFamilies(maintainer.nOldTableCFs);
        builder.setNewTableWalDisabled(maintainer.newTableWALDisabled);
        builder.setNewTableRowKeyByteSize(maintainer.estimatedNewTableRowKeyBytes);
        builder.setNewTableImmutable(maintainer.newTableImmutableRows);
        for (Pair<String, String> p : maintainer.newTableColumnsInfo) {
            ServerCachingProtos.ColumnInfo.Builder ciBuilder = ServerCachingProtos.ColumnInfo.newBuilder();
            if (p.getFirst() != null) {
                ciBuilder.setFamilyName((String)p.getFirst());
            }
            ciBuilder.setColumnName((String)p.getSecond());
            builder.addNewTableColumnInfo(ciBuilder.build());
        }
        builder.setNewTableEncodingScheme(maintainer.newTableEncodingScheme.getSerializedMetadataValue());
        builder.setNewTableImmutableStorageScheme(maintainer.newTableImmutableStorageScheme.getSerializedMetadataValue());
        builder.setLogicalNewTableName(maintainer.logicalNewTableName);
        builder.setOldTableEncodingScheme(maintainer.oldTableEncodingScheme.getSerializedMetadataValue());
        builder.setOldTableImmutableStorageScheme(maintainer.oldTableImmutableStorageScheme.getSerializedMetadataValue());
        return builder.build();
    }

    public static TransformMaintainer fromProto(ServerCachingProtos.TransformMaintainer proto, RowKeySchema dataTableRowKeySchema, boolean isDataTableSalted) throws IOException {
        TransformMaintainer maintainer = new TransformMaintainer(dataTableRowKeySchema, isDataTableSalted);
        maintainer.nNewTableSaltBuckets = proto.getSaltBuckets();
        maintainer.isMultiTenant = proto.getIsMultiTenant();
        List<ServerCachingProtos.ColumnReference> newTableColList = proto.getNewTableColumnsList();
        maintainer.newTableColumns = new HashSet<ColumnReference>(newTableColList.size());
        for (ServerCachingProtos.ColumnReference colRefFromProto : newTableColList) {
            maintainer.newTableColumns.add(new ColumnReference(colRefFromProto.getFamily().toByteArray(), colRefFromProto.getQualifier().toByteArray()));
        }
        maintainer.newTableName = proto.getNewTableName().toByteArray();
        if (proto.getNewTableColumnCount() != -1) {
            maintainer.newTableColumnCount = proto.getNewTableColumnCount();
        }
        maintainer.newTableRowKeyOrderOptimizable = proto.getNewTableRowKeyOrderOptimizable();
        maintainer.oldTableEmptyKeyValueCF = proto.getOldTableEmptyKeyValueColFamily().toByteArray();
        ServerCachingProtos.ImmutableBytesWritable emptyKeyValueColFamily = proto.getEmptyKeyValueColFamily();
        maintainer.emptyKeyValueCFPtr = new ImmutableBytesPtr(emptyKeyValueColFamily.getByteArray().toByteArray(), emptyKeyValueColFamily.getOffset(), emptyKeyValueColFamily.getLength());
        maintainer.nOldTableCFs = proto.getNumDataTableColFamilies();
        maintainer.newTableWALDisabled = proto.getNewTableWalDisabled();
        maintainer.estimatedNewTableRowKeyBytes = proto.getNewTableRowKeyByteSize();
        maintainer.newTableImmutableRows = proto.getNewTableImmutable();
        List<ServerCachingProtos.ColumnInfo> newTblColumnInfoList = proto.getNewTableColumnInfoList();
        maintainer.newTableColumnsInfo = Sets.newHashSet();
        for (ServerCachingProtos.ColumnInfo info : newTblColumnInfoList) {
            maintainer.newTableColumnsInfo.add((Pair<String, String>)new Pair((Object)info.getFamilyName(), (Object)info.getColumnName()));
        }
        maintainer.newTableExpressions = new ArrayList<Expression>();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(proto.getNewTableExpressions().toByteArray());){
            DataInputStream input = new DataInputStream(stream);
            while (stream.available() > 0) {
                int expressionOrdinal = WritableUtils.readVInt((DataInput)input);
                Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                expression.readFields(input);
                maintainer.newTableExpressions.add(expression);
            }
        }
        maintainer.newTableEncodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue((byte)proto.getNewTableEncodingScheme());
        maintainer.newTableImmutableStorageScheme = PTable.ImmutableStorageScheme.fromSerializedValue((byte)proto.getNewTableImmutableStorageScheme());
        maintainer.oldTableEncodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue((byte)proto.getOldTableEncodingScheme());
        maintainer.oldTableImmutableStorageScheme = PTable.ImmutableStorageScheme.fromSerializedValue((byte)proto.getOldTableImmutableStorageScheme());
        List<ServerCachingProtos.ColumnReference> oldTableColRefsForCoveredColumnsList = proto.getOldTableColRefForCoveredColumnsList();
        List<ServerCachingProtos.ColumnReference> newTableColRefsForCoveredColumnsList = proto.getNewTableColRefForCoveredColumnsList();
        maintainer.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)oldTableColRefsForCoveredColumnsList.size());
        Iterator<ServerCachingProtos.ColumnReference> newTableColRefItr = newTableColRefsForCoveredColumnsList.iterator();
        for (ServerCachingProtos.ColumnReference colRefFromProto : oldTableColRefsForCoveredColumnsList) {
            ColumnReference oldTableColRef = new ColumnReference(colRefFromProto.getFamily().toByteArray(), colRefFromProto.getQualifier().toByteArray());
            ServerCachingProtos.ColumnReference fromProto = newTableColRefItr.next();
            ColumnReference newTableColRef = new ColumnReference(fromProto.getFamily().toByteArray(), fromProto.getQualifier().toByteArray());
            maintainer.coveredColumnsMap.put(oldTableColRef, newTableColRef);
        }
        maintainer.logicalNewTableName = proto.getLogicalNewTableName();
        maintainer.initCachedState();
        return maintainer;
    }

    public static List<IndexMaintainer> deserialize(byte[] buf) {
        return TransformMaintainer.deserialize(buf, 0, buf.length);
    }

    private static List<IndexMaintainer> deserialize(byte[] buf, int offset, int length) {
        ArrayList maintainers = Collections.emptyList();
        if (length > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(buf, offset, length);
            DataInputStream input = new DataInputStream(stream);
            try {
                int size = WritableUtils.readVInt((DataInput)input);
                boolean isDataTableSalted = size < 0;
                size = Math.abs(size);
                RowKeySchema rowKeySchema = new RowKeySchema();
                rowKeySchema.readFields(input);
                maintainers = Lists.newArrayListWithExpectedSize((int)size);
                for (int i = 0; i < size; ++i) {
                    int protoSize = WritableUtils.readVInt((DataInput)input);
                    byte[] b = new byte[protoSize];
                    input.readFully(b);
                    ServerCachingProtos.TransformMaintainer proto = ServerCachingProtos.TransformMaintainer.parseFrom(b);
                    maintainers.add(TransformMaintainer.fromProto(proto, rowKeySchema, isDataTableSalted));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return maintainers;
    }

    @Override
    public byte[] getIndexTableName() {
        return this.newTableName;
    }

    @Override
    public byte[] buildRowKey(ValueGetter valueGetter, ImmutableBytesWritable rowKeyPtr, byte[] regionStartKey, byte[] regionEndKey, long ts, byte[] encodedRegionName) {
        byte[] byArray;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean isNewTableSalted = this.nNewTableSaltBuckets > 0;
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedNewTableRowKeyBytes);
        try {
            int length;
            DataOutputStream output = new DataOutputStream(stream);
            if (isNewTableSalted) {
                output.write(0);
            }
            int dataPosOffset = this.isOldTableSalted ? 1 : 0;
            int maxRowKeyOffset = rowKeyPtr.getOffset() + rowKeyPtr.getLength();
            this.oldTableRowKeySchema.iterator(rowKeyPtr, ptr, dataPosOffset);
            int trailingVariableWidthColumnNum = 0;
            while (this.oldTableRowKeySchema.next(ptr, dataPosOffset, maxRowKeyOffset) != null) {
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.oldTableRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(SchemaUtil.getSeparatorByte(this.newTableRowKeyOrderOptimizable, ptr.getLength() == 0, this.oldTableRowKeySchema.getField(dataPosOffset)));
                    ++trailingVariableWidthColumnNum;
                } else {
                    trailingVariableWidthColumnNum = 0;
                }
                ++dataPosOffset;
            }
            byte[] newTableRowKey = stream.getBuffer();
            for (length = stream.size(); trailingVariableWidthColumnNum > 0 && length > 0 && newTableRowKey[length - 1] == 0; --length, --trailingVariableWidthColumnNum) {
            }
            if (isNewTableSalted) {
                byte saltByte;
                newTableRowKey[0] = saltByte = SaltingUtil.getSaltingByte(newTableRowKey, 1, length - 1, this.nNewTableSaltBuckets);
            }
            byArray = newTableRowKey.length == length ? newTableRowKey : Arrays.copyOf(newTableRowKey, length);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return byArray;
    }

    @Override
    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable oldRowKeyPtr, long ts, byte[] regionStartKey, byte[] regionEndKey, boolean verified, byte[] encodedRegionName) throws IOException {
        byte[] newRowKey = this.buildRowKey(valueGetter, oldRowKeyPtr, regionStartKey, regionEndKey, ts, encodedRegionName);
        return TransformMaintainer.buildUpdateMutation(kvBuilder, valueGetter, oldRowKeyPtr, ts, regionStartKey, regionEndKey, newRowKey, this.getEmptyKeyValueFamily(), this.coveredColumnsMap, this.newTableEmptyKeyValueRef, this.newTableWALDisabled, this.oldTableImmutableStorageScheme, this.newTableImmutableStorageScheme, this.newTableEncodingScheme, this.oldTableEncodingScheme, verified);
    }

    @Override
    public ImmutableBytesPtr getEmptyKeyValueFamily() {
        return this.emptyKeyValueCFPtr;
    }

    @Override
    public byte[] getEmptyKeyValueQualifier() {
        return this.newTableEmptyKeyValueRef.getQualifier();
    }

    @Override
    public byte[] getDataEmptyKeyValueCF() {
        return this.oldTableEmptyKeyValueCF;
    }

    @Override
    public byte[] getEmptyKeyValueQualifierForDataTable() {
        return this.oldTableEmptyKeyValueRef.getQualifier();
    }
}

