/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnDefInPkConstraint;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tool.SchemaProcessor;
import org.apache.phoenix.schema.tool.SchemaSQLUtil;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;

public class SchemaSynthesisProcessor
implements SchemaProcessor {
    public static final String ENTITY_NAME_IN_BASE_AND_ALTER_DDL_DON_T_MATCH = "Entity name in base and alter DDL don't match";
    public static final String UNSUPPORTED_DDL_EXCEPTION = "SchemaTool in Synth mode is supported for CREATE TABLE/VIEW/INDEX ddls";
    private final String ddlFile;

    public SchemaSynthesisProcessor(String ddlFile) {
        this.ddlFile = ddlFile;
    }

    @Override
    public String process() throws Exception {
        List<String> allDDL = this.getQueriesFromFile(this.ddlFile);
        String ddl = null;
        for (String s : allDDL) {
            ddl = this.synthesize(ddl, s);
        }
        return ddl == null ? "" : ddl;
    }

    private String synthesize(String baseDDL, String nextDDL) throws Exception {
        if (baseDDL == null && nextDDL != null) {
            BindableStatement bStmt = new SQLParser(nextDDL).parseStatement();
            if (bStmt instanceof CreateTableStatement || bStmt instanceof CreateIndexStatement) {
                return nextDDL;
            }
            throw new Exception(UNSUPPORTED_DDL_EXCEPTION);
        }
        BindableStatement createStatement = new SQLParser(baseDDL).parseStatement();
        BindableStatement alterStatement = new SQLParser(nextDDL).parseStatement();
        if (createStatement instanceof CreateTableStatement) {
            CreateTableStatement newCreateStmt = null;
            CreateTableStatement createStmt = (CreateTableStatement)createStatement;
            if (alterStatement instanceof AddColumnStatement) {
                newCreateStmt = this.getCreateTableStatement((AddColumnStatement)alterStatement, createStmt);
            } else if (alterStatement instanceof DropColumnStatement) {
                newCreateStmt = this.getCreateTableStatement((DropColumnStatement)alterStatement, createStmt);
            } else if (alterStatement instanceof DropTableStatement) {
                return null;
            }
            return SchemaSQLUtil.getCreateTableSQL(newCreateStmt);
        }
        if (createStatement instanceof CreateIndexStatement) {
            if (alterStatement instanceof DropIndexStatement) {
                return null;
            }
            CreateIndexStatement newCreateIndexStmt = this.getCreateIndexStatement(alterStatement, (CreateIndexStatement)createStatement);
            return SchemaSQLUtil.getCreateIndexSQL(newCreateIndexStmt);
        }
        throw new Exception(UNSUPPORTED_DDL_EXCEPTION);
    }

    private CreateIndexStatement getCreateIndexStatement(BindableStatement alterStatement, CreateIndexStatement createStatement) throws Exception {
        CreateIndexStatement newCreateIndexStmt = null;
        String tableName = createStatement.getIndexTableName().toString();
        String tableNameInAlter = ((AddColumnStatement)alterStatement).getTable().toString().trim();
        this.sanityCheck(tableName, tableNameInAlter);
        AddColumnStatement addStmt = (AddColumnStatement)alterStatement;
        if (addStmt.getColumnDefs() == null) {
            ListMultimap<String, Pair<String, Object>> finalProps = this.getEffectiveProperties(addStmt, createStatement.getProps());
            newCreateIndexStmt = new CreateIndexStatement(createStatement, finalProps);
        }
        return newCreateIndexStmt;
    }

    private CreateTableStatement getCreateTableStatement(DropColumnStatement alterStatement, CreateTableStatement createStmt) throws Exception {
        CreateTableStatement newCreateStmt = null;
        String tableName = createStmt.getTableName().toString();
        String tableNameInAlter = alterStatement.getTable().toString().trim();
        this.sanityCheck(tableName, tableNameInAlter);
        List<ColumnDef> oldColumnDef = createStmt.getColumnDefs();
        ArrayList<ColumnDef> newColumnDef = new ArrayList<ColumnDef>();
        newColumnDef.addAll(oldColumnDef);
        DropColumnStatement dropStmt = alterStatement;
        block0: for (ColumnName cName : dropStmt.getColumnRefs()) {
            for (ColumnDef colDef : oldColumnDef) {
                if (!colDef.getColumnDefName().equals(cName)) continue;
                newColumnDef.remove(colDef);
                continue block0;
            }
        }
        newCreateStmt = new CreateTableStatement(createStmt, newColumnDef);
        return newCreateStmt;
    }

    private CreateTableStatement getCreateTableStatement(AddColumnStatement alterStatement, CreateTableStatement createStmt) throws Exception {
        CreateTableStatement newCreateStmt = null;
        String tableName = createStmt.getTableName().toString();
        String tableNameInAlter = alterStatement.getTable().toString().trim();
        this.sanityCheck(tableName, tableNameInAlter);
        AddColumnStatement addStmt = alterStatement;
        List<ColumnDef> oldColDef = createStmt.getColumnDefs();
        ArrayList<ColumnDef> newColDef = new ArrayList<ColumnDef>();
        if (addStmt.getColumnDefs() == null) {
            ListMultimap<String, Pair<String, Object>> finalProps = this.getEffectiveProperties(addStmt, createStmt.getProps());
            newCreateStmt = new CreateTableStatement(createStmt, finalProps, oldColDef);
        } else {
            newColDef.addAll(oldColDef);
            newColDef.addAll(addStmt.getColumnDefs());
            PrimaryKeyConstraint oldPKConstraint = createStmt.getPrimaryKeyConstraint();
            ArrayList<ColumnDefInPkConstraint> pkList = new ArrayList<ColumnDefInPkConstraint>();
            for (Pair<ColumnName, SortOrder> entry : oldPKConstraint.getColumnNames()) {
                ColumnDefInPkConstraint cd = new ColumnDefInPkConstraint((ColumnName)entry.getFirst(), (SortOrder)((Object)entry.getSecond()), oldPKConstraint.isColumnRowTimestamp((ColumnName)entry.getFirst()));
                pkList.add(cd);
            }
            for (ColumnDef cd : addStmt.getColumnDefs()) {
                if (!cd.isPK()) continue;
                ColumnDefInPkConstraint cdpk = new ColumnDefInPkConstraint(cd.getColumnDefName(), cd.getSortOrder(), cd.isRowTimestamp());
                pkList.add(cdpk);
            }
            PrimaryKeyConstraint pkConstraint = new PrimaryKeyConstraint(oldPKConstraint.getName(), pkList);
            newCreateStmt = new CreateTableStatement(createStmt, pkConstraint, newColDef);
        }
        return newCreateStmt;
    }

    private void sanityCheck(String tableName, String tableNameInAlter) throws Exception {
        if (!tableName.equalsIgnoreCase(tableNameInAlter)) {
            throw new Exception(ENTITY_NAME_IN_BASE_AND_ALTER_DDL_DON_T_MATCH);
        }
    }

    private ListMultimap<String, Pair<String, Object>> getEffectiveProperties(AddColumnStatement addStmt, ListMultimap<String, Pair<String, Object>> oldProps) {
        HashMap<String, Object> oldPropMap = new HashMap<String, Object>();
        HashMap<String, Object> changePropMap = new HashMap<String, Object>();
        for (Pair value : oldProps.values()) {
            oldPropMap.put((String)value.getFirst(), value.getSecond());
        }
        for (Pair value : addStmt.getProps().values()) {
            changePropMap.put((String)value.getFirst(), value.getSecond());
        }
        oldPropMap.putAll(changePropMap);
        ArrayListMultimap finalProps = ArrayListMultimap.create();
        for (Map.Entry entry : oldPropMap.entrySet()) {
            finalProps.put((Object)"", (Object)Pair.newPair((Object)((String)entry.getKey()), entry.getValue()));
        }
        return finalProps;
    }

    private List<String> getQueriesFromFile(String ddlFile) throws IOException {
        String st;
        StringBuilder sb = new StringBuilder();
        File file = new File(ddlFile);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        while ((st = br.readLine()) != null) {
            sb.append(st).append("\n");
        }
        String trimmedQuery = sb.toString().trim();
        if (trimmedQuery.contains("/*") && trimmedQuery.contains("*/")) {
            trimmedQuery = trimmedQuery.substring(trimmedQuery.lastIndexOf("*/") + 2);
        }
        String[] queries = trimmedQuery.split(";");
        ArrayList<String> output = new ArrayList<String>();
        for (String query : queries) {
            StringBuilder newSb = new StringBuilder(query);
            char lastChar = newSb.charAt(newSb.length() - 1);
            if (lastChar == '\n' || lastChar == ';') {
                newSb.deleteCharAt(newSb.length() - 1);
            }
            output.add(newSb.toString().trim());
        }
        return output;
    }
}

