/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tool;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.tool.SchemaProcessor;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class SchemaExtractionProcessor
implements SchemaProcessor {
    Map<String, String> defaultProps = new HashMap<String, String>();
    Map<String, String> definedProps = new HashMap<String, String>();
    private static final String CREATE_TABLE = "CREATE TABLE %s";
    private static final String CREATE_INDEX = "CREATE %sINDEX %s ON %s";
    private static final String CREATE_VIEW = "CREATE VIEW %s%s AS SELECT * FROM %s%s";
    private static final List<String> QUOTE_PROPERTIES = Arrays.asList("hbase.store.file-tracker.impl");
    private PTable table;
    private Configuration conf;
    private String ddl = null;
    private String tenantId;
    private boolean shouldGenerateWithDefaults = false;

    public SchemaExtractionProcessor(String tenantId, Configuration conf, String pSchemaName, String pTableName) throws SQLException {
        this.tenantId = tenantId;
        this.conf = conf;
        this.table = this.getPTable(pSchemaName, pTableName);
    }

    public SchemaExtractionProcessor(String tenantId, Configuration conf, PTable pTable, boolean shouldGenerateWithDefaults) throws SQLException {
        this.tenantId = tenantId;
        this.conf = conf;
        this.table = pTable;
        this.shouldGenerateWithDefaults = shouldGenerateWithDefaults;
    }

    @Override
    public String process() throws Exception {
        if (this.ddl != null) {
            return this.ddl;
        }
        if (this.table.getType().equals((Object)PTableType.TABLE)) {
            this.ddl = this.extractCreateTableDDL(this.table);
        } else if (this.table.getType().equals((Object)PTableType.INDEX)) {
            this.ddl = this.extractCreateIndexDDL(this.table);
        } else if (this.table.getType().equals((Object)PTableType.VIEW)) {
            this.ddl = this.extractCreateViewDDL(this.table);
        }
        return this.ddl;
    }

    protected String extractCreateIndexDDL(PTable indexPTable) throws SQLException, IOException {
        String quotedIndexTableName = SchemaUtil.getFullTableNameWithQuotes(null, indexPTable.getTableName().getString());
        String baseTableName = indexPTable.getParentTableName().getString();
        String baseTableFullName = indexPTable.getSchemaName().getString() + "." + baseTableName;
        PTable dataPTable = this.getPTable(baseTableFullName);
        String quotedBaseTableFullName = SchemaUtil.getFullTableNameWithQuotes(indexPTable.getSchemaName().getString(), baseTableName);
        String defaultCF = SchemaUtil.getEmptyColumnFamilyAsString(indexPTable);
        String indexedColumnsString = this.getIndexedColumnsString(indexPTable, dataPTable, defaultCF);
        String coveredColumnsString = this.getCoveredColumnsString(indexPTable, defaultCF);
        if (this.shouldGenerateWithDefaults) {
            this.populateDefaultProperties(indexPTable);
            this.setPTableProperties(indexPTable);
            ConnectionQueryServices cqsi = this.getCQSIObject();
            TableDescriptor htd = this.getTableDescriptor(cqsi, this.table);
            this.setHTableProperties(htd);
        }
        String propertiesString = this.convertPropertiesToString(true);
        return this.generateIndexDDLString(quotedBaseTableFullName, indexedColumnsString, coveredColumnsString, indexPTable.getIndexType().equals((Object)PTable.IndexType.LOCAL), quotedIndexTableName, propertiesString);
    }

    private String getIndexedColumnsString(PTable indexPTable, PTable dataPTable, String defaultCF) {
        List<PColumn> indexPK = indexPTable.getPKColumns();
        List<PColumn> dataPK = dataPTable.getPKColumns();
        ArrayList<String> indexPKName = new ArrayList<String>();
        ArrayList<String> dataPKName = new ArrayList<String>();
        HashMap<String, SortOrder> indexSortOrderMap = new HashMap<String, SortOrder>();
        StringBuilder indexedColumnsBuilder = new StringBuilder();
        for (PColumn indexedColumn : indexPK) {
            String indexColumn = this.extractIndexColumn(indexedColumn.getExpressionStr(), defaultCF);
            if (indexColumn == null) continue;
            indexPKName.add(indexColumn);
            indexSortOrderMap.put(indexColumn, indexedColumn.getSortOrder());
        }
        for (PColumn pColumn : dataPK) {
            dataPKName.add(pColumn.getName().getString());
        }
        String tenantIdColumn = (String)dataPKName.get(0);
        if (dataPTable.isMultiTenant() && indexPKName.contains(tenantIdColumn)) {
            indexPKName.remove(tenantIdColumn);
        }
        for (String column : indexPKName) {
            if (indexedColumnsBuilder.length() != 0) {
                indexedColumnsBuilder.append(", ");
            }
            indexedColumnsBuilder.append(column);
            if (!indexSortOrderMap.containsKey(column) || indexSortOrderMap.get(column) == SortOrder.getDefault()) continue;
            indexedColumnsBuilder.append(" ");
            indexedColumnsBuilder.append(indexSortOrderMap.get(column));
        }
        return indexedColumnsBuilder.toString();
    }

    private List<PColumn> getSymmetricDifferencePColumns(List<PColumn> firstList, List<PColumn> secondList) {
        ArrayList<PColumn> effectivePK = new ArrayList<PColumn>();
        for (PColumn column : firstList) {
            if (secondList.contains(column)) continue;
            effectivePK.add(column);
        }
        for (PColumn column : secondList) {
            if (firstList.contains(column)) continue;
            effectivePK.add(column);
        }
        return effectivePK;
    }

    private String extractIndexColumn(String columnName, String defaultCF) {
        if (columnName == null) {
            return null;
        }
        String[] columnNameSplit = columnName.split(":");
        if (columnNameSplit[0].equals("") || columnNameSplit[0].equalsIgnoreCase(defaultCF) || defaultCF.startsWith("L#") && columnNameSplit[0].equalsIgnoreCase(defaultCF.substring(2))) {
            return this.formatColumnOrExpression(columnNameSplit[1]);
        }
        if (columnNameSplit.length > 1) {
            String schema = SchemaUtil.formatSchemaName(columnNameSplit[0]);
            String name = SchemaUtil.formatColumnName(columnNameSplit[1]);
            return String.format("%s.%s", schema, name);
        }
        return this.formatColumnOrExpression(columnNameSplit[0]);
    }

    private String formatColumnOrExpression(String columnOrExpression) {
        if (columnOrExpression.startsWith("(")) {
            return columnOrExpression.substring(1, columnOrExpression.length() - 1);
        }
        if (columnOrExpression.contains("(")) {
            return columnOrExpression;
        }
        return SchemaUtil.formatIndexColumnName(columnOrExpression);
    }

    private String getCoveredColumnsString(PTable indexPTable, String defaultCF) {
        StringBuilder coveredColumnsBuilder = new StringBuilder();
        List<PColumn> pkColumns = indexPTable.getColumns();
        for (PColumn cc : pkColumns) {
            String indexColumn;
            if (coveredColumnsBuilder.length() != 0) {
                coveredColumnsBuilder.append(", ");
            }
            if (cc.getFamilyName() == null || (indexColumn = this.extractIndexColumn(cc.getName().getString(), defaultCF)) == null) continue;
            coveredColumnsBuilder.append(indexColumn);
        }
        return coveredColumnsBuilder.toString();
    }

    protected String generateIndexDDLString(String quotedBaseTableFullName, String indexedColumnString, String coveredColumnString, boolean local, String quotedIndexTableName, String properties) {
        StringBuilder outputBuilder = new StringBuilder(String.format(CREATE_INDEX, local ? "LOCAL " : "", quotedIndexTableName, quotedBaseTableFullName));
        outputBuilder.append("(");
        outputBuilder.append(indexedColumnString);
        outputBuilder.append(")");
        if (!coveredColumnString.equals("")) {
            outputBuilder.append(" INCLUDE (");
            outputBuilder.append(coveredColumnString);
            outputBuilder.append(")");
        }
        outputBuilder.append(properties);
        return outputBuilder.toString();
    }

    PTable getPTable(String pTableFullName) throws SQLException {
        try (Connection conn = this.getConnection();){
            PTable pTable = conn.unwrap(PhoenixConnection.class).getTable(pTableFullName);
            return pTable;
        }
    }

    protected String extractCreateViewDDL(PTable table) throws SQLException {
        String pSchemaName = table.getSchemaName().getString();
        String pTableName = table.getTableName().getString();
        String baseTableName = table.getParentTableName().getString();
        String quotedBaseTableName = SchemaUtil.getFullTableNameWithQuotes(pSchemaName, baseTableName);
        String baseTableFullName = pSchemaName + "." + baseTableName;
        PTable baseTable = this.getPTable(baseTableFullName);
        String columnInfoString = this.getColumnInfoStringForView(table, baseTable);
        String whereClause = table.getViewStatement();
        if (whereClause != null) {
            whereClause = whereClause.substring(whereClause.indexOf("WHERE"));
        }
        return this.generateCreateViewDDL(columnInfoString, quotedBaseTableName, (String)(whereClause == null ? "" : " " + whereClause), pSchemaName, pTableName);
    }

    private String generateCreateViewDDL(String columnInfoString, String quotedBaseTableName, String whereClause, String pSchemaName, String pTableName) {
        String quotedViewFullName = SchemaUtil.getFullTableNameWithQuotes(pSchemaName, pTableName);
        StringBuilder outputBuilder = new StringBuilder(String.format(CREATE_VIEW, quotedViewFullName, columnInfoString, quotedBaseTableName, whereClause));
        return outputBuilder.toString();
    }

    public String extractCreateTableDDL(PTable table) throws IOException, SQLException {
        String pSchemaName = table.getSchemaName().getString();
        String pTableName = table.getTableName().getString();
        ConnectionQueryServices cqsi = this.getCQSIObject();
        TableDescriptor htd = this.getTableDescriptor(cqsi, table);
        ColumnFamilyDescriptor[] hcds = htd.getColumnFamilies();
        this.populateDefaultProperties(table);
        this.setPTableProperties(table);
        this.setHTableProperties(htd);
        this.setHColumnFamilyProperties(hcds);
        String columnInfoString = this.getColumnInfoStringForTable(table);
        String propertiesString = this.convertPropertiesToString(false);
        String columnQualifierString = this.convertColumnQualifierCountersToString(table);
        return this.generateTableDDLString(columnInfoString, propertiesString, columnQualifierString, pSchemaName, pTableName);
    }

    private String generateTableDDLString(String columnInfoString, String propertiesString, String columnQualifierString, String pSchemaName, String pTableName) {
        String quotedTableFullName = SchemaUtil.getFullTableNameWithQuotes(pSchemaName, pTableName);
        StringBuilder outputBuilder = new StringBuilder(String.format(CREATE_TABLE, quotedTableFullName));
        outputBuilder.append(columnInfoString).append(" ").append(propertiesString).append(columnQualifierString);
        return outputBuilder.toString();
    }

    private void populateDefaultProperties(PTable table) {
        Map propsMap = ColumnFamilyDescriptorBuilder.getDefaultValues();
        for (Map.Entry entry : propsMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.defaultProps.put(key, value);
            if (key.equalsIgnoreCase("BLOOMFILTER")) {
                this.defaultProps.put(key, "ROW");
            }
            if (key.equalsIgnoreCase("COMPRESSION")) {
                this.defaultProps.put(key, "NONE");
            }
            if (!key.equalsIgnoreCase("DATA_BLOCK_ENCODING")) continue;
            this.defaultProps.put(key, String.valueOf(SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING));
        }
        this.defaultProps.putAll(table.getDefaultPropertyValues());
    }

    private void setHTableProperties(TableDescriptor htd) {
        Map propsMap = htd.getValues();
        for (Map.Entry entry : propsMap.entrySet()) {
            Bytes key = (Bytes)entry.getKey();
            Bytes value = (Bytes)entry.getValue();
            if (Bytes.toString((byte[])key.get()).contains("coprocessor") || Bytes.toString((byte[])key.get()).contains("IS_META")) continue;
            this.defaultProps.put(Bytes.toString((byte[])key.get()), "false");
            this.definedProps.put(Bytes.toString((byte[])key.get()), Bytes.toString((byte[])value.get()));
        }
    }

    private void setHColumnFamilyProperties(ColumnFamilyDescriptor[] columnDescriptors) {
        Map propsMap = columnDescriptors[0].getValues();
        for (Map.Entry entry : propsMap.entrySet()) {
            Bytes key = (Bytes)entry.getKey();
            Bytes globalValue = (Bytes)entry.getValue();
            HashMap<String, String> cfToPropertyValueMap = new HashMap<String, String>();
            HashSet<Bytes> cfPropertyValueSet = new HashSet<Bytes>();
            for (ColumnFamilyDescriptor columnDescriptor : columnDescriptors) {
                String columnFamilyName = Bytes.toString((byte[])columnDescriptor.getName());
                Bytes value = (Bytes)columnDescriptor.getValues().get(key);
                if (MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES.contains(Bytes.toString((byte[])key.get()))) {
                    this.definedProps.put(Bytes.toString((byte[])key.get()), Bytes.toString((byte[])value.get()));
                    break;
                }
                cfToPropertyValueMap.put(columnFamilyName, Bytes.toString((byte[])value.get()));
                cfPropertyValueSet.add(value);
            }
            if (cfPropertyValueSet.size() > 1) {
                for (Map.Entry entry2 : cfToPropertyValueMap.entrySet()) {
                    this.definedProps.put(String.format("%s.%s", entry2.getKey(), Bytes.toString((byte[])key.get())), (String)entry2.getValue());
                }
                continue;
            }
            this.definedProps.put(Bytes.toString((byte[])key.get()), Bytes.toString((byte[])globalValue.get()));
        }
    }

    private void setPTableProperties(PTable table) {
        Map<String, String> map = table.getPropertyValues();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            if (!key.equalsIgnoreCase("TTL")) {
                this.definedProps.put(key, value);
                continue;
            }
            TTLExpression ttlExpression = MetaDataUtil.convertForeverAndNoneTTLValue(value, false);
            if (!(ttlExpression instanceof LiteralTTLExpression)) continue;
            this.definedProps.put(key, value);
        }
    }

    private TableDescriptor getTableDescriptor(ConnectionQueryServices cqsi, PTable table) throws SQLException, IOException {
        try (Admin admin = cqsi.getAdmin();){
            TableDescriptor tableDescriptor = admin.getDescriptor(TableName.valueOf((String)table.getPhysicalName().getString()));
            return tableDescriptor;
        }
    }

    private String convertColumnQualifierCountersToString(PTable table) {
        StringBuilder cqBuilder = new StringBuilder();
        if (this.shouldGenerateWithDefaults) {
            return cqBuilder.toString();
        }
        Map<String, Integer> cqCounterValues = table.getEncodedCQCounter().values();
        ArrayList<CallSite> cqCounters = new ArrayList<CallSite>(cqCounterValues.size());
        for (Map.Entry<String, Integer> entry : cqCounterValues.entrySet()) {
            Boolean include = table.getColumns().stream().filter(c -> !table.getPKColumns().contains(c)).filter(pColumn -> table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? pColumn.getFamilyName().getString().equalsIgnoreCase((String)entry.getKey()) : true).map(o -> table.getEncodingScheme().decode(o.getColumnQualifierBytes())).max(Integer::compare).map(maxCounter -> maxCounter != (Integer)entry.getValue() - 1).orElse(false);
            if (!include.booleanValue()) continue;
            String def = "'" + entry.getKey() + "'=" + entry.getValue().toString();
            cqCounters.add((CallSite)((Object)def));
        }
        if (cqCounters.size() > 0) {
            cqBuilder.append(" COLUMN_QUALIFIER_COUNTER");
            cqBuilder.append(" (");
            cqBuilder.append(StringUtils.join((CharSequence)", ", cqCounters));
            cqBuilder.append(')');
        }
        return cqBuilder.toString();
    }

    private String convertPropertiesToString(boolean forIndex) {
        StringBuilder optionBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.definedProps.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String columnFamilyName = "0";
            String[] colPropKey = ((String)key).split("\\.");
            if (QUOTE_PROPERTIES.contains(key)) {
                key = "\"" + (String)key + "\"";
            } else if (colPropKey.length > 1) {
                columnFamilyName = colPropKey[0];
                key = colPropKey[1];
            }
            if (value == null || !this.shouldGenerateWithDefaults && (this.defaultProps.get(key) == null || ((String)value).equals(this.defaultProps.get(key))) || forIndex && ((String)key).equals("UPDATE_CACHE_FREQUENCY") || ((String)key).contains("TTL") && this.definedProps.containsKey("TRANSACTION_PROVIDER") && this.definedProps.get("TRANSACTION_PROVIDER").equalsIgnoreCase("OMID")) continue;
            if (optionBuilder.length() != 0) {
                optionBuilder.append(", ");
            }
            Object object = key = columnFamilyName.equals("0") ? key : String.format("\"%s\".%s", columnFamilyName, key);
            if (!(NumberUtils.isNumber((String)value) || ((String)value).equalsIgnoreCase(Boolean.TRUE.toString()) || ((String)value).equalsIgnoreCase(Boolean.FALSE.toString()))) {
                value = "'" + (String)value + "'";
            }
            optionBuilder.append((String)key + "=" + (String)value);
        }
        return optionBuilder.toString();
    }

    private PTable getPTable(String pSchemaName, String pTableName) throws SQLException {
        String pTableFullName = SchemaUtil.getQualifiedTableName(pSchemaName, pTableName);
        return this.getPTable(pTableFullName);
    }

    private ConnectionQueryServices getCQSIObject() throws SQLException {
        try (Connection conn = this.getConnection();){
            ConnectionQueryServices connectionQueryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            return connectionQueryServices;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.tenantId != null) {
            this.conf.set("TenantId", this.tenantId);
        }
        return ConnectionUtil.getInputConnection(this.conf);
    }

    private String getColumnInfoStringForTable(PTable table) {
        StringBuilder colInfo = new StringBuilder();
        List<PColumn> columns = table.getBucketNum() == null ? table.getColumns() : table.getColumns().subList(1, table.getColumns().size());
        List<PColumn> pkColumns = table.getBucketNum() == null ? table.getPKColumns() : table.getPKColumns().subList(1, table.getPKColumns().size());
        return this.getColumnInfoString(table, colInfo, columns, pkColumns);
    }

    private boolean hasEncodedQualifier(PTable table) {
        return table.getColumns().size() > 0 && !this.shouldGenerateWithDefaults && table.getType() == PTableType.TABLE && table.getEncodingScheme() != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
    }

    private boolean areEncodedIdsComplete(List<Integer> encodedIds, Integer initialID, Integer lastEncodedID) {
        if (encodedIds.size() == 0) {
            return true;
        }
        if (encodedIds.get(0) > initialID || encodedIds.get(encodedIds.size() - 1) < lastEncodedID) {
            return false;
        }
        for (int i = 1; i < encodedIds.size(); ++i) {
            if (encodedIds.get(i - 1) + 1 == encodedIds.get(i)) continue;
            return false;
        }
        return true;
    }

    private List<String> getNonConsecutiveQualifierFamilies(PTable table) {
        List<String> ret = new ArrayList<String>();
        if (!this.hasEncodedQualifier(table)) {
            return ret;
        }
        PTable.QualifierEncodingScheme scheme = table.getEncodingScheme();
        PTable.EncodedCQCounter encodedCQCounter = table.getEncodedCQCounter();
        if (table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
            for (PColumnFamily colFamily : table.getColumnFamilies()) {
                String colFamilyName = colFamily.getName().getString();
                List<Integer> encodedIds = colFamily.getColumns().stream().filter(c -> !table.getPKColumns().contains(c)).map(pColumn -> scheme.decode(pColumn.getColumnQualifierBytes())).collect(Collectors.toList());
                Collections.sort(encodedIds);
                if (this.areEncodedIdsComplete(encodedIds, 11, encodedCQCounter.getNextQualifier(colFamilyName) - 1)) continue;
                ret.add(colFamilyName);
            }
        } else {
            String defaultFamilyName;
            List<Integer> encodedIds = table.getColumns().stream().filter(c -> !table.getPKColumns().contains(c)).map(pColumn -> scheme.decode(pColumn.getColumnQualifierBytes())).collect(Collectors.toList());
            Collections.sort(encodedIds);
            String string = defaultFamilyName = table.getDefaultFamilyName() == null ? "0" : table.getDefaultFamilyName().getString();
            if (!this.areEncodedIdsComplete(encodedIds, 11, encodedCQCounter.getNextQualifier(defaultFamilyName) - 1)) {
                ret = table.getColumnFamilies().stream().map(pColumnFamily -> pColumnFamily.getName().getString()).collect(Collectors.toList());
            }
        }
        return ret;
    }

    private String getColumnInfoString(PTable table, StringBuilder colInfo, List<PColumn> columns, List<PColumn> pkColumns) {
        List<String> nonConsecutiveCounterFamilies = this.getNonConsecutiveQualifierFamilies(table);
        ArrayList<String> colDefs = new ArrayList<String>(columns.size());
        for (PColumn col : columns) {
            Object def = this.extractColumn(col);
            if (pkColumns.size() == 1 && pkColumns.contains(col)) {
                def = (String)def + " PRIMARY KEY" + this.extractPKColumnAttributes(col);
            }
            if (!pkColumns.contains(col) && nonConsecutiveCounterFamilies.contains(col.getFamilyName().getString())) {
                def = (String)def + " ENCODED_QUALIFIER " + table.getEncodingScheme().decode(col.getColumnQualifierBytes());
            }
            colDefs.add((String)def);
        }
        if (colDefs.size() > 0) {
            colInfo.append('(');
            colInfo.append(StringUtils.join((CharSequence)", ", colDefs));
        }
        if (pkColumns.size() > 1) {
            String pkConstraint = String.format(" CONSTRAINT %s PRIMARY KEY (%s)", table.getPKName().getString(), this.extractPKConstraint(pkColumns));
            colInfo.append(pkConstraint);
        }
        if (colDefs.size() > 0) {
            colInfo.append(')');
        }
        return colInfo.toString();
    }

    private String getColumnInfoStringForView(PTable table, PTable baseTable) {
        StringBuilder colInfo = new StringBuilder();
        List<PColumn> columns = table.getColumns();
        List<PColumn> pkColumns = table.getPKColumns();
        List<PColumn> baseColumns = baseTable.getColumns();
        List<PColumn> basePkColumns = baseTable.getPKColumns();
        columns = this.getSymmetricDifferencePColumns(baseColumns, columns);
        pkColumns = this.getSymmetricDifferencePColumns(basePkColumns, pkColumns);
        return this.getColumnInfoString(table, colInfo, columns, pkColumns);
    }

    private String extractColumn(PColumn column) {
        String colName = SchemaUtil.formatColumnName(column.getName().getString());
        if (column.getFamilyName() != null) {
            String colFamilyName = SchemaUtil.formatSchemaName(column.getFamilyName().getString());
            colName = colFamilyName.equals("0") ? colName : String.format("%s.%s", colFamilyName, colName);
        }
        boolean isArrayType = column.getDataType().isArrayType();
        String type = column.getDataType().getSqlTypeName();
        Integer maxLength = column.getMaxLength();
        Integer arrSize = column.getArraySize();
        Integer scale = column.getScale();
        StringBuilder buf = new StringBuilder(colName);
        buf.append(' ');
        if (isArrayType) {
            String arrayPrefix = type.split("\\s+")[0];
            buf.append(arrayPrefix);
            this.appendMaxLengthAndScale(buf, maxLength, scale);
            buf.append(' ');
            buf.append("ARRAY");
            if (arrSize != null) {
                buf.append('[');
                buf.append(arrSize);
                buf.append(']');
            }
        } else {
            buf.append(type);
            this.appendMaxLengthAndScale(buf, maxLength, scale);
        }
        if (!column.isNullable()) {
            buf.append(' ');
            buf.append("NOT NULL");
        }
        return buf.toString();
    }

    private void appendMaxLengthAndScale(StringBuilder buf, Integer maxLength, Integer scale) {
        if (maxLength != null) {
            buf.append('(');
            buf.append(maxLength);
            if (scale != null) {
                buf.append(',');
                buf.append(scale);
            }
            buf.append(')');
        }
    }

    private String extractPKColumnAttributes(PColumn column) {
        StringBuilder buf = new StringBuilder();
        if (column.getSortOrder() != SortOrder.getDefault()) {
            buf.append(' ');
            buf.append(column.getSortOrder().toString());
        }
        if (column.isRowTimestamp()) {
            buf.append(' ');
            buf.append("ROW_TIMESTAMP");
        }
        return buf.toString();
    }

    private String extractPKConstraint(List<PColumn> pkColumns) {
        ArrayList<CallSite> colDefs = new ArrayList<CallSite>(pkColumns.size());
        for (PColumn pkCol : pkColumns) {
            colDefs.add((CallSite)((Object)(SchemaUtil.formatColumnName(pkCol.getName().getString()) + this.extractPKColumnAttributes(pkCol))));
        }
        return StringUtils.join((CharSequence)", ", colDefs);
    }
}

