/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.task;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessor.generated.TaskMetaDataProtos;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Not possible to avoid")
public class Task {
    public static final Logger LOGGER = LoggerFactory.getLogger(Task.class);

    protected static List<Mutation> executeStatementAndGetTaskMutations(PhoenixConnection conn, PreparedStatement stmt) throws SQLException {
        stmt.execute();
        Iterator<Pair<byte[], List<Mutation>>> iterator = conn.getMutationState().toMutations();
        return (List)iterator.next().getSecond();
    }

    protected static PreparedStatement setValuesToAddTaskPS(PreparedStatement stmt, PTable.TaskType taskType, String tenantId, String schemaName, String tableName, String taskStatus, String data, Integer priority, Timestamp startTs, Timestamp endTs) throws SQLException {
        stmt.setByte(1, taskType.getSerializedValue());
        if (tenantId != null) {
            stmt.setString(2, tenantId);
        } else {
            stmt.setNull(2, 12);
        }
        if (schemaName != null) {
            stmt.setString(3, schemaName);
        } else {
            stmt.setNull(3, 12);
        }
        stmt.setString(4, tableName);
        if (taskStatus != null) {
            stmt.setString(5, taskStatus);
        } else {
            stmt.setString(5, PTable.TaskStatus.CREATED.toString());
        }
        if (priority != null) {
            stmt.setInt(6, priority);
        } else {
            int defaultPri = 4;
            stmt.setInt(6, defaultPri);
        }
        if (startTs == null) {
            startTs = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
        }
        stmt.setTimestamp(7, startTs);
        if (endTs != null) {
            stmt.setTimestamp(8, endTs);
        } else if (taskStatus != null && taskStatus.equals(PTable.TaskStatus.COMPLETED.toString())) {
            endTs = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            stmt.setTimestamp(8, endTs);
        } else {
            stmt.setNull(8, 93);
        }
        if (data != null) {
            stmt.setString(9, data);
        } else {
            stmt.setNull(9, 12);
        }
        return stmt;
    }

    protected static PreparedStatement addTaskAndGetStatement(SystemTaskParams systemTaskParams, PhoenixConnection connection) throws IOException {
        PreparedStatement stmt;
        try {
            stmt = connection.prepareStatement("UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " ( TASK_TYPE, TENANT_ID, TABLE_SCHEM, TABLE_NAME, TASK_STATUS, TASK_PRIORITY, TASK_TS, TASK_END_TS, TASK_DATA ) VALUES(?,?,?,?,?,?,?,?,?)");
            stmt = Task.setValuesToAddTaskPS(stmt, systemTaskParams.getTaskType(), systemTaskParams.getTenantId(), systemTaskParams.getSchemaName(), systemTaskParams.getTableName(), systemTaskParams.getTaskStatus(), systemTaskParams.getData(), systemTaskParams.getPriority(), systemTaskParams.getStartTs(), systemTaskParams.getEndTs());
            LOGGER.info("Adding task type: {} , tableName: {} , taskStatus: {} , startTs: {} , endTs: {}", new Object[]{systemTaskParams.getTaskType(), systemTaskParams.getTableName(), systemTaskParams.getTaskStatus(), systemTaskParams.getStartTs(), systemTaskParams.getEndTs()});
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return stmt;
    }

    public static List<Mutation> getMutationsForAddTask(SystemTaskParams systemTaskParams) throws IOException, SQLException {
        PhoenixConnection curConn = systemTaskParams.getConn();
        Configuration conf = curConn.getQueryServices().getConfiguration();
        try (PhoenixConnection newConnection = QueryUtil.getConnectionOnServer(curConn.getClientInfo(), conf).unwrap(PhoenixConnection.class);){
            List<Mutation> list;
            block12: {
                PreparedStatement statement = Task.addTaskAndGetStatement(systemTaskParams, newConnection);
                try {
                    list = Task.executeStatementAndGetTaskMutations(newConnection, statement);
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
    }

    public static MetaDataProtocol.MetaDataMutationResult taskMetaDataCoprocessorExec(PhoenixConnection connection, byte[] rowKey, Batch.Call<TaskMetaDataProtos.TaskMetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult;
        block10: {
            TableName tableName = SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME_BYTES, connection.getQueryServices().getProps());
            Table table = connection.getQueryServices().getTable(tableName.getName());
            try {
                Map results = table.coprocessorService(TaskMetaDataProtos.TaskMetaDataService.class, rowKey, rowKey, callable);
                assert (results.size() == 1);
                MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
                metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                if (table == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ClientUtil.parseServerException(e);
                }
                catch (Throwable t) {
                    throw new SQLException(t);
                }
            }
            table.close();
        }
        return metaDataMutationResult;
    }

    private static List<TaskRecord> populateTasks(Connection connection, String taskQuery) throws SQLException {
        ArrayList<TaskRecord> result = new ArrayList<TaskRecord>();
        try (PreparedStatement taskStatement = connection.prepareStatement(taskQuery);
             ResultSet rs = taskStatement.executeQuery();){
            while (rs.next()) {
                TaskRecord taskRecord = Task.parseResult(rs);
                result.add(taskRecord);
            }
        }
        return result;
    }

    public static List<TaskRecord> queryTaskTable(Connection connection, Timestamp ts, String schema, String tableName, PTable.TaskType taskType, String tenantId, String indexName) throws SQLException {
        String taskQuery = "SELECT TASK_TS, TENANT_ID, TABLE_SCHEM, TABLE_NAME, TASK_STATUS, TASK_TYPE, TASK_PRIORITY, TASK_DATA FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME;
        taskQuery = taskQuery + " WHERE TABLE_NAME ='" + tableName + "' AND TASK_TYPE=" + taskType.getSerializedValue();
        if (!Strings.isNullOrEmpty((String)tenantId)) {
            taskQuery = taskQuery + " AND TENANT_ID='" + tenantId + "' ";
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            taskQuery = taskQuery + " AND TABLE_SCHEM='" + schema + "' ";
        }
        if (!Strings.isNullOrEmpty((String)indexName)) {
            taskQuery = taskQuery + " AND TASK_DATA LIKE '%" + indexName + "%'";
        }
        List<TaskRecord> taskRecords = Task.populateTasks(connection, taskQuery);
        ArrayList<TaskRecord> result = new ArrayList();
        if (ts != null) {
            for (TaskRecord tr : taskRecords) {
                if (!tr.getTimeStamp().equals(ts)) continue;
                result.add(tr);
            }
        } else {
            result = taskRecords;
        }
        return result;
    }

    public static List<TaskRecord> queryTaskTable(Connection connection, String[] excludedTaskStatus) throws SQLException {
        String taskQuery = "SELECT TASK_TS, TENANT_ID, TABLE_SCHEM, TABLE_NAME, TASK_STATUS, TASK_TYPE, TASK_PRIORITY, TASK_DATA FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME;
        if (excludedTaskStatus != null && excludedTaskStatus.length > 0) {
            taskQuery = taskQuery + " WHERE TASK_STATUS IS NULL OR TASK_STATUS NOT IN (";
            CharSequence[] values = new String[excludedTaskStatus.length];
            for (int i = 0; i < excludedTaskStatus.length; ++i) {
                values[i] = String.format("'%s'", excludedTaskStatus[i].trim());
            }
            taskQuery = taskQuery + String.join((CharSequence)",", values);
            taskQuery = taskQuery + ")";
        }
        return Task.populateTasks(connection, taskQuery);
    }

    public static TaskRecord parseResult(ResultSet rs) throws SQLException {
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setTimeStamp(rs.getTimestamp("TASK_TS"));
        taskRecord.setTenantId(rs.getString("TENANT_ID"));
        taskRecord.setTenantIdBytes(rs.getBytes("TENANT_ID"));
        taskRecord.setSchemaName(rs.getString("TABLE_SCHEM"));
        taskRecord.setSchemaNameBytes(rs.getBytes("TABLE_SCHEM"));
        taskRecord.setTableName(rs.getString("TABLE_NAME"));
        taskRecord.setTableNameBytes(rs.getBytes("TABLE_NAME"));
        taskRecord.setStatus(rs.getString("TASK_STATUS"));
        taskRecord.setTaskType(PTable.TaskType.fromSerializedValue(rs.getByte("TASK_TYPE")));
        taskRecord.setPriority(rs.getInt("TASK_PRIORITY"));
        taskRecord.setData(rs.getString("TASK_DATA"));
        return taskRecord;
    }

    public static class TaskRecord {
        private String tenantId;
        private Timestamp timeStamp;
        private byte[] tenantIdBytes;
        private String schemaName = null;
        private byte[] schemaNameBytes;
        private String tableName = null;
        private byte[] tableNameBytes;
        private PTable.TaskType taskType;
        private String status;
        private int priority;
        private String data;

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public Timestamp getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(Timestamp timeStamp) {
            this.timeStamp = timeStamp;
        }

        public byte[] getTenantIdBytes() {
            return this.tenantIdBytes;
        }

        public void setTenantIdBytes(byte[] tenantIdBytes) {
            this.tenantIdBytes = tenantIdBytes;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public byte[] getSchemaNameBytes() {
            return this.schemaNameBytes;
        }

        public void setSchemaNameBytes(byte[] schemaNameBytes) {
            this.schemaNameBytes = schemaNameBytes;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public byte[] getTableNameBytes() {
            return this.tableNameBytes;
        }

        public void setTableNameBytes(byte[] tableNameBytes) {
            this.tableNameBytes = tableNameBytes;
        }

        public String getData() {
            if (this.data == null) {
                return "";
            }
            return this.data;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public PTable.TaskType getTaskType() {
            return this.taskType;
        }

        public void setTaskType(PTable.TaskType taskType) {
            this.taskType = taskType;
        }

        public boolean isMatchingTask(SystemTransformRecord transformRecord) {
            if (this.getTaskType() != PTable.TaskType.TRANSFORM_MONITOR) {
                return false;
            }
            return StringUtils.equals((CharSequence)transformRecord.getLogicalTableName(), (CharSequence)this.getTableName()) && StringUtils.equals((CharSequence)transformRecord.getTenantId(), (CharSequence)this.getTenantId()) && StringUtils.equals((CharSequence)transformRecord.getSchemaName(), (CharSequence)this.getSchemaName());
        }
    }
}

