/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.IOException;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.ConditionalTTLExpression;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.TTLExpression;

public class TTLExpressionFactory {
    public static TTLExpression create(String ttlExpr) {
        if ("NONE".equalsIgnoreCase(ttlExpr)) {
            return LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
        }
        if ("FOREVER".equalsIgnoreCase(ttlExpr)) {
            return LiteralTTLExpression.TTL_EXPRESSION_FOREVER;
        }
        try {
            int ttlValue = Integer.parseInt(ttlExpr);
            return TTLExpressionFactory.create(ttlValue);
        }
        catch (NumberFormatException e) {
            return new ConditionalTTLExpression(ttlExpr);
        }
    }

    public static LiteralTTLExpression create(int ttlValue) {
        if (ttlValue == 0) {
            return LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
        }
        if (ttlValue == Integer.MAX_VALUE) {
            return LiteralTTLExpression.TTL_EXPRESSION_FOREVER;
        }
        return new LiteralTTLExpression(ttlValue);
    }

    public static TTLExpression create(TTLExpression ttlExpr) {
        if (ttlExpr instanceof LiteralTTLExpression) {
            return new LiteralTTLExpression((LiteralTTLExpression)ttlExpr);
        }
        return new ConditionalTTLExpression((ConditionalTTLExpression)ttlExpr);
    }

    public static CompiledTTLExpression create(byte[] phoenixTTL) throws IOException {
        return TTLExpressionFactory.createFromProto(PTableProtos.TTLExpression.parseFrom(phoenixTTL));
    }

    public static CompiledTTLExpression createFromProto(PTableProtos.TTLExpression ttlExpressionProto) throws IOException {
        if (ttlExpressionProto.hasLiteral()) {
            return LiteralTTLExpression.createFromProto(ttlExpressionProto.getLiteral());
        }
        if (ttlExpressionProto.hasCondition()) {
            return CompiledConditionalTTLExpression.createFromProto(ttlExpressionProto.getCondition());
        }
        throw new RuntimeException("Unxexpected! Shouldn't reach here");
    }
}

