/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataCache;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableRefFactory;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TimeKeeper;

public class PMetaDataImpl
implements PMetaData {
    private PMetaDataCache metaData;
    private final TimeKeeper timeKeeper;
    private final PTableRefFactory tableRefFactory;
    private final long updateCacheFrequency;
    private HashMap<String, PTableKey> physicalNameToLogicalTableMap = new HashMap();

    public PMetaDataImpl(int initialCapacity, long updateCacheFrequency, ReadOnlyProps props) {
        this(initialCapacity, updateCacheFrequency, TimeKeeper.SYSTEM, props);
    }

    public PMetaDataImpl(int initialCapacity, long updateCacheFrequency, TimeKeeper timeKeeper, ReadOnlyProps props) {
        this(new PMetaDataCache(initialCapacity, props.getLong("phoenix.client.maxMetaDataCacheSize", 0xA00000L), timeKeeper), timeKeeper, PTableRefFactory.getFactory(props), updateCacheFrequency);
    }

    private PMetaDataImpl(PMetaDataCache metaData, TimeKeeper timeKeeper, PTableRefFactory tableRefFactory, long updateCacheFrequency) {
        this.timeKeeper = timeKeeper;
        this.metaData = metaData;
        this.tableRefFactory = tableRefFactory;
        this.updateCacheFrequency = updateCacheFrequency;
    }

    private void updateGlobalMetric(PTableRef pTableRef) {
        if (pTableRef != null && pTableRef.getTable() != null) {
            GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_HIT_COUNTER.increment();
        } else {
            GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_MISS_COUNTER.increment();
        }
    }

    @Override
    public PTableRef getTableRef(PTableKey key) throws TableNotFoundException {
        if (this.physicalNameToLogicalTableMap.containsKey(key.getName())) {
            key = this.physicalNameToLogicalTableMap.get(key.getName());
        }
        PTableRef ref = this.metaData.get(key);
        if (!key.getName().contains("SYSTEM")) {
            this.updateGlobalMetric(ref);
        }
        if (ref == null) {
            throw new TableNotFoundException(key.getName());
        }
        return ref;
    }

    @Override
    public PFunction getFunction(PTableKey key) throws FunctionNotFoundException {
        PFunction function = this.metaData.functions.get(key);
        if (function == null) {
            throw new FunctionNotFoundException(key.getName());
        }
        return function;
    }

    @Override
    public int size() {
        return (int)this.metaData.size();
    }

    private boolean useMetaDataCache(PTable table) {
        return table.getType() == PTableType.SYSTEM || table.getUpdateCacheFrequency() != 0L || this.updateCacheFrequency != 0L;
    }

    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTimestamp) throws SQLException {
        this.metaData.put(table.getKey(), this.tableRefFactory.makePTableRef(table, this.timeKeeper.getCurrentTime(), resolvedTimestamp));
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(table.getEstimatedSize());
    }

    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        PTableRef tableRef = this.tableRefFactory.makePTableRef(table, this.timeKeeper.getCurrentTime(), resolvedTime);
        PTableKey key = table.getKey();
        PTable newParentTable = null;
        PTableRef newParentTableRef = null;
        long parentResolvedTimestamp = resolvedTime;
        if (table.getType() == PTableType.INDEX) {
            String parentName = table.getParentName().getString();
            PTableRef oldParentRef = this.metaData.get(new PTableKey(table.getTenantId(), parentName));
            if (oldParentRef != null) {
                List<PTable> oldIndexes = oldParentRef.getTable().getIndexes();
                ArrayList newIndexes = Lists.newArrayListWithExpectedSize((int)(oldIndexes.size() + 1));
                newIndexes.addAll(oldIndexes);
                for (int i = 0; i < newIndexes.size(); ++i) {
                    PTable index = (PTable)newIndexes.get(i);
                    if (!index.getName().equals(table.getName())) continue;
                    newIndexes.remove(i);
                    break;
                }
                newIndexes.add(table);
                newParentTable = PTableImpl.builderWithColumns(oldParentRef.getTable(), PTableImpl.getColumnsToClone(oldParentRef.getTable())).setIndexes(newIndexes).setTimeStamp(table.getTimeStamp()).build();
                newParentTableRef = this.tableRefFactory.makePTableRef(newParentTable, this.timeKeeper.getCurrentTime(), parentResolvedTimestamp);
            }
        }
        if (newParentTable != null) {
            this.metaData.put(newParentTable.getKey(), newParentTableRef);
            GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
            GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(newParentTable.getEstimatedSize());
        }
        this.metaData.put(table.getKey(), tableRef);
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(table.getEstimatedSize());
        for (PTable index : table.getIndexes()) {
            this.metaData.put(index.getKey(), this.tableRefFactory.makePTableRef(index, this.timeKeeper.getCurrentTime(), resolvedTime));
            GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
            GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(index.getEstimatedSize());
        }
        if (table.getPhysicalName(true) != null && !Strings.isNullOrEmpty((String)table.getPhysicalName(true).getString()) && !table.getPhysicalName(true).getString().equals(table.getTableName().getString())) {
            String physicalTableName = table.getPhysicalName(true).getString().replace(":", ".");
            String physicalTableFullName = SchemaUtil.getTableName(table.getSchemaName() != null ? table.getSchemaName().getString() : null, physicalTableName);
            this.physicalNameToLogicalTableMap.put(physicalTableFullName, key);
        }
    }

    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        List<PTable> oldIndexes;
        PTableRef parentTableRef = null;
        PTableKey key = new PTableKey(tenantId, tableName);
        if (this.metaData.get(key) == null) {
            if (parentTableName != null) {
                parentTableRef = this.metaData.get(new PTableKey(tenantId, parentTableName));
            }
            if (parentTableRef == null) {
                return;
            }
        } else {
            PTable table = this.metaData.remove(key);
            for (PTable index : table.getIndexes()) {
                this.metaData.remove(index.getKey());
            }
            if (table.getParentName() != null) {
                parentTableRef = this.metaData.get(new PTableKey(tenantId, table.getParentName().getString()));
            }
        }
        if (parentTableRef != null && (oldIndexes = parentTableRef.getTable().getIndexes()) != null && !oldIndexes.isEmpty()) {
            ArrayList newIndexes = Lists.newArrayListWithExpectedSize((int)oldIndexes.size());
            newIndexes.addAll(oldIndexes);
            for (int i = 0; i < newIndexes.size(); ++i) {
                PTable index = (PTable)newIndexes.get(i);
                if (!index.getName().getString().equals(tableName)) continue;
                newIndexes.remove(i);
                PTableImpl.Builder parentTableBuilder = PTableImpl.builderWithColumns(parentTableRef.getTable(), PTableImpl.getColumnsToClone(parentTableRef.getTable())).setIndexes(newIndexes);
                if (tableTimeStamp != Long.MAX_VALUE) {
                    parentTableBuilder.setTimeStamp(tableTimeStamp);
                }
                PTableImpl parentTable = parentTableBuilder.build();
                this.metaData.put(parentTable.getKey(), this.tableRefFactory.makePTableRef(parentTable, this.timeKeeper.getCurrentTime(), parentTableRef.getResolvedTimeStamp()));
                GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
                GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(parentTable.getEstimatedSize());
                break;
            }
        }
    }

    @Override
    public void removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum, long resolvedTime) throws SQLException {
        PTableRef tableRef = this.metaData.get(new PTableKey(tenantId, tableName));
        if (tableRef == null) {
            return;
        }
        PTable table = tableRef.getTable();
        PMetaDataCache tables = this.metaData;
        for (PColumn columnToRemove : columnsToRemove) {
            String familyName = columnToRemove.getFamilyName().getString();
            PColumn column = familyName == null ? table.getPKColumn(columnToRemove.getName().getString()) : table.getColumnFamily(familyName).getPColumnForColumnName(columnToRemove.getName().getString());
            int positionOffset = 0;
            int position = column.getPosition();
            List<PColumn> oldColumns = table.getColumns();
            if (table.getBucketNum() != null) {
                --position;
                positionOffset = 1;
                oldColumns = oldColumns.subList(positionOffset, oldColumns.size());
            }
            ArrayList columns = Lists.newArrayListWithExpectedSize((int)(oldColumns.size() - 1));
            columns.addAll(oldColumns.subList(0, position));
            for (int i = position + 1; i < oldColumns.size(); ++i) {
                PColumn oldColumn = oldColumns.get(i);
                PColumnImpl newColumn = new PColumnImpl(oldColumn.getName(), oldColumn.getFamilyName(), oldColumn.getDataType(), oldColumn.getMaxLength(), oldColumn.getScale(), oldColumn.isNullable(), i - 1 + positionOffset, oldColumn.getSortOrder(), oldColumn.getArraySize(), oldColumn.getViewConstant(), oldColumn.isViewReferenced(), oldColumn.getExpressionStr(), oldColumn.isRowTimestamp(), oldColumn.isDynamic(), oldColumn.getColumnQualifierBytes(), oldColumn.getTimestamp());
                columns.add(newColumn);
            }
            table = PTableImpl.builderWithColumns(table, columns).setTimeStamp(tableTimeStamp).setSequenceNumber(tableSeqNum).build();
        }
        tables.put(table.getKey(), this.tableRefFactory.makePTableRef(table, this.timeKeeper.getCurrentTime(), resolvedTime));
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(table.getEstimatedSize());
    }

    @Override
    public void pruneTables(PMetaData.Pruner pruner) {
        ArrayList keysToPrune = Lists.newArrayListWithExpectedSize((int)this.size());
        for (PTable table : this) {
            if (!pruner.prune(table)) continue;
            keysToPrune.add(table.getKey());
        }
        if (!keysToPrune.isEmpty()) {
            for (PTableKey key : keysToPrune) {
                this.metaData.remove(key);
            }
        }
    }

    @Override
    public Iterator<PTable> iterator() {
        return this.metaData.iterator();
    }

    @Override
    public void addFunction(PFunction function) throws SQLException {
        this.metaData.functions.put(function.getKey(), function);
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(function.getEstimatedSize());
    }

    @Override
    public void removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        this.metaData.functions.remove(new PTableKey(tenantId, function));
    }

    @Override
    public void pruneFunctions(PMetaData.Pruner pruner) {
        ArrayList keysToPrune = Lists.newArrayListWithExpectedSize((int)this.size());
        for (PFunction function : this.metaData.functions.values()) {
            if (!pruner.prune(function)) continue;
            keysToPrune.add(function.getKey());
        }
        if (!keysToPrune.isEmpty()) {
            for (PTableKey key : keysToPrune) {
                this.metaData.functions.remove(key);
            }
        }
    }

    @Override
    public long getAge(PTableRef ref) {
        return this.metaData.getAge(ref);
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.metaData.schemas.put(schema.getSchemaKey(), schema);
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ADD_COUNTER.increment();
        GlobalClientMetrics.GLOBAL_CLIENT_METADATA_CACHE_ESTIMATED_USED_SIZE.update(schema.getEstimatedSize());
    }

    @Override
    public PSchema getSchema(PTableKey key) throws SchemaNotFoundException {
        PSchema schema = this.metaData.schemas.get(key);
        if (schema == null) {
            throw new SchemaNotFoundException(key.getName());
        }
        return schema;
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.metaData.schemas.remove(schema.getSchemaKey());
    }
}

