/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class LiteralTTLExpression
implements TTLExpression,
CompiledTTLExpression {
    private final int ttlValue;
    public static final LiteralTTLExpression TTL_EXPRESSION_FOREVER = new LiteralTTLExpression(Integer.MAX_VALUE);
    public static final LiteralTTLExpression TTL_EXPRESSION_NOT_DEFINED = new LiteralTTLExpression(0);
    public static final LiteralTTLExpression TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR = new LiteralTTLExpression(-1);

    public LiteralTTLExpression(int ttl) {
        Preconditions.checkArgument((ttl == -1 || ttl >= 0 ? 1 : 0) != 0);
        this.ttlValue = ttl;
    }

    public LiteralTTLExpression(LiteralTTLExpression ttlExpr) {
        this.ttlValue = ttlExpr.ttlValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralTTLExpression that = (LiteralTTLExpression)o;
        return this.ttlValue == that.ttlValue;
    }

    public int hashCode() {
        return Objects.hash(this.ttlValue);
    }

    @Override
    public String getTTLExpression() {
        return String.valueOf(this.ttlValue);
    }

    @Override
    public String toString() {
        return this.getTTLExpression();
    }

    @Override
    public long getRowTTLForMasking(List<Cell> result, boolean isRaw) {
        return this.getRowTTLForCompaction(result);
    }

    @Override
    public long getRowTTLForCompaction(List<Cell> result) {
        return this.ttlValue;
    }

    @Override
    public void validateTTLOnCreate(PhoenixConnection conn, CreateTableStatement create, PTable parent, Map<String, Object> tableProps) {
    }

    @Override
    public void validateTTLOnAlter(PhoenixConnection connection, PTable table) {
    }

    @Override
    public CompiledTTLExpression compileTTLExpression(PhoenixConnection connection, PTable table) {
        return this;
    }

    public static LiteralTTLExpression createFromProto(PTableProtos.LiteralTTL literal) {
        return new LiteralTTLExpression(literal.getTtlValue());
    }

    @Override
    public PTableProtos.TTLExpression toProto() throws SQLException {
        if (this.equals(TTL_EXPRESSION_NOT_DEFINED)) {
            return null;
        }
        PTableProtos.TTLExpression.Builder ttl = PTableProtos.TTLExpression.newBuilder();
        PTableProtos.LiteralTTL.Builder literal = PTableProtos.LiteralTTL.newBuilder();
        literal.setTtlValue(this.ttlValue);
        ttl.setLiteral(literal.build());
        return ttl.build();
    }

    public int getTTLValue() {
        return this.ttlValue;
    }
}

