/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.query.QueryServicesOptions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ConnectionProperty {
    UPDATE_CACHE_FREQUENCY{

        @Override
        public Object getValue(String value) {
            if (value == null) {
                return QueryServicesOptions.DEFAULT_UPDATE_CACHE_FREQUENCY;
            }
            if ("ALWAYS".equalsIgnoreCase(value)) {
                return 0L;
            }
            if ("NEVER".equalsIgnoreCase(value)) {
                return Long.MAX_VALUE;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Connection's phoenix.default.update.cache.frequency can only be set to 'ALWAYS', 'NEVER' or a millisecond numeric value.");
            }
        }
    };


    public Object getValue(String value) {
        return value;
    }
}

