/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalTTLExpression
implements TTLExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionalTTLExpression.class);
    private final String ttlExpr;

    public ConditionalTTLExpression(String ttlExpr) {
        this.ttlExpr = ttlExpr;
    }

    public ConditionalTTLExpression(ConditionalTTLExpression expr) {
        this.ttlExpr = expr.ttlExpr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalTTLExpression that = (ConditionalTTLExpression)o;
        return this.ttlExpr.equals(that.ttlExpr);
    }

    public int hashCode() {
        return Objects.hash(this.ttlExpr);
    }

    @Override
    public String getTTLExpression() {
        return this.ttlExpr;
    }

    @Override
    public String toString() {
        return this.getTTLExpression();
    }

    @Override
    public CompiledTTLExpression compileTTLExpression(PhoenixConnection connection, PTable table) throws SQLException {
        Pair<Expression, Set<ColumnReference>> exprAndCols = this.buildExpression(connection, table);
        return new CompiledConditionalTTLExpression(this.ttlExpr, (Expression)exprAndCols.getFirst(), (Set)exprAndCols.getSecond());
    }

    private Pair<Expression, Set<ColumnReference>> buildExpression(PhoenixConnection connection, PTable table) throws SQLException {
        return this.buildExpression(connection, table, null);
    }

    private Pair<Expression, Set<ColumnReference>> buildExpression(PhoenixConnection connection, PTable table, PTable parent) throws SQLException {
        ParseNode ttlCondition = this.parseExpression(connection, table, parent);
        ColumnResolver resolver = FromCompiler.getResolver(new TableRef(table));
        StatementContext context = new StatementContext(new PhoenixStatement(connection), resolver);
        WhereCompiler.WhereExpressionCompiler expressionCompiler = new WhereCompiler.WhereExpressionCompiler(context);
        Expression expr = ttlCondition.accept(expressionCompiler);
        if (expressionCompiler.isAggregate()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_EXPRESSION_NOT_ALLOWED_IN_CONDITIONAL_TTL).build().buildException();
        }
        HashSet exprCols = Sets.newHashSetWithExpectedSize((int)context.getWhereConditionColumns().size());
        for (Pair<byte[], byte[]> column : context.getWhereConditionColumns()) {
            exprCols.add(new ColumnReference((byte[])column.getFirst(), (byte[])column.getSecond()));
        }
        return new Pair((Object)expr, (Object)exprCols);
    }

    private ParseNode parseExpression(PhoenixConnection connection, PTable table, PTable parent) throws SQLException {
        ParseNode ttlCondition = SQLParser.parseCondition(this.ttlExpr);
        return table.getType() != PTableType.INDEX ? ttlCondition : this.rewriteForIndex(connection, table, parent, ttlCondition);
    }

    private ParseNode rewriteForIndex(PhoenixConnection connection, PTable index, PTable parent, ParseNode ttlCondition) throws SQLException {
        if (parent == null) {
            parent = this.getParent(connection, index);
        }
        ColumnResolver parentResolver = FromCompiler.getResolver(new TableRef(parent));
        return IndexStatementRewriter.translate(ttlCondition, parentResolver);
    }

    private PTable getParent(PhoenixConnection connection, PTable table) throws SQLException {
        return connection.getTable(table.getParentName().getString());
    }

    @Override
    public void validateTTLOnCreate(PhoenixConnection conn, CreateTableStatement create, PTable parent, Map<String, Object> tableProps) throws SQLException {
        PTable table = this.createTempPTable(conn, create, parent, tableProps);
        this.validateTTLExpression(conn, table, parent);
    }

    @Override
    public void validateTTLOnAlter(PhoenixConnection conn, PTable table) throws SQLException {
        this.validateTTLExpression(conn, table, null);
        for (PTable index : table.getIndexes()) {
            try {
                if (CDCUtil.isCDCIndex(index)) continue;
                this.buildExpression(conn, index, table);
            }
            catch (ColumnFamilyNotFoundException | ColumnNotFoundException e) {
                throw new SQLException(String.format("Conditional TTL expression %s not covered by index %s", this.ttlExpr, index.getTableName()), e);
            }
        }
    }

    private PTable createTempPTable(PhoenixConnection conn, CreateTableStatement createStmt, PTable parent, Map<String, Object> tableProps) throws SQLException {
        TableName tableNameNode = createStmt.getTableName();
        PName schemaName = PNameFactory.newName(tableNameNode.getSchemaName());
        PName tableName = PNameFactory.newName(tableNameNode.getTableName());
        PName fullName = SchemaUtil.getTableName(schemaName, tableName);
        PName tenantId = conn.getTenantId();
        PTableType tableType = createStmt.getTableType();
        String defaultFamily = parent != null ? (parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString()) : (String)TableProperty.DEFAULT_COLUMN_FAMILY.getValue(tableProps);
        ArrayList allCols = Lists.newArrayList();
        ArrayList pkCols = Lists.newArrayList();
        int pos = 0;
        for (ColumnDef colDef : createStmt.getColumnDefs()) {
            ColumnName columnDefName = colDef.getColumnDefName();
            String columnName = columnDefName.getColumnName();
            PName familyName = null;
            boolean isPK = SchemaUtil.isPKColumn(createStmt.getPrimaryKeyConstraint(), colDef);
            if (!isPK) {
                String family = columnDefName.getFamilyName();
                familyName = family != null ? PNameFactory.newName(family) : PNameFactory.newName(defaultFamily == null ? "0" : defaultFamily);
            }
            PColumnImpl pColumn = new PColumnImpl(PNameFactory.newName(columnName), familyName, colDef.getDataType(), colDef.getMaxLength(), colDef.getScale(), colDef.isNull(), pos++, colDef.getSortOrder(), colDef.getArraySize(), null, false, colDef.getExpression(), colDef.isRowTimestamp(), false, Bytes.toBytes((String)columnName), EnvironmentEdgeManager.currentTimeMillis());
            allCols.add(pColumn);
            if (!isPK) continue;
            pkCols.add(pColumn);
        }
        PTable table = new PTableImpl.Builder().setName(fullName).setKey(new PTableKey(tenantId, fullName.getString())).setTenantId(tenantId).setSchemaName(schemaName).setTableName(tableName).setParentSchemaName(parent == null ? null : parent.getSchemaName()).setParentTableName(parent == null ? null : parent.getTableName()).setPhysicalNames(Collections.EMPTY_LIST).setType(tableType).setImmutableStorageScheme(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN).setQualifierEncodingScheme(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS).setDefaultFamilyName(PNameFactory.newName(defaultFamily)).setColumns(allCols).setPkColumns(pkCols).setIndexes(Collections.EMPTY_LIST).build();
        if (parent != null && table.getType() == PTableType.VIEW) {
            table = ViewUtil.addDerivedColumnsFromParent(conn, table, parent);
        }
        return table;
    }

    private void validateTTLExpression(PhoenixConnection conn, PTable table, PTable parent) throws SQLException {
        if (table.getType() == PTableType.CDC) {
            return;
        }
        if (table.getColumnFamilies().size() > 1) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES).build().buildException();
        }
        try {
            Pair<Expression, Set<ColumnReference>> exprAndCols = this.buildExpression(conn, table, parent);
            Expression ttlExpression = (Expression)exprAndCols.getFirst();
            if (ttlExpression.getDataType() != PBoolean.INSTANCE) {
                throw TypeMismatchException.newException(PBoolean.INSTANCE, ttlExpression.getDataType(), ttlExpression.toString());
            }
        }
        catch (ColumnFamilyNotFoundException | ColumnNotFoundException e) {
            throw new SQLException(String.format("Conditional TTL expression %s refers columns not in %s", this.ttlExpr, table.getTableName()), e);
        }
    }
}

