/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledConditionalTTLExpression
implements CompiledTTLExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompiledConditionalTTLExpression.class);
    private final String ttlExpr;
    private final Expression compiledExpr;
    private final Set<ColumnReference> conditionExprColumns;
    List<Cell> latestRowVersion = new ArrayList<Cell>();
    List<Cell> deleteFamilyVersionCells = new ArrayList<Cell>();

    public CompiledConditionalTTLExpression(String ttlExpr, Expression compiledExpression, Set<ColumnReference> conditionExprColumns) {
        Preconditions.checkNotNull((Object)compiledExpression);
        Preconditions.checkNotNull(conditionExprColumns);
        this.ttlExpr = ttlExpr;
        this.compiledExpr = compiledExpression;
        this.conditionExprColumns = conditionExprColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompiledConditionalTTLExpression that = (CompiledConditionalTTLExpression)o;
        return this.ttlExpr.equals(that.ttlExpr);
    }

    public int hashCode() {
        return Objects.hash(this.ttlExpr);
    }

    @Override
    public String getTTLExpression() {
        return this.ttlExpr;
    }

    @Override
    public String toString() {
        return this.getTTLExpression();
    }

    @VisibleForTesting
    public List<Cell> getLatestRowVersion(List<Cell> result) {
        this.latestRowVersion.clear();
        this.deleteFamilyVersionCells.clear();
        Cell maxDeleteFamily = null;
        int index = 0;
        while (index < result.size()) {
            Cell cell = result.get(index);
            if (cell.getType() == Cell.Type.DeleteFamily) {
                maxDeleteFamily = cell;
                index = this.skipColumn(result, cell, index);
                continue;
            }
            if (cell.getType() == Cell.Type.DeleteFamilyVersion) {
                this.deleteFamilyVersionCells.add(cell);
                ++index;
                continue;
            }
            if (cell.getType() == Cell.Type.DeleteColumn) {
                index = this.skipColumn(result, cell, index);
                continue;
            }
            if (cell.getType() == Cell.Type.Delete) {
                ++index;
                continue;
            }
            if (cell.getType() != Cell.Type.Put) continue;
            if (this.deleteFamilyVersionCells.stream().anyMatch(deleteFamilyCell -> cell.getTimestamp() == deleteFamilyCell.getTimestamp())) {
                ++index;
                continue;
            }
            if (maxDeleteFamily != null && cell.getTimestamp() <= maxDeleteFamily.getTimestamp()) {
                index = this.skipColumn(result, cell, index);
                continue;
            }
            this.latestRowVersion.add(cell);
            index = this.skipColumn(result, cell, index);
        }
        return this.latestRowVersion;
    }

    private int skipColumn(List<Cell> result, Cell currentColumnCell, int index) {
        Cell cell;
        int next;
        for (next = index + 1; next < result.size() && CellUtil.matchingColumn((Cell)(cell = result.get(next)), (Cell)currentColumnCell); ++next) {
        }
        return next;
    }

    @Override
    public long getRowTTLForMasking(List<Cell> result, boolean isRaw) {
        return this.isExpired(result, isRaw) ? 0L : Integer.MAX_VALUE;
    }

    @Override
    public long getRowTTLForCompaction(List<Cell> result) {
        return Integer.MAX_VALUE;
    }

    public boolean isExpired(List<Cell> result, boolean isRaw) {
        List<Cell> latestRow;
        if (result.isEmpty()) {
            return false;
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        List<Cell> list = latestRow = !isRaw ? result : this.getLatestRowVersion(result);
        if (latestRow.isEmpty()) {
            return false;
        }
        MultiKeyValueTuple row = new MultiKeyValueTuple(latestRow);
        if (!this.compiledExpr.evaluate(row, ptr)) {
            LOGGER.info("Expression evaluation failed for expr {}", (Object)this.ttlExpr);
            return false;
        }
        Object value = PBoolean.INSTANCE.toObject(ptr);
        return Boolean.TRUE.equals(value);
    }

    public Set<ColumnReference> getColumnsReferenced() {
        return this.conditionExprColumns;
    }

    private static byte[] serializeExpression(Expression condTTLExpr) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(condTTLExpr).ordinal());
            condTTLExpr.write(output);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    private static Expression deSerializeExpression(byte[] serializedExpr) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(serializedExpr);){
            DataInputStream input = new DataInputStream(stream);
            int expressionOrdinal = WritableUtils.readVInt((DataInput)input);
            Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
            expression.readFields(input);
            Expression expression2 = expression;
            return expression2;
        }
    }

    public static CompiledConditionalTTLExpression createFromProto(PTableProtos.ConditionTTL condition) throws IOException {
        String ttlExpr = condition.getTtlExpression();
        Expression compiledExpression = CompiledConditionalTTLExpression.deSerializeExpression(condition.getCompiledExpression().toByteArray());
        List<ServerCachingProtos.ColumnReference> exprColumnsList = condition.getTtlExpressionColumnsList();
        HashSet<ColumnReference> conditionExprColumns = new HashSet<ColumnReference>(exprColumnsList.size());
        for (ServerCachingProtos.ColumnReference colRefFromProto : exprColumnsList) {
            conditionExprColumns.add(new ColumnReference(colRefFromProto.getFamily().toByteArray(), colRefFromProto.getQualifier().toByteArray()));
        }
        return new CompiledConditionalTTLExpression(ttlExpr, compiledExpression, conditionExprColumns);
    }

    @Override
    public PTableProtos.TTLExpression toProto() throws SQLException, IOException {
        PTableProtos.TTLExpression.Builder ttl = PTableProtos.TTLExpression.newBuilder();
        PTableProtos.ConditionTTL.Builder condition = PTableProtos.ConditionTTL.newBuilder();
        condition.setTtlExpression(this.ttlExpr);
        condition.setCompiledExpression(ByteStringer.wrap((byte[])CompiledConditionalTTLExpression.serializeExpression(this.compiledExpr)));
        for (ColumnReference colRef : this.conditionExprColumns) {
            ServerCachingProtos.ColumnReference.Builder cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            cRefBuilder.setFamily(ByteStringer.wrap((byte[])colRef.getFamily()));
            cRefBuilder.setQualifier(ByteStringer.wrap((byte[])colRef.getQualifier()));
            condition.addTtlExpressionColumns(cRefBuilder.build());
        }
        ttl.setCondition(condition.build());
        return ttl.build();
    }
}

