/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.SchemaUtil;

public class ColumnMetaDataOps {
    public static final String UPSERT_COLUMN = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,COLUMN_QUALIFIER, IS_ROW_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    public static void addColumnMutation(PhoenixConnection connection, String tenantId, String schemaName, String tableName, PColumn column, String parentTableName, String pkName, Short keySeq, boolean isSalted) throws SQLException {
        ColumnMetaDataOps.addColumnMutationInternal(connection, tenantId, schemaName, tableName, column, parentTableName, pkName, keySeq, isSalted);
    }

    public static void addColumnMutation(PhoenixConnection connection, String schemaName, String tableName, PColumn column, String parentTableName, String pkName, Short keySeq, boolean isSalted) throws SQLException {
        ColumnMetaDataOps.addColumnMutationInternal(connection, connection.getTenantId() == null ? null : connection.getTenantId().getString(), schemaName, tableName, column, parentTableName, pkName, keySeq, isSalted);
    }

    private static void addColumnMutationInternal(PhoenixConnection connection, String tenantId, String schemaName, String tableName, PColumn column, String parentTableName, String pkName, Short keySeq, boolean isSalted) throws SQLException {
        String addColumnSqlToUse = connection.isRunningUpgrade() && tableName.equals("CATALOG") && schemaName.equals("SYSTEM") ? "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : UPSERT_COLUMN;
        try (PreparedStatement colUpsert = connection.prepareStatement(addColumnSqlToUse);){
            colUpsert.setString(1, tenantId);
            colUpsert.setString(2, schemaName);
            colUpsert.setString(3, tableName);
            colUpsert.setString(4, column.getName().getString());
            colUpsert.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
            colUpsert.setInt(6, column.getDataType().getSqlType());
            colUpsert.setInt(7, SchemaUtil.getIsNullableInt(column.isNullable()));
            if (column.getMaxLength() == null) {
                colUpsert.setNull(8, 4);
            } else {
                colUpsert.setInt(8, column.getMaxLength());
            }
            if (column.getScale() == null) {
                colUpsert.setNull(9, 4);
            } else {
                colUpsert.setInt(9, column.getScale());
            }
            colUpsert.setInt(10, column.getPosition() + (isSalted ? 0 : 1));
            colUpsert.setInt(11, column.getSortOrder().getSystemValue());
            colUpsert.setString(12, parentTableName);
            if (column.getArraySize() == null) {
                colUpsert.setNull(13, 4);
            } else {
                colUpsert.setInt(13, column.getArraySize());
            }
            colUpsert.setBytes(14, column.getViewConstant());
            colUpsert.setBoolean(15, column.isViewReferenced());
            colUpsert.setString(16, pkName);
            if (keySeq == null) {
                colUpsert.setNull(17, 5);
            } else {
                colUpsert.setShort(17, keySeq);
            }
            if (column.getExpressionStr() == null) {
                colUpsert.setNull(18, 12);
            } else {
                colUpsert.setString(18, column.getExpressionStr());
            }
            if (colUpsert.getParameterMetaData().getParameterCount() > 18) {
                if (column.getColumnQualifierBytes() == null) {
                    colUpsert.setNull(19, -3);
                } else {
                    colUpsert.setBytes(19, column.getColumnQualifierBytes());
                }
                colUpsert.setBoolean(20, column.isRowTimestamp());
            }
            colUpsert.execute();
        }
    }

    public static PColumn newColumn(int position, ColumnDef def, PrimaryKeyConstraint pkConstraint, String defaultColumnFamily, boolean addingToPK, byte[] columnQualifierBytes, boolean isImmutableRows) throws SQLException {
        try {
            Pair<ColumnName, SortOrder> pkSortOrder;
            ColumnName columnDefName = def.getColumnDefName();
            SortOrder sortOrder = def.getSortOrder();
            boolean isPK = def.isPK();
            boolean isRowTimestamp = def.isRowTimestamp();
            if (pkConstraint != null && (pkSortOrder = pkConstraint.getColumnWithSortOrder(columnDefName)) != null) {
                isPK = true;
                sortOrder = (SortOrder)((Object)pkSortOrder.getSecond());
                isRowTimestamp = pkConstraint.isColumnRowTimestamp(columnDefName);
            }
            String columnName = columnDefName.getColumnName();
            if (isPK && sortOrder == SortOrder.DESC && def.getDataType() == PVarbinary.INSTANCE) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.DESC_VARBINARY_NOT_SUPPORTED).setColumnName(columnName).build().buildException();
            }
            PName familyName = null;
            if (def.isPK() && !pkConstraint.getColumnNames().isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(columnName).build().buildException();
            }
            boolean isNull = def.isNull();
            if (def.getColumnDefName().getFamilyName() != null) {
                String family = def.getColumnDefName().getFamilyName();
                if (isPK) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                if (!def.isNull() && !isImmutableRows) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                familyName = PNameFactory.newName(family);
            } else if (!isPK) {
                familyName = PNameFactory.newName(defaultColumnFamily == null ? "0" : defaultColumnFamily);
            }
            if (isPK && !addingToPK && pkConstraint.getColumnNames().size() <= 1) {
                if (def.isNull() && def.isNullSet()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_PK_MAY_NOT_BE_NULL).setColumnName(columnName).build().buildException();
                }
                isNull = false;
            }
            PColumnImpl column = new PColumnImpl(PNameFactory.newName(columnName), familyName, def.getDataType(), def.getMaxLength(), def.getScale(), isNull, position, sortOrder, def.getArraySize(), null, false, def.getExpression(), isRowTimestamp, false, columnQualifierBytes, EnvironmentEdgeManager.currentTimeMillis());
            return column;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }
}

