/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.ipc.controller.ClientRpcControllerFactory;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.ConnectionProperty;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableRefFactory;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ReadOnlyProps;

public class QueryServicesOptions {
    public static final int DEFAULT_KEEP_ALIVE_MS = 60000;
    public static final int DEFAULT_THREAD_POOL_SIZE = 128;
    public static final int DEFAULT_QUEUE_SIZE = 5000;
    public static final int UNLIMITED_QUEUE_SIZE = -1;
    public static final int DEFAULT_THREAD_TIMEOUT_MS = 600000;
    public static final int DEFAULT_SPOOL_THRESHOLD_BYTES = 0x1400000;
    public static final int DEFAULT_SERVER_SPOOL_THRESHOLD_BYTES = 0x1400000;
    public static final int DEFAULT_CLIENT_SPOOL_THRESHOLD_BYTES = 0x1400000;
    public static final boolean DEFAULT_CLIENT_ORDERBY_SPOOLING_ENABLED = true;
    public static final boolean DEFAULT_CLIENT_JOIN_SPOOLING_ENABLED = true;
    public static final boolean DEFAULT_SERVER_ORDERBY_SPOOLING_ENABLED = true;
    public static final String DEFAULT_SPOOL_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final int DEFAULT_MAX_MEMORY_PERC = 15;
    public static final int DEFAULT_MAX_TENANT_MEMORY_PERC = 100;
    public static final long DEFAULT_MAX_SERVER_CACHE_SIZE = 0x6400000L;
    public static final int DEFAULT_TARGET_QUERY_CONCURRENCY = 32;
    public static final int DEFAULT_MAX_QUERY_CONCURRENCY = 64;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DEFAULT_DATE_FORMAT_TIMEZONE = "GMT";
    public static final boolean DEFAULT_CALL_QUEUE_ROUND_ROBIN = true;
    public static final int DEFAULT_MAX_MUTATION_SIZE = 500000;
    public static final int DEFAULT_MAX_MUTATION_SIZE_BYTES = 0x6400000;
    public static final int DEFAULT_HBASE_CLIENT_KEYVALUE_MAXSIZE = 0xA00000;
    public static final boolean DEFAULT_USE_INDEXES = true;
    public static final boolean DEFAULT_IMMUTABLE_ROWS = false;
    public static final boolean DEFAULT_DROP_METADATA = true;
    public static final long DEFAULT_DRIVER_SHUTDOWN_TIMEOUT_MS = 5000L;
    public static final boolean DEFAULT_TRACING_ENABLED = false;
    public static final int DEFAULT_TRACING_THREAD_POOL_SIZE = 5;
    public static final int DEFAULT_TRACING_BATCH_SIZE = 100;
    public static final int DEFAULT_TRACING_TRACE_BUFFER_SIZE = 1000;
    public static final int DEFAULT_MAX_INDEXES_PER_TABLE = 10;
    public static final int DEFAULT_CLIENT_INDEX_ASYNC_THRESHOLD = 0;
    public static final int DEFAULT_MUTATE_BATCH_SIZE = 100;
    public static final long DEFAULT_MUTATE_BATCH_SIZE_BYTES = 0x200000L;
    public static final int DEFAULT_MAX_SERVER_CACHE_TIME_TO_LIVE_MS = 30000;
    public static final int DEFAULT_MAX_SERVER_CACHE_PERSISTENCE_TIME_TO_LIVE_MS = 1800000;
    public static final int DEFAULT_SCAN_CACHE_SIZE = 1000;
    public static final int DEFAULT_MAX_INTRA_REGION_PARALLELIZATION = 64;
    public static final int DEFAULT_DISTINCT_VALUE_COMPRESS_THRESHOLD = 0x100000;
    public static final int DEFAULT_AGGREGATE_CHUNK_SIZE_INCREASE = 0x100000;
    public static final int DEFAULT_INDEX_MUTATE_BATCH_SIZE_THRESHOLD = 3;
    public static final long DEFAULT_MAX_SPOOL_TO_DISK_BYTES = 1024000000L;
    public static final long DEFAULT_SCAN_RESULT_CHUNK_SIZE = 2999L;
    public static final boolean DEFAULT_IS_NAMESPACE_MAPPING_ENABLED = false;
    public static final boolean DEFAULT_IS_SYSTEM_TABLE_MAPPED_TO_NAMESPACE = true;
    public static final int DEFAULT_MAX_IN_LIST_SKIP_SCAN_SIZE = 50000;
    public static final boolean DEFAULT_GROUPBY_SPILLABLE = true;
    public static final int DEFAULT_GROUPBY_SPILL_FILES = 2;
    public static final long DEFAULT_GROUPBY_MAX_CACHE_MAX = 0x6400000L;
    public static final long DEFAULT_SEQUENCE_CACHE_SIZE = 100L;
    public static final int GLOBAL_INDEX_CHECKER_ENABLED_MAP_EXPIRATION_MIN = 10;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_TIME_TO_LIVE_MS = 1800000L;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_SIZE = 0x1400000L;
    public static final long DEFAULT_MAX_CLIENT_METADATA_CACHE_SIZE = 0xA00000L;
    public static final int DEFAULT_GROUPBY_ESTIMATED_DISTINCT_VALUES = 1000;
    public static final int DEFAULT_CLOCK_SKEW_INTERVAL = 2000;
    public static final boolean DEFAULT_INDEX_FAILURE_HANDLING_REBUILD = true;
    public static final boolean DEFAULT_INDEX_FAILURE_BLOCK_WRITE = false;
    public static final boolean DEFAULT_INDEX_FAILURE_DISABLE_INDEX = true;
    public static final boolean DEFAULT_INDEX_FAILURE_THROW_EXCEPTION = true;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_INTERVAL = 60000L;
    public static final long DEFAULT_INDEX_REBUILD_TASK_INITIAL_DELAY = 10000L;
    public static final long DEFAULT_START_TRUNCATE_TASK_DELAY = 20000L;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_OVERLAP_BACKWARD_TIME = 1L;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_OVERLAP_FORWARD_TIME = 180000L;
    public static final long DEFAULT_INDEX_REBUILD_QUERY_TIMEOUT = 9002100L;
    public static final long DEFAULT_INDEX_REBUILD_RPC_TIMEOUT = 1800000L;
    public static final long DEFAULT_INDEX_REBUILD_CLIENT_SCANNER_TIMEOUT = 1800000L;
    public static final int DEFAULT_INDEX_REBUILD_RPC_RETRIES_COUNTER = 5;
    public static final int DEFAULT_INDEX_REBUILD_DISABLE_TIMESTAMP_THRESHOLD = 86400000;
    public static final long DEFAULT_INDEX_PENDING_DISABLE_THRESHOLD = 30000L;
    public static final int DEFAULT_SERVER_SIDE_PRIORITY = 500;
    public static final int DEFAULT_INDEX_PRIORITY = 1000;
    public static final int DEFAULT_METADATA_PRIORITY = 2000;
    public static final int DEFAULT_INVALIDATE_METADATA_CACHE_PRIORITY = 3000;
    public static final boolean DEFAULT_ALLOW_LOCAL_INDEX = true;
    public static final int DEFAULT_INDEX_HANDLER_COUNT = 30;
    public static final int DEFAULT_METADATA_HANDLER_COUNT = 30;
    public static final int DEFAULT_SERVERSIDE_HANDLER_COUNT = 30;
    public static final int DEFAULT_INVALIDATE_CACHE_HANDLER_COUNT = 10;
    public static final int DEFAULT_SYSTEM_MAX_VERSIONS = 1;
    public static final boolean DEFAULT_SYSTEM_KEEP_DELETED_CELLS = false;
    public static final int DEFAULT_METADATA_WRITE_RETRIES_NUMBER = 20;
    public static final int DEFAULT_METADATA_WRITE_RETRY_PAUSE = 100;
    public static final int DEFAULT_TRACING_PAGE_SIZE = 100;
    public static final String DEFAULT_TRACING_STATS_TABLE_NAME = "SYSTEM.TRACING_STATS";
    public static final String DEFAULT_TRACING_FREQ = Tracing.Frequency.NEVER.getKey();
    public static final double DEFAULT_TRACING_PROBABILITY_THRESHOLD = 0.05;
    public static final int DEFAULT_STATS_UPDATE_FREQ_MS = 900000;
    public static final int DEFAULT_STATS_GUIDEPOST_PER_REGION = 0;
    public static final long DEFAULT_STATS_GUIDEPOST_WIDTH_BYTES = 314572800L;
    public static final boolean DEFAULT_STATS_USE_CURRENT_TIME = true;
    public static final boolean DEFAULT_RUN_UPDATE_STATS_ASYNC = true;
    public static final boolean DEFAULT_COMMIT_STATS_ASYNC = true;
    public static final int DEFAULT_STATS_POOL_SIZE = 4;
    public static final long DEFAULT_STATS_MAX_CACHE_SIZE = 0x10000000L;
    public static final int DEFAULT_MIN_STATS_UPDATE_FREQ_MS = 0;
    public static final int DEFAULT_STATS_CACHE_THREAD_POOL_SIZE = 4;
    public static final boolean DEFAULT_USE_REVERSE_SCAN = true;
    public static final String DEFAULT_CREATE_INDEX_STATE = PIndexState.BUILDING.toString();
    public static final boolean DEFAULT_DISABLE_ON_DROP = false;
    public static final int DEFAULT_SEQUENCE_TABLE_SALT_BUCKETS = 0;
    public static final int DEFAULT_COPROCESSOR_PRIORITY = 0x2FFFFFFE;
    public static final boolean DEFAULT_EXPLAIN_CHUNK_COUNT = true;
    public static final boolean DEFAULT_EXPLAIN_ROW_COUNT = true;
    public static final boolean DEFAULT_ALLOW_ONLINE_TABLE_SCHEMA_UPDATE = true;
    public static final int DEFAULT_RETRIES_FOR_SCHEMA_UPDATE_CHECK = 50;
    public static final long DEFAULT_DELAY_FOR_SCHEMA_UPDATE_CHECK = 1000L;
    public static final boolean DEFAULT_STORE_NULLS = false;
    public static final boolean DEFAULT_AUTO_COMMIT = false;
    public static final boolean DEFAULT_TABLE_ISTRANSACTIONAL = false;
    public static final String DEFAULT_TRANSACTION_PROVIDER = TransactionFactory.Provider.getDefault().name();
    public static final boolean DEFAULT_TRANSACTIONS_ENABLED = false;
    public static final boolean DEFAULT_IS_GLOBAL_METRICS_ENABLED = true;
    public static final boolean DEFAULT_IS_TABLE_LEVEL_METRICS_ENABLED = false;
    public static final boolean DEFAULT_IS_METRIC_PUBLISHER_ENABLED = false;
    public static final String DEFAULT_ALLOWED_LIST_FOR_TABLE_LEVEL_METRICS = null;
    public static final String DEFAULT_METRIC_PUBLISHER_CLASS_NAME = "org.apache.phoenix.monitoring.JmxMetricProvider";
    public static final String DEFAULT_CLIENT_METRICS_TAG = "FAT_CLIENT";
    public static final boolean DEFAULT_TRANSACTIONAL = false;
    public static final boolean DEFAULT_MULTI_TENANT = false;
    public static final boolean DEFAULT_AUTO_FLUSH = false;
    private static final String DEFAULT_CLIENT_RPC_CONTROLLER_FACTORY = ClientRpcControllerFactory.class.getName();
    public static final String DEFAULT_CONSISTENCY_LEVEL = Consistency.STRONG.toString();
    public static final boolean DEFAULT_USE_BYTE_BASED_REGEX = false;
    public static final boolean DEFAULT_FORCE_ROW_KEY_ORDER = false;
    public static final boolean DEFAULT_ALLOW_USER_DEFINED_FUNCTIONS = false;
    public static final boolean DEFAULT_REQUEST_LEVEL_METRICS_ENABLED = false;
    public static final boolean DEFAULT_ALLOW_VIEWS_ADD_NEW_CF_BASE_TABLE = true;
    public static final int DEFAULT_MAX_VERSIONS_TRANSACTIONAL = Integer.MAX_VALUE;
    public static final boolean DEFAULT_RETURN_SEQUENCE_VALUES = false;
    public static final String DEFAULT_EXTRA_JDBC_ARGUMENTS = "";
    public static final long DEFAULT_INDEX_POPULATION_SLEEP_TIME = 5000L;
    public static final String DEFAULT_QUERY_SERVICES_NAME = "DEFAULT_CQSN";
    public static final String DEFAULT_CONNECTION_QUERY_SERVICE_HISTOGRAM_SIZE_RANGES = "1, 10, 100, 500, 1000";
    public static final boolean DEFAULT_IS_CONNECTION_QUERY_SERVICE_METRICS_PUBLISHER_ENABLED = false;
    public static final boolean DEFAULT_IS_CONNECTION_QUERY_SERVICE_METRICS_ENABLED = false;
    public static final boolean DEFAULT_RENEW_LEASE_ENABLED = true;
    public static final int DEFAULT_RUN_RENEW_LEASE_FREQUENCY_INTERVAL_MILLISECONDS = 30000;
    public static final int DEFAULT_RENEW_LEASE_THRESHOLD_MILLISECONDS = 45000;
    public static final int DEFAULT_RENEW_LEASE_THREAD_POOL_SIZE = 10;
    public static final boolean DEFAULT_LOCAL_INDEX_CLIENT_UPGRADE = true;
    public static final float DEFAULT_LIMITED_QUERY_SERIAL_THRESHOLD = 0.2f;
    public static final boolean DEFAULT_INDEX_ASYNC_BUILD_ENABLED = true;
    public static final String DEFAULT_CLIENT_CACHE_ENCODING = PTableRefFactory.Encoding.OBJECT.toString();
    public static final boolean DEFAULT_AUTO_UPGRADE_ENABLED = true;
    public static final int DEFAULT_CLIENT_CONNECTION_CACHE_MAX_DURATION = 86400000;
    public static final int DEFAULT_COLUMN_ENCODED_BYTES = PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.getSerializedMetadataValue();
    public static final String DEFAULT_IMMUTABLE_STORAGE_SCHEME = PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS.toString();
    public static final String DEFAULT_MULTITENANT_IMMUTABLE_STORAGE_SCHEME = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN.toString();
    public static final int DEFAULT_CLIENT_CONNECTION_MAX_ALLOWED_CONNECTIONS = 0;
    public static final int DEFAULT_INTERNAL_CONNECTION_MAX_ALLOWED_CONNECTIONS = 0;
    public static final boolean DEFAULT_CONNECTION_ACTIVITY_LOGGING_ENABLED = false;
    public static final boolean DEFAULT_CONNECTION_EXPLAIN_PLAN_LOGGING_ENABLED = false;
    public static final int DEFAULT_CONNECTION_ACTIVITY_LOGGING_INTERVAL_IN_MINS = 15;
    public static final boolean DEFAULT_STATS_COLLECTION_ENABLED = true;
    public static final boolean DEFAULT_USE_STATS_FOR_PARALLELIZATION = true;
    public static final boolean DEFAULT_PHOENIX_ACLS_ENABLED = false;
    public static final int DEFAULT_SMALL_SCAN_THRESHOLD = 100;
    public static final long DEFAULT_UPDATE_CACHE_FREQUENCY = (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue("ALWAYS");
    public static final boolean DEFAULT_LAST_DDL_TIMESTAMP_VALIDATION_ENABLED = false;
    public static final boolean DEFAULT_PHOENIX_METADATA_INVALIDATE_CACHE_ENABLED = false;
    public static final int DEFAULT_PHOENIX_METADATA_CACHE_INVALIDATION_THREAD_POOL_SIZE = 20;
    public static final long DEFAULT_TASK_HANDLING_INTERVAL_MS = 60000L;
    public static final long DEFAULT_TASK_HANDLING_MAX_INTERVAL_MS = 1800000L;
    public static final long DEFAULT_TASK_HANDLING_INITIAL_DELAY_MS = 10000L;
    public static final long DEFAULT_GLOBAL_INDEX_ROW_AGE_THRESHOLD_TO_DELETE_MS = 604800000L;
    public static final boolean DEFAULT_INDEX_REGION_OBSERVER_ENABLED = true;
    public static final String DEFAULT_INDEX_REGION_OBSERVER_ENABLED_ALL_TABLES = Boolean.toString(true);
    public static final boolean DEFAULT_PHOENIX_SERVER_PAGING_ENABLED = true;
    public static final long DEFAULT_INDEX_REBUILD_PAGE_SIZE_IN_ROWS = 32768L;
    public static final long DEFAULT_INDEX_PAGE_SIZE_IN_ROWS = 32768L;
    public static final boolean DEFAULT_ALLOW_SPLITTABLE_SYSTEM_CATALOG_ROLLBACK = false;
    public static final boolean DEFAULT_PROPERTY_POLICY_PROVIDER_ENABLED = true;
    public static final String DEFAULT_SCHEMA = null;
    public static final String DEFAULT_UPLOAD_BINARY_DATA_TYPE_ENCODING = "BASE64";
    public static final boolean DEFAULT_ENABLE_SERVER_UPSERT_SELECT = false;
    public static final boolean DEFAULT_ENABLE_SERVER_SIDE_DELETE_MUTATIONS = true;
    public static final boolean DEFAULT_ENABLE_SERVER_SIDE_UPSERT_MUTATIONS = true;
    public static final boolean DEFAULT_COST_BASED_OPTIMIZER_ENABLED = false;
    public static final boolean DEFAULT_WILDCARD_QUERY_DYNAMIC_COLS_ATTRIB = false;
    public static final String DEFAULT_LOGGING_LEVEL = LogLevel.OFF.name();
    public static final String DEFAULT_AUDIT_LOGGING_LEVEL = LogLevel.OFF.name();
    public static final String DEFAULT_LOG_SAMPLE_RATE = "1.0";
    public static final int DEFAULT_LOG_SALT_BUCKETS = 32;
    public static final int DEFAULT_SALT_BUCKETS = 0;
    public static final boolean DEFAULT_SYSTEM_CATALOG_SPLITTABLE = true;
    public static final String DEFAULT_GUIDE_POSTS_CACHE_FACTORY_CLASS = "org.apache.phoenix.query.DefaultGuidePostsCacheFactory";
    public static final boolean DEFAULT_LONG_VIEW_INDEX_ENABLED = false;
    public static final boolean DEFAULT_PENDING_MUTATIONS_DDL_THROW = false;
    public static final boolean DEFAULT_SKIP_SYSTEM_TABLES_EXISTENCE_CHECK = false;
    public static final boolean DEFAULT_MOVE_CHILD_LINKS_DURING_UPGRADE_ENABLED = true;
    public static final int DEFAULT_TIMEOUT_DURING_UPGRADE_MS = 1800000;
    public static final int DEFAULT_SCAN_PAGE_SIZE = 32768;
    public static final boolean DEFAULT_APPLY_TIME_ZONE_DISPLACMENT = false;
    public static final boolean DEFAULT_PHOENIX_TABLE_TTL_ENABLED = true;
    public static final boolean DEFAULT_PHOENIX_COMPACTION_ENABLED = true;
    public static final boolean DEFAULT_PHOENIX_VIEW_TTL_ENABLED = true;
    public static final int DEFAULT_PHOENIX_VIEW_TTL_TENANT_VIEWS_PER_SCAN_LIMIT = 100;
    public static final int DEFAULT_MAX_REGION_LOCATIONS_SIZE_EXPLAIN_PLAN = 5;
    public static final boolean DEFAULT_SERVER_MERGE_FOR_UNCOVERED_INDEX = true;
    public static final boolean DEFAULT_PHOENIX_GET_METADATA_READ_LOCK_ENABLED = true;
    public static final int DEFAULT_PHOENIX_STREAMS_GET_TABLE_REGIONS_TIMEOUT = 300000;
    public static final boolean DEFAULT_SYSTEM_CATALOG_INDEXES_ENABLED = false;
    public static final Boolean DEFAULT_CLUSTER_ROLE_BASED_MUTATION_BLOCK_ENABLED = false;
    public static final Boolean DEFAULT_CQSI_THREAD_POOL_ENABLED = false;
    public static final int DEFAULT_CQSI_THREAD_POOL_KEEP_ALIVE_SECONDS = 60;
    public static final int DEFAULT_CQSI_THREAD_POOL_CORE_POOL_SIZE = 25;
    public static final int DEFAULT_CQSI_THREAD_POOL_MAX_THREADS = 25;
    public static final int DEFAULT_CQSI_THREAD_POOL_MAX_QUEUE = 512;
    public static final Boolean DEFAULT_CQSI_THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT = true;
    public static final Boolean DEFAULT_CQSI_THREAD_POOL_METRICS_ENABLED = false;
    public static final int DEFAULT_CDC_TTL_MUTATION_MAX_RETRIES = 5;
    public static final int DEFAULT_CDC_TTL_MUTATION_BATCH_SIZE = 50;
    public static final int DEFAULT_CDC_TTL_SHARED_CACHE_EXPIRY_SECONDS = 1200;
    public static final long DEFAULT_PHOENIX_CDC_STREAM_PARTITION_EXPIRY_MIN_AGE_MS = 108000000L;
    public static final int DEFAULT_PHOENIX_UNCOVERED_INDEX_MAX_POOL_SIZE = 512;
    public static final int DEFAULT_PHOENIX_UNCOVERED_INDEX_KEEP_ALIVE_TIME_SEC = 60;
    private final Configuration config;

    private QueryServicesOptions(Configuration config) {
        this.config = config;
    }

    public ReadOnlyProps getProps(ReadOnlyProps defaultProps) {
        return new ReadOnlyProps(defaultProps, this.config.iterator());
    }

    public QueryServicesOptions setAll(ReadOnlyProps props) {
        for (Map.Entry<String, String> entry : props) {
            this.config.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public static QueryServicesOptions withDefaults() {
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        QueryServicesOptions options = new QueryServicesOptions(config).setIfUnset("phoenix.stats.useCurrentTime", true).setIfUnset("phoenix.update.stats.command.async", true).setIfUnset("phoenix.stats.commit.async", true).setIfUnset("phoenix.query.keepAliveMs", 60000).setIfUnset("phoenix.query.threadPoolSize", 128).setIfUnset("phoenix.query.queueSize", 5000).setIfUnset("phoenix.query.timeoutMs", 600000).setIfUnset("phoenix.query.client.spoolThresholdBytes", 0x1400000).setIfUnset("phoenix.query.server.spoolThresholdBytes", 0x1400000).setIfUnset("phoenix.spool.directory", DEFAULT_SPOOL_DIRECTORY).setIfUnset("phoenix.query.maxGlobalMemoryPercentage", 15).setIfUnset("phoenix.query.maxTenantMemoryPercentage", 100).setIfUnset("phoenix.query.maxServerCacheBytes", 0x6400000L).setIfUnset("hbase.client.scanner.caching", 1000).setIfUnset("phoenix.query.dateFormat", DEFAULT_DATE_FORMAT).setIfUnset("phoenix.query.dateFormatTimeZone", DEFAULT_DATE_FORMAT_TIMEZONE).setIfUnset("phoenix.stats.updateFrequency", 900000).setIfUnset("phoenix.stats.minUpdateFrequency", 0).setIfUnset("phoenix.stats.cache.threadPoolSize", 4).setIfUnset("ipc.server.callqueue.roundrobin", true).setIfUnset("phoenix.mutate.maxSize", 500000).setIfUnset("phoenix.query.rowKeyOrderSaltedTable", false).setIfUnset("phoenix.query.useIndexes", true).setIfUnset("phoenix.mutate.immutableRows", false).setIfUnset("phoenix.index.mutableBatchSizeThreshold", 3).setIfUnset("phoenix.query.maxSpoolToDiskBytes", 1024000000L).setIfUnset("phoenix.schema.dropMetaData", true).setIfUnset("phoenix.groupby.spillable", true).setIfUnset("phoenix.groupby.maxCacheSize", 0x6400000L).setIfUnset("phoenix.groupby.spillFiles", 2).setIfUnset("phoenix.sequence.cacheSize", 100L).setIfUnset("phoenix.query.scanResultChunkSize", 2999L).setIfUnset("hbase.online.schema.update.enable", true).setIfUnset("phoenix.schema.change.retries", 50).setIfUnset("phoenix.schema.change.delay", 1000L).setIfUnset("phoenix.query.global.metrics.enabled", true).setIfUnset("hbase.rpc.controllerfactory.class", DEFAULT_CLIENT_RPC_CONTROLLER_FACTORY).setIfUnset("phoenix.regex.byteBased", false).setIfUnset("phoenix.query.force.rowkeyorder", false).setIfUnset("phoenix.query.request.metrics.enabled", false).setIfUnset("phoenix.view.allowNewColumnFamily", true).setIfUnset("phoenix.view.allowNewColumnFamily", true).setIfUnset("phoenix.scanner.lease.threshold", 45000).setIfUnset("phoenix.scanner.lease.renew.interval", 30000).setIfUnset("phoenix.scanner.lease.pool.size", 10).setIfUnset("phoenix.schema.isNamespaceMappingEnabled", false).setIfUnset("phoenix.schema.mapSystemTablesToNamespace", true).setIfUnset("phoenix.client.localIndexUpgrade", true).setIfUnset("phoenix.autoupgrade.enabled", true).setIfUnset("phoenix.upload.binaryDataType.encoding", DEFAULT_UPLOAD_BINARY_DATA_TYPE_ENCODING).setIfUnset("phoenix.trace.enabled", false).setIfUnset("phoenix.trace.batchSize", 100).setIfUnset("phoenix.trace.threadPoolSize", 5).setIfUnset("phoenix.stats.collection.enabled", true).setIfUnset("phoenix.use.stats.parallelization", true).setIfUnset("phoenix.use.stats.parallelization", true).setIfUnset("phoenix.upload.binaryDataType.encoding", DEFAULT_UPLOAD_BINARY_DATA_TYPE_ENCODING).setIfUnset("phoenix.costbased.optimizer.enabled", false).setIfUnset("phoenix.acls.enabled", false).setIfUnset("phoenix.log.level", DEFAULT_LOGGING_LEVEL).setIfUnset("phoenix.log.sample.rate", DEFAULT_LOG_SAMPLE_RATE).setIfUnset("data.tx.pre.014.changeset.key", Boolean.FALSE.toString()).setIfUnset("phoenix.client.metrics.tag", DEFAULT_CLIENT_METRICS_TAG).setIfUnset("phoenix.index.async.threshold", 0).setIfUnset("phoenix.query.services.name", DEFAULT_QUERY_SERVICES_NAME).setIfUnset("phoenix.index.create.default.state", DEFAULT_CREATE_INDEX_STATE).setIfUnset("phoenix.conn.query.service.histogram.size.ranges", DEFAULT_CONNECTION_QUERY_SERVICE_HISTOGRAM_SIZE_RANGES).setIfUnset("phoenix.conn.query.service.metrics.enabled", false).setIfUnset("phoenix.conn.query.service.metricsPublisher.enabled", false).setIfUnset("phoenix.skip.system.tables.existence.check", false).setIfUnset("phoenix.max.inList.skipScan.size", 50000).setIfUnset("phoenix.max.region.locations.size.explain.plan", 5).setIfUnset("phoenix.query.global.server.merge.enable", true).setIfUnset("phoenix.max.inList.skipScan.size", 50000).setIfUnset("phoenix.connection.activity.logging.enabled", false).setIfUnset("phoenix.connection.activity.logging.explain.plan.enabled", false).setIfUnset("phoenix.connection.activity.logging.interval", 15).setIfUnset("phoenix.cluster.role.based.mutation.block.enabled", DEFAULT_CLUSTER_ROLE_BASED_MUTATION_BLOCK_ENABLED).setIfUnset("phoenix.cqsi.thread.pool.enabled", DEFAULT_CQSI_THREAD_POOL_ENABLED).setIfUnset("phoenix.cqsi.thread.pool.keepalive.seconds", 60).setIfUnset("phoenix.cqsi.thread.pool.core.size", 25).setIfUnset("phoenix.cqsi.thread.pool.max.threads", 25).setIfUnset("phoenix.cqsi.thread.pool.max.queue", 512).setIfUnset("phoenix.cqsi.thread.pool.allow.core.thread.timeout", DEFAULT_CQSI_THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT).setIfUnset("phoenix.cqsi.thread.pool.metrics.enabled", DEFAULT_CQSI_THREAD_POOL_METRICS_ENABLED).setIfUnset("phoenix.cdc.ttl.mutation.max.retries", 5).setIfUnset("phoenix.cdc.ttl.mutation.batch.size", 50).setIfUnset("phoenix.cdc.ttl.shared.cache.expiry.seconds", 1200);
        int scanCaching = config.getInt("hbase.client.scanner.caching", 0);
        if (scanCaching == 1) {
            config.setInt("hbase.client.scanner.caching", 1000);
        } else if (scanCaching <= 0) {
            config.setInt("hbase.client.scanner.caching", 1);
        }
        return options;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private QueryServicesOptions setIfUnset(String name, int value) {
        this.config.setIfUnset(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, boolean value) {
        this.config.setIfUnset(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, long value) {
        this.config.setIfUnset(name, Long.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, String value) {
        this.config.setIfUnset(name, value);
        return this;
    }

    public QueryServicesOptions setKeepAliveMs(int keepAliveMs) {
        return this.set("phoenix.query.keepAliveMs", keepAliveMs);
    }

    public QueryServicesOptions setThreadPoolSize(int threadPoolSize) {
        return this.set("phoenix.query.threadPoolSize", threadPoolSize);
    }

    public QueryServicesOptions setQueueSize(int queueSize) {
        this.config.setInt("phoenix.query.queueSize", queueSize);
        return this;
    }

    public QueryServicesOptions setThreadTimeoutMs(int threadTimeoutMs) {
        return this.set("phoenix.query.timeoutMs", threadTimeoutMs);
    }

    public QueryServicesOptions setClientSpoolThresholdBytes(long spoolThresholdBytes) {
        return this.set("phoenix.query.client.spoolThresholdBytes", spoolThresholdBytes);
    }

    public QueryServicesOptions setServerSpoolThresholdBytes(long spoolThresholdBytes) {
        return this.set("phoenix.query.server.spoolThresholdBytes", spoolThresholdBytes);
    }

    public QueryServicesOptions setSpoolDirectory(String spoolDirectory) {
        return this.set("phoenix.spool.directory", spoolDirectory);
    }

    public QueryServicesOptions setMaxMemoryPerc(int maxMemoryPerc) {
        return this.set("phoenix.query.maxGlobalMemoryPercentage", maxMemoryPerc);
    }

    public QueryServicesOptions setMaxTenantMemoryPerc(int maxTenantMemoryPerc) {
        return this.set("phoenix.query.maxTenantMemoryPercentage", maxTenantMemoryPerc);
    }

    public QueryServicesOptions setMaxServerCacheSize(long maxServerCacheSize) {
        return this.set("phoenix.query.maxServerCacheBytes", maxServerCacheSize);
    }

    public QueryServicesOptions setMaxServerMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.coprocessor.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setMaxClientMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.client.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setScanFetchSize(int scanFetchSize) {
        return this.set("hbase.client.scanner.caching", scanFetchSize);
    }

    public QueryServicesOptions setDateFormat(String dateFormat) {
        return this.set("phoenix.query.dateFormat", dateFormat);
    }

    public QueryServicesOptions setCallQueueRoundRobin(boolean isRoundRobin) {
        return this.set("CALL_QUEUE_PRODUCER", isRoundRobin);
    }

    public QueryServicesOptions setMaxMutateSize(int maxMutateSize) {
        return this.set("phoenix.mutate.maxSize", maxMutateSize);
    }

    @Deprecated
    public QueryServicesOptions setMutateBatchSize(int mutateBatchSize) {
        return this.set("phoenix.mutate.batchSize", mutateBatchSize);
    }

    public QueryServicesOptions setDropMetaData(boolean dropMetadata) {
        return this.set("phoenix.schema.dropMetaData", dropMetadata);
    }

    public QueryServicesOptions setGroupBySpill(boolean enabled) {
        return this.set("phoenix.groupby.spillable", enabled);
    }

    public QueryServicesOptions setGroupBySpillMaxCacheSize(long size) {
        return this.set("phoenix.groupby.maxCacheSize", size);
    }

    public QueryServicesOptions setGroupBySpillNumSpillFiles(long num) {
        return this.set("phoenix.groupby.spillFiles", num);
    }

    QueryServicesOptions set(String name, boolean value) {
        this.config.set(name, Boolean.toString(value));
        return this;
    }

    QueryServicesOptions set(String name, int value) {
        this.config.set(name, Integer.toString(value));
        return this;
    }

    QueryServicesOptions set(String name, String value) {
        this.config.set(name, value);
        return this;
    }

    QueryServicesOptions set(String name, long value) {
        this.config.set(name, Long.toString(value));
        return this;
    }

    public int getKeepAliveMs() {
        return this.config.getInt("phoenix.query.keepAliveMs", 60000);
    }

    public int getThreadPoolSize() {
        return this.config.getInt("phoenix.query.threadPoolSize", 128);
    }

    public int getQueueSize() {
        return this.config.getInt("phoenix.query.queueSize", 5000);
    }

    public int getMaxMemoryPerc() {
        return this.config.getInt("phoenix.query.maxGlobalMemoryPercentage", 15);
    }

    public int getMaxMutateSize() {
        return this.config.getInt("phoenix.mutate.maxSize", 500000);
    }

    @Deprecated
    public int getMutateBatchSize() {
        return this.config.getInt("phoenix.mutate.batchSize", 100);
    }

    public String getClientMetricTag() {
        return this.config.get("phoenix.client.metrics.tag", DEFAULT_CLIENT_METRICS_TAG);
    }

    public boolean isUseIndexes() {
        return this.config.getBoolean("phoenix.query.useIndexes", true);
    }

    public boolean isImmutableRows() {
        return this.config.getBoolean("phoenix.mutate.immutableRows", false);
    }

    public boolean isDropMetaData() {
        return this.config.getBoolean("phoenix.schema.dropMetaData", true);
    }

    public boolean isSpillableGroupByEnabled() {
        return this.config.getBoolean("phoenix.groupby.spillable", true);
    }

    public long getSpillableGroupByMaxCacheSize() {
        return this.config.getLongBytes("phoenix.groupby.maxCacheSize", 0x6400000L);
    }

    public int getSpillableGroupByNumSpillFiles() {
        return this.config.getInt("phoenix.groupby.spillFiles", 2);
    }

    public boolean isTracingEnabled() {
        return this.config.getBoolean("phoenix.trace.enabled", false);
    }

    public QueryServicesOptions setTracingEnabled(boolean enable) {
        this.config.setBoolean("phoenix.trace.enabled", enable);
        return this;
    }

    public int getTracingThreadPoolSize() {
        return this.config.getInt("phoenix.trace.threadPoolSize", 5);
    }

    public int getTracingBatchSize() {
        return this.config.getInt("phoenix.trace.batchSize", 100);
    }

    public int getTracingTraceBufferSize() {
        return this.config.getInt("phoenix.trace.traceBufferSize", 1000);
    }

    public String getTableName() {
        return this.config.get("phoenix.trace.statsTableName", DEFAULT_TRACING_STATS_TABLE_NAME);
    }

    public boolean isGlobalMetricsEnabled() {
        return this.config.getBoolean("phoenix.query.global.metrics.enabled", true);
    }

    public String getMetricPublisherClass() {
        return this.config.get("phoenix.monitoring.metricProvider.className", DEFAULT_METRIC_PUBLISHER_CLASS_NAME);
    }

    public String getAllowedListTableNames() {
        return this.config.get("phoenix.monitoring.allowedTableNames.list", DEFAULT_ALLOWED_LIST_FOR_TABLE_LEVEL_METRICS);
    }

    public boolean isTableLevelMetricsEnabled() {
        return this.config.getBoolean("phoenix.monitoring.tableMetrics.enabled", false);
    }

    public boolean isCQSIThreadPoolMetricsEnabled() {
        return this.config.getBoolean("phoenix.cqsi.thread.pool.metrics.enabled", DEFAULT_CQSI_THREAD_POOL_METRICS_ENABLED.booleanValue());
    }

    public void setCQSIThreadPoolMetricsEnabled(boolean enabled) {
        this.config.setBoolean("phoenix.cqsi.thread.pool.metrics.enabled", enabled);
    }

    public void setTableLevelMetricsEnabled() {
        this.set("phoenix.monitoring.tableMetrics.enabled", true);
    }

    public boolean isMetricPublisherEnabled() {
        return this.config.getBoolean("phoenix.monitoring.metricsPublisher.enabled", false);
    }

    public boolean isConnectionQueryServiceMetricsEnabled() {
        return this.config.getBoolean("phoenix.conn.query.service.metrics.enabled", false);
    }

    public boolean isConnectionQueryServiceMetricsPublisherEnabled() {
        return this.config.getBoolean("phoenix.conn.query.service.metricsPublisher.enabled", false);
    }

    public String getQueryServicesName() {
        return this.config.get("phoenix.query.services.name", DEFAULT_QUERY_SERVICES_NAME);
    }

    public void setConnectionQueryServiceMetricsEnabled() {
        this.set("phoenix.conn.query.service.metrics.enabled", true);
    }

    public String getConnectionQueryServiceMetricsPublisherClass() {
        return this.config.get("phoenix.monitoring.connection.query.service.metricProvider.className", DEFAULT_METRIC_PUBLISHER_CLASS_NAME);
    }

    @VisibleForTesting
    public void setAllowedListForTableLevelMetrics(String tableNameList) {
        this.set("phoenix.monitoring.allowedTableNames.list", tableNameList);
    }

    public boolean isUseByteBasedRegex() {
        return this.config.getBoolean("phoenix.regex.byteBased", false);
    }

    public int getScanCacheSize() {
        return this.config.getInt("hbase.client.scanner.caching", 1000);
    }

    public QueryServicesOptions setMaxServerCacheTTLMs(int ttl) {
        return this.set("phoenix.coprocessor.maxServerCacheTimeToLiveMs", ttl);
    }

    public QueryServicesOptions setMasterInfoPort(int port) {
        return this.set("hbase.master.info.port", port);
    }

    public QueryServicesOptions setRegionServerInfoPort(int port) {
        return this.set("hbase.regionserver.info.port", port);
    }

    public QueryServicesOptions setRegionServerLeasePeriodMs(int period) {
        return this.set("hbase.client.scanner.timeout.period", period);
    }

    public QueryServicesOptions setRpcTimeoutMs(int timeout) {
        return this.set("hbase.rpc.timeout", timeout);
    }

    public QueryServicesOptions setUseIndexes(boolean useIndexes) {
        return this.set("phoenix.query.useIndexes", useIndexes);
    }

    public QueryServicesOptions setImmutableRows(boolean isImmutableRows) {
        return this.set("phoenix.mutate.immutableRows", isImmutableRows);
    }

    public QueryServicesOptions setWALEditCodec(String walEditCodec) {
        return this.set("hbase.regionserver.wal.codec", walEditCodec);
    }

    public QueryServicesOptions setStatsHistogramDepthBytes(long byteDepth) {
        return this.set("phoenix.stats.guidepost.width", byteDepth);
    }

    public QueryServicesOptions setStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.stats.updateFrequency", frequencyMs);
    }

    public QueryServicesOptions setMinStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.stats.minUpdateFrequency", frequencyMs);
    }

    public QueryServicesOptions setStatsCacheThreadPoolSize(int threadPoolSize) {
        return this.set("phoenix.stats.cache.threadPoolSize", threadPoolSize);
    }

    public QueryServicesOptions setSequenceSaltBuckets(int saltBuckets) {
        this.config.setInt("phoenix.sequence.saltBuckets", saltBuckets);
        return this;
    }

    public QueryServicesOptions setExplainChunkCount(boolean showChunkCount) {
        this.config.setBoolean("phoenix.explain.displayChunkCount", showChunkCount);
        return this;
    }

    public QueryServicesOptions setTransactionsEnabled(boolean transactionsEnabled) {
        this.config.setBoolean("phoenix.transactions.enabled", transactionsEnabled);
        return this;
    }

    public QueryServicesOptions setExplainRowCount(boolean showRowCount) {
        this.config.setBoolean("phoenix.explain.displayRowCount", showRowCount);
        return this;
    }

    public QueryServicesOptions setAllowOnlineSchemaUpdate(boolean allow) {
        this.config.setBoolean("hbase.online.schema.update.enable", allow);
        return this;
    }

    public QueryServicesOptions setNumRetriesForSchemaChangeCheck(int numRetries) {
        this.config.setInt("phoenix.schema.change.retries", numRetries);
        return this;
    }

    public QueryServicesOptions setDelayInMillisForSchemaChangeCheck(long delayInMillis) {
        this.config.setLong("phoenix.schema.change.delay", delayInMillis);
        return this;
    }

    public QueryServicesOptions setUseByteBasedRegex(boolean flag) {
        this.config.setBoolean("phoenix.regex.byteBased", flag);
        return this;
    }

    public QueryServicesOptions setForceRowKeyOrder(boolean forceRowKeyOrder) {
        this.config.setBoolean("phoenix.query.force.rowkeyorder", forceRowKeyOrder);
        return this;
    }

    public QueryServicesOptions setExtraJDBCArguments(String extraArgs) {
        this.config.set("phoenix.jdbc.extra.arguments", extraArgs);
        return this;
    }

    public QueryServicesOptions setRunUpdateStatsAsync(boolean flag) {
        this.config.setBoolean("phoenix.update.stats.command.async", flag);
        return this;
    }

    public QueryServicesOptions setCommitStatsAsync(boolean flag) {
        this.config.setBoolean("phoenix.stats.commit.async", flag);
        return this;
    }

    public QueryServicesOptions setEnableRenewLease(boolean enable) {
        this.config.setBoolean("phoenix.scanner.lease.renew.enabled", enable);
        return this;
    }

    public QueryServicesOptions setIndexHandlerCount(int count) {
        this.config.setInt("phoenix.rpc.index.handler.count", count);
        return this;
    }

    public QueryServicesOptions setMetadataHandlerCount(int count) {
        this.config.setInt("phoenix.rpc.metadata.handler.count", count);
        return this;
    }

    public QueryServicesOptions setHConnectionPoolCoreSize(int count) {
        this.config.setInt("hbase.hconnection.threads.core", count);
        return this;
    }

    public QueryServicesOptions setHConnectionPoolMaxSize(int count) {
        this.config.setInt("hbase.hconnection.threads.max", count);
        return this;
    }

    public QueryServicesOptions setMaxThreadsPerHTable(int count) {
        this.config.setInt("hbase.htable.threads.max", count);
        return this;
    }

    public QueryServicesOptions setDefaultIndexPopulationWaitTime(long waitTime) {
        this.config.setLong("phoenix.index.population.wait.time", waitTime);
        return this;
    }

    public QueryServicesOptions setUseStatsForParallelization(boolean flag) {
        this.config.setBoolean("phoenix.use.stats.parallelization", flag);
        return this;
    }

    public QueryServicesOptions setIndexRebuildTaskInitialDelay(long waitTime) {
        this.config.setLong("phoenix.index.rebuild.task.initial.delay", waitTime);
        return this;
    }

    public QueryServicesOptions setSequenceCacheSize(long sequenceCacheSize) {
        this.config.setLong("phoenix.sequence.cacheSize", sequenceCacheSize);
        return this;
    }
}

