/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableProperty;

public interface QueryConstants {
    public static final String NAME_SEPARATOR = ".";
    public static final String NAMESPACE_SEPARATOR = ":";
    public static final String CHILD_VIEW_INDEX_NAME_SEPARATOR = "#";
    public static final byte[] NAMESPACE_SEPARATOR_BYTES = Bytes.toBytes((String)":");
    public static final byte NAMESPACE_SEPARATOR_BYTE = NAMESPACE_SEPARATOR_BYTES[0];
    public static final String NAME_SEPARATOR_REGEX = "\\.";
    public static final byte[] NAME_SEPARATOR_BYTES = Bytes.toBytes((String)".");
    public static final byte NAME_SEPARATOR_BYTE = NAME_SEPARATOR_BYTES[0];
    public static final String NULL_DISPLAY_TEXT = "<null>";
    public static final long UNSET_TIMESTAMP = -1L;
    public static final String SYSTEM_SCHEMA_NAME = "SYSTEM";
    public static final byte[] SYSTEM_SCHEMA_NAME_BYTES = Bytes.toBytes((String)"SYSTEM");
    public static final String OFFSET_ROW_KEY = "_OFFSET_";
    public static final byte[] OFFSET_ROW_KEY_BYTES = Bytes.toBytes((String)"_OFFSET_");
    public static final String GROUPED_AGGREGATOR_VALUE = "_GA_";
    public static final byte[] GROUPED_AGGREGATOR_VALUE_BYTES = Bytes.toBytes((String)"_GA_");
    public static final long AGG_TIMESTAMP = Long.MAX_VALUE;
    public static final byte[] UNGROUPED_AGG_ROW_KEY = Bytes.toBytes((String)"a");
    public static final String RESERVED_COLUMN_FAMILY = "_v";
    public static final byte[] RESERVED_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"_v");
    public static final byte[] VALUE_COLUMN_FAMILY = RESERVED_COLUMN_FAMILY_BYTES;
    public static final byte[] VALUE_COLUMN_QUALIFIER = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(1);
    public static final byte[] ARRAY_VALUE_COLUMN_FAMILY = RESERVED_COLUMN_FAMILY_BYTES;
    public static final byte[] ARRAY_VALUE_COLUMN_QUALIFIER = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(2);
    public static final PName SINGLE_COLUMN_NAME = PNameFactory.newNormalizedName("s");
    public static final PName SINGLE_COLUMN_FAMILY_NAME = PNameFactory.newNormalizedName("s");
    public static final byte[] SINGLE_COLUMN = SINGLE_COLUMN_NAME.getBytes();
    public static final byte[] SINGLE_COLUMN_FAMILY = SINGLE_COLUMN_FAMILY_NAME.getBytes();
    public static final byte[] TRUE = new byte[]{1};
    public static final String PRIORITY = "PRIORITY";
    public static final byte SEPARATOR_BYTE = 0;
    public static final byte[] SEPARATOR_BYTE_ARRAY = new byte[]{0};
    public static final byte DESC_SEPARATOR_BYTE = SortOrder.invert((byte)0);
    public static final byte[] DESC_SEPARATOR_BYTE_ARRAY = new byte[]{DESC_SEPARATOR_BYTE};
    public static final byte[] VARBINARY_ENCODED_SEPARATOR_BYTES = new byte[]{0, 1};
    public static final byte[] DESC_VARBINARY_ENCODED_SEPARATOR_BYTES = SortOrder.invert(VARBINARY_ENCODED_SEPARATOR_BYTES, 0, 2);
    public static final byte[] ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR = Bytes.toBytes((String)"_ROW_KEY_VALUE_ACCESSOR_ENCODED_SEPARATOR_");
    public static final String DEFAULT_COPROCESS_JAR_NAME = "phoenix-[version]-server.jar";
    public static final int MILLIS_IN_DAY = 86400000;
    public static final String EMPTY_COLUMN_NAME = "_0";
    public static final byte[] EMPTY_COLUMN_BYTES = Bytes.toBytes((String)"_0");
    public static final ImmutableBytesPtr EMPTY_COLUMN_BYTES_PTR = new ImmutableBytesPtr(EMPTY_COLUMN_BYTES);
    public static final Integer ENCODED_EMPTY_COLUMN_NAME = 0;
    public static final byte[] ENCODED_EMPTY_COLUMN_BYTES = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(ENCODED_EMPTY_COLUMN_NAME);
    public static final String EMPTY_COLUMN_VALUE = "x";
    public static final byte[] EMPTY_COLUMN_VALUE_BYTES = Bytes.toBytes((String)"x");
    public static final ImmutableBytesPtr EMPTY_COLUMN_VALUE_BYTES_PTR = new ImmutableBytesPtr(EMPTY_COLUMN_VALUE_BYTES);
    public static final byte[] ENCODED_EMPTY_COLUMN_VALUE_BYTES = Bytes.toBytes((String)"x");
    public static final String DEFAULT_COLUMN_FAMILY = "0";
    public static final byte[] DEFAULT_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"0");
    public static final ImmutableBytesPtr DEFAULT_COLUMN_FAMILY_BYTES_PTR = new ImmutableBytesPtr(DEFAULT_COLUMN_FAMILY_BYTES);
    public static final byte VERIFIED_BYTE = 1;
    public static final byte UNVERIFIED_BYTE = 2;
    public static final byte[] VERIFIED_BYTES = new byte[]{1};
    public static final byte[] UNVERIFIED_BYTES = new byte[]{2};
    public static final ImmutableBytesPtr VERIFIED_BYTES_PTR = new ImmutableBytesPtr(VERIFIED_BYTES);
    public static final ImmutableBytesPtr UNVERIFIED_BYTES_PTR = new ImmutableBytesPtr(UNVERIFIED_BYTES);
    public static final String SINGLE_KEYVALUE_COLUMN_QUALIFIER = "1";
    public static final byte[] SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES = Bytes.toBytes((String)"1");
    public static final ImmutableBytesPtr SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES_PTR = new ImmutableBytesPtr(SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
    public static final String LOCAL_INDEX_COLUMN_FAMILY_PREFIX = "L#";
    public static final byte[] LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES = Bytes.toBytes((String)"L#");
    public static final String DEFAULT_LOCAL_INDEX_COLUMN_FAMILY = "L#0";
    public static final byte[] DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"L#0");
    public static final ImmutableBytesPtr DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES_PTR = new ImmutableBytesPtr(DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
    public static final String ALL_FAMILY_PROPERTIES_KEY = "";
    public static final String SYSTEM_TABLE_PK_NAME = "pk";
    public static final double MILLIS_TO_NANOS_CONVERTOR = Math.pow(10.0, 6.0);
    public static final BigDecimal BD_MILLIS_NANOS_CONVERSION = BigDecimal.valueOf(MILLIS_TO_NANOS_CONVERTOR);
    public static final BigDecimal BD_MILLIS_IN_DAY = BigDecimal.valueOf(86400000L);
    public static final int MAX_ALLOWED_NANOS = 999999999;
    public static final int DIVERGED_VIEW_BASE_COLUMN_COUNT = -100;
    public static final int BASE_TABLE_BASE_COLUMN_COUNT = -1;
    public static final String METADATA_SPLIT_POLICY_CLASSNAME = "org.apache.phoenix.schema.MetaDataSplitPolicy";
    public static final String SYSTEM_STATS_SPLIT_POLICY_CLASSNAME = "org.apache.phoenix.schema.SystemStatsSplitPolicy";
    public static final String SYSTEM_FUNCTION_SPLIT_POLICY_CLASSNAME = "org.apache.phoenix.schema.SystemFunctionSplitPolicy";
    public static final String SYSTEM_TASK_SPLIT_POLICY_CLASSNAME = "org.apache.phoenix.schema.SystemTaskSplitPolicy";
    public static final String INDEX_REGION_SPLIT_POLICY_CLASSNAME = "org.apache.phoenix.hbase.index.IndexRegionSplitPolicy";
    public static final String GLOBAL_INDEX_CHECKER_CLASSNAME = "org.apache.phoenix.index.GlobalIndexChecker";
    public static final String INDEX_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.hbase.index.IndexRegionObserver";
    public static final String PHOENIX_TRANSACTIONAL_INDEXER_CLASSNAME = "org.apache.phoenix.index.PhoenixTransactionalIndexer";
    public static final String LOCAL_INDEX_SPLITTER_CLASSNAME = "org.apache.hadoop.hbase.regionserver.LocalIndexSplitter";
    public static final String INDEXER_CLASSNAME = "org.apache.phoenix.hbase.index.Indexer";
    public static final String SCAN_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.ScanRegionObserver";
    public static final String UNGROUPED_AGGREGATE_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver";
    public static final String GROUPED_AGGREGATE_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver";
    public static final String SERVER_CACHING_ENDPOINT_IMPL_CLASSNAME = "org.apache.phoenix.coprocessor.ServerCachingEndpointImpl";
    public static final String MULTI_ROW_MUTATION_ENDPOINT_CLASSNAME = "org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint";
    public static final String INDEX_HALF_STORE_FILE_READER_GENERATOR_CLASSNAME = "org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReaderGenerator";
    public static final String META_DATA_ENDPOINT_IMPL_CLASSNAME = "org.apache.phoenix.coprocessor.MetaDataEndpointImpl";
    public static final String META_DATA_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.MetaDataRegionObserver";
    public static final String SEQUENCE_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.SequenceRegionObserver";
    public static final String TASK_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.TaskRegionObserver";
    public static final String TASK_META_DATA_ENDPOINT_CLASSNAME = "org.apache.phoenix.coprocessor.TaskMetaDataEndpoint";
    public static final String CHILD_LINK_META_DATA_ENDPOINT_CLASSNAME = "org.apache.phoenix.coprocessor.ChildLinkMetaDataEndpoint";
    public static final String PHOENIX_TTL_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.PhoenixTTLRegionObserver";
    public static final String SYSTEM_CATALOG_REGION_OBSERVER_CLASSNAME = "org.apache.phoenix.coprocessor.SystemCatalogRegionObserver";
    public static final byte VIEW_MODIFIED_PROPERTY_TAG_TYPE = 70;
    public static final String CDC_JSON_COL_NAME = "CDC JSON";
    public static final String CDC_EVENT_TYPE = "event_type";
    public static final String CDC_PRE_IMAGE = "pre_image";
    public static final String CDC_POST_IMAGE = "post_image";
    public static final String CDC_CHANGE_IMAGE = "change_image";
    public static final String CDC_UPSERT_EVENT_TYPE = "upsert";
    public static final String CDC_DELETE_EVENT_TYPE = "delete";
    public static final String SPLITS_FILE = "SPLITS_FILE";
    public static final String CDC_TTL_DELETE_EVENT_TYPE = "ttl_delete";
    public static final String CDC_IMAGE_CQ = "_CDC_IMG_";
    public static final byte[] CDC_IMAGE_CQ_BYTES = Bytes.toBytes((String)"_CDC_IMG_");
    public static final int ENCODED_CQ_COUNTER_INITIAL_VALUE = 11;
    public static final String CREATE_TABLE_METADATA = "CREATE TABLE SYSTEM.\"CATALOG\"(\nTENANT_ID VARCHAR NULL,TABLE_SCHEM VARCHAR NULL,TABLE_NAME VARCHAR NOT NULL,COLUMN_NAME VARCHAR NULL,COLUMN_FAMILY VARCHAR NULL,TABLE_SEQ_NUM BIGINT,TABLE_TYPE CHAR(1),PK_NAME VARCHAR,COLUMN_COUNT INTEGER,SALT_BUCKETS INTEGER,DATA_TABLE_NAME VARCHAR,INDEX_STATE CHAR(1),\nIMMUTABLE_ROWS BOOLEAN,\nVIEW_STATEMENT VARCHAR,\nDEFAULT_COLUMN_FAMILY VARCHAR,\nDISABLE_WAL BOOLEAN,\nMULTI_TENANT BOOLEAN,\nVIEW_TYPE UNSIGNED_TINYINT,\nVIEW_INDEX_ID BIGINT,\nVIEW_INDEX_ID_DATA_TYPE INTEGER,\nPHOENIX_TTL BIGINT,\nPHOENIX_TTL_HWM BIGINT,\nLAST_DDL_TIMESTAMP BIGINT, \nCHANGE_DETECTION_ENABLED BOOLEAN, \nSCHEMA_VERSION VARCHAR, \nEXTERNAL_SCHEMA_ID VARCHAR, \nSTREAMING_TOPIC_NAME VARCHAR, \nINDEX_WHERE VARCHAR, \nCDC_INCLUDE VARCHAR, \nTTL VARCHAR, \nROW_KEY_MATCHER VARBINARY_ENCODED, \nIS_STRICT_TTL BOOLEAN, \nDATA_TYPE INTEGER,COLUMN_SIZE INTEGER,DECIMAL_DIGITS INTEGER,NULLABLE INTEGER,ORDINAL_POSITION INTEGER,SORT_ORDER INTEGER,ARRAY_SIZE INTEGER,\nVIEW_CONSTANT VARBINARY,\nIS_VIEW_REFERENCED BOOLEAN,\nKEY_SEQ SMALLINT,\nLINK_TYPE UNSIGNED_TINYINT,\nTYPE_NAME VARCHAR,REMARKS VARCHAR,SELF_REFERENCING_COL_NAME VARCHAR,REF_GENERATION VARCHAR,BUFFER_LENGTH INTEGER,NUM_PREC_RADIX INTEGER,COLUMN_DEF VARCHAR,SQL_DATA_TYPE INTEGER,SQL_DATETIME_SUB INTEGER,CHAR_OCTET_LENGTH INTEGER,IS_NULLABLE VARCHAR,SCOPE_CATALOG VARCHAR,SCOPE_SCHEMA VARCHAR,SCOPE_TABLE VARCHAR,SOURCE_DATA_TYPE SMALLINT,IS_AUTOINCREMENT VARCHAR,INDEX_TYPE UNSIGNED_TINYINT,INDEX_DISABLE_TIMESTAMP BIGINT,STORE_NULLS BOOLEAN,BASE_COLUMN_COUNT INTEGER,IS_ROW_TIMESTAMP BOOLEAN, TRANSACTIONAL BOOLEAN,UPDATE_CACHE_FREQUENCY BIGINT,IS_NAMESPACE_MAPPED BOOLEAN,AUTO_PARTITION_SEQ VARCHAR,APPEND_ONLY_SCHEMA BOOLEAN,GUIDE_POSTS_WIDTH BIGINT,COLUMN_QUALIFIER VARBINARY,IMMUTABLE_STORAGE_SCHEME TINYINT, ENCODING_SCHEME TINYINT, QUALIFIER_COUNTER INTEGER, USE_STATS_FOR_PARALLELIZATION BOOLEAN, TRANSACTION_PROVIDER TINYINT, PHYSICAL_TABLE_NAME VARCHAR,CONSTRAINT pk PRIMARY KEY (TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nSPLIT_POLICY='org.apache.phoenix.schema.MetaDataSplitPolicy',\nTRANSACTIONAL=" + Boolean.FALSE;
    public static final String CREATE_STATS_TABLE_METADATA = "CREATE TABLE SYSTEM.\"STATS\"(\nPHYSICAL_NAME VARCHAR NOT NULL,COLUMN_FAMILY VARCHAR,GUIDE_POST_KEY VARBINARY,GUIDE_POSTS_WIDTH BIGINT,LAST_STATS_UPDATE_TIME DATE, GUIDE_POSTS_ROW_COUNT BIGINT, CONSTRAINT pk PRIMARY KEY (PHYSICAL_NAME,COLUMN_FAMILY,GUIDE_POST_KEY))\nSPLIT_POLICY='org.apache.phoenix.schema.SystemStatsSplitPolicy',\nTRANSACTIONAL=" + Boolean.FALSE;
    public static final String CREATE_SEQUENCE_METADATA = "CREATE TABLE SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT, \nCURRENT_VALUE BIGINT, \nINCREMENT_BY BIGINT, \nCACHE_SIZE BIGINT, \nMIN_VALUE BIGINT, \nMAX_VALUE BIGINT, \nCYCLE_FLAG BOOLEAN, \nLIMIT_REACHED_FLAG BOOLEAN \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTRANSACTIONAL=" + Boolean.FALSE;
    public static final String UPGRADE_TABLE_SNAPSHOT_PREFIX = "_UPGRADING_TABLE_";
    public static final String CREATE_FUNCTION_METADATA = "CREATE TABLE SYSTEM.\"FUNCTION\"(\nTENANT_ID VARCHAR NULL,FUNCTION_NAME VARCHAR NOT NULL, \nNUM_ARGS INTEGER, \nCLASS_NAME VARCHAR, \nJAR_PATH  VARCHAR, \nRETURN_TYPE VARCHAR, \nTYPE VARCHAR, \nARG_POSITION VARBINARY, \nIS_ARRAY BOOLEAN, \nIS_CONSTANT BOOLEAN, \nDEFAULT_VALUE VARCHAR, \nMIN_VALUE VARCHAR, \nMAX_VALUE VARCHAR, \n CONSTRAINT pk PRIMARY KEY (TENANT_ID, FUNCTION_NAME, TYPE, ARG_POSITION))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nSPLIT_POLICY='org.apache.phoenix.schema.SystemFunctionSplitPolicy',\nTRANSACTIONAL=" + Boolean.FALSE;
    public static final String CREATE_LOG_METADATA = "CREATE IMMUTABLE TABLE SYSTEM.\"LOG\"(\nSTART_TIME DECIMAL, \nTABLE_NAME VARCHAR, \nQUERY_ID VARCHAR NOT NULL,\nTENANT_ID VARCHAR ,USER VARCHAR , \nCLIENT_IP VARCHAR, \nQUERY VARCHAR, \nEXPLAIN_PLAN VARCHAR, \nNO_OF_RESULTS_ITERATED BIGINT, \nQUERY_STATUS VARCHAR, \nEXCEPTION_TRACE VARCHAR, \nGLOBAL_SCAN_DETAILS VARCHAR, \nBIND_PARAMETERS VARCHAR, \nSCAN_METRICS_JSON VARCHAR, \n" + MetricType.getMetricColumnsDetails() + "\n CONSTRAINT pk PRIMARY KEY (START_TIME, TABLE_NAME, QUERY_ID))\nSALT_BUCKETS=%s,\nTRANSACTIONAL=" + Boolean.FALSE + ",\nTTL=604800,\n" + TableProperty.IMMUTABLE_STORAGE_SCHEME.toString() + " = " + PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS.name() + ",\n" + TableProperty.COLUMN_ENCODED_BYTES.toString() + " = 1";
    public static final byte[] OFFSET_FAMILY = "f_offset".getBytes(StandardCharsets.UTF_8);
    public static final byte[] OFFSET_COLUMN = "c_offset".getBytes(StandardCharsets.UTF_8);
    public static final String LAST_SCAN = "LAST_SCAN";
    public static final String HASH_JOIN_CACHE_RETRIES = "hashjoin.client.retries.number";
    public static final int DEFAULT_HASH_JOIN_CACHE_RETRIES = 5;
    public static final String CREATE_CHILD_LINK_METADATA = "CREATE TABLE SYSTEM.\"CHILD_LINK\"(\nTENANT_ID VARCHAR NULL,TABLE_SCHEM VARCHAR NULL,TABLE_NAME VARCHAR NOT NULL,COLUMN_NAME VARCHAR NULL,COLUMN_FAMILY VARCHAR NULL,LINK_TYPE UNSIGNED_TINYINT,\nCONSTRAINT pk PRIMARY KEY (TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTRANSACTIONAL=" + Boolean.FALSE;
    public static final String CREATE_MUTEX_METADATA = "CREATE IMMUTABLE TABLE SYSTEM.\"MUTEX\"(\nTENANT_ID VARCHAR NULL,TABLE_SCHEM VARCHAR NULL,TABLE_NAME VARCHAR NOT NULL,COLUMN_NAME VARCHAR NULL,COLUMN_FAMILY VARCHAR NULL CONSTRAINT pk PRIMARY KEY (TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTRANSACTIONAL=" + Boolean.FALSE + ",\nTTL=900";
    public static final String CREATE_TASK_METADATA = "CREATE TABLE SYSTEM.\"TASK\"(\nTASK_TYPE UNSIGNED_TINYINT NOT NULL,TASK_TS TIMESTAMP NOT NULL,TENANT_ID VARCHAR NULL,TABLE_SCHEM VARCHAR NULL,TABLE_NAME VARCHAR NOT NULL,\nTASK_STATUS VARCHAR NULL,TASK_END_TS TIMESTAMP NULL,TASK_PRIORITY UNSIGNED_TINYINT NULL,TASK_DATA VARCHAR NULL,\nCONSTRAINT pk PRIMARY KEY (TASK_TYPE,TASK_TS ROW_TIMESTAMP,TENANT_ID,TABLE_SCHEM,TABLE_NAME))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTTL=864000,\nSPLIT_POLICY='org.apache.phoenix.schema.SystemTaskSplitPolicy',\nTRANSACTIONAL=" + Boolean.FALSE + ",\nSTORE_NULLS=" + Boolean.TRUE;
    public static final String CREATE_TRANSFORM_METADATA = "CREATE TABLE SYSTEM.\"TRANSFORM\"(\nTENANT_ID VARCHAR NULL,\nTABLE_SCHEM VARCHAR NULL,LOGICAL_TABLE_NAME VARCHAR NOT NULL,\nNEW_PHYS_TABLE_NAME VARCHAR,\nTRANSFORM_TYPE INTEGER,LOGICAL_PARENT_NAME VARCHAR NULL,\nSTATUS VARCHAR NULL,JOB_ID VARCHAR NULL,RETRY_COUNT INTEGER NULL,START_TS TIMESTAMP NULL,END_TS TIMESTAMP NULL,OLD_METADATA VARBINARY NULL,\nNEW_METADATA VARCHAR NULL,\nTRANSFORM_FUNCTION VARCHAR NULL\nCONSTRAINT pk PRIMARY KEY (TENANT_ID,TABLE_SCHEM,LOGICAL_TABLE_NAME))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTTL=7776000,\nSPLIT_POLICY='org.apache.phoenix.schema.SystemTaskSplitPolicy',\nTRANSACTIONAL=" + Boolean.FALSE + ",\nSTORE_NULLS=" + Boolean.TRUE;
    public static final String CREATE_CDC_STREAM_STATUS_METADATA = "CREATE TABLE SYSTEM.\"CDC_STREAM_STATUS\"(\nTABLE_NAME VARCHAR NOT NULL,STREAM_NAME VARCHAR NOT NULL,STREAM_STATUS VARCHAR,\nSTREAM_TYPE VARCHAR,\nCONSTRAINT pk PRIMARY KEY (TABLE_NAME,STREAM_NAME))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTRANSACTIONAL=" + Boolean.FALSE + ",\nUPDATE_CACHE_FREQUENCY=7200000";
    public static final String CREATE_CDC_STREAM_METADATA = "CREATE TABLE SYSTEM.\"CDC_STREAM\"(\nTABLE_NAME VARCHAR NOT NULL,STREAM_NAME VARCHAR NOT NULL,PARTITION_ID VARCHAR NOT NULL,PARENT_PARTITION_ID VARCHAR,PARTITION_START_TIME BIGINT,PARTITION_END_TIME BIGINT,PARTITION_START_KEY VARBINARY_ENCODED,PARTITION_END_KEY VARBINARY_ENCODED,PARENT_PARTITION_START_TIME BIGINT,\nCONSTRAINT pk PRIMARY KEY (TABLE_NAME,STREAM_NAME,PARTITION_ID,PARENT_PARTITION_ID))\nVERSIONS=%s,\nKEEP_DELETED_CELLS=%s,\nTRANSACTIONAL=" + Boolean.FALSE + ",\nUPDATE_CACHE_FREQUENCY=7200000";

    public static enum JoinType {
        INNER,
        LEFT_OUTER;

    }
}

