/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.PhoenixStatsCacheLoader;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.phoenix.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalCause;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.phoenix.thirdparty.com.google.common.cache.Weigher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidePostsCacheImpl
implements GuidePostsCache {
    private static final Logger logger = LoggerFactory.getLogger(GuidePostsCacheImpl.class);
    private final LoadingCache<GuidePostsKey, GuidePostsInfo> cache;

    public GuidePostsCacheImpl(PhoenixStatsCacheLoader cacheLoader, Configuration config) {
        Preconditions.checkNotNull((Object)((Object)cacheLoader));
        long statsUpdateFrequency = config.getLong("phoenix.stats.updateFrequency", 900000L);
        long maxTableStatsCacheSize = config.getLongBytes("phoenix.stats.cache.maxSize", 0x10000000L);
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(statsUpdateFrequency, TimeUnit.MILLISECONDS).maximumWeight(maxTableStatsCacheSize).weigher((Weigher)new Weigher<GuidePostsKey, GuidePostsInfo>(){

            public int weigh(GuidePostsKey key, GuidePostsInfo info) {
                return info.getEstimatedSize();
            }
        }).removalListener((RemovalListener)new PhoenixStatsCacheRemovalListener()).build((CacheLoader)cacheLoader);
    }

    LoadingCache<GuidePostsKey, GuidePostsInfo> getCache() {
        return this.cache;
    }

    @Override
    public GuidePostsInfo get(GuidePostsKey key) throws ExecutionException {
        return (GuidePostsInfo)this.getCache().get((Object)key);
    }

    @Override
    public void put(GuidePostsKey key, GuidePostsInfo info) {
        this.getCache().put((Object)Objects.requireNonNull(key), (Object)Objects.requireNonNull(info));
    }

    @Override
    public void invalidate(GuidePostsKey key) {
        this.getCache().invalidate((Object)Objects.requireNonNull(key));
    }

    @Override
    public void invalidateAll() {
        this.getCache().invalidateAll();
    }

    static class PhoenixStatsCacheRemovalListener
    implements RemovalListener<GuidePostsKey, GuidePostsInfo> {
        PhoenixStatsCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<GuidePostsKey, GuidePostsInfo> notification) {
            RemovalCause cause;
            if (logger.isTraceEnabled() && this.wasEvicted(cause = notification.getCause())) {
                GuidePostsKey key = (GuidePostsKey)notification.getKey();
                logger.trace("Cached stats for {} with size={}bytes was evicted due to cause={}", new Object[]{key, ((GuidePostsInfo)notification.getValue()).getEstimatedSize(), cause});
            }
        }

        boolean wasEvicted(RemovalCause cause) {
            return RemovalCause.EXPLICIT != cause && RemovalCause.REPLACED != cause;
        }
    }
}

