/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.ipc.controller.InvalidateMetadataCacheControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.ServerSideRPCControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.ServerToServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.generated.ChildLinkMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessor.generated.RegionServerEndpointProtos;
import org.apache.phoenix.coprocessorclient.InvalidateServerMetadataCacheRequest;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.metrics.MetricsMetadataCachingSource;
import org.apache.phoenix.coprocessorclient.metrics.MetricsPhoenixCoprocessorSourceFactory;
import org.apache.phoenix.exception.InvalidRegionSplitPolicyException;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.exception.UpgradeBlockedException;
import org.apache.phoenix.exception.UpgradeInProgressException;
import org.apache.phoenix.exception.UpgradeNotRequiredException;
import org.apache.phoenix.exception.UpgradeRequiredException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.AbstractRPCConnectionInfo;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.ZKConnectionInfo;
import org.apache.phoenix.job.HTableThreadPoolWithUtilizationStats;
import org.apache.phoenix.log.ConnectionLimiter;
import org.apache.phoenix.log.DefaultConnectionLimiter;
import org.apache.phoenix.log.LoggingConnectionLimiter;
import org.apache.phoenix.log.QueryLoggerDisruptor;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.AdminUtilWithFallback;
import org.apache.phoenix.query.ChildLinkMetaDataServiceCallBack;
import org.apache.phoenix.query.ChildQueryServices;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.GuidePostsCacheProvider;
import org.apache.phoenix.query.GuidePostsCacheWrapper;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ConditionalTTLExpression;
import org.apache.phoenix.schema.ConnectionProperty;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.NewerSchemaAlreadyExistsException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.ConfigUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixContextExecutor;
import org.apache.phoenix.util.PhoenixStopWatch;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionQueryServicesImpl.class);
    private static final int INITIAL_CHILD_SERVICES_CAPACITY = 100;
    private static final int DEFAULT_OUT_OF_ORDER_MUTATIONS_WAIT_TIME_MS = 1000;
    private static final String ALTER_TABLE_SET_PROPS = "ALTER TABLE %s SET %s=%s";
    private final GuidePostsCacheProvider GUIDE_POSTS_CACHE_PROVIDER = new GuidePostsCacheProvider();
    protected final Configuration config;
    protected final ConnectionInfo connectionInfo;
    private final ReadOnlyProps props;
    private final String userName;
    private final User user;
    private final ConcurrentHashMap<ImmutableBytesWritable, ConnectionQueryServices> childServices;
    private final GuidePostsCacheWrapper tableStatsCache;
    private volatile PMetaData latestMetaData;
    private final Object latestMetaDataLock = new Object();
    private int lowestClusterHBaseVersion = Integer.MAX_VALUE;
    private boolean hasIndexWALCodec = true;
    @GuardedBy(value="connectionCountLock")
    private int connectionCount = 0;
    @GuardedBy(value="connectionCountLock")
    private int internalConnectionCount = 0;
    private final Object connectionCountLock = new Object();
    private final boolean returnSequenceValues;
    private Connection connection;
    private volatile boolean initialized;
    private volatile int nSequenceSaltBuckets;
    private volatile boolean closed;
    private volatile SQLException initializationException;
    private volatile ConcurrentMap<SequenceKey, Sequence> sequenceMap = Maps.newConcurrentMap();
    private KeyValueBuilder kvBuilder;
    private final int renewLeaseTaskFrequency;
    private final int renewLeasePoolSize;
    private final int renewLeaseThreshold;
    private final List<LinkedBlockingQueue<WeakReference<PhoenixConnection>>> connectionQueues;
    private ScheduledExecutorService renewLeaseExecutor;
    private PhoenixTransactionClient[] txClients = new PhoenixTransactionClient[TransactionFactory.Provider.values().length];
    private static final ThreadFactory renewLeaseThreadFactory = new RenewLeaseThreadFactory();
    private final boolean renewLeaseEnabled;
    private final boolean isAutoUpgradeEnabled;
    private final AtomicBoolean upgradeRequired = new AtomicBoolean(false);
    private final int maxConnectionsAllowed;
    private final int maxInternalConnectionsAllowed;
    private final boolean shouldThrottleNumConnections;
    public static final byte[] MUTEX_LOCKED = "MUTEX_LOCKED".getBytes(StandardCharsets.UTF_8);
    private ServerSideRPCControllerFactory serverSideRPCControllerFactory;
    private boolean localIndexUpgradeRequired;
    private final boolean enableConnectionActivityLogging;
    private final int loggingIntervalInMins;
    private final ConnectionLimiter connectionLimiter;
    private volatile List<ServerName> liveRegionServers;
    private final Object liveRegionServersLock = new Object();
    private Connection invalidateMetadataCacheConnection = null;
    private final Object invalidateMetadataCacheConnLock = new Object();
    private MetricsMetadataCachingSource metricsMetadataCachingSource;
    private ThreadPoolExecutor threadPoolExecutor = null;
    private static final AtomicInteger threadPoolNumber = new AtomicInteger(1);
    public static final String INVALIDATE_SERVER_METADATA_CACHE_EX_MESSAGE = "Cannot invalidate server metadata cache on a non-server connection";
    private final Map<ConnectionQueryServices.Feature, FeatureSupported> featureMap = ImmutableMap.of((Object)((Object)ConnectionQueryServices.Feature.LOCAL_INDEX), (Object)new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion < MetaDataProtocol.MIN_LOCAL_SI_VERSION_DISALLOW || hbaseVersion > MetaDataProtocol.MAX_LOCAL_SI_VERSION_DISALLOW;
        }
    }, (Object)((Object)ConnectionQueryServices.Feature.RENEW_LEASE), (Object)new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion >= MetaDataProtocol.MIN_RENEW_LEASE_VERSION;
        }
    });
    private QueryLoggerDisruptor queryDisruptor;
    private static final String TRUE_BYTES_AS_STRING = Bytes.toString((byte[])PDataType.TRUE_BYTES);

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    private PMetaData newEmptyMetaData() {
        return new PMetaDataImpl(100, (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(this.getProps().get("phoenix.default.update.cache.frequency")), this.getProps());
    }

    public ConnectionQueryServicesImpl(QueryServices services, ConnectionInfo connectionInfo, Properties info) {
        super(services);
        Configuration finalConfig;
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        for (Map.Entry entry : services.getProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        if (info != null) {
            for (Object key : info.keySet()) {
                config.set((String)key, info.getProperty((String)key));
            }
        }
        for (Map.Entry entry : connectionInfo.asProps()) {
            config.set((String)entry.getKey(), (String)entry.getValue());
        }
        if (connectionInfo.getPrincipal() != null) {
            config.set("phoenix.query.services.name", connectionInfo.getPrincipal());
        }
        LOGGER.info(String.format("CQS initialized with connection query service : %s", config.get("phoenix.query.services.name")));
        this.connectionInfo = connectionInfo;
        this.config = finalConfig = HBaseFactoryProvider.getConfigurationFactory().getConfiguration(config);
        if (finalConfig.getBoolean("phoenix.cqsi.thread.pool.enabled", QueryServicesOptions.DEFAULT_CQSI_THREAD_POOL_ENABLED.booleanValue())) {
            int keepAlive = finalConfig.getInt("phoenix.cqsi.thread.pool.keepalive.seconds", 60);
            int corePoolSize = finalConfig.getInt("phoenix.cqsi.thread.pool.core.size", 25);
            int maxThreads = finalConfig.getInt("phoenix.cqsi.thread.pool.max.threads", 25);
            int maxQueue = finalConfig.getInt("phoenix.cqsi.thread.pool.max.queue", 512);
            String threadPoolName = connectionInfo.getPrincipal() != null ? connectionInfo.getPrincipal() : "DEFAULT_CQSN";
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxQueue);
            Supplier<HTableThreadPoolHistograms> hTableThreadPoolHistogramsSupplier = this.getThreadPoolHistogramsSupplier(maxThreads, maxQueue);
            this.threadPoolExecutor = new HTableThreadPoolWithUtilizationStats(corePoolSize, maxThreads, keepAlive, TimeUnit.SECONDS, workQueue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CQSI-" + threadPoolName + "-" + threadPoolNumber.incrementAndGet() + "-shared-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), connectionInfo.toUrl(), hTableThreadPoolHistogramsSupplier);
            this.threadPoolExecutor.allowCoreThreadTimeOut(finalConfig.getBoolean("phoenix.cqsi.thread.pool.allow.core.thread.timeout", QueryServicesOptions.DEFAULT_CQSI_THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT.booleanValue()));
            LOGGER.info("For ConnectionQueryService = {} , CQSI ThreadPool Configs {} = {}, {} = {}, {} = {}, {} = {}, {} = {}", new Object[]{threadPoolName, "phoenix.cqsi.thread.pool.keepalive.seconds", finalConfig.get("phoenix.cqsi.thread.pool.keepalive.seconds"), "phoenix.cqsi.thread.pool.core.size", finalConfig.get("phoenix.cqsi.thread.pool.core.size"), "phoenix.cqsi.thread.pool.max.threads", finalConfig.get("phoenix.cqsi.thread.pool.max.threads"), "phoenix.cqsi.thread.pool.max.queue", finalConfig.get("phoenix.cqsi.thread.pool.max.queue"), "phoenix.cqsi.thread.pool.allow.core.thread.timeout", finalConfig.get("phoenix.cqsi.thread.pool.allow.core.thread.timeout")});
        }
        LOGGER.info("CQS Configs {} = {} , {} = {} , {} = {} , {} = {} , {} = {} , {} = {} , {} = {}, {} = {}", new Object[]{"hbase.zookeeper.quorum", finalConfig.get("hbase.zookeeper.quorum"), "hbase.client.zookeeper.quorum", finalConfig.get("hbase.client.zookeeper.quorum"), "hbase.client.zookeeper.property.clientPort", finalConfig.get("hbase.client.zookeeper.property.clientPort"), "hbase.zookeeper.property.clientPort", finalConfig.get("hbase.zookeeper.property.clientPort"), "hbase.client.bootstrap.servers", finalConfig.get("hbase.client.bootstrap.servers"), "hbase.masters", finalConfig.get("hbase.masters"), "hbase.client.registry.impl", finalConfig.get("hbase.client.registry.impl"), "phoenix.cqsi.thread.pool.enabled", finalConfig.get("phoenix.cqsi.thread.pool.enabled")});
        boolean isServerSideConnection = config.getBoolean("IS_SERVER_CONNECTION", false);
        if (isServerSideConnection) {
            this.serverSideRPCControllerFactory = new ServerSideRPCControllerFactory(config);
        }
        ConfigUtil.setReplicationConfigIfAbsent(finalConfig);
        this.props = new ReadOnlyProps(finalConfig.iterator());
        this.userName = connectionInfo.getPrincipal();
        this.user = connectionInfo.getUser();
        this.latestMetaData = this.newEmptyMetaData();
        this.childServices = new ConcurrentHashMap(100);
        String hbaseVersion = VersionInfo.getVersion();
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
        this.returnSequenceValues = this.props.getBoolean("phoenix.sequence.returnValues", false);
        this.renewLeaseEnabled = config.getBoolean("phoenix.scanner.lease.renew.enabled", true);
        this.renewLeasePoolSize = config.getInt("phoenix.scanner.lease.pool.size", 10);
        this.renewLeaseThreshold = config.getInt("phoenix.scanner.lease.threshold", 45000);
        this.renewLeaseTaskFrequency = config.getInt("phoenix.scanner.lease.renew.interval", 30000);
        ArrayList list = Lists.newArrayListWithCapacity((int)this.renewLeasePoolSize);
        for (int i = 0; i < this.renewLeasePoolSize; ++i) {
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            list.add(queue);
        }
        this.connectionQueues = ImmutableList.copyOf((Collection)list);
        this.tableStatsCache = this.GUIDE_POSTS_CACHE_PROVIDER.getGuidePostsCache(this.props.get("phoenix.guide.posts.cache.factory.class", "org.apache.phoenix.query.DefaultGuidePostsCacheFactory"), this, config);
        this.isAutoUpgradeEnabled = config.getBoolean("phoenix.autoupgrade.enabled", true);
        this.maxConnectionsAllowed = config.getInt("phoenix.client.connection.max.allowed.connections", 0);
        this.maxInternalConnectionsAllowed = config.getInt("phoenix.internal.connection.max.allowed.connections", 0);
        this.shouldThrottleNumConnections = this.maxConnectionsAllowed > 0 || this.maxInternalConnectionsAllowed > 0;
        this.enableConnectionActivityLogging = config.getBoolean("phoenix.connection.activity.logging.enabled", false);
        this.loggingIntervalInMins = config.getInt("phoenix.connection.activity.logging.interval", 15);
        if (this.enableConnectionActivityLogging) {
            builder = new LoggingConnectionLimiter.Builder(this.shouldThrottleNumConnections);
            this.connectionLimiter = ((LoggingConnectionLimiter.Builder)builder).withLoggingIntervalInMins(this.loggingIntervalInMins).withLogging(true).withMaxAllowed(this.maxConnectionsAllowed).withMaxInternalAllowed(this.maxInternalConnectionsAllowed).build();
        } else {
            builder = new DefaultConnectionLimiter.Builder(this.shouldThrottleNumConnections);
            this.connectionLimiter = ((DefaultConnectionLimiter.Builder)builder).withMaxAllowed(this.maxConnectionsAllowed).withMaxInternalAllowed(this.maxInternalConnectionsAllowed).build();
        }
        if (finalConfig.getBoolean("hbase.client.metrics.enable", false)) {
            finalConfig.set("hbase.client.metrics.scope", config.get("phoenix.query.services.name"));
        }
        if (!QueryUtil.isServerConnection(this.props)) {
            try {
                this.queryDisruptor = new QueryLoggerDisruptor(finalConfig);
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to initiate query logging service !!");
                e.printStackTrace();
            }
        }
        this.nSequenceSaltBuckets = config.getInt("phoenix.sequence.saltBuckets", 0);
        this.metricsMetadataCachingSource = MetricsPhoenixCoprocessorSourceFactory.getInstance().getMetadataCachingSource();
    }

    private Supplier<HTableThreadPoolHistograms> getThreadPoolHistogramsSupplier(final int maxThreadPoolSize, final int maxQueueSize) {
        if (this.config.getBoolean("phoenix.cqsi.thread.pool.metrics.enabled", QueryServicesOptions.DEFAULT_CQSI_THREAD_POOL_METRICS_ENABLED.booleanValue())) {
            return new Supplier<HTableThreadPoolHistograms>(){

                @Override
                public HTableThreadPoolHistograms get() {
                    HTableThreadPoolHistograms hTableThreadPoolHistograms = new HTableThreadPoolHistograms(maxThreadPoolSize, maxQueueSize);
                    if (ConnectionQueryServicesImpl.this.connectionInfo instanceof ZKConnectionInfo) {
                        hTableThreadPoolHistograms.addServerTag(((ZKConnectionInfo)ConnectionQueryServicesImpl.this.connectionInfo).getZkHosts());
                    } else if (ConnectionQueryServicesImpl.this.connectionInfo instanceof AbstractRPCConnectionInfo) {
                        hTableThreadPoolHistograms.addServerTag(((AbstractRPCConnectionInfo)ConnectionQueryServicesImpl.this.connectionInfo).getBoostrapServers());
                    } else {
                        throw new IllegalStateException("Unexpected connection info type!!");
                    }
                    String cqsiName = ConnectionQueryServicesImpl.this.connectionInfo.getPrincipal();
                    hTableThreadPoolHistograms.addCqsiNameTag(cqsiName != null ? cqsiName : "DEFAULT_CQSN");
                    return hTableThreadPoolHistograms;
                }
            };
        }
        return null;
    }

    private Connection openConnection(Configuration conf) throws SQLException {
        Connection localConnection;
        try {
            localConnection = HBaseFactoryProvider.getHConnectionFactory().createConnection(conf, this.threadPoolExecutor);
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.increment();
            LOGGER.info("HConnection established. Stacktrace for informational purposes: " + localConnection + " " + LogUtil.getCallerStackTrace());
        }
        catch (IOException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setRootCause(e).build().buildException();
        }
        if (localConnection.isClosed()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).build().buildException();
        }
        return localConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getInvalidateMetadataCacheConnection() throws SQLException {
        if (this.invalidateMetadataCacheConnection != null) {
            return this.invalidateMetadataCacheConnection;
        }
        Object object = this.invalidateMetadataCacheConnLock;
        synchronized (object) {
            Configuration clonedConfiguration = PropertiesUtil.cloneConfig(this.config);
            clonedConfiguration.setClass("hbase.rpc.controllerfactory.class", InvalidateMetadataCacheControllerFactory.class, RpcControllerFactory.class);
            this.invalidateMetadataCacheConnection = this.openConnection(clonedConfiguration);
        }
        return this.invalidateMetadataCacheConnection;
    }

    private void closeConnection(Connection connection) throws IOException {
        if (connection != null) {
            connection.close();
            LOGGER.info("{} HConnection closed. Stacktrace for informational purposes: {}", (Object)connection, (Object)LogUtil.getCallerStackTrace());
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.decrement();
        }
    }

    @Override
    public Table getTable(byte[] tableName) throws SQLException {
        try {
            return HBaseFactoryProvider.getHTableFactory().getTable(tableName, this.connection, this.threadPoolExecutor);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Table getTableIfExists(byte[] tableName) throws SQLException {
        try (Admin admin = this.getAdmin();){
            if (!AdminUtilWithFallback.tableExists(admin, TableName.valueOf((byte[])tableName))) {
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(tableName), SchemaUtil.getTableNameFromFullName(tableName));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new SQLException(e);
        }
        return this.getTable(tableName);
    }

    @Override
    public TableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        Table htable = this.getTable(tableName);
        try {
            TableDescriptor tableDescriptor = htable.getDescriptor();
            return tableDescriptor;
        }
        catch (IOException e) {
            if (e instanceof org.apache.hadoop.hbase.TableNotFoundException || e.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                byte[][] schemaAndTableName = new byte[2][];
                SchemaUtil.getVarChars(tableName, schemaAndTableName);
                throw new TableNotFoundException(Bytes.toString((byte[])schemaAndTableName[0]), Bytes.toString((byte[])schemaAndTableName[1]));
            }
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)htable);
        }
    }

    @Override
    public ReadOnlyProps getProps() {
        return this.props;
    }

    @Override
    public void closeAllConnections(SQLExceptionInfo.Builder reasonBuilder) {
        for (LinkedBlockingQueue<WeakReference<PhoenixConnection>> queue : this.connectionQueues) {
            for (WeakReference<PhoenixConnection> connectionReference : queue) {
                PhoenixConnection connection = (PhoenixConnection)connectionReference.get();
                try {
                    if (connection == null || connection.isClosed()) continue;
                    connection.close(reasonBuilder.build().buildException());
                }
                catch (SQLException e) {
                    LOGGER.warn("Exception while closing phoenix connection {}", (Object)connection, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
        synchronized (connectionQueryServicesImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.decrement();
            try {
                if (this.queryDisruptor != null) {
                    this.queryDisruptor.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SQLException sqlE = null;
            try {
                if (this.connection == null) return;
                this.returnAllSequences(this.sequenceMap);
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    this.childServices.clear();
                    PhoenixTransactionClient[] e = this.latestMetaDataLock;
                    synchronized (this.latestMetaDataLock) {
                        block83: {
                            this.latestMetaData = null;
                            this.latestMetaDataLock.notifyAll();
                            // ** MonitorExit[e] (shouldn't be in output)
                            try {
                                this.closeConnection(this.connection);
                                this.closeConnection(this.invalidateMetadataCacheConnection);
                                if (this.renewLeaseExecutor == null) break block83;
                            }
                            catch (Throwable throwable) {
                                if (this.renewLeaseExecutor != null) {
                                    this.renewLeaseExecutor.shutdownNow();
                                }
                                PhoenixTransactionClient[] phoenixTransactionClientArray = this.txClients;
                                int n = phoenixTransactionClientArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PhoenixTransactionClient client = phoenixTransactionClientArray[n2];
                                    if (client != null) {
                                        client.close();
                                    }
                                    ++n2;
                                }
                                throw throwable;
                            }
                            this.renewLeaseExecutor.shutdownNow();
                        }
                        e = this.txClients;
                        int n = e.length;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n) {
                            }
                            PhoenixTransactionClient client = e[n3];
                            if (client != null) {
                                client.close();
                            }
                            ++n3;
                        }
                    }
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ClientUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ClientUtil.parseServerException(e));
                }
                finally {
                    try {
                        this.tableStatsCache.invalidateAll();
                        super.close();
                        this.shutdownThreadPool(this.threadPoolExecutor);
                    }
                    catch (SQLException e) {
                        if (sqlE == null) {
                            sqlE = e;
                        }
                        sqlE.setNextException(e);
                    }
                    finally {
                        if (sqlE == null) return;
                        throw sqlE;
                    }
                }
            }
            return;
        }
    }

    private void shutdownThreadPool(ThreadPoolExecutor pool) {
        if (pool != null && !pool.isShutdown()) {
            pool.shutdown();
            try {
                if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                pool.shutdownNow();
            }
        }
    }

    protected ConnectionQueryServices newChildQueryService() {
        return new ChildQueryServices(this);
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable tenantId) {
        ConnectionQueryServices childQueryService = this.childServices.get(tenantId);
        if (childQueryService == null) {
            childQueryService = this.newChildQueryService();
            ConnectionQueryServices prevQueryService = this.childServices.putIfAbsent(tenantId, childQueryService);
            return prevQueryService == null ? childQueryService : prevQueryService;
        }
        return childQueryService;
    }

    @Override
    public void clearTableRegionCache(TableName tableName) throws SQLException {
        try {
            this.connection.getRegionLocator(tableName).clearRegionLocationCache();
        }
        catch (IOException e) {
            LOGGER.info("Exception while clearing table region cache", (Throwable)e);
            throw new TableNotFoundException(tableName.toString());
        }
    }

    public byte[] getNextRegionStartKey(HRegionLocation regionLocation, byte[] currentKey, HRegionLocation prevRegionLocation) {
        boolean conditionTwo;
        boolean conditionOne = (Bytes.compareTo((byte[])regionLocation.getRegion().getStartKey(), (byte[])currentKey) > 0 || Bytes.compareTo((byte[])regionLocation.getRegion().getEndKey(), (byte[])currentKey) <= 0) && !Bytes.equals((byte[])currentKey, (byte[])HConstants.EMPTY_START_ROW) && !Bytes.equals((byte[])regionLocation.getRegion().getEndKey(), (byte[])HConstants.EMPTY_END_ROW);
        boolean bl = conditionTwo = prevRegionLocation != null && (Bytes.compareTo((byte[])regionLocation.getRegion().getStartKey(), (byte[])prevRegionLocation.getRegion().getEndKey()) != 0 || Bytes.compareTo((byte[])regionLocation.getRegion().getEndKey(), (byte[])prevRegionLocation.getRegion().getEndKey()) <= 0) && !Bytes.equals((byte[])prevRegionLocation.getRegion().getEndKey(), (byte[])HConstants.EMPTY_START_ROW) && !Bytes.equals((byte[])regionLocation.getRegion().getEndKey(), (byte[])HConstants.EMPTY_END_ROW);
        if (conditionOne || conditionTwo) {
            GlobalClientMetrics.GLOBAL_HBASE_COUNTER_METADATA_INCONSISTENCY.increment();
            LOGGER.warn("HBase region overlap/inconsistencies on {} , current key: {} , region startKey: {} , region endKey: {} , prev region startKey: {} , prev region endKey: {}", new Object[]{regionLocation, Bytes.toStringBinary((byte[])currentKey), Bytes.toStringBinary((byte[])regionLocation.getRegion().getStartKey()), Bytes.toStringBinary((byte[])regionLocation.getRegion().getEndKey()), prevRegionLocation == null ? "null" : Bytes.toStringBinary((byte[])prevRegionLocation.getRegion().getStartKey()), prevRegionLocation == null ? "null" : Bytes.toStringBinary((byte[])prevRegionLocation.getRegion().getEndKey())});
        }
        return regionLocation.getRegion().getEndKey();
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        int queryTimeout = this.getProps().getInt("phoenix.query.timeoutMs", 600000);
        return this.getTableRegions(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, queryTimeout);
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName, int queryTimeout) throws SQLException {
        return this.getTableRegions(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, queryTimeout);
    }

    @Override
    public List<HRegionLocation> getTableRegions(byte[] tableName, byte[] startRowKey, byte[] endRowKey) throws SQLException {
        int queryTimeout = this.getProps().getInt("phoenix.query.timeoutMs", 600000);
        return this.getTableRegions(tableName, startRowKey, endRowKey, queryTimeout);
    }

    @Override
    public List<HRegionLocation> getTableRegions(byte[] tableName, byte[] startRowKey, byte[] endRowKey, int queryTimeout) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = this.config.getInt("phoenix.get.table.regions.retries", 10);
        TableName table = TableName.valueOf((byte[])tableName);
        byte[] currentKey = null;
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        long maxQueryEndTime = startTime + (long)queryTimeout;
        while (true) {
            try {
                ArrayList locations = Lists.newArrayList();
                HRegionLocation prevRegionLocation = null;
                currentKey = startRowKey;
                do {
                    HRegionLocation regionLocation = this.connection.getRegionLocator(table).getRegionLocation(currentKey, false);
                    currentKey = this.getNextRegionStartKey(regionLocation, currentKey, prevRegionLocation);
                    locations.add(regionLocation);
                    prevRegionLocation = regionLocation;
                    if (!Bytes.equals((byte[])endRowKey, (byte[])HConstants.EMPTY_END_ROW) && Bytes.compareTo((byte[])currentKey, (byte[])endRowKey) >= 0) break;
                    ConnectionQueryServicesImpl.throwErrorIfQueryTimedOut(startRowKey, endRowKey, maxQueryEndTime, queryTimeout, table, retryCount, currentKey);
                } while (!Bytes.equals((byte[])currentKey, (byte[])HConstants.EMPTY_END_ROW));
                return locations;
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                TableNotFoundException ex = new TableNotFoundException(table.getNameAsString());
                e.initCause((Throwable)ex);
                throw ex;
            }
            catch (IOException e) {
                LOGGER.error("Exception encountered in getAllTableRegions for table: {}, retryCount: {} , currentKey: {} , startRowKey: {} , endRowKey: {}", new Object[]{table.getNameAsString(), retryCount, Bytes.toStringBinary((byte[])currentKey), Bytes.toStringBinary((byte[])startRowKey), Bytes.toStringBinary((byte[])endRowKey), e});
                if (retryCount++ < maxRetryCount) continue;
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    private static void throwErrorIfQueryTimedOut(byte[] startRowKey, byte[] endRowKey, long maxQueryEndTime, int queryTimeout, TableName table, int retryCount, byte[] currentKey) throws SQLException {
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        if (currentTime >= maxQueryEndTime) {
            LOGGER.error("getTableRegions has exceeded query timeout {} ms.Table: {}, retryCount: {} , currentKey: {} , startRowKey: {} , endRowKey: {}", new Object[]{queryTimeout, table.getNameAsString(), retryCount, Bytes.toStringBinary((byte[])currentKey), Bytes.toStringBinary((byte[])startRowKey), Bytes.toStringBinary((byte[])endRowKey)});
            String message = "getTableRegions has exceeded query timeout " + queryTimeout + "ms";
            IOException e = new IOException(message);
            throw new SQLTimeoutException(message, SQLExceptionCode.OPERATION_TIMED_OUT.getSQLState(), SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), e);
        }
    }

    @Override
    public PMetaData getMetaDataCache() {
        return this.latestMetaData;
    }

    @Override
    public int getConnectionCount(boolean isInternal) {
        if (isInternal) {
            return this.connectionLimiter.getInternalConnectionCount();
        }
        return this.connectionLimiter.getConnectionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PTableRef existingTableRef = this.latestMetaData.getTableRef(new PTableKey(table.getTenantId(), table.getName().getString()));
                PTable existingTable = existingTableRef.getTable();
                if (existingTable.getTimeStamp() > table.getTimeStamp()) {
                    return;
                }
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            this.latestMetaData.addTable(table, resolvedTime);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTime) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.updateResolvedTimestamp(table, resolvedTime);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMetaData metaDataMutated(PName tenantId, String tableName, long tableSeqNum, Mutator mutator) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            PMetaData metaData = this.latestMetaData;
            long endTime = EnvironmentEdgeManager.currentTimeMillis() + 1000L;
            try {
                while (true) {
                    long waitTime;
                    block11: {
                        try {
                            PTable table = metaData.getTableRef(new PTableKey(tenantId, tableName)).getTable();
                            if (table.getSequenceNumber() + 1L == tableSeqNum) {
                                mutator.mutate(metaData);
                                break;
                            }
                            if (table.getSequenceNumber() < tableSeqNum) break block11;
                            LOGGER.warn("Attempt to cache older version of " + tableName + ": current= " + table.getSequenceNumber() + ", new=" + tableSeqNum);
                            break;
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                            // empty catch block
                        }
                    }
                    if ((waitTime = endTime - EnvironmentEdgeManager.currentTimeMillis()) <= 0L) {
                        LOGGER.warn("Unable to update meta data repo within 1 seconds for " + tableName);
                        metaData.removeTable(tenantId, tableName, null, Long.MAX_VALUE);
                        break;
                    }
                    this.latestMetaDataLock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            this.latestMetaData = metaData;
            this.latestMetaDataLock.notifyAll();
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
            this.latestMetaDataLock.notifyAll();
        }
    }

    @Override
    public void removeColumn(final PName tenantId, final String tableName, final List<PColumn> columnsToRemove, final long tableTimeStamp, final long tableSeqNum, final long resolvedTime) throws SQLException {
        this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public void mutate(PMetaData metaData) throws SQLException {
                try {
                    metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    private void validateConnectionProperties(Properties info) {
        if (info.get("phoenix.default.update.cache.frequency") != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Connection's phoenix.default.update.cache.frequency set to " + info.get("phoenix.default.update.cache.frequency"));
            }
            ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(info.getProperty("phoenix.default.update.cache.frequency"));
        }
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        this.checkClosed();
        this.throwConnectionClosedIfNullMetaData();
        this.validateConnectionProperties(info);
        return new PhoenixConnection(this, url, info);
    }

    private ColumnFamilyDescriptor generateColumnFamilyDescriptor(Pair<byte[], Map<String, Object>> family, PTableType tableType) throws SQLException {
        ColumnFamilyDescriptorBuilder columnDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])((byte[])family.getFirst()));
        if (tableType != PTableType.VIEW) {
            columnDescBuilder.setDataBlockEncoding(SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING);
            for (Map.Entry entry : ((Map)family.getSecond()).entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ConnectionQueryServicesImpl.setHColumnDescriptorValue(columnDescBuilder, key, value);
            }
        }
        return columnDescBuilder.build();
    }

    private static void setHColumnDescriptorValue(ColumnFamilyDescriptorBuilder columnDescBuilder, String key, Object value) {
        if ("VERSIONS".equals(key)) {
            columnDescBuilder.setMaxVersions(ConnectionQueryServicesImpl.getMaxVersion(value));
        } else {
            columnDescBuilder.setValue(key, value == null ? null : value.toString());
        }
    }

    private static int getMaxVersion(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String stringValue = value.toString();
        if (stringValue.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(stringValue);
    }

    private void modifyColumnFamilyDescriptor(ColumnFamilyDescriptorBuilder hcd, Map<String, Object> props) throws SQLException {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String propName = entry.getKey();
            Object value = entry.getValue();
            ConnectionQueryServicesImpl.setHColumnDescriptorValue(hcd, propName, value);
        }
    }

    private void modifyTableDescriptor(TableDescriptorBuilder td, Map<String, Object> props) {
        if (props != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String propName = entry.getKey();
                Object value = entry.getValue();
                td.setValue(propName, value == null ? null : value.toString());
            }
        }
    }

    private TableDescriptorBuilder generateTableDescriptor(byte[] physicalTableName, byte[] parentPhysicalTableName, TableDescriptor existingDesc, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped) throws SQLException {
        Object defaultFamilyBytes;
        String defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
        TableDescriptorBuilder tableDescriptorBuilder = existingDesc != null ? TableDescriptorBuilder.newBuilder((TableDescriptor)existingDesc) : TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])physicalTableName));
        ColumnFamilyDescriptor dataTableColDescForIndexTablePropSyncing = null;
        boolean doNotAddGlobalIndexChecker = false;
        if (tableType == PTableType.INDEX || MetaDataUtil.isViewIndex(Bytes.toString((byte[])physicalTableName))) {
            defaultFamilyBytes = defaultFamilyName == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : Bytes.toBytes((String)defaultFamilyName);
            Object object = defaultFamilyBytes;
            TableDescriptor baseTableDesc = MetaDataUtil.isViewIndex(Bytes.toString((byte[])physicalTableName)) ? this.getTableDescriptor(parentPhysicalTableName) : (existingDesc == null ? this.getTableDescriptor(SchemaUtil.getPhysicalTableName(Bytes.toBytes((String)((String)tableProps.get("DATA_TABLE_NAME"))), isNamespaceMapped).getName()) : existingDesc);
            String baseTableMaxLookbackVal = baseTableDesc.getValue("phoenix.max.lookback.age.seconds");
            if (baseTableMaxLookbackVal != null) {
                tableProps.put("phoenix.max.lookback.age.seconds", baseTableMaxLookbackVal);
            }
            if ((dataTableColDescForIndexTablePropSyncing = baseTableDesc.getColumnFamily(defaultFamilyBytes)) == null) {
                dataTableColDescForIndexTablePropSyncing = baseTableDesc.getColumnFamilies()[0];
            }
            if (baseTableDesc.hasCoprocessor("org.apache.phoenix.hbase.index.Indexer")) {
                doNotAddGlobalIndexChecker = true;
            }
        }
        defaultFamilyBytes = tableProps.entrySet().iterator();
        while (defaultFamilyBytes.hasNext()) {
            Map.Entry entry = (Map.Entry)defaultFamilyBytes.next();
            String key = (String)entry.getKey();
            if (TableProperty.isPhoenixTableProperty(key)) continue;
            Object value = entry.getValue();
            tableDescriptorBuilder.setValue(key, value == null ? null : value.toString());
        }
        Map<String, Object> syncedProps = MetaDataUtil.getSyncedProps(dataTableColDescForIndexTablePropSyncing);
        for (Pair<byte[], Map<String, Object>> family : families) {
            ColumnFamilyDescriptor columnDescriptor;
            byte[] familyByte = (byte[])family.getFirst();
            if (tableDescriptorBuilder.build().getColumnFamily(familyByte) == null) {
                if (tableType == PTableType.VIEW) {
                    String fullTableName = Bytes.toString((byte[])physicalTableName);
                    throw new ReadOnlyTableException("The HBase column families for a read-only table must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), Bytes.toString((byte[])familyByte));
                }
                columnDescriptor = this.generateColumnFamilyDescriptor(family, tableType);
                if ((tableType == PTableType.INDEX || MetaDataUtil.isViewIndex(Bytes.toString((byte[])physicalTableName))) && syncedProps != null && !syncedProps.isEmpty()) {
                    ColumnFamilyDescriptorBuilder colFamDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)columnDescriptor);
                    this.modifyColumnFamilyDescriptor(colFamDescBuilder, syncedProps);
                    columnDescriptor = colFamDescBuilder.build();
                }
                tableDescriptorBuilder.setColumnFamily(columnDescriptor);
                continue;
            }
            if (tableType == PTableType.VIEW) continue;
            columnDescriptor = tableDescriptorBuilder.build().getColumnFamily(familyByte);
            if (columnDescriptor == null) {
                throw new IllegalArgumentException("Unable to find column descriptor with family name " + Bytes.toString((byte[])((byte[])family.getFirst())));
            }
            ColumnFamilyDescriptorBuilder columnDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)columnDescriptor);
            this.modifyColumnFamilyDescriptor(columnDescriptorBuilder, (Map)family.getSecond());
            tableDescriptorBuilder.modifyColumnFamily(columnDescriptorBuilder.build());
        }
        this.addCoprocessors(physicalTableName, tableDescriptorBuilder, tableType, tableProps, existingDesc, doNotAddGlobalIndexChecker);
        if (tableType == PTableType.SYSTEM) {
            tableDescriptorBuilder.setValue("PRIORITY", String.valueOf(IndexUtil.getMetadataPriority(this.config)));
        } else if (tableType == PTableType.INDEX && !this.isLocalIndexTable(tableDescriptorBuilder.build().getColumnFamilyNames()) && !Boolean.TRUE.equals(tableProps.get("IMMUTABLE_ROWS"))) {
            tableDescriptorBuilder.setValue("PRIORITY", String.valueOf(IndexUtil.getIndexPriority(this.config)));
        }
        return tableDescriptorBuilder;
    }

    private boolean isLocalIndexTable(Collection<byte[]> families) {
        for (byte[] family : families) {
            if (!Bytes.toString((byte[])family).startsWith("L#")) continue;
            return true;
        }
        return false;
    }

    private void addCoprocessors(byte[] tableName, TableDescriptorBuilder builder, PTableType tableType, Map<String, Object> tableProps, TableDescriptor existingDesc, boolean doNotAddGlobalIndexChecker) throws SQLException {
        int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
        try {
            TableDescriptor newDesc = builder.build();
            TransactionFactory.Provider provider = this.getTransactionProvider(tableProps);
            boolean isTransactional = provider != null;
            boolean indexRegionObserverEnabled = this.config.getBoolean("phoenix.index.region.observer.enabled", true);
            boolean isViewIndex = TRUE_BYTES_AS_STRING.equals(tableProps.get("IS_VIEW_INDEX_TABLE"));
            boolean isViewBaseTransactional = false;
            if (!isTransactional && isViewIndex && tableProps.containsKey("TRANSACTIONAL") && Boolean.TRUE.equals(tableProps.get("TRANSACTIONAL"))) {
                isViewBaseTransactional = true;
            }
            if (!(isTransactional || isViewBaseTransactional || tableType != PTableType.INDEX && !isViewIndex)) {
                if (!indexRegionObserverEnabled && newDesc.hasCoprocessor("org.apache.phoenix.index.GlobalIndexChecker")) {
                    builder.removeCoprocessor("org.apache.phoenix.index.GlobalIndexChecker");
                } else if (indexRegionObserverEnabled && !newDesc.hasCoprocessor("org.apache.phoenix.index.GlobalIndexChecker") && !this.isLocalIndexTable(newDesc.getColumnFamilyNames())) {
                    if (newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver")) {
                        builder.removeCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver");
                    }
                    if (!doNotAddGlobalIndexChecker) {
                        builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.index.GlobalIndexChecker").setPriority(priority - 1).build());
                    }
                }
            }
            if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.ScanRegionObserver")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.ScanRegionObserver").setPriority(priority).build());
            }
            if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver").setPriority(priority).build());
            }
            if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver").setPriority(priority).build());
            }
            if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.ServerCachingEndpointImpl")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.ServerCachingEndpointImpl").setPriority(priority).build());
            }
            if (tableType != PTableType.INDEX && tableType != PTableType.VIEW && !isViewIndex && !SchemaUtil.isStatsTable(tableName)) {
                if (isTransactional) {
                    if (!newDesc.hasCoprocessor("org.apache.phoenix.index.PhoenixTransactionalIndexer")) {
                        builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.index.PhoenixTransactionalIndexer").setPriority(priority).build());
                    }
                    if (newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.Indexer")) {
                        builder.removeCoprocessor("org.apache.phoenix.hbase.index.Indexer");
                    }
                    if (newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver")) {
                        builder.removeCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver");
                    }
                } else {
                    if (newDesc.hasCoprocessor("org.apache.phoenix.index.PhoenixTransactionalIndexer")) {
                        builder.removeCoprocessor("org.apache.phoenix.index.PhoenixTransactionalIndexer");
                    }
                    if (!this.doesPhoenixTableAlreadyExist(existingDesc)) {
                        if (indexRegionObserverEnabled) {
                            if (newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.Indexer")) {
                                builder.removeCoprocessor("org.apache.phoenix.hbase.index.Indexer");
                            }
                            if (!newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver")) {
                                opts = Maps.newHashMapWithExpectedSize((int)1);
                                opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                                IndexUtil.enableIndexing(builder, "org.apache.phoenix.index.PhoenixIndexBuilder", opts, priority, "org.apache.phoenix.hbase.index.IndexRegionObserver");
                            }
                        } else {
                            if (newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver")) {
                                builder.removeCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver");
                            }
                            if (!newDesc.hasCoprocessor("org.apache.phoenix.hbase.index.Indexer")) {
                                opts = Maps.newHashMapWithExpectedSize((int)1);
                                opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                                IndexUtil.enableIndexing(builder, "org.apache.phoenix.index.PhoenixIndexBuilder", opts, priority, "org.apache.phoenix.hbase.index.Indexer");
                            }
                        }
                    }
                }
            }
            if ((SchemaUtil.isStatsTable(tableName) || SchemaUtil.isMetaTable(tableName)) && !newDesc.hasCoprocessor("org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint").setPriority(priority).setProperties(Collections.emptyMap()).build());
            }
            Set familiesKeys = builder.build().getColumnFamilyNames();
            for (byte[] family : familiesKeys) {
                if (!Bytes.toString((byte[])family).startsWith("L#") || newDesc.hasCoprocessor("org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReaderGenerator")) continue;
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReaderGenerator").setPriority(priority).setProperties(Collections.emptyMap()).build());
                break;
            }
            if (SchemaUtil.isMetaTable(tableName) || SchemaUtil.isFunctionTable(tableName)) {
                if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.MetaDataEndpointImpl")) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.MetaDataEndpointImpl").setPriority(priority).setProperties(Collections.emptyMap()).build());
                }
                if (SchemaUtil.isMetaTable(tableName) && !newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.MetaDataRegionObserver")) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.MetaDataRegionObserver").setPriority(priority + 1).setProperties(Collections.emptyMap()).build());
                }
            } else if (SchemaUtil.isSequenceTable(tableName)) {
                if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.SequenceRegionObserver")) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.SequenceRegionObserver").setPriority(priority).setProperties(Collections.emptyMap()).build());
                }
            } else if (SchemaUtil.isTaskTable(tableName)) {
                if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.TaskRegionObserver")) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.TaskRegionObserver").setPriority(priority).setProperties(Collections.emptyMap()).build());
                }
                if (!newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.TaskMetaDataEndpoint")) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.TaskMetaDataEndpoint").setPriority(priority).setProperties(Collections.emptyMap()).build());
                }
            } else if (SchemaUtil.isChildLinkTable(tableName) && !newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.ChildLinkMetaDataEndpoint")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.ChildLinkMetaDataEndpoint").setPriority(priority).setProperties(Collections.emptyMap()).build());
            }
            if (isTransactional) {
                String coprocessorGCClassName;
                String coprocessorClassName = provider.getTransactionProvider().getCoprocessorClassName();
                if (!newDesc.hasCoprocessor(coprocessorClassName)) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)coprocessorClassName).setPriority(priority - 10).setProperties(Collections.emptyMap()).build());
                }
                if ((coprocessorGCClassName = provider.getTransactionProvider().getGCCoprocessorClassName()) != null && !newDesc.hasCoprocessor(coprocessorGCClassName)) {
                    builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)coprocessorGCClassName).setPriority(priority - 10).setProperties(Collections.emptyMap()).build());
                }
            } else {
                for (TransactionFactory.Provider aprovider : TransactionFactory.Provider.available()) {
                    String coprocessorClassName = aprovider.getTransactionProvider().getCoprocessorClassName();
                    String coprocessorGCClassName = aprovider.getTransactionProvider().getGCCoprocessorClassName();
                    if (coprocessorClassName != null && newDesc.hasCoprocessor(coprocessorClassName)) {
                        builder.removeCoprocessor(coprocessorClassName);
                    }
                    if (coprocessorGCClassName == null || !newDesc.hasCoprocessor(coprocessorGCClassName)) continue;
                    builder.removeCoprocessor(coprocessorGCClassName);
                }
            }
            if (newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.PhoenixTTLRegionObserver")) {
                builder.removeCoprocessor("org.apache.phoenix.coprocessor.PhoenixTTLRegionObserver");
            }
            if (Arrays.equals(tableName, SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.props).getName()) && !newDesc.hasCoprocessor("org.apache.phoenix.coprocessor.SystemCatalogRegionObserver")) {
                builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.SystemCatalogRegionObserver").setPriority(priority).setProperties(Collections.emptyMap()).build());
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    private TransactionFactory.Provider getTransactionProvider(Map<String, Object> tableProps) {
        TransactionFactory.Provider provider = (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(tableProps));
        return provider;
    }

    private boolean doesPhoenixTableAlreadyExist(TableDescriptor existingDesc) {
        if (existingDesc == null) {
            return false;
        }
        boolean hasScanObserver = existingDesc.hasCoprocessor("org.apache.phoenix.coprocessor.ScanRegionObserver");
        boolean hasUnAggObserver = existingDesc.hasCoprocessor("org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver");
        boolean hasGroupedObserver = existingDesc.hasCoprocessor("org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver");
        boolean hasIndexObserver = existingDesc.hasCoprocessor("org.apache.phoenix.hbase.index.Indexer") || existingDesc.hasCoprocessor("org.apache.phoenix.hbase.index.IndexRegionObserver") || existingDesc.hasCoprocessor("org.apache.phoenix.index.GlobalIndexChecker");
        return hasScanObserver && hasUnAggObserver && hasGroupedObserver && hasIndexObserver;
    }

    private void pollForUpdatedTableDescriptor(final Admin admin, final TableDescriptor newTableDescriptor, final byte[] tableName) throws InterruptedException, TimeoutException {
        this.checkAndRetry(new RetriableOperation(){

            @Override
            public String getOperationName() {
                return "UpdateOrNewTableDescriptor";
            }

            @Override
            public boolean checkForCompletion() throws TimeoutException, IOException {
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((byte[])tableName));
                return newTableDescriptor.equals(tableDesc);
            }
        });
    }

    private void checkAndRetry(RetriableOperation op) throws InterruptedException, TimeoutException {
        int maxRetries = this.props.getInt("phoenix.schema.change.retries", 50);
        long sleepInterval = this.props.getLong("phoenix.schema.change.delay", 1000L);
        boolean success = false;
        int numTries = 0;
        PhoenixStopWatch watch = new PhoenixStopWatch();
        watch.start();
        do {
            block5: {
                try {
                    success = op.checkForCompletion();
                }
                catch (Exception ex) {
                    if (numTries != 0) break block5;
                    watch.stop();
                    TimeoutException toThrow = new TimeoutException("Operation " + op.getOperationName() + " didn't complete because of exception. Time elapsed: " + watch.elapsedMillis());
                    toThrow.initCause(ex);
                    throw toThrow;
                }
            }
            if (++numTries >= maxRetries || success) continue;
            Thread.sleep(sleepInterval);
        } while (numTries < maxRetries && !success);
        watch.stop();
        if (!success) {
            throw new TimeoutException("Operation  " + op.getOperationName() + " didn't complete within " + watch.elapsedMillis() + " ms after trying " + numTries + "times.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Operation " + op.getOperationName() + " completed within " + watch.elapsedMillis() + "ms after trying " + numTries + " times.");
        }
    }

    private boolean allowOnlineTableSchemaUpdate() {
        return this.props.getBoolean("hbase.online.schema.update.enable", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureNamespaceCreated(String schemaName) throws SQLException {
        boolean createdNamespace;
        block12: {
            SQLException sqlE = null;
            createdNamespace = false;
            try (Admin admin = this.getAdmin();){
                if (!ClientUtil.isHBaseNamespaceAvailable(admin, schemaName)) {
                    NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)schemaName).build();
                    admin.createNamespace(namespaceDescriptor);
                    createdNamespace = true;
                }
            }
            catch (IOException e) {
                sqlE = ClientUtil.parseServerException(e);
                return (boolean)sqlE;
            }
            finally {
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return createdNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDescriptor ensureTableCreated(byte[] physicalTableName, byte[] parentPhysicalTableName, PTableType tableType, Map<String, Object> props, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean modifyExistingMetaData, boolean isNamespaceMapped, boolean isDoNotUpgradePropSet) throws SQLException {
        block77: {
            SQLException sqlE = null;
            TableDescriptor existingDesc = null;
            boolean isMetaTable = SchemaUtil.isMetaTable(physicalTableName);
            boolean tableExist = true;
            try {
                TableDescriptor tableDescriptor;
                block76: {
                    TableDescriptor result;
                    TableDescriptorBuilder newDesc;
                    Admin admin;
                    block74: {
                        TableDescriptor tableDescriptor2;
                        block75: {
                            boolean willBeTx;
                            block72: {
                                TableDescriptor possibleCompatException22;
                                block73: {
                                    block70: {
                                        TableDescriptor possibleCompatException22;
                                        block71: {
                                            boolean createdNamespace;
                                            block69: {
                                                block67: {
                                                    TableDescriptor possibleCompatException32;
                                                    block68: {
                                                        admin = this.getAdmin();
                                                        String quorum = ZKConfig.getZKQuorumServersString((Configuration)this.config);
                                                        String znode = this.getProps().get("zookeeper.znode.parent");
                                                        createdNamespace = false;
                                                        LOGGER.debug("Found quorum: " + quorum + ":" + znode);
                                                        if (!isMetaTable) break block67;
                                                        if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                                                            try {
                                                                createdNamespace = this.ensureNamespaceCreated("SYSTEM");
                                                            }
                                                            catch (PhoenixIOException phoenixIOException) {
                                                                // empty catch block
                                                            }
                                                            if (AdminUtilWithFallback.tableExists(admin, SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, false))) {
                                                                try {
                                                                    this.checkClientServerCompatibility(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
                                                                }
                                                                catch (SQLException possibleCompatException4) {
                                                                    if (createdNamespace && possibleCompatException4.getErrorCode() == SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode()) {
                                                                        this.ensureNamespaceDropped("SYSTEM");
                                                                    }
                                                                    throw possibleCompatException4;
                                                                }
                                                                throw new UpgradeRequiredException(42L);
                                                            }
                                                        } else if (AdminUtilWithFallback.tableExists(admin, SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true))) {
                                                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES).setMessage("Cannot initiate connection as " + SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true) + " is found but client does not have phoenix.schema.isNamespaceMappingEnabled enabled").build().buildException();
                                                        }
                                                        if (!isDoNotUpgradePropSet) break block67;
                                                        try {
                                                            this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                        }
                                                        catch (SQLException possibleCompatException32) {
                                                            if (possibleCompatException32.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                                                                throw new UpgradeRequiredException(42L);
                                                            }
                                                            throw possibleCompatException32;
                                                        }
                                                        possibleCompatException32 = null;
                                                        if (admin == null) break block68;
                                                        admin.close();
                                                    }
                                                    return possibleCompatException32;
                                                }
                                                try {
                                                    existingDesc = admin.getDescriptor(TableName.valueOf((byte[])physicalTableName));
                                                }
                                                catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                                                    tableExist = false;
                                                    if (tableType != PTableType.VIEW) break block69;
                                                    String fullTableName = Bytes.toString((byte[])physicalTableName);
                                                    throw new ReadOnlyTableException("An HBase table for a VIEW must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
                                                }
                                            }
                                            newDesc = this.generateTableDescriptor(physicalTableName, parentPhysicalTableName, existingDesc, tableType, props, families, splits, isNamespaceMapped);
                                            if (LOGGER.isDebugEnabled()) {
                                                LOGGER.debug("ensureTableCreated physicalTableName = {}, parentPhysicalTableName = {}, isUpgradeRequired = {}, isAutoUpgradeEnabled = {}, isDoNotUpgradePropSet = {}, isNamespaceMapped = {}, createdNamespace = {}", new Object[]{Bytes.toString((byte[])physicalTableName), Bytes.toString((byte[])parentPhysicalTableName), this.isUpgradeRequired(), this.isAutoUpgradeEnabled, isDoNotUpgradePropSet, isNamespaceMapped, createdNamespace});
                                            }
                                            if (tableExist) break block70;
                                            if (!(!SchemaUtil.isSystemTable(physicalTableName) || tableType != PTableType.TABLE && tableType != PTableType.SYSTEM || this.isUpgradeRequired() || this.isAutoUpgradeEnabled && !isDoNotUpgradePropSet)) {
                                                throw new UpgradeRequiredException();
                                            }
                                            if (newDesc.build().getValue(MetaDataUtil.IS_LOCAL_INDEX_TABLE_PROP_BYTES) != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(newDesc.build().getValue(MetaDataUtil.IS_LOCAL_INDEX_TABLE_PROP_BYTES)))) {
                                                newDesc.setRegionSplitPolicyClassName("org.apache.phoenix.hbase.index.IndexRegionSplitPolicy");
                                            }
                                            try {
                                                if (splits == null) {
                                                    admin.createTable(newDesc.build());
                                                } else {
                                                    admin.createTable(newDesc.build(), splits);
                                                }
                                            }
                                            catch (TableExistsException e) {
                                                if (isMetaTable && !this.isUpgradeRequired()) {
                                                    this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                }
                                                TableDescriptor tableDescriptor3 = null;
                                                if (admin != null) {
                                                    admin.close();
                                                }
                                                if (sqlE != null) {
                                                    throw sqlE;
                                                }
                                                return tableDescriptor3;
                                            }
                                            if (isMetaTable && !this.isUpgradeRequired()) {
                                                try {
                                                    this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                }
                                                catch (SQLException possibleCompatException22) {
                                                    if (possibleCompatException22.getErrorCode() == SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode()) {
                                                        try {
                                                            this.disableTable(admin, TableName.valueOf((byte[])physicalTableName));
                                                            admin.deleteTable(TableName.valueOf((byte[])physicalTableName));
                                                        }
                                                        catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                                                            // empty catch block
                                                        }
                                                        if (createdNamespace && SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                                                            this.ensureNamespaceDropped("SYSTEM");
                                                        }
                                                    }
                                                    throw possibleCompatException22;
                                                }
                                            }
                                            possibleCompatException22 = null;
                                            if (admin == null) break block71;
                                            admin.close();
                                        }
                                        return possibleCompatException22;
                                    }
                                    try {
                                        if (isMetaTable && !this.isUpgradeRequired()) {
                                            this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                        } else {
                                            for (Pair<byte[], Map<String, Object>> family : families) {
                                                if (!Bytes.toString((byte[])((byte[])family.getFirst())).startsWith("L#")) continue;
                                                newDesc.setRegionSplitPolicyClassName("org.apache.phoenix.hbase.index.IndexRegionSplitPolicy");
                                                break;
                                            }
                                        }
                                        if (modifyExistingMetaData) break block72;
                                        possibleCompatException22 = existingDesc;
                                        if (admin == null) break block73;
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if (admin != null) {
                                                try {
                                                    admin.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        catch (IOException e) {
                                            sqlE = ClientUtil.parseServerException(e);
                                            if (sqlE != null) {
                                                throw sqlE;
                                            }
                                            break block77;
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                            sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                                            return sqlE;
                                        }
                                        catch (TimeoutException e) {
                                            sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
                                            return sqlE;
                                        }
                                    }
                                    admin.close();
                                }
                                return possibleCompatException22;
                            }
                            TransactionFactory.Provider provider = this.getTransactionProvider(props);
                            boolean bl = willBeTx = provider != null;
                            if (willBeTx) {
                                if (!ConnectionQueryServicesImpl.equalTxCoprocessor(provider, existingDesc, newDesc.build())) {
                                    if (ConnectionQueryServicesImpl.hasTxCoprocessor(existingDesc)) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SWITCH_TXN_PROVIDERS).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                    }
                                    if (provider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL).setMessage(provider.name()).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                    }
                                    newDesc.setValue("data.tx.read.pre.existing", Boolean.TRUE.toString());
                                }
                            } else {
                                if (ConnectionQueryServicesImpl.hasTxCoprocessor(existingDesc)) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                }
                                newDesc.removeValue(Bytes.toBytes((String)"data.tx.read.pre.existing"));
                            }
                            if (!existingDesc.equals(result = newDesc.build())) break block74;
                            tableDescriptor2 = null;
                            if (admin == null) break block75;
                            admin.close();
                        }
                        return tableDescriptor2;
                    }
                    if (tableType != PTableType.SYSTEM) {
                        this.modifyTable(physicalTableName, newDesc.build(), true);
                    }
                    tableDescriptor = result;
                    if (admin == null) break block76;
                    admin.close();
                }
                return tableDescriptor;
            }
            finally {
                if (sqlE == null) break block77;
                throw sqlE;
            }
        }
        return null;
    }

    @VisibleForTesting
    public boolean updateAndConfirmSplitPolicyForTask(TableDescriptorBuilder tdBuilder) throws SQLException {
        boolean isTaskTable = false;
        TableName sysTaskTable = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME, this.props);
        if (tdBuilder.build().getTableName().equals((Object)sysTaskTable)) {
            isTaskTable = true;
        }
        if (isTaskTable) {
            String actualSplitPolicy = tdBuilder.build().getRegionSplitPolicyClassName();
            String targetSplitPolicy = "org.apache.phoenix.schema.SystemTaskSplitPolicy";
            if (!"org.apache.phoenix.schema.SystemTaskSplitPolicy".equals(actualSplitPolicy)) {
                if (StringUtils.isNotEmpty((CharSequence)actualSplitPolicy)) {
                    throw new InvalidRegionSplitPolicyException("SYSTEM", "TASK", (List<String>)ImmutableList.of((Object)"null", (Object)"org.apache.phoenix.schema.SystemTaskSplitPolicy"), actualSplitPolicy);
                }
                tdBuilder.setRegionSplitPolicyClassName("org.apache.phoenix.schema.SystemTaskSplitPolicy");
                return true;
            }
        }
        return false;
    }

    private static boolean hasTxCoprocessor(TableDescriptor descriptor) {
        for (TransactionFactory.Provider provider : TransactionFactory.Provider.available()) {
            String coprocessorClassName = provider.getTransactionProvider().getCoprocessorClassName();
            if (coprocessorClassName == null || !descriptor.hasCoprocessor(coprocessorClassName)) continue;
            return true;
        }
        return false;
    }

    private static boolean equalTxCoprocessor(TransactionFactory.Provider provider, TableDescriptor existingDesc, TableDescriptor newDesc) {
        String coprocessorClassName = provider.getTransactionProvider().getCoprocessorClassName();
        return coprocessorClassName != null && existingDesc.hasCoprocessor(coprocessorClassName) && newDesc.hasCoprocessor(coprocessorClassName);
    }

    private void modifyTable(byte[] tableName, TableDescriptor newDesc, boolean shouldPoll) throws IOException, InterruptedException, TimeoutException, SQLException {
        TableName tn = TableName.valueOf((byte[])tableName);
        try (Admin admin = this.getAdmin();){
            if (!this.allowOnlineTableSchemaUpdate()) {
                this.disableTable(admin, tn);
                admin.modifyTable(newDesc);
                admin.enableTable(tn);
            } else {
                admin.modifyTable(newDesc);
                if (shouldPoll) {
                    this.pollForUpdatedTableDescriptor(admin, newDesc, tableName);
                }
            }
        }
    }

    private static boolean hasIndexWALCodec(Long serverVersion) {
        if (serverVersion == null) {
            return true;
        }
        return MetaDataUtil.decodeHasIndexWALCodec(serverVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClientServerCompatibility(byte[] metaTable) throws SQLException, AccessDeniedException {
        StringBuilder errorMessage = new StringBuilder();
        int minHBaseVersion = Integer.MAX_VALUE;
        boolean isTableNamespaceMappingEnabled = false;
        long systemCatalogTimestamp = Long.MAX_VALUE;
        long startTime = 0L;
        Table ht = null;
        try {
            Map results;
            try {
                startTime = EnvironmentEdgeManager.currentTimeMillis();
                ht = this.getTable(metaTable);
                byte[] tableKey = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES;
                results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.GetVersionResponse>(){

                    public MetaDataProtos.GetVersionResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        RpcController controller = ConnectionQueryServicesImpl.this.getController();
                        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                        MetaDataProtos.GetVersionRequest.Builder builder = MetaDataProtos.GetVersionRequest.newBuilder();
                        builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                        instance.getVersion(controller, builder.build(), (RpcCallback<MetaDataProtos.GetVersionResponse>)rpcCallback);
                        ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                        return (MetaDataProtos.GetVersionResponse)rpcCallback.get();
                    }
                });
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, 1L);
            }
            catch (Throwable e) {
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES, 1L);
                throw ClientUtil.parseServerException(e);
            }
            finally {
                long systemCatalogRpcTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, systemCatalogRpcTime);
            }
            for (Map.Entry result : results.entrySet()) {
                MetaDataProtos.GetVersionResponse versionResponse = (MetaDataProtos.GetVersionResponse)result.getValue();
                long serverJarVersion = versionResponse.getVersion();
                isTableNamespaceMappingEnabled |= MetaDataUtil.decodeTableNamespaceMappingEnabled(serverJarVersion);
                MetaDataUtil.ClientServerCompatibility compatibility = MetaDataUtil.areClientAndServerCompatible(serverJarVersion);
                if (!compatibility.getIsCompatible()) {
                    if (compatibility.getErrorCode() == SQLExceptionCode.OUTDATED_JARS.getErrorCode()) {
                        errorMessage.append("Newer Phoenix clients can't communicate with older Phoenix servers. Client version: 5.3.0; Server version: " + this.getServerVersion(serverJarVersion) + " The following servers require an updated phoenix-[version]-server.jar to be put in the classpath of HBase.");
                    } else if (compatibility.getErrorCode() == SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode()) {
                        errorMessage.append("Major version of client is less than that of the server. Client version: 5.3.0; Server version: " + this.getServerVersion(serverJarVersion));
                    }
                }
                boolean bl = this.hasIndexWALCodec = this.hasIndexWALCodec && ConnectionQueryServicesImpl.hasIndexWALCodec(serverJarVersion);
                if (minHBaseVersion > MetaDataUtil.decodeHBaseVersion(serverJarVersion)) {
                    minHBaseVersion = MetaDataUtil.decodeHBaseVersion(serverJarVersion);
                }
                if (versionResponse.hasSystemCatalogTimestamp()) {
                    long l = systemCatalogTimestamp = systemCatalogTimestamp < versionResponse.getSystemCatalogTimestamp() ? systemCatalogTimestamp : versionResponse.getSystemCatalogTimestamp();
                }
                if (compatibility.getErrorCode() == 0) continue;
                if (compatibility.getErrorCode() == SQLExceptionCode.OUTDATED_JARS.getErrorCode()) {
                    errorMessage.setLength(errorMessage.length() - 1);
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.OUTDATED_JARS).setMessage(errorMessage.toString()).build().buildException();
                }
                if (compatibility.getErrorCode() != SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode()) continue;
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR).setMessage(errorMessage.toString()).build().buildException();
            }
            if (isTableNamespaceMappingEnabled != SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, this.getProps())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES).setMessage("Ensure that config phoenix.schema.isNamespaceMappingEnabled is consistent on client and server.").build().buildException();
            }
            this.lowestClusterHBaseVersion = minHBaseVersion;
        }
        finally {
            if (ht != null) {
                try {
                    ht.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not close HTable", (Throwable)e);
                }
            }
        }
        if (systemCatalogTimestamp < 42L) {
            throw new UpgradeRequiredException(systemCatalogTimestamp);
        }
    }

    private String getServerVersion(long serverJarVersion) {
        return VersionUtil.decodeMajorVersion(MetaDataUtil.decodePhoenixVersion(serverJarVersion)) + "." + VersionUtil.decodeMinorVersion(MetaDataUtil.decodePhoenixVersion(serverJarVersion)) + "." + VersionUtil.decodePatchVersion(MetaDataUtil.decodePhoenixVersion(serverJarVersion));
    }

    private MetaDataProtocol.MetaDataMutationResult childLinkMetaDataCoprocessorExec(byte[] parentTableKey, Batch.Call<ChildLinkMetaDataProtos.ChildLinkMetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult;
        block10: {
            Table htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, this.getProps()).getName());
            try {
                Map results = htable.coprocessorService(ChildLinkMetaDataProtos.ChildLinkMetaDataService.class, parentTableKey, parentTableKey, callable);
                assert (results.size() == 1);
                MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
                metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                if (htable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (htable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ClientUtil.parseServerException(e);
                }
                catch (Throwable t) {
                    throw new SQLException(t);
                }
            }
            htable.close();
        }
        return metaDataMutationResult;
    }

    @VisibleForTesting
    protected RpcController getController() {
        return this.getController(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME);
    }

    @VisibleForTesting
    protected RpcController getController(TableName systemTableName) {
        if (this.serverSideRPCControllerFactory != null) {
            ServerToServerRpcController controller = this.serverSideRPCControllerFactory.newController();
            controller.setPriority(systemTableName);
            return controller;
        }
        return new ServerRpcController();
    }

    @Override
    @VisibleForTesting
    public ConnectionLimiter getConnectionLimiter() {
        return this.connectionLimiter;
    }

    private void checkForRemoteExceptions(RpcController controller) throws IOException {
        if (controller != null) {
            if (controller instanceof ServerRpcController) {
                if (((ServerRpcController)controller).getFailedOn() != null) {
                    throw ((ServerRpcController)controller).getFailedOn();
                }
            } else if (((HBaseRpcController)controller).getFailed() != null) {
                throw ((HBaseRpcController)controller).getFailed();
            }
        }
    }

    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(String tableName, byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        return this.metaDataCoprocessorExec(tableName, tableKey, callable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(String tableName, byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable, byte[] systemTableName) throws SQLException {
        try {
            boolean success = false;
            boolean retried = false;
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            while (true) {
                if (retried) {
                    this.connection.getRegionLocator(SchemaUtil.getPhysicalName(systemTableName, this.getProps())).getRegionLocation(tableKey, true);
                }
                Table ht = this.getTable(SchemaUtil.getPhysicalName(systemTableName, this.getProps()).getName());
                try {
                    Map results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, callable);
                    assert (results.size() == 1);
                    MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
                    if (result.getReturnCode() == MetaDataProtos.MutationCode.TABLE_NOT_IN_REGION || result.getReturnCode() == MetaDataProtos.MutationCode.FUNCTION_NOT_IN_REGION) {
                        if (retried) {
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                            return metaDataMutationResult;
                        }
                        retried = true;
                        continue;
                    }
                    success = true;
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                    return metaDataMutationResult;
                }
                finally {
                    long systemCatalogRpcTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableName, MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, systemCatalogRpcTime);
                    if (success) {
                        TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableName, MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, 1L);
                    } else {
                        TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableName, MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES, 1L);
                    }
                    Closeables.closeQuietly((Closeable)ht);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    private void ensureViewIndexTableCreated(byte[] physicalTableName, byte[] parentPhysicalTableName, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, long timestamp, boolean isNamespaceMapped) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        tableProps.put("IS_VIEW_INDEX_TABLE", TRUE_BYTES_AS_STRING);
        TableDescriptor desc = this.ensureTableCreated(physicalIndexName, parentPhysicalTableName, PTableType.TABLE, tableProps, families, splits, true, isNamespaceMapped, false);
        if (desc != null && !Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) {
            String fullTableName = Bytes.toString((byte[])physicalIndexName);
            throw new TableAlreadyExistsException(SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), "Unable to create shared physical table for indexes on views.");
        }
    }

    private void disableTable(Admin admin, TableName tableName) throws IOException {
        try {
            admin.disableTable(tableName);
        }
        catch (TableNotEnabledException e) {
            LOGGER.info("Table already disabled, continuing with next steps", (Throwable)e);
        }
    }

    private boolean ensureViewIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        boolean wasDeleted;
        block11: {
            byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
            wasDeleted = false;
            try (Admin admin = this.getAdmin();){
                try {
                    TableName physicalIndexTableName = TableName.valueOf((byte[])physicalIndexName);
                    TableDescriptor desc = admin.getDescriptor(physicalIndexTableName);
                    if (!Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) break block11;
                    ReadOnlyProps props = this.getProps();
                    boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                    if (dropMetadata) {
                        this.disableTable(admin, physicalIndexTableName);
                        admin.deleteTable(physicalIndexTableName);
                        this.clearTableRegionCache(physicalIndexTableName);
                        wasDeleted = true;
                        break block11;
                    }
                    this.tableStatsCache.invalidateAll(desc);
                }
                catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException(e);
            }
        }
        return wasDeleted;
    }

    private boolean ensureLocalIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        TableDescriptor desc = null;
        boolean wasDeleted = false;
        try (Admin admin = this.getAdmin();){
            try {
                desc = admin.getDescriptor(TableName.valueOf((byte[])physicalTableName));
                for (byte[] fam : desc.getColumnFamilyNames()) {
                    this.tableStatsCache.invalidate(new GuidePostsKey(physicalTableName, fam));
                }
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    ArrayList<String> columnFamiles = new ArrayList<String>();
                    for (ColumnFamilyDescriptor cf : desc.getColumnFamilies()) {
                        if (!cf.getNameAsString().startsWith("L#")) continue;
                        columnFamiles.add(cf.getNameAsString());
                    }
                    for (String cf : columnFamiles) {
                        admin.deleteColumnFamily(TableName.valueOf((byte[])physicalTableName), Bytes.toBytes((String)cf));
                    }
                    this.clearTableRegionCache(TableName.valueOf((byte[])physicalTableName));
                    wasDeleted = true;
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
        return wasDeleted;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(final List<Mutation> tableMetaData, byte[] physicalTableName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped, final boolean allocateIndexId, boolean isDoNotUpgradePropSet, final PTable parentTable) throws SQLException {
        List<Mutation> childLinkMutations = MetaDataUtil.removeChildLinkMutations(tableMetaData);
        byte[][] rowKeyMetadata = new byte[3][];
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] physicalTableNameBytes = physicalTableName != null ? physicalTableName : SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, isNamespaceMapped).getBytes();
        boolean localIndexTable = false;
        for (Pair<byte[], Map<String, Object>> family : families) {
            if (!Bytes.toString((byte[])((byte[])family.getFirst())).startsWith("L#")) continue;
            localIndexTable = true;
            break;
        }
        if (tableType != PTableType.CDC && (tableType == PTableType.VIEW && physicalTableName != null || tableType != PTableType.VIEW && (physicalTableName == null || localIndexTable))) {
            this.ensureTableCreated(physicalTableNameBytes, null, tableType, tableProps, families, splits, true, isNamespaceMapped, isDoNotUpgradePropSet);
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (tableType == PTableType.INDEX) {
            if (physicalTableName != null && !localIndexTable && !MetaDataUtil.isMultiTenant((Mutation)m, this.kvBuilder, ptr)) {
                this.ensureViewIndexTableCreated(tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes), physicalTableName, MetaDataUtil.getClientTimeStamp((Mutation)m), isNamespaceMapped);
            }
        } else if (tableType == PTableType.TABLE && MetaDataUtil.isMultiTenant((Mutation)m, this.kvBuilder, ptr)) {
            ptr.set(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            MetaDataUtil.getMutationValue((Mutation)m, PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES, this.kvBuilder, ptr);
            List<Object> familiesPlusDefault = null;
            for (Pair<byte[], Map<String, Object>> family : families) {
                byte[] cf = (byte[])family.getFirst();
                if (Bytes.compareTo((byte[])cf, (int)0, (int)cf.length, (byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength()) != 0) continue;
                familiesPlusDefault = families;
                break;
            }
            if (familiesPlusDefault == null) {
                byte[] defaultCF = ByteUtil.copyKeyBytesIfNecessary(ptr);
                familiesPlusDefault = Lists.newArrayList(families);
                familiesPlusDefault.add(new Pair((Object)defaultCF, Collections.emptyMap()));
            }
            this.ensureViewIndexTableCreated(physicalTableNameBytes, physicalTableNameBytes, tableProps, familiesPlusDefault, (byte[][])(MetaDataUtil.isSalted((Mutation)m, this.kvBuilder, ptr) ? splits : null), MetaDataUtil.getClientTimeStamp((Mutation)m), isNamespaceMapped);
        }
        if (!childLinkMutations.isEmpty()) {
            byte[] rowKey = childLinkMutations.get(0).getRow();
            RpcController controller = this.getController(PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME);
            MetaDataProtocol.MetaDataMutationResult result = this.childLinkMetaDataCoprocessorExec(rowKey, new ChildLinkMetaDataServiceCallBack(controller, childLinkMutations));
            switch (result.getMutationCode()) {
                case UNABLE_TO_CREATE_CHILD_LINK: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_CREATE_CHILD_LINK).setSchemaName(Bytes.toString((byte[])schemaBytes)).setTableName(Bytes.toString((byte[])physicalTableNameBytes)).build().buildException();
                }
            }
        }
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.props)).toString(), tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.CreateTableRequest.Builder builder = MetaDataProtos.CreateTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                if (allocateIndexId) {
                    builder.setAllocateIndexId(allocateIndexId);
                }
                if (parentTable != null) {
                    builder.setParentTable(PTableImpl.toProto(parentTable));
                }
                MetaDataProtos.CreateTableRequest build = builder.build();
                instance.createTable(controller, build, (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, final byte[] schemaBytes, final byte[] tableBytes, final long tableTimestamp, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.props)).toString(), tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.GetTableRequest.Builder builder = MetaDataProtos.GetTableRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                builder.setSchemaName(ByteStringer.wrap((byte[])schemaBytes));
                builder.setTableName(ByteStringer.wrap((byte[])tableBytes));
                builder.setTableTimestamp(tableTimestamp);
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.getTable(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(final List<Mutation> tableMetaData, final PTableType tableType, final boolean cascade) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.props)).toString(), tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.DropTableRequest.Builder builder = MetaDataProtos.DropTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTableType(tableType.getSerializedValue());
                builder.setCascade(cascade);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.dropTable(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                PTable table = result.getTable();
                if (dropMetadata) {
                    this.flushParentPhysicalTable(table);
                    this.dropTables(result.getTableNamesToDelete());
                } else {
                    this.invalidateTableStats(result.getTableNamesToDelete());
                }
                long timestamp = MetaDataUtil.getClientTimeStamp(tableMetaData);
                if (tableType != PTableType.TABLE) break;
                byte[] physicalName = table.getPhysicalName().getBytes();
                this.ensureViewIndexTableDropped(physicalName, timestamp);
                this.ensureLocalIndexTableDropped(physicalName, timestamp);
                this.tableStatsCache.invalidateAll(table);
                break;
            }
        }
        return result;
    }

    private void flushParentPhysicalTable(PTable table) throws SQLException {
        byte[] parentPhysicalTableName = null;
        if (PTableType.VIEW == table.getType()) {
            if (!table.getIndexes().isEmpty()) {
                parentPhysicalTableName = table.getPhysicalName().getBytes();
            }
        } else if (PTableType.INDEX == table.getType()) {
            PTable parentTable = this.getTable(table.getTenantId(), table.getParentName().getString(), Long.MAX_VALUE);
            parentPhysicalTableName = parentTable.getPhysicalName().getBytes();
        }
        if (parentPhysicalTableName != null) {
            try {
                this.flushTable(parentPhysicalTableName);
            }
            catch (PhoenixIOException ex) {
                if (ex.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                    LOGGER.info("Flushing physical parent table " + Bytes.toString((byte[])parentPhysicalTableName) + " of " + table.getName().getString() + " failed with : " + ex + " with cause: " + ex.getCause() + " since the table has already been dropped");
                }
                throw ex;
            }
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropFunction(final List<Mutation> functionData, final boolean ifExists) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        byte[] key = functionData.get(0).getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(null, functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController(PhoenixDatabaseMetaData.SYSTEM_FUNCTION_HBASE_TABLE_NAME);
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.DropFunctionRequest.Builder builder = MetaDataProtos.DropFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setIfExists(ifExists);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.dropFunction(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    private void invalidateTableStats(List<byte[]> tableNamesToDelete) throws SQLException {
        if (tableNamesToDelete != null) {
            for (byte[] tableName : tableNamesToDelete) {
                TableName tn = TableName.valueOf((byte[])tableName);
                TableDescriptor htableDesc = this.getTableDescriptor(tableName);
                this.tableStatsCache.invalidateAll(htableDesc);
            }
        }
    }

    private void dropTable(byte[] tableNameToDelete) throws SQLException {
        this.dropTables(Collections.singletonList(tableNameToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void dropTables(List<byte[]> tableNamesToDelete) throws SQLException {
        block15: {
            SQLException sqlE = null;
            try (Admin admin = this.getAdmin();){
                if (tableNamesToDelete != null) {
                    for (byte[] tableName : tableNamesToDelete) {
                        try {
                            TableName tn = TableName.valueOf((byte[])tableName);
                            TableDescriptor htableDesc = this.getTableDescriptor(tableName);
                            this.disableTable(admin, tn);
                            admin.deleteTable(tn);
                            this.tableStatsCache.invalidateAll(htableDesc);
                            this.clearTableRegionCache(TableName.valueOf((byte[])tableName));
                        }
                        catch (TableNotFoundException tableNotFoundException) {}
                    }
                }
            }
            catch (IOException e) {
                sqlE = ClientUtil.parseServerException(e);
            }
            finally {
                if (sqlE == null) break block15;
                throw sqlE;
            }
        }
    }

    private static Map<String, Object> createPropertiesMap(Map<Bytes, Bytes> htableProps) {
        HashMap props = Maps.newHashMapWithExpectedSize((int)htableProps.size());
        for (Map.Entry<Bytes, Bytes> entry : htableProps.entrySet()) {
            Bytes key = entry.getKey();
            Bytes value = entry.getValue();
            props.put(Bytes.toString((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()), Bytes.toString((byte[])value.get(), (int)value.getOffset(), (int)value.getLength()));
        }
        return props;
    }

    private void ensureViewIndexTableCreated(PName tenantId, byte[] physicalIndexTableName, long timestamp, boolean isNamespaceMapped) throws SQLException {
        String name = Bytes.toString((byte[])SchemaUtil.getParentTableNameFromIndexTable(physicalIndexTableName, "_IDX_")).replace(":", ".");
        PTable table = this.getTable(tenantId, name, timestamp);
        this.ensureViewIndexTableCreated(table, timestamp, isNamespaceMapped);
    }

    private PTable getTable(PName tenantId, String fullTableName, long timestamp) throws SQLException {
        PTable table;
        block3: {
            try {
                PMetaData metadata = this.latestMetaData;
                this.throwConnectionClosedIfNullMetaData();
                table = metadata.getTableRef(new PTableKey(tenantId, fullTableName)).getTable();
                if (table.getTimeStamp() >= timestamp) {
                    throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
                }
            }
            catch (TableNotFoundException e) {
                byte[] schemaName = Bytes.toBytes((String)SchemaUtil.getSchemaNameFromFullName(fullTableName));
                byte[] tableName = Bytes.toBytes((String)SchemaUtil.getTableNameFromFullName(fullTableName));
                MetaDataProtocol.MetaDataMutationResult result = this.getTable(tenantId, schemaName, tableName, Long.MAX_VALUE, timestamp);
                table = result.getTable();
                if (table != null) break block3;
                throw e;
            }
        }
        return table;
    }

    private void ensureViewIndexTableCreated(PTable table, long timestamp, boolean isNamespaceMapped) throws SQLException {
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        TableDescriptor htableDesc = this.getTableDescriptor(physicalTableName);
        ArrayList families = Lists.newArrayListWithExpectedSize((int)Math.max(1, table.getColumnFamilies().size() + 1));
        for (PColumnFamily family : table.getColumnFamilies()) {
            byte[] familyName = family.getName().getBytes();
            Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getColumnFamily(familyName).getValues());
            families.add(new Pair((Object)familyName, familyProps));
        }
        byte[] defaultFamilyName = table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes();
        families.add(new Pair((Object)defaultFamilyName, Collections.emptyMap()));
        byte[][] splits = null;
        if (table.getBucketNum() != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(table.getBucketNum());
        }
        Map<String, Object> tableProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getValues());
        tableProps.put("TRANSACTIONAL", table.isTransactional());
        tableProps.put("IMMUTABLE_ROWS", table.isImmutableRows());
        byte[] viewPhysicalTableName = MetaDataUtil.getNamespaceMappedName(table.getName(), isNamespaceMapped).getBytes(StandardCharsets.UTF_8);
        this.ensureViewIndexTableCreated(viewPhysicalTableName, physicalTableName, tableProps, families, splits, timestamp, isNamespaceMapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(final List<Mutation> tableMetaData, PTable table, final PTable parentTable, final PTable transformingNewTable, Map<String, List<Pair<String, Object>>> stmtProperties, Set<String> colFamiliesForPColumnsToBeAdded, List<PColumn> columns) throws SQLException {
        ArrayList families = new ArrayList(stmtProperties.size());
        HashMap<String, Object> tableProps = new HashMap<String, Object>();
        HashSet<TableDescriptor> tableDescriptors = Collections.emptySet();
        boolean nonTxToTx = false;
        Map<TableDescriptor, TableDescriptor> oldToNewTableDescriptors = this.separateAndValidateProperties(table, stmtProperties, colFamiliesForPColumnsToBeAdded, tableProps);
        HashSet<TableDescriptor> origTableDescriptors = new HashSet<TableDescriptor>(oldToNewTableDescriptors.keySet());
        TableDescriptor baseTableOrigDesc = this.getTableDescriptor(table.getPhysicalName().getBytes());
        TableDescriptor tableDescriptor = oldToNewTableDescriptors.get(baseTableOrigDesc);
        if (tableDescriptor != null) {
            tableDescriptors = Sets.newHashSetWithExpectedSize((int)(3 + table.getIndexes().size()));
            nonTxToTx = Boolean.TRUE.equals(tableProps.get("data.tx.read.pre.existing"));
            TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
            if (nonTxToTx) {
                this.updateDescriptorForTx(table, tableProps, tableDescriptorBuilder, Boolean.TRUE.toString(), tableDescriptors, origTableDescriptors, oldToNewTableDescriptors);
                tableDescriptor = tableDescriptorBuilder.build();
                tableDescriptors.add(tableDescriptor);
            } else {
                tableDescriptors = new HashSet<TableDescriptor>(oldToNewTableDescriptors.values());
            }
        }
        boolean success = false;
        boolean metaDataUpdated = !tableDescriptors.isEmpty();
        boolean pollingNeeded = tableProps.isEmpty() || !families.isEmpty() || !colFamiliesForPColumnsToBeAdded.isEmpty();
        MetaDataProtocol.MetaDataMutationResult result = null;
        try {
            boolean modifyHTable = true;
            if (table.getType() == PTableType.VIEW) {
                boolean canViewsAddNewCF = this.props.getBoolean("phoenix.view.allowNewColumnFamily", true);
                boolean bl = modifyHTable = canViewsAddNewCF && !this.existingColumnFamiliesForBaseTable(table.getPhysicalName()).containsAll(colFamiliesForPColumnsToBeAdded);
            }
            if (tableMetaData.isEmpty() || tableMetaData.size() == 1 && tableMetaData.get(0).isEmpty()) {
                if (modifyHTable) {
                    this.sendHBaseMetaData(tableDescriptors, pollingNeeded);
                }
                MetaDataProtocol.MetaDataMutationResult canViewsAddNewCF = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_OP, EnvironmentEdgeManager.currentTimeMillis(), table);
                return canViewsAddNewCF;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            PTableType tableType = table.getType();
            Mutation m = tableMetaData.get(0);
            byte[] rowKey = m.getRow();
            SchemaUtil.getVarChars(rowKey, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            byte[] schemaBytes = rowKeyMetaData[1];
            byte[] tableBytes = rowKeyMetaData[2];
            byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            final boolean addingColumns = columns != null && columns.size() > 0;
            result = this.metaDataCoprocessorExec(SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.props)).toString(), tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

                public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                    RpcController controller = ConnectionQueryServicesImpl.this.getController();
                    CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                    MetaDataProtos.AddColumnRequest.Builder builder = MetaDataProtos.AddColumnRequest.newBuilder();
                    for (Mutation m : tableMetaData) {
                        ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                        builder.addTableMetadataMutations(mp.toByteString());
                    }
                    builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                    if (parentTable != null) {
                        builder.setParentTable(PTableImpl.toProto(parentTable));
                    }
                    if (transformingNewTable != null) {
                        builder.setTransformingNewTable(PTableImpl.toProto(transformingNewTable));
                    }
                    builder.setAddingColumns(addingColumns);
                    instance.addColumn(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                    ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                    return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
                }
            });
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND || result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                success = true;
                if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DISABLE_WAL_BYTES, this.kvBuilder, ptr) && Boolean.FALSE.equals(PBoolean.INSTANCE.toObject(ptr))) {
                    this.flushTable(table.getPhysicalName().getBytes());
                }
                if (tableType == PTableType.TABLE && MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, this.kvBuilder, ptr)) {
                    long timestamp = MetaDataUtil.getClientTimeStamp(m);
                    if (Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr.get(), ptr.getOffset(), ptr.getLength()))) {
                        this.ensureViewIndexTableCreated(table, timestamp, table.isNamespaceMapped());
                    } else {
                        this.ensureViewIndexTableDropped(table.getPhysicalName().getBytes(), timestamp);
                    }
                }
            }
            if (modifyHTable && result.getMutationCode() != MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
                this.sendHBaseMetaData(tableDescriptors, pollingNeeded);
            }
        }
        finally {
            if (!success && metaDataUpdated && nonTxToTx) {
                this.sendHBaseMetaData(origTableDescriptors, pollingNeeded);
            }
        }
        return result;
    }

    private void updateDescriptorForTx(PTable table, Map<String, Object> tableProps, TableDescriptorBuilder tableDescriptorBuilder, String txValue, Set<TableDescriptor> descriptorsToUpdate, Set<TableDescriptor> origDescriptors, Map<TableDescriptor, TableDescriptor> oldToNewTableDescriptors) throws SQLException {
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        try (Admin admin = this.getAdmin();){
            TableDescriptorBuilder indexDescriptorBuilder;
            TableDescriptor intermedIndexDesc;
            HashMap indexTableProps;
            TableDescriptor baseDesc = admin.getDescriptor(TableName.valueOf((byte[])physicalTableName));
            boolean hasOldIndexing = baseDesc.hasCoprocessor("org.apache.phoenix.hbase.index.Indexer");
            this.setTransactional(physicalTableName, tableDescriptorBuilder, table.getType(), txValue, tableProps, hasOldIndexing);
            if (txValue == null) {
                indexTableProps = Collections.emptyMap();
            } else {
                indexTableProps = Maps.newHashMapWithExpectedSize((int)1);
                indexTableProps.put("data.tx.read.pre.existing", Boolean.valueOf(txValue));
                indexTableProps.put("TRANSACTION_PROVIDER", tableProps.get("TRANSACTION_PROVIDER"));
            }
            for (PTable index : table.getIndexes()) {
                TableDescriptor origIndexDesc;
                TableDescriptor intermedIndexDesc2 = origIndexDesc = admin.getDescriptor(TableName.valueOf((byte[])index.getPhysicalName().getBytes()));
                if (origDescriptors.contains(origIndexDesc)) {
                    intermedIndexDesc2 = oldToNewTableDescriptors.get(origIndexDesc);
                    descriptorsToUpdate.remove(intermedIndexDesc2);
                } else {
                    origDescriptors.add(origIndexDesc);
                }
                TableDescriptorBuilder indexDescriptorBuilder2 = TableDescriptorBuilder.newBuilder((TableDescriptor)intermedIndexDesc2);
                if (index.getColumnFamilies().isEmpty()) {
                    byte[] dataFamilyName = SchemaUtil.getEmptyColumnFamily(table);
                    byte[] indexFamilyName = SchemaUtil.getEmptyColumnFamily(index);
                    ColumnFamilyDescriptorBuilder indexColDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)indexDescriptorBuilder2.build().getColumnFamily(indexFamilyName));
                    ColumnFamilyDescriptor tableColDescriptor = tableDescriptorBuilder.build().getColumnFamily(dataFamilyName);
                    indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                    indexColDescriptor.setValue(Bytes.toBytes((String)"dataset.table.ttl"), tableColDescriptor.getValue(Bytes.toBytes((String)"dataset.table.ttl")));
                    indexDescriptorBuilder2.removeColumnFamily(indexFamilyName);
                    indexDescriptorBuilder2.setColumnFamily(indexColDescriptor.build());
                } else {
                    for (PColumnFamily family : index.getColumnFamilies()) {
                        byte[] familyName = family.getName().getBytes();
                        ColumnFamilyDescriptorBuilder indexColDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)indexDescriptorBuilder2.build().getColumnFamily(familyName));
                        ColumnFamilyDescriptor tableColDescriptor = tableDescriptorBuilder.build().getColumnFamily(familyName);
                        indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                        indexColDescriptor.setValue(Bytes.toBytes((String)"dataset.table.ttl"), tableColDescriptor.getValue(Bytes.toBytes((String)"dataset.table.ttl")));
                        indexDescriptorBuilder2.removeColumnFamily(familyName);
                        indexDescriptorBuilder2.setColumnFamily(indexColDescriptor.build());
                    }
                }
                this.setTransactional(index.getPhysicalName().getBytes(), indexDescriptorBuilder2, index.getType(), txValue, indexTableProps, hasOldIndexing);
                descriptorsToUpdate.add(indexDescriptorBuilder2.build());
            }
            try {
                TableDescriptor origIndexDesc;
                intermedIndexDesc = origIndexDesc = admin.getDescriptor(TableName.valueOf((byte[])MetaDataUtil.getViewIndexPhysicalName(physicalTableName)));
                if (origDescriptors.contains(origIndexDesc)) {
                    intermedIndexDesc = oldToNewTableDescriptors.get(origIndexDesc);
                    descriptorsToUpdate.remove(intermedIndexDesc);
                } else {
                    origDescriptors.add(origIndexDesc);
                }
                indexDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)intermedIndexDesc);
                this.setSharedIndexMaxVersion(table, tableDescriptorBuilder.build(), indexDescriptorBuilder);
                this.setTransactional(MetaDataUtil.getViewIndexPhysicalName(physicalTableName), indexDescriptorBuilder, PTableType.INDEX, txValue, indexTableProps, hasOldIndexing);
                descriptorsToUpdate.add(indexDescriptorBuilder.build());
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException origIndexDesc) {
                // empty catch block
            }
            try {
                intermedIndexDesc = origIndexDesc = admin.getDescriptor(TableName.valueOf((byte[])MetaDataUtil.getLocalIndexPhysicalName(physicalTableName)));
                if (origDescriptors.contains(origIndexDesc)) {
                    intermedIndexDesc = oldToNewTableDescriptors.get(origIndexDesc);
                    descriptorsToUpdate.remove(intermedIndexDesc);
                } else {
                    origDescriptors.add(origIndexDesc);
                }
                indexDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)intermedIndexDesc);
                this.setSharedIndexMaxVersion(table, tableDescriptorBuilder.build(), indexDescriptorBuilder);
                this.setTransactional(MetaDataUtil.getViewIndexPhysicalName(physicalTableName), indexDescriptorBuilder, PTableType.INDEX, txValue, indexTableProps, hasOldIndexing);
                descriptorsToUpdate.add(indexDescriptorBuilder.build());
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    private void setSharedIndexMaxVersion(PTable table, TableDescriptor tableDescriptor, TableDescriptorBuilder indexDescriptorBuilder) {
        if (table.getColumnFamilies().isEmpty()) {
            byte[] familyName = SchemaUtil.getEmptyColumnFamily(table);
            ColumnFamilyDescriptorBuilder indexColDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)indexDescriptorBuilder.build().getColumnFamily(familyName));
            ColumnFamilyDescriptor tableColDescriptor = tableDescriptor.getColumnFamily(familyName);
            indexColDescriptorBuilder.setMaxVersions(tableColDescriptor.getMaxVersions());
            indexColDescriptorBuilder.setValue(Bytes.toBytes((String)"dataset.table.ttl"), tableColDescriptor.getValue(Bytes.toBytes((String)"dataset.table.ttl")));
            indexDescriptorBuilder.removeColumnFamily(familyName);
            indexDescriptorBuilder.setColumnFamily(indexColDescriptorBuilder.build());
        } else {
            for (PColumnFamily family : table.getColumnFamilies()) {
                byte[] familyName = family.getName().getBytes();
                ColumnFamilyDescriptor indexColDescriptor = indexDescriptorBuilder.build().getColumnFamily(familyName);
                if (indexColDescriptor == null) continue;
                ColumnFamilyDescriptor tableColDescriptor = tableDescriptor.getColumnFamily(familyName);
                ColumnFamilyDescriptorBuilder indexColDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)indexColDescriptor);
                indexColDescriptorBuilder.setMaxVersions(tableColDescriptor.getMaxVersions());
                indexColDescriptorBuilder.setValue(Bytes.toBytes((String)"dataset.table.ttl"), tableColDescriptor.getValue(Bytes.toBytes((String)"dataset.table.ttl")));
                indexDescriptorBuilder.removeColumnFamily(familyName);
                indexDescriptorBuilder.setColumnFamily(indexColDescriptorBuilder.build());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHBaseMetaData(Set<TableDescriptor> tableDescriptors, boolean pollingNeeded) throws SQLException {
        SQLException sqlE = null;
        for (TableDescriptor descriptor : tableDescriptors) {
            try {
                this.modifyTable(descriptor.getTableName().getName(), descriptor, pollingNeeded);
            }
            catch (IOException e) {
                sqlE = ClientUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            catch (TimeoutException e) {
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
            }
            finally {
                if (sqlE == null) continue;
                throw sqlE;
            }
        }
    }

    private void setTransactional(byte[] physicalTableName, TableDescriptorBuilder tableDescriptorBuilder, PTableType tableType, String txValue, Map<String, Object> tableProps, boolean hasOldIndexing) throws SQLException {
        if (txValue == null) {
            tableDescriptorBuilder.removeValue(Bytes.toBytes((String)"data.tx.read.pre.existing"));
        } else {
            tableDescriptorBuilder.setValue("data.tx.read.pre.existing", txValue);
        }
        this.addCoprocessors(physicalTableName, tableDescriptorBuilder, tableType, tableProps, null, hasOldIndexing);
    }

    /*
     * WARNING - void declaration
     */
    private Map<TableDescriptor, TableDescriptor> separateAndValidateProperties(PTable table, Map<String, List<Pair<String, Object>>> properties, Set<String> colFamiliesForPColumnsToBeAdded, Map<String, Object> tableProps) throws SQLException {
        void var20_29;
        boolean isAddingPkColOnly;
        HashMap stmtFamiliesPropsMap = new HashMap(properties.size());
        Map<String, Integer> commonFamilyProps = new HashMap();
        boolean addingColumns = colFamiliesForPColumnsToBeAdded != null && !colFamiliesForPColumnsToBeAdded.isEmpty();
        HashSet<String> existingColumnFamilies = this.existingColumnFamilies(table);
        HashMap<String, Map<String, Object>> allFamiliesProps = new HashMap<String, Map<String, Object>>(existingColumnFamilies.size());
        boolean isTransactional = table.isTransactional();
        boolean willBeTransactional = false;
        boolean isOrWillBeTransactional = isTransactional;
        Integer newTTL = null;
        TTLExpression newPhoenixTTL = null;
        Integer newReplicationScope = null;
        KeepDeletedCells newKeepDeletedCells = null;
        TransactionFactory.Provider txProvider = null;
        Integer newMaxLookback = null;
        for (String string : properties.keySet()) {
            List<Pair<String, Object>> propsList = properties.get(string);
            if (propsList == null || propsList.size() <= 0) continue;
            HashMap<String, Iterator<PColumnFamily>> colFamilyPropsMap = new HashMap<String, Iterator<PColumnFamily>>(propsList.size());
            for (Pair<String, Object> pair : propsList) {
                String string2 = (String)pair.getFirst();
                Iterator<PColumnFamily> propValue = pair.getSecond();
                if ((MetaDataUtil.isHTableProperty(string2) || TableProperty.isPhoenixTableProperty(string2)) && addingColumns) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN).setMessage("Property: " + string2).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
                }
                if (MetaDataUtil.isHTableProperty(string2)) {
                    if (!string.equals("")) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY).setMessage("Column Family: " + string + ", Property: " + string2).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
                    }
                    if ("phoenix.max.lookback.age.seconds".equals(string2)) {
                        if (table.getType() == PTableType.INDEX) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_MAX_LOOKBACK_FOR_INDEX).setMessage("Property: " + string2).build().buildException();
                        }
                        newMaxLookback = (Integer)((Object)propValue);
                    }
                    tableProps.put(string2, propValue);
                    continue;
                }
                if (TableProperty.isPhoenixTableProperty(string2)) {
                    TableProperty tableProperty = TableProperty.valueOf(string2);
                    tableProperty.validate(true, !string.equals(""), table.getType());
                    if (string2.equals("TTL")) {
                        if (table.getType() == PTableType.INDEX) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX).setMessage("Property: " + string2).build().buildException();
                        }
                        if (propValue == null) continue;
                        TTLExpression tTLExpression = MetaDataUtil.convertForeverAndNoneTTLValue(propValue, false);
                        if (tTLExpression instanceof LiteralTTLExpression && table.getType() != PTableType.VIEW) {
                            newTTL = ((LiteralTTLExpression)tTLExpression).getTTLValue();
                            commonFamilyProps.put(string2, newTTL);
                        } else if (tTLExpression instanceof ConditionalTTLExpression && table.getType() == PTableType.TABLE) {
                            newTTL = Integer.MAX_VALUE;
                            commonFamilyProps.put(string2, newTTL);
                        }
                        newPhoenixTTL = (TTLExpression)TableProperty.TTL.getValue(propValue);
                        continue;
                    }
                    if (string2.equals("TRANSACTIONAL") && Boolean.TRUE.equals(propValue)) {
                        isOrWillBeTransactional = true;
                        willBeTransactional = true;
                        tableProps.put("data.tx.read.pre.existing", propValue);
                        continue;
                    }
                    if (!string2.equals("TRANSACTION_PROVIDER") || propValue == null) continue;
                    isOrWillBeTransactional = true;
                    willBeTransactional = true;
                    tableProps.put("data.tx.read.pre.existing", Boolean.TRUE);
                    txProvider = (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(propValue));
                    tableProps.put("TRANSACTION_PROVIDER", (Object)txProvider);
                    continue;
                }
                if (MetaDataUtil.isHColumnProperty(string2)) {
                    if (table.getType() == PTableType.INDEX && MetaDataUtil.propertyNotAllowedToBeOutOfSync(string2)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX).setMessage("Property: " + string2).build().buildException();
                    }
                    if (string.equals("")) {
                        if (string2.equals("KEEP_DELETED_CELLS")) {
                            KeepDeletedCells keepDeletedCells = newKeepDeletedCells = Boolean.valueOf(propValue.toString()) != false ? KeepDeletedCells.TRUE : KeepDeletedCells.FALSE;
                        }
                        if (string2.equals("REPLICATION_SCOPE")) {
                            newReplicationScope = ((Number)((Object)propValue)).intValue();
                        }
                        commonFamilyProps.put(string2, (Integer)((Object)propValue));
                        continue;
                    }
                    if (MetaDataUtil.propertyNotAllowedToBeOutOfSync(string2)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY).setMessage("Property: " + string2).build().buildException();
                    }
                    colFamilyPropsMap.put(string2, propValue);
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_PROPERTY).setMessage("Column Family: " + string + ", Property: " + string2).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
            }
            if (isOrWillBeTransactional && (newTTL != null || newPhoenixTTL != null)) {
                TransactionFactory.Provider isOrWillBeTransactionProvider;
                TransactionFactory.Provider provider = isOrWillBeTransactionProvider = txProvider == null ? table.getTransactionProvider() : txProvider;
                if (isOrWillBeTransactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                    throw new SQLExceptionInfo.Builder(PhoenixTransactionProvider.Feature.SET_TTL.getCode()).setMessage(isOrWillBeTransactionProvider.name()).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
                }
            }
            if (colFamilyPropsMap.isEmpty()) continue;
            stmtFamiliesPropsMap.put(string, colFamilyPropsMap);
        }
        commonFamilyProps = Collections.unmodifiableMap(commonFamilyProps);
        boolean bl = isAddingPkColOnly = colFamiliesForPColumnsToBeAdded.size() == 1 && colFamiliesForPColumnsToBeAdded.contains(null);
        if (!commonFamilyProps.isEmpty()) {
            if (!addingColumns) {
                for (String existingColFamily : existingColumnFamilies) {
                    m = new HashMap<String, Integer>(commonFamilyProps.size());
                    m.putAll(commonFamilyProps);
                    allFamiliesProps.put(existingColFamily, m);
                }
            } else {
                for (String colFamily : colFamiliesForPColumnsToBeAdded) {
                    if (colFamily != null) {
                        m = new HashMap(commonFamilyProps.size());
                        m.putAll(commonFamilyProps);
                        allFamiliesProps.put(colFamily, m);
                        continue;
                    }
                    if (!isAddingPkColOnly) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).build().buildException();
                }
            }
        }
        for (String f : stmtFamiliesPropsMap.keySet()) {
            if (!addingColumns && !existingColumnFamilies.contains(f)) {
                String schemaNameStr = table.getSchemaName() == null ? null : table.getSchemaName().getString();
                String tableNameStr = table.getTableName() == null ? null : table.getTableName().getString();
                throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, f);
            }
            if (addingColumns && !colFamiliesForPColumnsToBeAdded.contains(f)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_PROPERTY_FOR_COLUMN_NOT_ADDED).build().buildException();
            }
            Map commonProps = (Map)allFamiliesProps.get(f);
            Map stmtProps = (Map)stmtFamiliesPropsMap.get(f);
            if (commonProps != null) {
                if (stmtProps == null) continue;
                commonProps.putAll(stmtProps);
                continue;
            }
            if (stmtProps == null) continue;
            allFamiliesProps.put(f, stmtProps);
        }
        for (String cf : colFamiliesForPColumnsToBeAdded) {
            if (cf == null || allFamiliesProps.get(cf) != null) continue;
            allFamiliesProps.put(cf, new HashMap());
        }
        if (table.getColumnFamilies().isEmpty() && !addingColumns && !commonFamilyProps.isEmpty()) {
            allFamiliesProps.put(Bytes.toString((byte[])(table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes())), commonFamilyProps);
        }
        if (!(table.getType() != PTableType.VIEW || stmtFamiliesPropsMap.isEmpty() && commonFamilyProps.isEmpty() && tableProps.isEmpty())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
        }
        Object var20_27 = null;
        TableDescriptor origTableDescriptor = null;
        HashMap tableAndIndexDescriptorMappings = Collections.emptyMap();
        if (!allFamiliesProps.isEmpty() || !tableProps.isEmpty()) {
            void var24_41;
            tableAndIndexDescriptorMappings = Maps.newHashMapWithExpectedSize((int)(3 + table.getIndexes().size()));
            TableDescriptor existingTableDescriptor = origTableDescriptor = this.getTableDescriptor(table.getPhysicalName().getBytes());
            TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)existingTableDescriptor);
            if (!tableProps.isEmpty()) {
                for (Map.Entry<String, Object> entry : tableProps.entrySet()) {
                    tableDescriptorBuilder.setValue(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
                }
            }
            if (addingColumns) {
                this.setSyncedPropsForNewColumnFamilies(allFamiliesProps, table, tableDescriptorBuilder, newTTL, newKeepDeletedCells, newReplicationScope);
            }
            if (newTTL != null || newKeepDeletedCells != null || newReplicationScope != null) {
                this.setSyncedPropsForUnreferencedColumnFamilies(this.getTableDescriptor(table.getPhysicalName().getBytes()), allFamiliesProps, newTTL, newKeepDeletedCells, newReplicationScope);
            }
            Object var24_36 = null;
            if (isOrWillBeTransactional) {
                int ttl;
                void var24_38;
                Map map = (Map)allFamiliesProps.get(SchemaUtil.getEmptyColumnFamilyAsString(table));
                if (map != null) {
                    Integer n = (Integer)map.get("VERSIONS");
                }
                if (var24_38 == null) {
                    if (isTransactional) {
                        Integer n = tableDescriptorBuilder.build().getColumnFamily(SchemaUtil.getEmptyColumnFamily(table)).getMaxVersions();
                    } else {
                        Integer n = this.getProps().getInt("phoenix.transactions.maxVersions", Integer.MAX_VALUE);
                    }
                }
                if (willBeTransactional) {
                    for (PColumnFamily pColumnFamily : table.getColumnFamilies()) {
                        if (allFamiliesProps.containsKey(pColumnFamily.getName().getString())) continue;
                        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)1);
                        hashMap.put("VERSIONS", var24_41);
                        allFamiliesProps.put(pColumnFamily.getName().getString(), hashMap);
                    }
                }
                if ((ttl = ConnectionQueryServicesImpl.getTTL(table, tableDescriptorBuilder.build(), newTTL)) != Integer.MAX_VALUE) {
                    for (Map.Entry entry : allFamiliesProps.entrySet()) {
                        Map props = (HashMap<String, Integer>)entry.getValue();
                        if (props == null) {
                            allFamiliesProps.put((String)entry.getKey(), new HashMap());
                            props = (Map)allFamiliesProps.get(entry.getKey());
                        } else {
                            props = new HashMap<String, Integer>(props);
                        }
                        props.put("dataset.table.ttl", ttl);
                        if (!willBeTransactional && !Boolean.valueOf(tableDescriptorBuilder.build().getValue("data.tx.read.pre.existing")).booleanValue()) {
                            props.remove("TTL");
                        }
                        entry.setValue(props);
                    }
                }
            }
            for (Map.Entry entry : allFamiliesProps.entrySet()) {
                Map map = (Map)entry.getValue();
                if (isOrWillBeTransactional && !map.containsKey("VERSIONS")) {
                    map.put("VERSIONS", var24_41);
                }
                byte[] byArray = Bytes.toBytes((String)((String)entry.getKey()));
                ColumnFamilyDescriptor colDescriptor = tableDescriptorBuilder.build().getColumnFamily(byArray);
                if (colDescriptor == null) {
                    colDescriptor = this.generateColumnFamilyDescriptor((Pair<byte[], Map<String, Object>>)new Pair((Object)byArray, (Object)map), table.getType());
                    tableDescriptorBuilder.setColumnFamily(colDescriptor);
                } else {
                    ColumnFamilyDescriptorBuilder colDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)colDescriptor);
                    this.modifyColumnFamilyDescriptor(colDescriptorBuilder, map);
                    colDescriptor = colDescriptorBuilder.build();
                    tableDescriptorBuilder.removeColumnFamily(byArray);
                    tableDescriptorBuilder.setColumnFamily(colDescriptor);
                }
                if (!isOrWillBeTransactional) continue;
                this.checkTransactionalVersionsValue(colDescriptor);
            }
        }
        if (origTableDescriptor != null && var20_29 != null) {
            tableAndIndexDescriptorMappings.put(origTableDescriptor, var20_29.build());
        }
        Map<String, Object> applyPropsToAllIndexColFams = this.getNewSyncedPropsMap(newTTL, newKeepDeletedCells, newReplicationScope);
        this.setSyncedPropertiesForTableIndexes(table, tableAndIndexDescriptorMappings, applyPropsToAllIndexColFams, this.getNewSyncedPropsMapForTableDescriptor(newMaxLookback));
        return tableAndIndexDescriptorMappings;
    }

    private void checkTransactionalVersionsValue(ColumnFamilyDescriptor colDescriptor) throws SQLException {
        int maxVersions = colDescriptor.getMaxVersions();
        if (maxVersions <= 1) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAX_VERSIONS_MUST_BE_GREATER_THAN_ONE).setFamilyName(colDescriptor.getNameAsString()).build().buildException();
        }
    }

    private HashSet<String> existingColumnFamiliesForBaseTable(PName baseTableName) throws TableNotFoundException {
        this.throwConnectionClosedIfNullMetaData();
        PTable table = this.latestMetaData.getTableRef(new PTableKey(null, baseTableName.getString())).getTable();
        return this.existingColumnFamilies(table);
    }

    public HashSet<String> existingColumnFamilies(PTable table) {
        List<PColumnFamily> cfs = table.getColumnFamilies();
        HashSet<String> cfNames = new HashSet<String>(cfs.size());
        for (PColumnFamily cf : table.getColumnFamilies()) {
            cfNames.add(cf.getName().getString());
        }
        return cfNames;
    }

    public static KeepDeletedCells getKeepDeletedCells(PTable table, TableDescriptor tableDesc, KeepDeletedCells newKeepDeletedCells) throws SQLException {
        return newKeepDeletedCells != null ? newKeepDeletedCells : tableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(table)).getKeepDeletedCells();
    }

    public static int getReplicationScope(PTable table, TableDescriptor tableDesc, Integer newReplicationScope) throws SQLException {
        return newReplicationScope != null ? newReplicationScope.intValue() : tableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(table)).getScope();
    }

    public static int getTTL(PTable table, TableDescriptor tableDesc, Integer newTTL) throws SQLException {
        return newTTL != null ? newTTL.intValue() : tableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(table)).getTimeToLive();
    }

    private void setSyncedPropsForNewColumnFamilies(Map<String, Map<String, Object>> allFamiliesProps, PTable table, TableDescriptorBuilder tableDescBuilder, Integer newTTL, KeepDeletedCells newKeepDeletedCells, Integer newReplicationScope) throws SQLException {
        if (!allFamiliesProps.isEmpty()) {
            int ttl = ConnectionQueryServicesImpl.getTTL(table, tableDescBuilder.build(), newTTL);
            int replicationScope = ConnectionQueryServicesImpl.getReplicationScope(table, tableDescBuilder.build(), newReplicationScope);
            KeepDeletedCells keepDeletedCells = ConnectionQueryServicesImpl.getKeepDeletedCells(table, tableDescBuilder.build(), newKeepDeletedCells);
            for (Map.Entry<String, Map<String, Object>> entry : allFamiliesProps.entrySet()) {
                Map<String, Object> props = entry.getValue();
                if (props == null) {
                    allFamiliesProps.put(entry.getKey(), new HashMap());
                    props = allFamiliesProps.get(entry.getKey());
                }
                props.put("TTL", ttl);
                props.put("KEEP_DELETED_CELLS", keepDeletedCells);
                props.put("REPLICATION_SCOPE", replicationScope);
            }
        }
    }

    private void setPropIfNotNull(Map<String, Object> propMap, String propName, Object propVal) {
        if (propName != null && propVal != null) {
            propMap.put(propName, propVal);
        }
    }

    private Map<String, Object> getNewSyncedPropsMap(Integer newTTL, KeepDeletedCells newKeepDeletedCells, Integer newReplicationScope) {
        HashMap newSyncedProps = Maps.newHashMapWithExpectedSize((int)3);
        this.setPropIfNotNull(newSyncedProps, "TTL", newTTL);
        this.setPropIfNotNull(newSyncedProps, "KEEP_DELETED_CELLS", newKeepDeletedCells);
        this.setPropIfNotNull(newSyncedProps, "REPLICATION_SCOPE", newReplicationScope);
        return newSyncedProps;
    }

    private Map<String, Object> getNewSyncedPropsMapForTableDescriptor(Integer newMaxLookback) {
        if (newMaxLookback == null) {
            return null;
        }
        HashMap<String, Object> newSyncedProps = new HashMap<String, Object>(1);
        this.setPropIfNotNull(newSyncedProps, "phoenix.max.lookback.age.seconds", newMaxLookback);
        return newSyncedProps;
    }

    private void setSyncedPropsForUnreferencedColumnFamilies(TableDescriptor tableDesc, Map<String, Map<String, Object>> allFamiliesProps, Integer newTTL, KeepDeletedCells newKeepDeletedCells, Integer newReplicationScope) {
        for (ColumnFamilyDescriptor family : tableDesc.getColumnFamilies()) {
            if (allFamiliesProps.containsKey(family.getNameAsString())) continue;
            allFamiliesProps.put(family.getNameAsString(), this.getNewSyncedPropsMap(newTTL, newKeepDeletedCells, newReplicationScope));
        }
    }

    private void setSyncedPropertiesForTableIndexes(PTable table, Map<TableDescriptor, TableDescriptor> tableAndIndexDescriptorMappings, Map<String, Object> applyPropsToAllIndexesDefaultCF, Map<String, Object> applyPropsToAllIndexesTd) throws SQLException {
        if ((applyPropsToAllIndexesDefaultCF == null || applyPropsToAllIndexesDefaultCF.isEmpty()) && (applyPropsToAllIndexesTd == null || applyPropsToAllIndexesTd.isEmpty())) {
            return;
        }
        for (PTable indexTable : table.getIndexes()) {
            if (indexTable.getIndexType() == PTable.IndexType.LOCAL) continue;
            TableDescriptor origIndexDescriptor = this.getTableDescriptor(indexTable.getPhysicalName().getBytes());
            TableDescriptorBuilder newIndexDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)origIndexDescriptor);
            this.modifyTableDescriptor(newIndexDescriptorBuilder, applyPropsToAllIndexesTd);
            byte[] defaultIndexColFam = SchemaUtil.getEmptyColumnFamily(indexTable);
            ColumnFamilyDescriptorBuilder indexDefaultColDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)origIndexDescriptor.getColumnFamily(defaultIndexColFam));
            this.modifyColumnFamilyDescriptor(indexDefaultColDescriptorBuilder, applyPropsToAllIndexesDefaultCF);
            newIndexDescriptorBuilder.removeColumnFamily(defaultIndexColFam);
            newIndexDescriptorBuilder.setColumnFamily(indexDefaultColDescriptorBuilder.build());
            tableAndIndexDescriptorMappings.put(origIndexDescriptor, newIndexDescriptorBuilder.build());
        }
        String viewIndexName = MetaDataUtil.getViewIndexPhysicalName(table.getName(), table.isNamespaceMapped());
        if (!Strings.isNullOrEmpty((String)viewIndexName)) {
            try {
                TableDescriptor origViewIndexTableDescriptor = this.getTableDescriptor(Bytes.toBytes((String)viewIndexName));
                TableDescriptorBuilder newViewIndexDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)origViewIndexTableDescriptor);
                for (ColumnFamilyDescriptor cfd : origViewIndexTableDescriptor.getColumnFamilies()) {
                    ColumnFamilyDescriptorBuilder newCfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd);
                    this.modifyColumnFamilyDescriptor(newCfd, applyPropsToAllIndexesDefaultCF);
                    newViewIndexDescriptorBuilder.removeColumnFamily(cfd.getName());
                    newViewIndexDescriptorBuilder.setColumnFamily(newCfd.build());
                }
                tableAndIndexDescriptorMappings.put(origViewIndexTableDescriptor, newViewIndexDescriptorBuilder.build());
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(final List<Mutation> tableMetaData, PTableType tableType, final PTable parentTable) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.props)).toString(), tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.DropColumnRequest.Builder builder = MetaDataProtos.DropColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                if (parentTable != null) {
                    builder.setParentTable(PTableImpl.toProto(parentTable));
                }
                instance.dropColumn(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    this.dropTables(result.getTableNamesToDelete());
                    break;
                }
                this.invalidateTableStats(result.getTableNamesToDelete());
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection removeNotNullConstraint(PhoenixConnection oldMetaConnection, String schemaName, String tableName, long timestamp, String columnName) throws SQLException {
        PhoenixConnection metaConnection;
        block16: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            try {
                String dml = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,NULLABLE) VALUES (null, ?, ?, ?, ?)";
                PreparedStatement stmt = metaConnection.prepareStatement(dml);
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                stmt.setString(3, columnName);
                stmt.setInt(4, 1);
                stmt.executeUpdate();
                metaConnection.commit();
            }
            catch (NewerTableAlreadyExistsException e) {
                LOGGER.warn("Table already modified at this timestamp, so assuming column already nullable: " + columnName);
            }
            catch (SQLException e) {
                LOGGER.warn("Add column failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block16;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection addColumn(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns, boolean addIfNotExists) throws SQLException {
        PhoenixConnection metaConnection;
        block16: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            try {
                metaConnection.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD " + (addIfNotExists ? " IF NOT EXISTS " : "") + columns);
            }
            catch (NewerTableAlreadyExistsException e) {
                LOGGER.warn("Table already modified at this timestamp, so assuming add of these columns already done: " + columns);
            }
            catch (SQLException e) {
                LOGGER.warn("Add column failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block16;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    private PhoenixConnection addColumnsIfNotExists(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns) throws SQLException {
        return this.addColumn(oldMetaConnection, tableName, timestamp, columns, true);
    }

    private void copyDataFromPhoenixTTLtoTTL(PhoenixConnection oldMetaConnection) throws IOException {
        if (oldMetaConnection.getQueryServices().getConfiguration().getBoolean("phoenix.view.ttl.enabled", true)) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("hbase.rpc.timeout", Integer.toString(1800000));
            options.put("hbase.client.scanner.timeout.period", Integer.toString(1800000));
            UpgradeUtil.copyTTLValuesFromPhoenixTTLColumnToTTLColumn(oldMetaConnection, options);
        }
    }

    private void moveTTLFromHBaseLevelTTLToPhoenixLevelTTL(PhoenixConnection oldMetaConnection) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("hbase.rpc.timeout", Integer.toString(1800000));
        options.put("hbase.client.scanner.timeout.period", Integer.toString(1800000));
        UpgradeUtil.moveHBaseLevelTTLToSYSCAT(oldMetaConnection, options);
    }

    protected long getSystemTableVersion() {
        return 42L;
    }

    protected void setUpgradeRequired() {
        this.upgradeRequired.set(true);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    protected String getSystemCatalogTableDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_TABLE_METADATA);
    }

    protected String getSystemSequenceTableDDL(int nSaltBuckets) {
        String schema = String.format(this.setSystemDDLProperties(QueryConstants.CREATE_SEQUENCE_METADATA), new Object[0]);
        return Sequence.getCreateTableStatement(schema, nSaltBuckets);
    }

    protected String getFunctionTableDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_FUNCTION_METADATA);
    }

    protected String getLogTableDDL() {
        return this.setSystemLogDDLProperties(QueryConstants.CREATE_LOG_METADATA);
    }

    private String setSystemLogDDLProperties(String ddl) {
        return String.format(ddl, this.props.getInt("phoenix.log.saltBuckets", 32));
    }

    protected String getChildLinkDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_CHILD_LINK_METADATA);
    }

    protected String getMutexDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_MUTEX_METADATA);
    }

    protected String getTaskDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_TASK_METADATA);
    }

    protected String getTransformDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_TRANSFORM_METADATA);
    }

    protected String getCDCStreamStatusDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_CDC_STREAM_STATUS_METADATA);
    }

    protected String getCDCStreamDDL() {
        long partitionExpiryMinAge = this.getProps().getLong("phoenix.cdc.stream.partition.expiry.min.age.ms", 108000000L);
        String ttlExpression = String.format("PARTITION_END_TIME IS NOT NULL AND TO_NUMBER(CURRENT_TIME()) - TO_NUMBER(PHOENIX_ROW_TIMESTAMP()) >= %d", partitionExpiryMinAge);
        String ddl = this.setSystemDDLProperties(QueryConstants.CREATE_CDC_STREAM_METADATA);
        return ddl + ",TTL='" + ttlExpression + "'";
    }

    private String setSystemDDLProperties(String ddl) {
        return String.format(ddl, this.props.getInt("phoenix.system.default.max.versions", 1), this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
    }

    @Override
    public void init(final String url, final Properties props) throws SQLException {
        try {
            PhoenixContextExecutor.call(new Callable<Void>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Void call() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
        }
    }

    void createSysMutexTableIfNotExists(Admin admin) throws IOException {
        try {
            if (this.checkIfSysMutexExistsAndModifyTTLIfRequired(admin)) {
                return;
            }
            TableName mutexTableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME, this.props);
            TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)mutexTableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES).setTimeToLive(900).build()).build();
            admin.createTable(tableDesc);
        }
        catch (IOException e) {
            if (this.inspectIfAnyExceptionInChain(e, Arrays.asList(AccessDeniedException.class, TableExistsException.class))) {
                LOGGER.debug("Ignoring exception while creating mutex table during connection initialization: " + Throwables.getStackTraceAsString((Throwable)e));
            }
            throw e;
        }
    }

    @VisibleForTesting
    boolean checkIfSysMutexExistsAndModifyTTLIfRequired(Admin admin) throws IOException {
        TableDescriptor htd;
        try {
            htd = admin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME));
        }
        catch (org.apache.hadoop.hbase.TableNotFoundException ignored) {
            try {
                htd = admin.getDescriptor(TableName.valueOf((String)"SYSTEM", (String)"MUTEX"));
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException ignored2) {
                return false;
            }
        }
        if (htd.getColumnFamily(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES).getTimeToLive() != 900) {
            LOGGER.debug("SYSTEM MUTEX already appears to exist, but has the wrong TTL. Will modify the TTL");
            ColumnFamilyDescriptor hColFamDesc = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)htd.getColumnFamily(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES)).setTimeToLive(900).build();
            htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).modifyColumnFamily(hColFamDesc).build();
            admin.modifyTable(htd);
        } else {
            LOGGER.debug("SYSTEM MUTEX already appears to exist with the correct TTL, not creating it");
        }
        return true;
    }

    private boolean inspectIfAnyExceptionInChain(Throwable io, List<Class<? extends Exception>> ioList) {
        boolean exceptionToIgnore = false;
        for (Throwable t : Throwables.getCausalChain((Throwable)io)) {
            for (Class<? extends Exception> exception : ioList) {
                exceptionToIgnore |= this.isExceptionInstanceOf(t, exception);
            }
            if (!exceptionToIgnore) continue;
            break;
        }
        return exceptionToIgnore;
    }

    private boolean isExceptionInstanceOf(Throwable io, Class<? extends Exception> exception) {
        return exception.isInstance(io) || io instanceof RemoteException && ((RemoteException)io).getClassName().equals(exception.getName());
    }

    List<TableName> getSystemTableNamesInDefaultNamespace(Admin admin) throws IOException {
        return Lists.newArrayList((Object[])admin.listTableNames(Pattern.compile("SYSTEM\\..*")));
    }

    private void createOtherSystemTables(PhoenixConnection metaConnection) throws SQLException, IOException {
        try {
            metaConnection.createStatement().execute(this.getSystemSequenceTableDDL(this.nSequenceSaltBuckets));
            this.updateSystemSequenceWithCacheOnWriteProps(metaConnection);
        }
        catch (TableAlreadyExistsException e) {
            this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
        }
        try {
            metaConnection.createStatement().execute(QueryConstants.CREATE_STATS_TABLE_METADATA);
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().execute(this.getFunctionTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().execute(this.getLogTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getChildLinkDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getMutexDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getTaskDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getTransformDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getCDCStreamStatusDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getCDCStreamDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
    }

    private void createSchemaIfNotExistsSystemNSMappingEnabled(PhoenixConnection metaConnection) throws SQLException {
        block4: {
            if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                try {
                    metaConnection.createStatement().execute("CREATE SCHEMA IF NOT EXISTS SYSTEM");
                }
                catch (NewerSchemaAlreadyExistsException newerSchemaAlreadyExistsException) {
                }
                catch (PhoenixIOException e) {
                    if (!Iterables.isEmpty((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), AccessDeniedException.class))) break block4;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PhoenixConnection upgradeSystemCatalogIfRequired(PhoenixConnection metaConnection, long currentServerSideTableTimeStamp) throws SQLException, IOException, TimeoutException, InterruptedException {
        Object columnsToAdd = "";
        if (currentServerSideTableTimeStamp < 7L) {
            columnsToAdd = this.addColumn((String)columnsToAdd, "STORE_NULLS " + PBoolean.INSTANCE.getSqlTypeName());
            try (Admin admin = this.getAdmin();){
                List localIndexTables = admin.listTableDescriptors(Pattern.compile("_LOCAL_IDX_.*"));
                for (TableDescriptor table : localIndexTables) {
                    if (table.getValue("PARENT_TABLE") != null || table.getValue("IS_LOCAL_INDEX_TABLE") == null) continue;
                    table = TableDescriptorBuilder.newBuilder((TableDescriptor)table).setValue(Bytes.toBytes((String)"PARENT_TABLE"), Bytes.toBytes((String)MetaDataUtil.getLocalIndexUserTableName(table.getTableName().getNameAsString()))).build();
                    this.disableTable(admin, table.getTableName());
                    admin.modifyTable(table);
                    admin.enableTable(table.getTableName());
                }
            }
        }
        if (currentServerSideTableTimeStamp < 3L) {
            columnsToAdd = this.addColumn((String)columnsToAdd, "INDEX_TYPE " + PUnsignedTinyint.INSTANCE.getSqlTypeName() + ", INDEX_DISABLE_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName());
        }
        if (!((String)columnsToAdd).isEmpty()) {
            PhoenixConnection newMetaConnection;
            metaConnection = newMetaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 7L, (String)columnsToAdd);
        }
        if (currentServerSideTableTimeStamp < 8L) {
            columnsToAdd = "BASE_COLUMN_COUNT " + PInteger.INSTANCE.getSqlTypeName();
            try {
                metaConnection = this.addColumn(metaConnection, "SYSTEM.\"CATALOG\"", 8L, (String)columnsToAdd, false);
                UpgradeUtil.upgradeTo4_5_0(metaConnection);
            }
            catch (ColumnAlreadyExistsException ignored) {
                LOGGER.debug("No need to run 4.5 upgrade");
            }
            Properties p = PropertiesUtil.deepCopy(metaConnection.getClientInfo());
            p.remove("CurrentSCN");
            p.remove("TenantId");
            try (PhoenixConnection conn = new PhoenixConnection(this, metaConnection.getURL(), p);){
                List<String> unsupportedTables;
                List<String> tablesNeedingUpgrade = UpgradeUtil.getPhysicalTablesWithDescRowKey(conn);
                if (!tablesNeedingUpgrade.isEmpty()) {
                    LOGGER.warn("The following tables require upgrade due to a bug causing the row key to be incorrect for descending columns and ascending BINARY columns (PHOENIX-2067 and PHOENIX-2120):\n" + Joiner.on((char)' ').join(tablesNeedingUpgrade) + "\nTo upgrade issue the \"bin/psql.py -u\" command.");
                }
                if (!(unsupportedTables = UpgradeUtil.getPhysicalTablesWithDescVarbinaryRowKey(conn)).isEmpty()) {
                    LOGGER.warn("The following tables use an unsupported VARBINARY DESC construct and need to be changed:\n" + Joiner.on((char)' ').join(unsupportedTables));
                }
            }
        }
        if (currentServerSideTableTimeStamp < 9L) {
            columnsToAdd = "IS_ROW_TIMESTAMP " + PBoolean.INSTANCE.getSqlTypeName();
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 9L, (String)columnsToAdd);
        }
        if (currentServerSideTableTimeStamp < 15L) {
            metaConnection = this.dropStatsTable(metaConnection, 11L);
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 12L, "TRANSACTIONAL " + PBoolean.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 13L, "UPDATE_CACHE_FREQUENCY " + PLong.INSTANCE.getSqlTypeName());
            metaConnection = this.setImmutableTableIndexesImmutable(metaConnection, 14L);
            metaConnection = this.updateSystemCatalogTimestamp(metaConnection, 15L);
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 15L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 18L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 16L, "IS_NAMESPACE_MAPPED " + PBoolean.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 17L, "AUTO_PARTITION_SEQ " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 18L, "APPEND_ONLY_SCHEMA " + PBoolean.INSTANCE.getSqlTypeName());
            metaConnection = UpgradeUtil.disableViewIndexes(metaConnection);
            if (this.getProps().getBoolean("phoenix.client.localIndexUpgrade", true)) {
                this.localIndexUpgradeRequired = true;
            }
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 18L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 20L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 20L, "GUIDE_POSTS_WIDTH " + PLong.INSTANCE.getSqlTypeName());
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 20L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 25L) {
            metaConnection = this.addColumnQualifierColumn(metaConnection, 22L);
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 23L, "IMMUTABLE_STORAGE_SCHEME " + PTinyint.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 24L, "ENCODING_SCHEME " + PTinyint.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 25L, "QUALIFIER_COUNTER " + PInteger.INSTANCE.getSqlTypeName());
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 25L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 27L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 27L, "USE_STATS_FOR_PARALLELIZATION " + PBoolean.INSTANCE.getSqlTypeName());
            UpgradeUtil.addParentToChildLinks(metaConnection);
        }
        if (currentServerSideTableTimeStamp < 28L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 28L, "TRANSACTION_PROVIDER " + PTinyint.INSTANCE.getSqlTypeName());
            try (Statement altQry = metaConnection.createStatement();){
                altQry.executeUpdate("ALTER TABLE SYSTEM.\"CATALOG\" SET VERSIONS= " + this.props.getInt("phoenix.system.default.max.versions", 1) + ",\nKEEP_DELETED_CELLS=" + this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
                altQry.executeUpdate("ALTER TABLE SYSTEM.\"FUNCTION\" SET SPLIT_POLICY='org.apache.phoenix.schema.SystemFunctionSplitPolicy',\nVERSIONS= " + this.props.getInt("phoenix.system.default.max.versions", 1) + ",\nKEEP_DELETED_CELLS=" + this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
                altQry.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " SET SPLIT_POLICY='org.apache.phoenix.schema.SystemStatsSplitPolicy'");
            }
        }
        if (currentServerSideTableTimeStamp < 29L) {
            UpgradeUtil.addViewIndexToParentLinks(metaConnection);
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 29L, "VIEW_INDEX_ID_DATA_TYPE " + PInteger.INSTANCE.getSqlTypeName());
        }
        if (currentServerSideTableTimeStamp < 33L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 30L, "PHOENIX_TTL " + PInteger.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 31L, "PHOENIX_TTL_HWM " + PInteger.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 32L, "LAST_DDL_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 33L, "CHANGE_DETECTION_ENABLED " + PBoolean.INSTANCE.getSqlTypeName());
            UpgradeUtil.bootstrapLastDDLTimestampForTablesAndViews(metaConnection);
            boolean isNamespaceMapping = SchemaUtil.isNamespaceMappingEnabled(null, this.getConfiguration());
            String tableName = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME;
            if (isNamespaceMapping) {
                tableName = tableName.replace(".", ":");
            }
            byte[] tableBytes = StringUtil.toBytes(tableName);
            byte[] rowKey = SchemaUtil.getColumnKey(null, "SYSTEM", "CATALOG", "VIEW_INDEX_ID", "0");
            if (UpgradeUtil.isUpdateViewIndexIdColumnDataTypeFromShortToLongNeeded(metaConnection, rowKey, tableBytes)) {
                LOGGER.info("Updating VIEW_INDEX_ID data type to BIGINT.");
                UpgradeUtil.updateViewIndexIdColumnDataTypeFromShortToLong(metaConnection, rowKey, tableBytes);
            } else {
                LOGGER.info("Updating VIEW_INDEX_ID data type is not needed.");
            }
            try (Admin admin = metaConnection.getQueryServices().getAdmin();){
                TableName sysCatPhysicalTableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, this.props);
                TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)admin.getDescriptor(sysCatPhysicalTableName));
                if (!tdBuilder.build().hasCoprocessor("org.apache.phoenix.coprocessor.SystemCatalogRegionObserver")) {
                    int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
                    tdBuilder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.SystemCatalogRegionObserver").setPriority(priority).setProperties(Collections.emptyMap()).build());
                    admin.modifyTable(tdBuilder.build());
                    this.pollForUpdatedTableDescriptor(admin, tdBuilder.build(), sysCatPhysicalTableName.getName());
                }
            }
        }
        if (currentServerSideTableTimeStamp < 42L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 34L, "PHYSICAL_TABLE_NAME " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 35L, "SCHEMA_VERSION " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 36L, "EXTERNAL_SCHEMA_ID " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 37L, "STREAMING_TOPIC_NAME " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 38L, "INDEX_WHERE " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 39L, "CDC_INCLUDE " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 40L, "TTL " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 41L, "ROW_KEY_MATCHER " + PVarbinary.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 42L, "IS_STRICT_TTL " + PBoolean.INSTANCE.getSqlTypeName());
            this.moveTTLFromHBaseLevelTTLToPhoenixLevelTTL(metaConnection);
            UpgradeUtil.bootstrapLastDDLTimestampForTablesAndViews(metaConnection);
            UpgradeUtil.bootstrapLastDDLTimestampForIndexes(metaConnection);
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void upgradeSystemTables(String url, Properties props) throws SQLException {
        PhoenixConnection metaConnection = null;
        boolean success = false;
        HashMap<String, String> systemTableToSnapshotMap = new HashMap<String, String>();
        String sysCatalogTableName = null;
        SQLException toThrow = null;
        boolean acquiredMutexLock = false;
        boolean moveChildLinks = false;
        boolean syncAllTableAndIndexProps = false;
        try {
            if (!this.isUpgradeRequired()) {
                throw new UpgradeNotRequiredException();
            }
            Properties scnProps = PropertiesUtil.deepCopy(props);
            scnProps.setProperty("CurrentSCN", Long.toString(42L));
            scnProps.remove("TenantId");
            String globalUrl = JDBCUtil.removeProperty(url, "TenantId");
            metaConnection = new PhoenixConnection(this, globalUrl, scnProps);
            metaConnection.setRunningUpgrade(true);
            try (Admin admin = this.getAdmin();){
                this.createSysMutexTableIfNotExists(admin);
            }
            UpgradeRequiredException caughtUpgradeRequiredException = null;
            TableAlreadyExistsException caughtTableAlreadyExistsException = null;
            try {
                metaConnection.createStatement().executeUpdate(this.getSystemCatalogTableDDL());
            }
            catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
            }
            catch (UpgradeRequiredException e) {
                caughtUpgradeRequiredException = e;
            }
            catch (TableAlreadyExistsException e) {
                caughtTableAlreadyExistsException = e;
            }
            if (caughtUpgradeRequiredException != null || caughtTableAlreadyExistsException != null) {
                long currentServerSideTableTimeStamp = caughtUpgradeRequiredException != null ? caughtUpgradeRequiredException.getSystemCatalogTimeStamp() : caughtTableAlreadyExistsException.getTable().getTimeStamp();
                ReadOnlyProps readOnlyProps = metaConnection.getQueryServices().getProps();
                String skipUpgradeBlock = readOnlyProps.get("phoenix.skip.upgrade.block.check");
                if (skipUpgradeBlock == null || !Boolean.valueOf(skipUpgradeBlock).booleanValue()) {
                    this.checkUpgradeBlockMutex();
                }
                acquiredMutexLock = this.acquireUpgradeMutex(0L);
                LOGGER.debug("Acquired lock in SYSMUTEX table for migrating SYSTEM tables to SYSTEM namespace and/or upgrading " + sysCatalogTableName);
                String snapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                this.createSnapshot(snapshotName, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                systemTableToSnapshotMap.put(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, snapshotName);
                LOGGER.info("Created snapshot {} for {}", (Object)snapshotName, (Object)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                String mappedSnapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, "MAPPED." + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                this.createSnapshot(mappedSnapshotName, PhoenixDatabaseMetaData.MAPPED_SYSTEM_CATALOG_NAME);
                systemTableToSnapshotMap.put(PhoenixDatabaseMetaData.MAPPED_SYSTEM_CATALOG_NAME, mappedSnapshotName);
                LOGGER.info("Created snapshot {} for {}", (Object)mappedSnapshotName, (Object)PhoenixDatabaseMetaData.MAPPED_SYSTEM_CATALOG_NAME);
                if (caughtUpgradeRequiredException != null && SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                    this.ensureSystemTablesMigratedToSystemNamespace();
                    LOGGER.debug("Migrated SYSTEM tables to SYSTEM namespace");
                }
                metaConnection = this.upgradeSystemCatalogIfRequired(metaConnection, currentServerSideTableTimeStamp);
                if (currentServerSideTableTimeStamp < 29L) {
                    moveChildLinks = true;
                    syncAllTableAndIndexProps = true;
                }
                if (currentServerSideTableTimeStamp < 33L) {
                    try (PhoenixConnection conn = new PhoenixConnection(this, globalUrl, props);){
                        UpgradeUtil.mergeViewIndexIdSequences(metaConnection);
                    }
                    catch (Exception mergeViewIndeIdException) {
                        LOGGER.warn("Merge view index id sequence failed! If possible, please run MergeViewIndexIdSequencesTool to avoid view indexid collision. Error: " + mergeViewIndeIdException.getMessage());
                    }
                }
            }
            metaConnection = this.upgradeOtherSystemTablesIfRequired(metaConnection, moveChildLinks, systemTableToSnapshotMap);
            if (this.localIndexUpgradeRequired) {
                LOGGER.info("Upgrading local indexes");
                metaConnection = UpgradeUtil.upgradeLocalIndexes(metaConnection);
            }
            if (syncAllTableAndIndexProps) {
                UpgradeUtil.syncTableAndIndexProperties(metaConnection);
            }
            this.createSchemaIfNotExistsSystemNSMappingEnabled(metaConnection);
            this.clearUpgradeRequired();
            success = true;
            return;
        }
        catch (UpgradeInProgressException | UpgradeNotRequiredException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                toThrow = (SQLException)e;
            }
            toThrow = new SQLException(e);
        }
        finally {
            try {
                if (metaConnection != null) {
                    metaConnection.close();
                }
            }
            catch (SQLException e) {
                if (toThrow != null) {
                    toThrow.setNextException(e);
                }
                toThrow = e;
            }
            finally {
                if (!success) {
                    LOGGER.warn("Failed upgrading System tables. Snapshots for system tables created so far: {}", systemTableToSnapshotMap);
                }
                if (acquiredMutexLock) {
                    try {
                        this.releaseUpgradeMutex();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Release of upgrade mutex failed ", (Throwable)e);
                    }
                }
                if (toThrow == null) return;
                throw toThrow;
            }
        }
    }

    private PhoenixConnection upgradeOtherSystemTablesIfRequired(PhoenixConnection metaConnection, boolean moveChildLinks, Map<String, String> systemTableToSnapshotMap) throws SQLException, IOException {
        metaConnection = this.upgradeSystemSequence(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemStats(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemTask(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemFunction(metaConnection);
        metaConnection = this.upgradeSystemTransform(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemLog(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemMutex(metaConnection);
        metaConnection = this.upgradeSystemCDCStreamStatus(metaConnection);
        metaConnection = this.upgradeSystemCDCStream(metaConnection);
        metaConnection = this.upgradeSystemChildLink(metaConnection, moveChildLinks, systemTableToSnapshotMap);
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemChildLink(PhoenixConnection metaConnection, boolean moveChildLinks, Map<String, String> systemTableToSnapshotMap) throws SQLException, IOException {
        try (Statement statement = metaConnection.createStatement();){
            statement.executeUpdate(this.getChildLinkDDL());
        }
        catch (TableAlreadyExistsException e) {
            this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
        }
        if (moveChildLinks) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("hbase.rpc.timeout", Integer.toString(1800000));
            options.put("hbase.client.scanner.timeout.period", Integer.toString(1800000));
            UpgradeUtil.moveOrCopyChildLinks(metaConnection, options);
        }
        return metaConnection;
    }

    @VisibleForTesting
    public PhoenixConnection upgradeSystemSequence(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException, IOException {
        try (Statement statement = metaConnection.createStatement();){
            String createSequenceTable = this.getSystemSequenceTableDDL(this.nSequenceSaltBuckets);
            statement.executeUpdate(createSequenceTable);
        }
        catch (NewerTableAlreadyExistsException e) {
            this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
        }
        catch (TableAlreadyExistsException e) {
            this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
            long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
            if (currentServerSideTableTimeStamp < 3L) {
                String columnsToAdd = "MIN_VALUE " + PLong.INSTANCE.getSqlTypeName() + ", MAX_VALUE " + PLong.INSTANCE.getSqlTypeName() + ", CYCLE_FLAG " + PBoolean.INSTANCE.getSqlTypeName() + ", LIMIT_REACHED_FLAG " + PBoolean.INSTANCE.getSqlTypeName();
                this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 42L, columnsToAdd);
            }
            if (currentServerSideTableTimeStamp < 5L) {
                if (UpgradeUtil.upgradeSequenceTable(metaConnection, this.nSequenceSaltBuckets, e.getTable())) {
                    metaConnection.removeTable(null, "SYSTEM", "SEQUENCE", 42L);
                    this.clearTableFromCache(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_SCHEMA_BYTES, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_TABLE_BYTES, 42L);
                    this.clearTableRegionCache(TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES));
                }
            } else {
                this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
            }
            this.updateSystemSequenceWithCacheOnWriteProps(metaConnection);
        }
        return metaConnection;
    }

    private void updateSystemSequenceWithCacheOnWriteProps(PhoenixConnection metaConnection) throws IOException, SQLException {
        try (Admin admin = this.getAdmin();){
            TableDescriptor oldTD = admin.getDescriptor(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME, metaConnection.getQueryServices().getProps()));
            ColumnFamilyDescriptor oldCf = oldTD.getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            if (!(oldCf.isCacheBloomsOnWrite() && oldCf.isCacheDataOnWrite() && oldCf.isCacheIndexesOnWrite())) {
                ColumnFamilyDescriptorBuilder newCFBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)oldCf);
                newCFBuilder.setCacheBloomsOnWrite(true);
                newCFBuilder.setCacheDataOnWrite(true);
                newCFBuilder.setCacheIndexesOnWrite(true);
                TableDescriptorBuilder newTD = TableDescriptorBuilder.newBuilder((TableDescriptor)oldTD);
                newTD.modifyColumnFamily(newCFBuilder.build());
                admin.modifyTable(newTD.build());
            }
        }
    }

    private void takeSnapshotOfSysTable(Map<String, String> systemTableToSnapshotMap, TableAlreadyExistsException e) throws SQLException {
        String tableName;
        long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
        String snapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, tableName = e.getTable().getPhysicalName().getString());
        if (snapshotName.contains(":")) {
            snapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, "MAPPED." + tableName).replace(":", ".");
        }
        this.createSnapshot(snapshotName, tableName);
        systemTableToSnapshotMap.put(tableName, snapshotName);
        LOGGER.info("Snapshot {} created for table {}", (Object)snapshotName, (Object)tableName);
    }

    @VisibleForTesting
    public PhoenixConnection upgradeSystemStats(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException, org.apache.hadoop.hbase.TableNotFoundException, IOException {
        block24: {
            try (Statement statement2 = metaConnection.createStatement();){
                statement2.executeUpdate(QueryConstants.CREATE_STATS_TABLE_METADATA);
            }
            catch (NewerTableAlreadyExistsException statement2) {
            }
            catch (TableAlreadyExistsException e) {
                this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
                long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                if (currentServerSideTableTimeStamp < 7L) {
                    metaConnection = this.addColumnsIfNotExists(metaConnection, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, 42L, "GUIDE_POSTS_ROW_COUNT " + PLong.INSTANCE.getSqlTypeName());
                }
                if (currentServerSideTableTimeStamp < 20L) {
                    metaConnection = this.removeNotNullConstraint(metaConnection, "SYSTEM", "STATS", 20L, "COLUMN_FAMILY");
                    this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, null, 20L);
                    this.clearCache();
                }
                if (UpgradeUtil.tableHasKeepDeleted(metaConnection, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME)) {
                    try (Statement altStmt = metaConnection.createStatement();){
                        altStmt.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " SET KEEP_DELETED_CELLS='" + KeepDeletedCells.FALSE + "'");
                    }
                }
                if (!UpgradeUtil.tableHasMaxVersions(metaConnection, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME)) break block24;
                try (Statement altStats = metaConnection.createStatement();){
                    altStats.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " SET VERSIONS = '1' ");
                }
            }
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemTask(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException, IOException {
        try (Statement statement2 = metaConnection.createStatement();){
            statement2.executeUpdate(this.getTaskDDL());
        }
        catch (NewerTableAlreadyExistsException statement2) {
        }
        catch (TableAlreadyExistsException e) {
            this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
            long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
            if (currentServerSideTableTimeStamp <= 29L) {
                String columnsToAdd = "TASK_STATUS " + PVarchar.INSTANCE.getSqlTypeName() + ", TASK_END_TS " + PTimestamp.INSTANCE.getSqlTypeName() + ", TASK_PRIORITY " + PUnsignedTinyint.INSTANCE.getSqlTypeName() + ", TASK_DATA " + PVarchar.INSTANCE.getSqlTypeName();
                String taskTableFullName = SchemaUtil.getTableName("SYSTEM", "TASK");
                metaConnection = this.addColumnsIfNotExists(metaConnection, taskTableFullName, 42L, columnsToAdd);
                String altQuery = String.format(ALTER_TABLE_SET_PROPS, taskTableFullName, "TTL", "864000");
                try (PreparedStatement altQueryStmt = metaConnection.prepareStatement(altQuery);){
                    altQueryStmt.executeUpdate();
                }
                this.clearCache();
            }
            try (Admin admin = metaConnection.getQueryServices().getAdmin();){
                TableName tableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME, this.props);
                TableDescriptor td = admin.getDescriptor(tableName);
                TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)td);
                boolean isTableDescUpdated = false;
                if (this.updateAndConfirmSplitPolicyForTask(tableDescriptorBuilder)) {
                    isTableDescUpdated = true;
                }
                if (!tableDescriptorBuilder.build().hasCoprocessor("org.apache.phoenix.coprocessor.TaskMetaDataEndpoint")) {
                    int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
                    tableDescriptorBuilder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.phoenix.coprocessor.TaskMetaDataEndpoint").setPriority(priority).setProperties(Collections.emptyMap()).build());
                    isTableDescUpdated = true;
                }
                if (isTableDescUpdated) {
                    admin.modifyTable(tableDescriptorBuilder.build());
                    this.pollForUpdatedTableDescriptor(admin, tableDescriptorBuilder.build(), tableName.getName());
                }
            }
            catch (InterruptedException | TimeoutException ite) {
                throw new SQLException(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " Upgrade is not confirmed");
            }
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemTransform(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException {
        try (Statement statement = metaConnection.createStatement();){
            statement.executeUpdate(this.getTransformDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemFunction(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getFunctionTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    @VisibleForTesting
    public PhoenixConnection upgradeSystemLog(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException, org.apache.hadoop.hbase.TableNotFoundException, IOException {
        block22: {
            try (Statement statement2 = metaConnection.createStatement();){
                statement2.executeUpdate(this.getLogTableDDL());
            }
            catch (NewerTableAlreadyExistsException statement2) {
            }
            catch (TableAlreadyExistsException e) {
                this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
                if (UpgradeUtil.tableHasKeepDeleted(metaConnection, PhoenixDatabaseMetaData.SYSTEM_LOG_NAME)) {
                    try (Statement altLogStmt = metaConnection.createStatement();){
                        altLogStmt.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_LOG_NAME + " SET KEEP_DELETED_CELLS='" + KeepDeletedCells.FALSE + "'");
                    }
                }
                if (!UpgradeUtil.tableHasMaxVersions(metaConnection, PhoenixDatabaseMetaData.SYSTEM_LOG_NAME)) break block22;
                try (Statement altLogVer = metaConnection.createStatement();){
                    altLogVer.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_LOG_NAME + " SET VERSIONS='1'");
                }
            }
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemMutex(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getMutexDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemCDCStreamStatus(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getCDCStreamStatusDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemCDCStream(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getCDCStreamDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection addColumnQualifierColumn(PhoenixConnection oldMetaConnection, Long timestamp) throws SQLException {
        Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
        props.setProperty("CurrentSCN", Long.toString(timestamp));
        PhoenixConnection metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
        metaConnection.setAutoCommit(false);
        PTable sysCatalogPTable = metaConnection.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
        int numColumns = sysCatalogPTable.getColumns().size();
        try (PreparedStatement mutateTable = metaConnection.prepareStatement("UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)");){
            mutateTable.setString(1, null);
            mutateTable.setString(2, "SYSTEM");
            mutateTable.setString(3, "CATALOG");
            mutateTable.setString(4, PTableType.SYSTEM.getSerializedValue());
            mutateTable.setLong(5, sysCatalogPTable.getSequenceNumber() + 1L);
            mutateTable.setInt(6, numColumns + 1);
            mutateTable.execute();
        }
        ArrayList<Mutation> tableMetadata = new ArrayList<Mutation>((Collection)metaConnection.getMutationState().toMutations(metaConnection.getSCN()).next().getSecond());
        metaConnection.rollback();
        PColumnImpl column = new PColumnImpl(PNameFactory.newName("COLUMN_QUALIFIER"), PNameFactory.newName("DEFAULT_COLUMN_FAMILY"), PVarbinary.INSTANCE, null, null, true, numColumns, SortOrder.ASC, null, null, false, null, false, false, Bytes.toBytes((String)"COLUMN_QUALIFIER"), timestamp);
        String upsertColumnMetadata = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,IS_ROW_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement colUpsert = metaConnection.prepareStatement(upsertColumnMetadata);){
            colUpsert.setString(1, null);
            colUpsert.setString(2, "SYSTEM");
            colUpsert.setString(3, "CATALOG");
            colUpsert.setString(4, "COLUMN_QUALIFIER");
            colUpsert.setString(5, "0");
            colUpsert.setInt(6, column.getDataType().getSqlType());
            colUpsert.setInt(7, 1);
            colUpsert.setNull(8, 4);
            colUpsert.setNull(9, 4);
            colUpsert.setInt(10, sysCatalogPTable.getBucketNum() != null ? numColumns : numColumns + 1);
            colUpsert.setInt(11, SortOrder.ASC.getSystemValue());
            colUpsert.setString(12, null);
            colUpsert.setNull(13, 4);
            colUpsert.setBytes(14, null);
            colUpsert.setBoolean(15, false);
            colUpsert.setString(16, sysCatalogPTable.getPKName() == null ? null : sysCatalogPTable.getPKName().getString());
            colUpsert.setNull(17, 5);
            colUpsert.setNull(18, 12);
            colUpsert.setBoolean(19, false);
            colUpsert.execute();
        }
        tableMetadata.addAll((Collection)metaConnection.getMutationState().toMutations(metaConnection.getSCN()).next().getSecond());
        metaConnection.rollback();
        metaConnection.getQueryServices().addColumn(tableMetadata, sysCatalogPTable, null, null, Collections.emptyMap(), Collections.emptySet(), Lists.newArrayList((Object[])new PColumn[]{column}));
        metaConnection.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, timestamp);
        this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, timestamp);
        this.clearCache();
        return metaConnection;
    }

    private void deleteSnapshot(String snapshotName) throws SQLException, IOException {
        try (Admin admin = this.getAdmin();){
            admin.deleteSnapshot(snapshotName);
            LOGGER.info("Snapshot {} is deleted", (Object)snapshotName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSnapshot(String snapshotName, String tableName) throws SQLException {
        Admin admin = null;
        SQLException sqlE = null;
        try {
            admin = this.getAdmin();
            admin.snapshot(snapshotName, TableName.valueOf((String)tableName));
            LOGGER.info("Successfully created snapshot " + snapshotName + " for " + tableName);
            return;
        }
        catch (SnapshotCreationException e) {
            if (e.getMessage().contains("doesn't exist")) {
                LOGGER.warn("Could not create snapshot {}, table is missing." + snapshotName, (Throwable)e);
            }
            sqlE = new SQLException(e);
        }
        catch (Exception e) {
            sqlE = new SQLException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (Exception e) {
                SQLException adminCloseEx = new SQLException(e);
                if (sqlE == null) {
                    sqlE = adminCloseEx;
                }
                sqlE.setNextException(adminCloseEx);
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureSystemTablesMigratedToSystemNamespace() throws SQLException, IOException, IllegalArgumentException, InterruptedException {
        if (!SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
            return;
        }
        try (Table metatable = null;
             Admin admin = this.getAdmin();){
            List<TableName> tableNames = this.getSystemTableNamesInDefaultNamespace(admin);
            if (tableNames.size() == 0) {
                return;
            }
            if (tableNames.size() > 9) {
                LOGGER.warn("Expected 9 system tables but found " + tableNames.size() + ":" + tableNames);
            }
            byte[] mappedSystemTable = SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName();
            metatable = this.getTable(mappedSystemTable);
            if (tableNames.contains(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME)) {
                if (!AdminUtilWithFallback.tableExists(admin, TableName.valueOf((byte[])mappedSystemTable))) {
                    LOGGER.info("Migrating SYSTEM.CATALOG table to SYSTEM namespace.");
                    UpgradeUtil.mapTableToNamespace(admin, metatable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, this.getProps(), null, PTableType.SYSTEM, null);
                    this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 3L);
                }
                tableNames.remove(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME);
            }
            for (TableName table : tableNames) {
                LOGGER.info(String.format("Migrating %s table to SYSTEM namespace.", table.getNameAsString()));
                UpgradeUtil.mapTableToNamespace(admin, metatable, table.getNameAsString(), this.getProps(), null, PTableType.SYSTEM, null);
                this.removeTable(null, table.getNameAsString(), null, 3L);
            }
            this.clearCache();
        }
    }

    @VisibleForTesting
    public boolean checkUpgradeBlockMutex() throws SQLException {
        try (Table sysMutexTable = this.getSysMutexTable();){
            byte[] rowKey = Bytes.toBytes((String)"BLOCK_UPGRADE");
            Get get = new Get(rowKey).addColumn(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES, PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES);
            Result r = sysMutexTable.get(get);
            if (!r.isEmpty()) {
                throw new UpgradeBlockedException();
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
        return true;
    }

    @VisibleForTesting
    public boolean acquireUpgradeMutex(long currentServerSideTableTimestamp) throws SQLException {
        Preconditions.checkArgument((currentServerSideTableTimestamp < 42L ? 1 : 0) != 0);
        if (!this.writeMutexCell(null, "SYSTEM", "CATALOG", null, null)) {
            throw new UpgradeInProgressException(MetaDataProtocol.getVersion(currentServerSideTableTimestamp), MetaDataProtocol.getVersion(42L));
        }
        return true;
    }

    @Override
    public boolean writeMutexCell(String tenantId, String schemaName, String tableName, String columnName, String familyName) throws SQLException {
        boolean bl;
        block10: {
            byte[] rowKey = columnName != null ? SchemaUtil.getColumnKey(tenantId, schemaName, tableName, columnName, familyName) : SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            Table sysMutexTable = this.getSysMutexTable();
            try {
                Put put = new Put(rowKey);
                put.addColumn(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES, PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES, MUTEX_LOCKED);
                CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])rowKey).ifNotExists(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES, PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES).build(put);
                boolean checkAndPut = sysMutexTable.checkAndMutate(checkAndMutate).isSuccess();
                String processName = ManagementFactory.getRuntimeMXBean().getName();
                String msg = " tenantId : " + tenantId + " schemaName : " + schemaName + " tableName : " + tableName + " columnName : " + columnName + " familyName : " + familyName;
                if (!checkAndPut) {
                    LOGGER.error(processName + " failed to acquire mutex for " + msg);
                } else {
                    LOGGER.debug(processName + " acquired mutex for " + msg);
                }
                bl = checkAndPut;
                if (sysMutexTable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (sysMutexTable != null) {
                        try {
                            sysMutexTable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ClientUtil.parseServerException(e);
                }
            }
            sysMutexTable.close();
        }
        return bl;
    }

    @VisibleForTesting
    public void releaseUpgradeMutex() throws IOException, SQLException {
        this.deleteMutexCell(null, "SYSTEM", "CATALOG", null, null);
    }

    @Override
    public void deleteMutexCell(String tenantId, String schemaName, String tableName, String columnName, String familyName) throws SQLException {
        try {
            byte[] rowKey = columnName != null ? SchemaUtil.getColumnKey(tenantId, schemaName, tableName, columnName, familyName) : SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            try (Table sysMutexTable = this.getSysMutexTable();){
                byte[] family = PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES;
                byte[] qualifier = PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES;
                Delete delete = new Delete(rowKey);
                delete.addColumn(family, qualifier);
                sysMutexTable.delete(delete);
                String processName = ManagementFactory.getRuntimeMXBean().getName();
                String msg = " tenantId : " + tenantId + " schemaName : " + schemaName + " tableName : " + tableName + " columnName : " + columnName + " familyName : " + familyName;
                LOGGER.debug(processName + " released mutex for " + msg);
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    @VisibleForTesting
    public Table getSysMutexTable() throws SQLException {
        Table table;
        String tableNameAsString = PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME;
        try {
            table = this.getTableIfExists(Bytes.toBytes((String)tableNameAsString));
        }
        catch (TableNotFoundException e) {
            tableNameAsString = tableNameAsString.replace(".", ":");
            table = this.getTable(Bytes.toBytes((String)tableNameAsString));
        }
        return table;
    }

    private String addColumn(String columnsToAddSoFar, String columns) {
        if (columnsToAddSoFar == null || columnsToAddSoFar.isEmpty()) {
            return columns;
        }
        return columnsToAddSoFar + ", " + columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection setImmutableTableIndexesImmutable(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            SQLException sqlE = null;
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            boolean autoCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().execute("UPSERT INTO SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, IMMUTABLE_ROWS)\nSELECT A.TENANT_ID, A.TABLE_SCHEM,B.COLUMN_FAMILY,null,null,true\nFROM SYSTEM.CATALOG A JOIN SYSTEM.CATALOG B ON (\n A.TENANT_ID = B.TENANT_ID AND \n A.TABLE_SCHEM = B.TABLE_SCHEM AND\n A.TABLE_NAME = B.TABLE_NAME AND\n A.COLUMN_NAME = B.COLUMN_NAME AND\n B.LINK_TYPE = 1\n)\nWHERE A.COLUMN_FAMILY IS NULL AND\n B.COLUMN_FAMILY IS NOT NULL AND\n A.IMMUTABLE_ROWS = TRUE");
            }
            catch (SQLException e) {
                LOGGER.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(autoCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection updateSystemCatalogTimestamp(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            SQLException sqlE = null;
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            boolean autoCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().execute("UPSERT INTO SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, DISABLE_WAL)\nVALUES (NULL, 'SYSTEM','CATALOG', NULL, NULL, FALSE)");
            }
            catch (SQLException e) {
                LOGGER.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(autoCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection dropStatsTable(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException, IOException {
        PhoenixConnection metaConnection;
        block12: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            boolean wasCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().executeUpdate("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_NAME='STATS' AND TABLE_SCHEM='SYSTEM'");
            }
            catch (SQLException e) {
                LOGGER.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(wasCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    private void scheduleRenewLeaseTasks() {
        if (this.isRenewingLeasesEnabled()) {
            this.renewLeaseExecutor = Executors.newScheduledThreadPool(this.renewLeasePoolSize, renewLeaseThreadFactory);
            for (LinkedBlockingQueue<WeakReference<PhoenixConnection>> q : this.connectionQueues) {
                this.renewLeaseExecutor.scheduleAtFixedRate(new RenewLeaseTask(q), 0L, this.renewLeaseTaskFrequency, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static int getSaltBuckets(TableAlreadyExistsException e) {
        PTable table = e.getTable();
        Integer sequenceSaltBuckets = table == null ? null : table.getBucketNum();
        return sequenceSaltBuckets == null ? 0 : sequenceSaltBuckets;
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        MutationState state = plan.execute();
        plan.getContext().getConnection().commit();
        return state;
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return this.lowestClusterHBaseVersion;
    }

    @Override
    public boolean hasIndexWALCodec() {
        return this.hasIndexWALCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clearCache() throws SQLException {
        long l;
        block19: {
            Object object = this.latestMetaDataLock;
            synchronized (object) {
                this.latestMetaData = this.newEmptyMetaData();
            }
            this.tableStatsCache.invalidateAll();
            long startTime = 0L;
            Table htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
            try {
                Map results;
                try {
                    startTime = EnvironmentEdgeManager.currentTimeMillis();
                    results = htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, Long>(){

                        public Long call(MetaDataProtos.MetaDataService instance) throws IOException {
                            RpcController controller = ConnectionQueryServicesImpl.this.getController();
                            CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                            MetaDataProtos.ClearCacheRequest.Builder builder = MetaDataProtos.ClearCacheRequest.newBuilder();
                            builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                            instance.clearCache(controller, builder.build(), (RpcCallback<MetaDataProtos.ClearCacheResponse>)rpcCallback);
                            ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                            return ((MetaDataProtos.ClearCacheResponse)rpcCallback.get()).getUnfreedBytes();
                        }
                    });
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, 1L);
                }
                catch (Throwable e) {
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES, 1L);
                    throw ClientUtil.parseServerException(e);
                }
                finally {
                    long systemCatalogRpcTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, systemCatalogRpcTime);
                }
                long unfreedBytes = 0L;
                for (Map.Entry result : results.entrySet()) {
                    if (result.getValue() == null) continue;
                    unfreedBytes += ((Long)result.getValue()).longValue();
                }
                l = unfreedBytes;
                if (htable == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (htable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ClientUtil.parseServerException(e);
                }
                catch (Throwable e) {
                    throw new SQLException(e);
                }
            }
            htable.close();
        }
        return l;
    }

    private void flushTable(byte[] tableName) throws SQLException {
        Admin admin = this.getAdmin();
        try {
            admin.flush(TableName.valueOf((byte[])tableName));
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)admin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLiveRegionServers() throws SQLException {
        Object object = this.liveRegionServersLock;
        synchronized (object) {
            try (Admin admin = this.getAdmin();){
                this.liveRegionServers = new ArrayList<ServerName>(admin.getRegionServers(true));
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException(e);
            }
        }
        LOGGER.info("Refreshed list of live region servers.");
    }

    @Override
    public List<ServerName> getLiveRegionServers() {
        return this.liveRegionServers;
    }

    @Override
    public Admin getAdmin() throws SQLException {
        try {
            return this.connection.getAdmin();
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(final List<Mutation> tableMetaData, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tableKey = SchemaUtil.getTableKey(rowKeyMetadata[0], rowKeyMetadata[1], rowKeyMetadata[2]);
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        return this.metaDataCoprocessorExec(SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.props)).toString(), tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.updateIndexState(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(List<Mutation> tableMetaData, String parentTableName, Map<String, List<Pair<String, Object>>> stmtProperties, PTable table) throws SQLException {
        if (stmtProperties == null) {
            return this.updateIndexState(tableMetaData, parentTableName);
        }
        Map<TableDescriptor, TableDescriptor> oldToNewTableDescriptors = this.separateAndValidateProperties(table, stmtProperties, new HashSet<String>(), new HashMap<String, Object>());
        TableDescriptor origTableDescriptor = this.getTableDescriptor(table.getPhysicalName().getBytes());
        TableDescriptor newTableDescriptor = oldToNewTableDescriptors.remove(origTableDescriptor);
        HashSet modifiedTableDescriptors = Collections.emptySet();
        if (newTableDescriptor != null) {
            modifiedTableDescriptors = Sets.newHashSetWithExpectedSize((int)(3 + table.getIndexes().size()));
            modifiedTableDescriptors.add(newTableDescriptor);
        }
        this.sendHBaseMetaData(modifiedTableDescriptors, true);
        return this.updateIndexState(tableMetaData, parentTableName);
    }

    /*
     * Loose catch block
     */
    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue, boolean cycle, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.createSequence(startWith, incrementBy, cacheSize, timestamp, minValue, maxValue, cycle);
            Table htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            try {
                Result result = htable.append(append);
                long l = sequence.createSequence(result, minValue, maxValue, cycle);
                return l;
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.dropSequence(timestamp);
            Table htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            try {
                Result result = htable.append(append);
                long l = sequence.dropSequence(result);
                return l;
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        Sequence sequence = (Sequence)this.sequenceMap.get(sequenceKey);
        if (sequence == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        sequence.getLock().lock();
        try {
            long l = sequence.currentValue(timestamp);
            return l;
        }
        catch (EmptySequenceCacheException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public void validateSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp action) throws SQLException {
        this.incrementSequenceValues(sequenceAllocations, timestamp, values, exceptions, action);
    }

    @Override
    public void incrementSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        this.incrementSequenceValues(sequenceAllocations, timestamp, values, exceptions, Sequence.ValueOp.INCREMENT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequenceValues(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp op) throws SQLException {
        Sequence sequence4;
        ArrayList sequences = Lists.newArrayListWithExpectedSize((int)sequenceAllocations.size());
        for (SequenceAllocation sequenceAllocation : sequenceAllocations) {
            SequenceKey key = sequenceAllocation.getSequenceKey();
            Sequence newSequences = new Sequence(key);
            sequence4 = this.getSequence(sequenceAllocation);
            if (sequence4 == null) {
                sequence4 = newSequences;
            }
            sequences.add(sequence4);
        }
        try {
            Object[] resultObjects;
            ArrayList toIncrementList;
            ArrayList incrementBatch;
            block32: {
                for (Sequence sequence2 : sequences) {
                    sequence2.getLock().lock();
                }
                incrementBatch = Lists.newArrayListWithExpectedSize((int)sequences.size());
                toIncrementList = Lists.newArrayListWithExpectedSize((int)sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    sequence4 = (Sequence)sequences.get(i);
                    try {
                        values[i] = sequence4.incrementValue(timestamp, op, sequenceAllocations.get(i).getNumAllocations());
                        continue;
                    }
                    catch (EmptySequenceCacheException e) {
                        indexes[toIncrementList.size()] = i;
                        toIncrementList.add(sequence4);
                        Increment inc = sequence4.newIncrement(timestamp, op, sequenceAllocations.get(i).getNumAllocations());
                        incrementBatch.add(inc);
                        continue;
                    }
                    catch (SQLException e) {
                        exceptions[i] = e;
                    }
                }
                if (toIncrementList.isEmpty()) {
                    return;
                }
                Table hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
                resultObjects = new Object[incrementBatch.size()];
                SQLException sqlE = null;
                try {
                    hTable.batch((List)incrementBatch, resultObjects);
                }
                catch (IOException e) {
                    sqlE = ClientUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ClientUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ClientUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block32;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence3 = (Sequence)toIncrementList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    long numToAllocate = Bytes.toLong((byte[])((Increment)incrementBatch.get(i)).getAttribute("NUM_TO_ALLOCATE"));
                    values[indexes[i]] = sequence3.incrementValue(result, op, numToAllocate);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence4 : sequences) {
                sequence4.getLock().unlock();
            }
        }
    }

    private Sequence getSequence(SequenceAllocation sequenceAllocation) {
        SequenceKey key = sequenceAllocation.getSequenceKey();
        if (key.getTenantId() == null) {
            return this.sequenceMap.putIfAbsent(key, new Sequence(key));
        }
        Sequence sequence = (Sequence)this.sequenceMap.get(key);
        if (sequence == null) {
            return this.sequenceMap.entrySet().stream().filter(entry -> this.compareSequenceKeysWithoutTenant(key, (SequenceKey)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return sequence;
    }

    private boolean compareSequenceKeysWithoutTenant(SequenceKey keyToCompare, SequenceKey availableKey) {
        boolean sameSchema;
        if (availableKey.getTenantId() != null) {
            return false;
        }
        boolean bl = keyToCompare.getSchemaName() == null ? availableKey.getSchemaName() == null : (sameSchema = keyToCompare.getSchemaName().equals(availableKey.getSchemaName()));
        if (!sameSchema) {
            return false;
        }
        return keyToCompare.getSequenceName().equals(availableKey.getSequenceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearTableFromCache(final byte[] tenantId, final byte[] schemaName, final byte[] tableName, final long clientTS) throws SQLException {
        boolean success = false;
        try {
            SQLException sqlE = null;
            long startTime = 0L;
            Table htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
            try {
                startTime = EnvironmentEdgeManager.currentTimeMillis();
                htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearTableFromCacheResponse>(){

                    public MetaDataProtos.ClearTableFromCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        RpcController controller = ConnectionQueryServicesImpl.this.getController();
                        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                        MetaDataProtos.ClearTableFromCacheRequest.Builder builder = MetaDataProtos.ClearTableFromCacheRequest.newBuilder();
                        builder.setTenantId(ByteStringer.wrap((byte[])tenantId));
                        builder.setTableName(ByteStringer.wrap((byte[])tableName));
                        builder.setSchemaName(ByteStringer.wrap((byte[])schemaName));
                        builder.setClientTimestamp(clientTS);
                        builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                        instance.clearTableFromCache(controller, builder.build(), (RpcCallback<MetaDataProtos.ClearTableFromCacheResponse>)rpcCallback);
                        ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                        return (MetaDataProtos.ClearTableFromCacheResponse)rpcCallback.get();
                    }
                });
                success = true;
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException(e);
            }
            catch (Throwable e) {
                sqlE = new SQLException(e);
            }
            finally {
                try {
                    htable.close();
                    long systemCatalogRpcTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(Bytes.toString((byte[])tableName), MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, systemCatalogRpcTime);
                    if (success) {
                        TableMetricsManager.updateMetricsForSystemCatalogTableMethod(Bytes.toString((byte[])tableName), MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, 1L);
                    }
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(Bytes.toString((byte[])tableName), MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES, 1L);
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ClientUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ClientUtil.parseServerException(e));
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(ClientUtil.parseServerException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnSequences(List<SequenceKey> keys, long timestamp, SQLException[] exceptions) throws SQLException {
        ArrayList sequences = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList toReturnList;
            block31: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList mutations = Lists.newArrayListWithExpectedSize((int)sequences.size());
                toReturnList = Lists.newArrayListWithExpectedSize((int)sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        Append append = sequence.newReturn(timestamp);
                        toReturnList.add(sequence);
                        mutations.add(append);
                        continue;
                    }
                    catch (EmptySequenceCacheException append) {
                        // empty catch block
                    }
                }
                if (toReturnList.isEmpty()) {
                    return;
                }
                Table hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    hTable.batch((List)mutations, resultObjects);
                }
                catch (IOException e) {
                    sqlE = ClientUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ClientUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ClientUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block31;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toReturnList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    sequence.returnValue(result);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnAllSequences(ConcurrentMap<SequenceKey, Sequence> sequenceMap) throws SQLException {
        block18: {
            ArrayList mutations = Lists.newArrayListWithExpectedSize((int)sequenceMap.size());
            for (Sequence sequence : sequenceMap.values()) {
                mutations.addAll(sequence.newReturns());
            }
            if (mutations.isEmpty()) {
                return;
            }
            Table hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            SQLException sqlE = null;
            try {
                hTable.batch((List)mutations, null);
            }
            catch (IOException e) {
                sqlE = ClientUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            finally {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ClientUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ClientUtil.parseServerException(e));
                }
                if (sqlE == null) break block18;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(PhoenixConnection connection) throws SQLException {
        if (this.returnSequenceValues || this.shouldThrottleNumConnections) {
            Object object = this.connectionCountLock;
            synchronized (object) {
                this.connectionLimiter.acquireConnection(connection);
            }
        }
        if (this.isRenewingLeasesEnabled()) {
            this.connectionQueues.get(this.getQueueIndex(connection)).add(new WeakReference<PhoenixConnection>(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
        if (this.returnSequenceValues) {
            ConcurrentMap<SequenceKey, Sequence> formerSequenceMap = null;
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (!connection.isInternalConnection() && this.connectionLimiter.isLastConnection() && !this.sequenceMap.isEmpty()) {
                    formerSequenceMap = this.sequenceMap;
                    this.sequenceMap = Maps.newConcurrentMap();
                }
            }
            if (formerSequenceMap != null) {
                this.returnAllSequences(formerSequenceMap);
            }
        }
        if (this.returnSequenceValues || this.connectionLimiter.isShouldThrottleNumConnections()) {
            Object object = this.connectionCountLock;
            synchronized (object) {
                this.connectionLimiter.returnConnection(connection);
            }
        }
    }

    private int getQueueIndex(PhoenixConnection conn) {
        return ThreadLocalRandom.current().nextInt(this.renewLeasePoolSize);
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        FeatureSupported supported = this.featureMap.get((Object)feature);
        if (supported == null) {
            return false;
        }
        return supported.isSupported(this);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @VisibleForTesting
    public void checkClosed() {
        if (this.closed) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedIfNullMetaData() {
        if (this.latestMetaData == null) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedException() {
        throw new IllegalStateException("Connection to the cluster is closed");
    }

    @Override
    public GuidePostsInfo getTableStats(GuidePostsKey key) throws SQLException {
        try {
            return this.tableStatsCache.get(key);
        }
        catch (ExecutionException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    @Override
    public int getSequenceSaltBuckets() {
        return this.nSequenceSaltBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFunction(PFunction function) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PFunction existingFunction = this.latestMetaData.getFunction(new PTableKey(function.getTenantId(), function.getFunctionName()));
                if (existingFunction.getTimeStamp() >= function.getTimeStamp()) {
                    return;
                }
            }
            catch (FunctionNotFoundException functionNotFoundException) {
                // empty catch block
            }
            this.latestMetaData.addFunction(function);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.removeFunction(tenantId, function, functionTimeStamp);
            this.latestMetaDataLock.notifyAll();
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getFunctions(PName tenantId, final List<Pair<byte[], Long>> functions, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        return this.metaDataCoprocessorExec(null, tenantIdBytes, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController(PhoenixDatabaseMetaData.SYSTEM_FUNCTION_HBASE_TABLE_NAME);
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.GetFunctionsRequest.Builder builder = MetaDataProtos.GetFunctionsRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                for (Pair function : functions) {
                    builder.addFunctionNames(ByteStringer.wrap((byte[])((byte[])function.getFirst())));
                    builder.addFunctionTimestamps((Long)function.getSecond());
                }
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.getFunctions(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getSchema(final String schemaName, final long clientTimestamp) throws SQLException {
        return this.metaDataCoprocessorExec(null, SchemaUtil.getSchemaKey(schemaName), new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.GetSchemaRequest.Builder builder = MetaDataProtos.GetSchemaRequest.newBuilder();
                builder.setSchemaName(schemaName);
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.getSchema(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createFunction(final List<Mutation> functionData, final PFunction function, final boolean temporary) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(functionData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(null, functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController(PhoenixDatabaseMetaData.SYSTEM_FUNCTION_HBASE_TABLE_NAME);
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.CreateFunctionRequest.Builder builder = MetaDataProtos.CreateFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTemporary(temporary);
                builder.setReplace(function.isReplace());
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.createFunction(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    @Override
    public long getRenewLeaseThresholdMilliSeconds() {
        return this.renewLeaseThreshold;
    }

    @Override
    public boolean isRenewingLeasesEnabled() {
        return this.supportsFeature(ConnectionQueryServices.Feature.RENEW_LEASE) && this.renewLeaseEnabled;
    }

    @Override
    public HRegionLocation getTableRegionLocation(byte[] tableName, byte[] row) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        while (true) {
            TableName table = TableName.valueOf((byte[])tableName);
            try {
                return this.connection.getRegionLocator(table).getRegionLocation(row, false);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString((byte[])tableName);
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(fullName), SchemaUtil.getTableNameFromFullName(fullName));
            }
            catch (IOException e) {
                LOGGER.error("Exception encountered in getTableRegionLocation for table: {}, retryCount: {}", new Object[]{table.getNameAsString(), retryCount, e});
                if (retryCount++ < maxRetryCount) continue;
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createSchema(final List<Mutation> schemaMutations, final String schemaName) throws SQLException {
        this.ensureNamespaceCreated(schemaName);
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(schemaMutations);
        byte[] key = m.getRow();
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(null, key, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.CreateSchemaRequest.Builder builder = MetaDataProtos.CreateSchemaRequest.newBuilder();
                for (Mutation m : schemaMutations) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setSchemaName(schemaName);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.createSchema(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        return result;
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.latestMetaData.addSchema(schema);
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.latestMetaData.removeSchema(schema, schemaTimeStamp);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropSchema(final List<Mutation> schemaMetaData, final String schemaName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(null, SchemaUtil.getSchemaKey(schemaName), new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                RpcController controller = ConnectionQueryServicesImpl.this.getController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.DropSchemaRequest.Builder builder = MetaDataProtos.DropSchemaRequest.newBuilder();
                for (Mutation m : schemaMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addSchemaMetadataMutations(mp.toByteString());
                }
                builder.setSchemaName(schemaName);
                builder.setClientVersion(VersionUtil.encodeVersion(5, 3, 0));
                instance.dropSchema(controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                ConnectionQueryServicesImpl.this.checkForRemoteExceptions(controller);
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case SCHEMA_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (!dropMetadata) break;
                this.ensureNamespaceDropped(schemaName);
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNamespaceDropped(String schemaName) throws SQLException {
        block12: {
            SQLException sqlE = null;
            try (Admin admin = this.getAdmin();){
                String quorum = ZKConfig.getZKQuorumServersString((Configuration)this.config);
                String znode = this.props.get("zookeeper.znode.parent");
                LOGGER.debug("Found quorum: " + quorum + ":" + znode);
                if (ClientUtil.isHBaseNamespaceAvailable(admin, schemaName)) {
                    admin.deleteNamespace(schemaName);
                }
            }
            catch (IOException e) {
                sqlE = ClientUtil.parseServerException(e);
            }
            finally {
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
    }

    public void addTableStats(GuidePostsKey key, GuidePostsInfo info) {
        this.tableStatsCache.put(Objects.requireNonNull(key), Objects.requireNonNull(info));
    }

    @Override
    public void invalidateStats(GuidePostsKey key) {
        this.tableStatsCache.invalidate(Objects.requireNonNull(key));
    }

    @Override
    public boolean isUpgradeRequired() {
        return this.upgradeRequired.get();
    }

    @Override
    public void clearUpgradeRequired() {
        this.upgradeRequired.set(false);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public QueryLoggerDisruptor getQueryDisruptor() {
        return this.queryDisruptor;
    }

    @Override
    public synchronized PhoenixTransactionClient initTransactionClient(TransactionFactory.Provider provider) throws SQLException {
        PhoenixTransactionClient client = this.txClients[provider.ordinal()];
        if (client == null) {
            PhoenixTransactionClient phoenixTransactionClient = provider.getTransactionProvider().getTransactionClient(this.config, this.connectionInfo);
            this.txClients[provider.ordinal()] = phoenixTransactionClient;
            client = phoenixTransactionClient;
        }
        return client;
    }

    @VisibleForTesting
    public List<LinkedBlockingQueue<WeakReference<PhoenixConnection>>> getCachedConnections() {
        return this.connectionQueues;
    }

    @Override
    public void invalidateServerMetadataCache(List<InvalidateServerMetadataCacheRequest> requests) throws Throwable {
        boolean invalidateCacheEnabled = this.config.getBoolean("phoenix.metadata.invalidate.cache.enabled", false);
        if (!invalidateCacheEnabled) {
            LOGGER.info("Skip invalidating server metadata cache since conf property phoenix.metadata.invalidate.cache.enabled is set to false");
            return;
        }
        if (!QueryUtil.isServerConnection(this.props)) {
            LOGGER.warn(INVALIDATE_SERVER_METADATA_CACHE_EX_MESSAGE);
            throw new Exception(INVALIDATE_SERVER_METADATA_CACHE_EX_MESSAGE);
        }
        this.metricsMetadataCachingSource.incrementMetadataCacheInvalidationOperationsCount();
        Admin admin = this.getInvalidateMetadataCacheConnection().getAdmin();
        Collection serverNames = admin.getRegionServers(true);
        PhoenixStopWatch stopWatch = new PhoenixStopWatch().start();
        try {
            this.invalidateServerMetadataCacheWithRetries(admin, serverNames, requests, false);
            this.metricsMetadataCachingSource.incrementMetadataCacheInvalidationSuccessCount();
        }
        catch (Throwable t) {
            this.metricsMetadataCachingSource.incrementMetadataCacheInvalidationFailureCount();
            throw t;
        }
        finally {
            this.metricsMetadataCachingSource.addMetadataCacheInvalidationTotalTime(stopWatch.stop().elapsedMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateServerMetadataCacheWithRetries(Admin admin, Collection<ServerName> serverNames, List<InvalidateServerMetadataCacheRequest> invalidateCacheRequests, boolean isRetry) throws Throwable {
        RegionServerEndpointProtos.InvalidateServerMetadataCacheRequest protoRequest = this.getRequest(invalidateCacheRequests);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        HashMap<Future, ServerName> map = new HashMap<Future, ServerName>();
        int poolSize = this.config.getInt("phoenix.metadata.cache.invalidation.threadPool.size", 20);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("metadata-cache-invalidation-pool-%d");
        ExecutorService executor = Executors.newFixedThreadPool(poolSize, builder.build());
        for (ServerName serverName : serverNames) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    PhoenixStopWatch innerWatch = new PhoenixStopWatch().start();
                    for (InvalidateServerMetadataCacheRequest invalidateCacheRequest : invalidateCacheRequests) {
                        LOGGER.info("Sending invalidate metadata cache for {}  to region server: {}", (Object)invalidateCacheRequest.toString(), (Object)serverName);
                    }
                    RegionServerEndpointProtos.RegionServerEndpointService.BlockingInterface service = RegionServerEndpointProtos.RegionServerEndpointService.newBlockingStub((BlockingRpcChannel)admin.coprocessorService(serverName));
                    service.invalidateServerMetadataCache(null, protoRequest);
                    long cacheInvalidationTime = innerWatch.stop().elapsedMillis();
                    LOGGER.info("Invalidating metadata cache on region server: {} completed successfully and it took {} ms", (Object)serverName, (Object)cacheInvalidationTime);
                    this.metricsMetadataCachingSource.addMetadataCacheInvalidationRpcTime(cacheInvalidationTime);
                }
                catch (ServiceException se) {
                    LOGGER.error("Invalidating metadata cache failed for regionserver {}", (Object)serverName, (Object)se);
                    IOException ioe = ClientUtil.parseServiceException(se);
                    throw new CompletionException(ioe);
                }
            }, executor);
            futures.add(future);
            map.put(future, serverName);
        }
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        long metadataCacheInvalidationTimeoutMs = this.config.getLong("phoenix.metadata.cache.invalidation.timeoutMs", 10000L);
        try {
            allFutures.get(metadataCacheInvalidationTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            List<ServerName> failedServers = this.getFailedServers(futures, map);
            LOGGER.error("Invalidating metadata cache for failed for region servers: {}", failedServers, (Object)t);
            if (isRetry) {
                if (allFutures.isCompletedExceptionally() && t instanceof ExecutionException) {
                    t = t.getCause();
                }
                throw t;
            }
            this.invalidateServerMetadataCacheWithRetries(admin, failedServers, invalidateCacheRequests, true);
        }
        finally {
            executor.shutdown();
        }
    }

    private List<ServerName> getFailedServers(List<CompletableFuture<Void>> futures, Map<Future, ServerName> map) {
        ArrayList<ServerName> failedServers = new ArrayList<ServerName>();
        for (CompletableFuture<Void> completedFuture : futures) {
            ServerName sn;
            if (!completedFuture.isDone()) {
                sn = map.get(completedFuture);
                failedServers.add(sn);
                completedFuture.cancel(true);
                continue;
            }
            if (!completedFuture.isCompletedExceptionally() && !completedFuture.isCancelled()) continue;
            sn = map.get(completedFuture);
            failedServers.add(sn);
        }
        return failedServers;
    }

    private RegionServerEndpointProtos.InvalidateServerMetadataCacheRequest getRequest(List<InvalidateServerMetadataCacheRequest> requests) {
        RegionServerEndpointProtos.InvalidateServerMetadataCacheRequest.Builder builder = RegionServerEndpointProtos.InvalidateServerMetadataCacheRequest.newBuilder();
        for (InvalidateServerMetadataCacheRequest request : requests) {
            RegionServerEndpointProtos.InvalidateServerMetadataCache.Builder innerBuilder = RegionServerEndpointProtos.InvalidateServerMetadataCache.newBuilder();
            innerBuilder.setTenantId(ByteStringer.wrap((byte[])request.getTenantId()));
            innerBuilder.setSchemaName(ByteStringer.wrap((byte[])request.getSchemaName()));
            innerBuilder.setTableName(ByteStringer.wrap((byte[])request.getTableName()));
            builder.addInvalidateServerMetadataCacheRequests(innerBuilder.build());
        }
        return builder.build();
    }

    private static interface Mutator {
        public void mutate(PMetaData var1) throws SQLException;
    }

    private static interface RetriableOperation {
        public boolean checkForCompletion() throws TimeoutException, IOException;

        public String getOperationName();
    }

    @VisibleForTesting
    static class RenewLeaseTask
    implements Runnable {
        private final LinkedBlockingQueue<WeakReference<PhoenixConnection>> connectionsQueue;
        private final Random random = new Random();
        private static final int MAX_WAIT_TIME = 1000;

        RenewLeaseTask(LinkedBlockingQueue<WeakReference<PhoenixConnection>> queue) {
            this.connectionsQueue = queue;
        }

        private void waitForRandomDuration() throws InterruptedException {
            new CountDownLatch(1).await(this.random.nextInt(1000), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            try {
                boolean wait = true;
                for (int numConnections = this.connectionsQueue.size(); numConnections > 0; --numConnections) {
                    WeakReference<PhoenixConnection> connRef;
                    if (wait) {
                        this.waitForRandomDuration();
                        wait = false;
                    }
                    if ((connRef = this.connectionsQueue.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                        throw new InternalRenewLeaseTaskException("Connection ref found to be null. This is a bug. Some other thread removed items from the connection queue.");
                    }
                    PhoenixConnection conn = (PhoenixConnection)connRef.get();
                    if (conn == null || conn.isClosed()) continue;
                    LinkedBlockingQueue<WeakReference<TableResultIterator>> scannerQueue = conn.getScanners();
                    int renewed = 0;
                    long start = EnvironmentEdgeManager.currentTimeMillis();
                    block10: for (int numScanners = scannerQueue.size(); numScanners > 0; --numScanners) {
                        WeakReference<TableResultIterator> ref = scannerQueue.poll(1L, TimeUnit.MILLISECONDS);
                        if (ref == null) {
                            throw new InternalRenewLeaseTaskException("TableResulIterator ref found to be null. This is a bug. Some other thread removed items from the scanner queue.");
                        }
                        TableResultIterator scanningItr = (TableResultIterator)ref.get();
                        if (scanningItr == null) continue;
                        TableResultIterator.RenewLeaseStatus status = scanningItr.renewLease();
                        switch (status) {
                            case RENEWED: {
                                ++renewed;
                                scannerQueue.offer(new WeakReference<TableResultIterator>(scanningItr));
                                LOGGER.info("Lease renewed for scanner: " + scanningItr);
                                continue block10;
                            }
                            case UNINITIALIZED: 
                            case THRESHOLD_NOT_REACHED: 
                            case LOCK_NOT_ACQUIRED: {
                                scannerQueue.offer(new WeakReference<TableResultIterator>(scanningItr));
                                continue block10;
                            }
                        }
                    }
                    if (renewed > 0) {
                        LOGGER.info("Renewed leases for " + renewed + " scanner/s in " + (EnvironmentEdgeManager.currentTimeMillis() - start) + " ms ");
                    }
                    this.connectionsQueue.offer(connRef);
                }
            }
            catch (InternalRenewLeaseTaskException e) {
                LOGGER.error("Exception thrown when renewing lease. Draining the queue of scanners ", (Throwable)e);
                this.connectionsQueue.clear();
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Thread interrupted when renewing lease.", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Exception thrown when renewing lease ", (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Exception thrown when renewing lease. Draining the queue of scanners ", e);
                this.connectionsQueue.clear();
                throw new RuntimeException(e);
            }
        }

        private static class InternalRenewLeaseTaskException
        extends Exception {
            public InternalRenewLeaseTaskException(String msg) {
                super(msg);
            }
        }
    }

    private static interface FeatureSupported {
        public boolean isSupported(ConnectionQueryServices var1);
    }

    private static class RenewLeaseThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PREFIX = "PHOENIX-SCANNER-RENEW-LEASE-thread-";

        private RenewLeaseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, NAME_PREFIX + threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

