/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.util.StringUtils;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.coprocessor.generated.ChildLinkMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.coprocessor.generated.TaskMetaDataProtos;
import org.apache.phoenix.schema.PTableType;

public class ProtobufUtil {
    public static void setControllerException(RpcController controller, IOException ioe) {
        if (controller != null) {
            if (controller instanceof ServerRpcController) {
                ((ServerRpcController)controller).setFailedOn(ioe);
            } else {
                controller.setFailed(StringUtils.stringifyException((Throwable)ioe));
            }
        }
    }

    public static PTableProtos.PTableType toPTableTypeProto(PTableType type) {
        return PTableProtos.PTableType.values()[type.ordinal()];
    }

    public static PTableType toPTableType(PTableProtos.PTableType type) {
        return PTableType.values()[type.ordinal()];
    }

    public static List<Mutation> getMutations(MetaDataProtos.CreateTableRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.DropSchemaRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getSchemaMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.DropFunctionRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.CreateFunctionRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.DropTableRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.AddColumnRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.DropColumnRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.UpdateIndexStateRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(MetaDataProtos.CreateSchemaRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(TaskMetaDataProtos.TaskMutateRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    public static List<Mutation> getMutations(ChildLinkMetaDataProtos.CreateViewAddChildLinkRequest request) throws IOException {
        return ProtobufUtil.getMutations(request.getTableMetadataMutationsList());
    }

    private static List<Mutation> getMutations(List<ByteString> mutations) throws IOException {
        ArrayList<Mutation> result = new ArrayList<Mutation>();
        for (ByteString mutation : mutations) {
            ClientProtos.MutationProto mProto = ClientProtos.MutationProto.parseFrom((ByteString)mutation);
            result.add(org.apache.hadoop.hbase.protobuf.ProtobufUtil.toMutation((ClientProtos.MutationProto)mProto));
        }
        return result;
    }

    public static ClientProtos.MutationProto toProto(Mutation mutation) throws IOException {
        ClientProtos.MutationProto.MutationType type;
        if (mutation instanceof Put) {
            type = ClientProtos.MutationProto.MutationType.PUT;
        } else if (mutation instanceof Delete) {
            type = ClientProtos.MutationProto.MutationType.DELETE;
        } else {
            throw new IllegalArgumentException("Only Put and Delete are supported");
        }
        return org.apache.hadoop.hbase.protobuf.ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)type, (Mutation)mutation);
    }

    public static ServerCachingProtos.ImmutableBytesWritable toProto(ImmutableBytesWritable w) {
        ServerCachingProtos.ImmutableBytesWritable.Builder builder = ServerCachingProtos.ImmutableBytesWritable.newBuilder();
        builder.setByteArray(ByteStringer.wrap((byte[])w.get()));
        builder.setOffset(w.getOffset());
        builder.setLength(w.getLength());
        return builder.build();
    }

    public static ImmutableBytesWritable toImmutableBytesWritable(ServerCachingProtos.ImmutableBytesWritable proto) {
        return new ImmutableBytesWritable(proto.getByteArray().toByteArray(), proto.getOffset(), proto.getLength());
    }
}

