/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Objects;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ShowCreateTable;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.SchemaUtil;

public class ShowCreateTableStatement
extends ShowCreateTable {
    private TableName tableName;

    public ShowCreateTableStatement(TableName tn) {
        this.tableName = tn;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        Preconditions.checkNotNull((Object)buf);
        buf.append("SHOW CREATE TABLE ");
        buf.append(SchemaUtil.getEscapedTableName(this.tableName.getSchemaName(), this.tableName.getTableName()));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toSQL(null, buf);
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ShowCreateTableStatement)) {
            return false;
        }
        ShowCreateTableStatement stmt = (ShowCreateTableStatement)other;
        return Objects.equals(this.tableName, stmt.getTableName());
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }
}

