/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.function.AvgAggregateFunction;
import org.apache.phoenix.expression.function.CurrentDateFunction;
import org.apache.phoenix.expression.function.CurrentTimeFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AddJarsStatement;
import org.apache.phoenix.parse.AddParseNode;
import org.apache.phoenix.parse.AggregateFunctionParseNode;
import org.apache.phoenix.parse.AggregateFunctionWithinGroupParseNode;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.AlterSessionStatement;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArrayAllComparisonNode;
import org.apache.phoenix.parse.ArrayAnyComparisonNode;
import org.apache.phoenix.parse.ArrayConstructorNode;
import org.apache.phoenix.parse.ArrayElemRefNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ChangePermsStatement;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnDefInPkConstraint;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.CreateCDCStatement;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.CursorName;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.DeleteJarStatement;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.DistinctCountParseNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.DocumentFieldBeginsWithParseNode;
import org.apache.phoenix.parse.DocumentFieldContainsParseNode;
import org.apache.phoenix.parse.DocumentFieldExistsParseNode;
import org.apache.phoenix.parse.DocumentFieldSizeParseNode;
import org.apache.phoenix.parse.DocumentFieldTypeParseNode;
import org.apache.phoenix.parse.DropCDCStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropFunctionStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSchemaStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.ExecuteUpgradeStatement;
import org.apache.phoenix.parse.ExistsParseNode;
import org.apache.phoenix.parse.ExplainStatement;
import org.apache.phoenix.parse.ExplainType;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FetchStatement;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.GreaterThanOrEqualParseNode;
import org.apache.phoenix.parse.GreaterThanParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.InParseNode;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LessThanOrEqualParseNode;
import org.apache.phoenix.parse.LessThanParseNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.ListJarsStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ModulusParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.NotEqualParseNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.PropertyName;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.ShowCreateTable;
import org.apache.phoenix.parse.ShowCreateTableStatement;
import org.apache.phoenix.parse.ShowSchemasStatement;
import org.apache.phoenix.parse.ShowTablesStatement;
import org.apache.phoenix.parse.StringConcatParseNode;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.TraceStatement;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.UpdateStatisticsStatement;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.parse.UseSchemaStatement;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ParseNodeFactory {
    private static final String ARRAY_ELEM = "ARRAY_ELEM";
    private static final List<Class<? extends FunctionExpression>> CLIENT_SIDE_BUILT_IN_FUNCTIONS = Arrays.asList(CurrentDateFunction.class, CurrentTimeFunction.class, AvgAggregateFunction.class);
    private static final Map<BuiltInFunctionKey, FunctionParseNode.BuiltInFunctionInfo> BUILT_IN_FUNCTION_MAP = Maps.newHashMap();
    private static final Multimap<String, FunctionParseNode.BuiltInFunctionInfo> BUILT_IN_FUNCTION_MULTIMAP = ArrayListMultimap.create();
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static AtomicInteger tempAliasCounter = new AtomicInteger(0);

    private static void addBuiltInFunction(Class<? extends FunctionExpression> f) throws Exception {
        FunctionParseNode.BuiltInFunction d = f.getAnnotation(FunctionParseNode.BuiltInFunction.class);
        if (d == null) {
            return;
        }
        int nArgs = d.args().length;
        FunctionParseNode.BuiltInFunctionInfo value = new FunctionParseNode.BuiltInFunctionInfo(f, d);
        if (d.classType() != FunctionParseNode.FunctionClassType.ABSTRACT) {
            BUILT_IN_FUNCTION_MULTIMAP.put((Object)value.getName(), (Object)value);
        }
        if (d.classType() != FunctionParseNode.FunctionClassType.DERIVED) {
            do {
                BuiltInFunctionKey key;
                if (BUILT_IN_FUNCTION_MAP.put(key = new BuiltInFunctionKey(value.getName(), nArgs), value) == null) continue;
                throw new IllegalStateException("Multiple " + value.getName() + " functions with " + nArgs + " arguments");
            } while (--nArgs >= 0 && d.args()[nArgs].defaultValue().length() > 0);
            while (--nArgs >= 0) {
                if (d.args()[nArgs].defaultValue().length() <= 0) continue;
                throw new IllegalStateException("Function " + value.getName() + " has non trailing default value of '" + d.args()[nArgs].defaultValue() + "'. Only trailing arguments may have default values");
            }
        }
    }

    private static synchronized void initBuiltInFunctionMap() {
        if (!BUILT_IN_FUNCTION_MAP.isEmpty()) {
            return;
        }
        Class<Expression> f = null;
        try {
            for (int i = 0; i < CLIENT_SIDE_BUILT_IN_FUNCTIONS.size(); ++i) {
                f = CLIENT_SIDE_BUILT_IN_FUNCTIONS.get(i);
                ParseNodeFactory.addBuiltInFunction(f);
            }
            for (ExpressionType et : ExpressionType.values()) {
                Class<? extends Expression> ec = et.getExpressionClass();
                if (!FunctionExpression.class.isAssignableFrom(ec)) continue;
                Class<? extends Expression> c = ec;
                f = c;
                ParseNodeFactory.addBuiltInFunction(f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed initialization of built-in functions at class '" + f + "'", e);
        }
    }

    private static FunctionParseNode.BuiltInFunctionInfo getInfo(String name, List<ParseNode> children) {
        return ParseNodeFactory.get(SchemaUtil.normalizeIdentifier(name), children);
    }

    public static FunctionParseNode.BuiltInFunctionInfo get(String normalizedName, List<ParseNode> children) {
        ParseNodeFactory.initBuiltInFunctionMap();
        FunctionParseNode.BuiltInFunctionInfo info = BUILT_IN_FUNCTION_MAP.get(new BuiltInFunctionKey(normalizedName, children.size()));
        return info;
    }

    public static Multimap<String, FunctionParseNode.BuiltInFunctionInfo> getBuiltInFunctionMultimap() {
        ParseNodeFactory.initBuiltInFunctionMap();
        return BUILT_IN_FUNCTION_MULTIMAP;
    }

    @VisibleForTesting
    public static int getTempAliasCounterValue() {
        return tempAliasCounter.get();
    }

    @VisibleForTesting
    public static void setTempAliasCounterValue(int newValue) {
        tempAliasCounter.set(newValue);
    }

    public static String createTempAlias() {
        return "$" + tempAliasCounter.incrementAndGet();
    }

    public ExplainStatement explain(BindableStatement statement, ExplainType explainType) {
        return new ExplainStatement(statement, explainType);
    }

    public AliasedNode aliasedNode(String alias, ParseNode expression) {
        return new AliasedNode(alias, expression);
    }

    public AddParseNode add(List<ParseNode> children) {
        return new AddParseNode(children);
    }

    public SubtractParseNode subtract(List<ParseNode> children) {
        return new SubtractParseNode(children);
    }

    public MultiplyParseNode multiply(List<ParseNode> children) {
        return new MultiplyParseNode(children);
    }

    public ModulusParseNode modulus(List<ParseNode> children) {
        return new ModulusParseNode(children);
    }

    public AndParseNode and(List<ParseNode> children) {
        return new AndParseNode(children);
    }

    public FamilyWildcardParseNode family(String familyName) {
        return new FamilyWildcardParseNode(familyName, false);
    }

    public TableWildcardParseNode tableWildcard(TableName tableName) {
        return new TableWildcardParseNode(tableName, false);
    }

    public WildcardParseNode wildcard() {
        return WildcardParseNode.INSTANCE;
    }

    public BetweenParseNode between(ParseNode l, ParseNode r1, ParseNode r2, boolean negate) {
        return new BetweenParseNode(l, r1, r2, negate);
    }

    public BindParseNode bind(String bind) {
        return new BindParseNode(bind);
    }

    public StringConcatParseNode concat(List<ParseNode> children) {
        return new StringConcatParseNode(children);
    }

    public ColumnParseNode column(TableName tableName, String columnName, String alias) {
        return new ColumnParseNode(tableName, columnName, alias);
    }

    public ColumnName columnName(String columnName) {
        return new ColumnName(columnName);
    }

    public ColumnName columnName(String familyName, String columnName) {
        return new ColumnName(familyName, columnName);
    }

    public PropertyName propertyName(String propertyName) {
        return new PropertyName(propertyName);
    }

    public PropertyName propertyName(String familyName, String propertyName) {
        return new PropertyName(familyName, propertyName);
    }

    public ColumnDef columnDef(ColumnName columnDefName, String sqlTypeName, boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder, String expressionStr, boolean isRowTimestamp) {
        return new ColumnDef(columnDefName, sqlTypeName, isNull, maxLength, scale, isPK, sortOrder, expressionStr, null, isRowTimestamp);
    }

    public DocumentFieldExistsParseNode documentFieldExists(ParseNode fieldName, boolean exists) {
        return new DocumentFieldExistsParseNode(fieldName, exists);
    }

    public DocumentFieldBeginsWithParseNode documentFieldBeginsWith(ParseNode fieldKey, ParseNode value) {
        return new DocumentFieldBeginsWithParseNode(fieldKey, value);
    }

    public DocumentFieldContainsParseNode documentFieldContains(ParseNode fieldKey, ParseNode value) {
        return new DocumentFieldContainsParseNode(fieldKey, value);
    }

    public DocumentFieldTypeParseNode documentFieldType(ParseNode fieldKey, ParseNode value) {
        return new DocumentFieldTypeParseNode(fieldKey, value);
    }

    public DocumentFieldSizeParseNode documentFieldSize(ParseNode fieldKey) {
        return new DocumentFieldSizeParseNode(fieldKey);
    }

    public ColumnDef columnDef(ColumnName columnDefName, String sqlTypeName, boolean isArray, Integer arrSize, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder, String expressionStr, Integer encodedQualifier, boolean isRowTimestamp) {
        return new ColumnDef(columnDefName, sqlTypeName, isArray, arrSize, isNull, maxLength, scale, isPK, sortOrder, expressionStr, encodedQualifier, isRowTimestamp);
    }

    public ColumnDef columnDef(ColumnName columnDefName, String sqlTypeName, boolean isArray, Integer arrSize, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder, String expressionStr, boolean isRowTimestamp) {
        return new ColumnDef(columnDefName, sqlTypeName, isArray, arrSize, isNull, maxLength, scale, isPK, sortOrder, expressionStr, null, isRowTimestamp);
    }

    public ColumnDef columnDef(ColumnName columnDefName, String sqlTypeName, boolean isArray, Integer arrSize, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder, boolean isRowTimestamp) {
        return new ColumnDef(columnDefName, sqlTypeName, isArray, arrSize, isNull, maxLength, scale, isPK, sortOrder, null, null, isRowTimestamp);
    }

    public ColumnDefInPkConstraint columnDefInPkConstraint(ColumnName columnDefName, SortOrder sortOrder, boolean isRowTimestamp) {
        return new ColumnDefInPkConstraint(columnDefName, sortOrder, isRowTimestamp);
    }

    public PrimaryKeyConstraint primaryKey(String name, List<ColumnDefInPkConstraint> columnDefs) {
        return new PrimaryKeyConstraint(name, columnDefs);
    }

    public IndexKeyConstraint indexKey(List<Pair<ParseNode, SortOrder>> parseNodeAndSortOrder) {
        return new IndexKeyConstraint(parseNodeAndSortOrder);
    }

    public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows, Map<String, Integer> cqCounters, boolean noVerify) {
        return new CreateTableStatement(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, cqCounters, noVerify);
    }

    public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows, Map<String, Integer> cqCounters) {
        return this.createTable(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, cqCounters, false);
    }

    public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows) {
        return this.createTable(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, null, false);
    }

    public CreateSchemaStatement createSchema(String schemaName, boolean ifNotExists) {
        return new CreateSchemaStatement(schemaName, ifNotExists);
    }

    public CreateIndexStatement createIndex(NamedNode indexName, NamedTableNode dataTable, IndexKeyConstraint ikConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, PTable.IndexType indexType, boolean async, int bindCount, Map<String, UDFParseNode> udfParseNodes, ParseNode where) {
        return new CreateIndexStatement(indexName, dataTable, ikConstraint, includeColumns, splits, props, ifNotExists, indexType, async, bindCount, udfParseNodes, where);
    }

    public CreateCDCStatement createCDC(NamedNode cdcObj, TableName dataTable, Set<PTable.CDCChangeScope> includeScopes, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
        return new CreateCDCStatement(cdcObj, dataTable, includeScopes, props, ifNotExists, bindCount);
    }

    public CreateSequenceStatement createSequence(TableName tableName, ParseNode startsWith, ParseNode incrementBy, ParseNode cacheSize, ParseNode minValue, ParseNode maxValue, boolean cycle, boolean ifNotExits, int bindCount) {
        return new CreateSequenceStatement(tableName, startsWith, incrementBy, cacheSize, minValue, maxValue, cycle, ifNotExits, bindCount);
    }

    public CreateFunctionStatement createFunction(PFunction functionInfo, boolean temporary, boolean isReplace) {
        return new CreateFunctionStatement(functionInfo, temporary, isReplace);
    }

    public AddJarsStatement addJars(List<LiteralParseNode> jarPaths) {
        return new AddJarsStatement(jarPaths);
    }

    public ListJarsStatement listJars() {
        return new ListJarsStatement();
    }

    public DeleteJarStatement deleteJar(LiteralParseNode jarPath) {
        return new DeleteJarStatement(jarPath);
    }

    public DropFunctionStatement dropFunction(String functionName, boolean ifExists) {
        return new DropFunctionStatement(functionName, ifExists);
    }

    public DropSequenceStatement dropSequence(TableName tableName, boolean ifExits, int bindCount) {
        return new DropSequenceStatement(tableName, ifExits, bindCount);
    }

    public SequenceValueParseNode currentValueFor(TableName tableName) {
        return new SequenceValueParseNode(tableName, SequenceValueParseNode.Op.CURRENT_VALUE, null);
    }

    public SequenceValueParseNode nextValueFor(TableName tableName, ParseNode numToAllocateNode) {
        return new SequenceValueParseNode(tableName, SequenceValueParseNode.Op.NEXT_VALUE, numToAllocateNode);
    }

    public AddColumnStatement addColumn(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, ListMultimap<String, Pair<String, Object>> props, boolean cascade, List<NamedNode> indexes) {
        return new AddColumnStatement(table, tableType, columnDefs, ifNotExists, props, cascade, indexes);
    }

    public DropColumnStatement dropColumn(NamedTableNode table, PTableType tableType, List<ColumnName> columnNodes, boolean ifExists) {
        return new DropColumnStatement(table, tableType, columnNodes, ifExists);
    }

    public DropTableStatement dropTable(TableName tableName, PTableType tableType, boolean ifExists, boolean cascade) {
        return new DropTableStatement(tableName, tableType, ifExists, cascade, false);
    }

    public DropIndexStatement dropIndex(NamedNode indexName, TableName tableName, boolean ifExists) {
        return new DropIndexStatement(indexName, tableName, ifExists);
    }

    public DropCDCStatement dropCDC(NamedNode cdcObjName, TableName tableName, boolean ifExists) {
        return new DropCDCStatement(cdcObjName, tableName, ifExists);
    }

    public AlterIndexStatement alterIndex(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state, boolean isRebuildAll, boolean async, ListMultimap<String, Pair<String, Object>> props) {
        return new AlterIndexStatement(indexTableNode, dataTableName, ifExists, state, isRebuildAll, async, props);
    }

    public AlterIndexStatement alterIndex(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state) {
        return new AlterIndexStatement(indexTableNode, dataTableName, ifExists, state, false, false);
    }

    public TraceStatement trace(boolean isTraceOn, double samplingRate) {
        return new TraceStatement(isTraceOn, samplingRate);
    }

    public AlterSessionStatement alterSession(Map<String, Object> props) {
        return new AlterSessionStatement(props);
    }

    public TableName table(String schemaName, String tableName) {
        return TableName.createNormalized(schemaName, tableName);
    }

    public NamedNode indexName(String name) {
        return new NamedNode(name);
    }

    public NamedNode cdcName(String name) {
        return new NamedNode(name);
    }

    @Deprecated
    public NamedTableNode namedTable(String alias, TableName name) {
        return new NamedTableNode(alias, name);
    }

    @Deprecated
    public NamedTableNode namedTable(String alias, TableName name, List<ColumnDef> dyn_columns) {
        return new NamedTableNode(alias, name, dyn_columns);
    }

    public NamedTableNode namedTable(String alias, TableName name, Double tableSamplingRate) {
        return new NamedTableNode(alias, name, tableSamplingRate);
    }

    public NamedTableNode namedTable(String alias, TableName name, List<ColumnDef> dyn_columns, Double tableSamplingRate) {
        return new NamedTableNode(alias, name, dyn_columns, tableSamplingRate);
    }

    public NamedTableNode namedTable(String alias, TableName name, List<ColumnDef> dyn_columns, LiteralParseNode tableSampleNode) {
        Double tableSamplingRate = tableSampleNode == null || tableSampleNode.getValue() == null ? ConcreteTableNode.DEFAULT_TABLE_SAMPLING_RATE : (tableSampleNode.getValue() instanceof Integer ? Double.valueOf(((Integer)tableSampleNode.getValue()).intValue()) : Double.valueOf(((BigDecimal)tableSampleNode.getValue()).doubleValue()));
        return new NamedTableNode(alias, name, dyn_columns, tableSamplingRate);
    }

    public BindTableNode bindTable(String alias, TableName name) {
        return new BindTableNode(alias, name);
    }

    public CaseParseNode caseWhen(List<ParseNode> children) {
        return new CaseParseNode(children);
    }

    public DivideParseNode divide(List<ParseNode> children) {
        return new DivideParseNode(children);
    }

    public UpdateStatisticsStatement updateStatistics(NamedTableNode table, StatisticsCollectionScope scope, Map<String, Object> props) {
        return new UpdateStatisticsStatement(table, scope, props);
    }

    public ExecuteUpgradeStatement executeUpgrade() {
        return new ExecuteUpgradeStatement();
    }

    public FunctionParseNode functionDistinct(String name, List<ParseNode> args) {
        if ("COUNT".equals(SchemaUtil.normalizeIdentifier(name))) {
            FunctionParseNode.BuiltInFunctionInfo info = ParseNodeFactory.getInfo(SchemaUtil.normalizeIdentifier("DISTINCT_COUNT"), args);
            return new DistinctCountParseNode("DISTINCT_COUNT", args, info);
        }
        throw new UnsupportedOperationException("DISTINCT not supported with " + name);
    }

    public FunctionParseNode arrayElemRef(List<ParseNode> args) {
        return this.function(ARRAY_ELEM, args);
    }

    public FunctionParseNode function(String name, List<ParseNode> args) {
        FunctionParseNode.BuiltInFunctionInfo info = ParseNodeFactory.getInfo(name, args);
        if (info == null) {
            return new UDFParseNode(name, args, info);
        }
        Constructor<? extends FunctionParseNode> ctor = info.getNodeCtor();
        if (ctor == null) {
            return info.isAggregate() ? new AggregateFunctionParseNode(name, args, info) : new FunctionParseNode(name, args, info);
        }
        try {
            return ctor.newInstance(name, args, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FunctionParseNode function(String name, List<ParseNode> valueNodes, List<ParseNode> columnNodes, boolean isAscending) {
        ArrayList args = Lists.newArrayListWithExpectedSize((int)(columnNodes.size() + valueNodes.size() + 1));
        args.addAll(columnNodes);
        args.add(new LiteralParseNode(isAscending));
        args.addAll(valueNodes);
        FunctionParseNode.BuiltInFunctionInfo info = ParseNodeFactory.getInfo(name, args);
        if (info == null) {
            return new UDFParseNode(name, args, info);
        }
        Constructor<? extends FunctionParseNode> ctor = info.getNodeCtor();
        if (ctor == null) {
            return new AggregateFunctionWithinGroupParseNode(name, args, info);
        }
        try {
            return ctor.newInstance(name, args, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HintNode hint(String hint) {
        return new HintNode(hint);
    }

    public InListParseNode inList(List<ParseNode> children, boolean negate) {
        return new InListParseNode(children, negate);
    }

    public ExistsParseNode exists(ParseNode child, boolean negate) {
        return new ExistsParseNode(child, negate);
    }

    public InParseNode in(ParseNode l, ParseNode r, boolean negate, boolean isSubqueryDistinct) {
        return new InParseNode(l, r, negate, isSubqueryDistinct);
    }

    public IsNullParseNode isNull(ParseNode child, boolean negate) {
        return new IsNullParseNode(child, negate);
    }

    public JoinTableNode join(JoinTableNode.JoinType type, TableNode lhs, TableNode rhs, ParseNode on, boolean singleValueOnly) {
        return new JoinTableNode(type, lhs, rhs, on, singleValueOnly);
    }

    public DerivedTableNode derivedTable(String alias, SelectStatement select) {
        return new DerivedTableNode(alias, select);
    }

    public LikeParseNode like(ParseNode lhs, ParseNode rhs, boolean negate, LikeParseNode.LikeType likeType) {
        return new LikeParseNode(lhs, rhs, negate, likeType);
    }

    public LiteralParseNode literal(Object value) {
        return new LiteralParseNode(value);
    }

    public LiteralParseNode realNumber(String text) {
        return new LiteralParseNode(new BigDecimal(text, PDataType.DEFAULT_MATH_CONTEXT));
    }

    public LiteralParseNode wholeNumber(String text) {
        int length = text.length();
        if (length <= PDataType.LONG_PRECISION - 1) {
            long l = Long.parseLong(text);
            if (l <= Integer.MAX_VALUE) {
                return new LiteralParseNode((int)l);
            }
            return new LiteralParseNode(l);
        }
        BigDecimal d = new BigDecimal(text, PDataType.DEFAULT_MATH_CONTEXT);
        if (d.compareTo(MAX_LONG) <= 0) {
            return new LiteralParseNode(d.longValueExact());
        }
        return new LiteralParseNode(d);
    }

    public LiteralParseNode intOrLong(String text) {
        long l = Long.parseLong(text);
        if (l <= Integer.MAX_VALUE) {
            return new LiteralParseNode((int)l);
        }
        return new LiteralParseNode(l);
    }

    public LiteralParseNode hexLiteral(String text) {
        int length = text.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Hex literals must have an even number of digits");
        }
        byte[] bytes = Bytes.fromHex((String)text);
        return new LiteralParseNode(bytes, PBinary.INSTANCE);
    }

    public String stringToHexLiteral(String in) {
        String noSpace = in.replaceAll(" ", "");
        if (!noSpace.matches("^[0-9a-fA-F]+$")) {
            throw new IllegalArgumentException("Hex literal continuation line has non hex digit characters");
        }
        return noSpace;
    }

    public LiteralParseNode binLiteral(String text) {
        int length = text.length();
        if (length % 8 != 0) {
            throw new IllegalArgumentException("Binary literals must have a multiple of 8 digits");
        }
        byte[] bytes = ByteUtil.fromAscii(text.toCharArray());
        return new LiteralParseNode(bytes, PBinary.INSTANCE);
    }

    public String stringToBinLiteral(String in) {
        String noSpace = in.replaceAll(" ", "");
        if (!noSpace.matches("^[0-1]+$")) {
            throw new IllegalArgumentException("Binary literal continuation line has non binary digit characters");
        }
        return noSpace;
    }

    public CastParseNode cast(ParseNode expression, String dataType, Integer maxLength, Integer scale) {
        return new CastParseNode(expression, dataType, maxLength, scale, false);
    }

    public CastParseNode cast(ParseNode expression, PDataType dataType, Integer maxLength, Integer scale) {
        return new CastParseNode(expression, dataType, maxLength, scale, false);
    }

    public CastParseNode cast(ParseNode expression, PDataType dataType, Integer maxLength, Integer scale, boolean arr) {
        return new CastParseNode(expression, dataType, maxLength, scale, arr);
    }

    public CastParseNode cast(ParseNode expression, String dataType, Integer maxLength, Integer scale, boolean arr) {
        return new CastParseNode(expression, dataType, maxLength, scale, arr);
    }

    public RowValueConstructorParseNode rowValueConstructor(List<ParseNode> l) {
        return new RowValueConstructorParseNode(l);
    }

    private void checkTypeMatch(PDataType expectedType, PDataType actualType) throws SQLException {
        if (!expectedType.isCoercibleTo(actualType)) {
            throw TypeMismatchException.newException(expectedType, actualType);
        }
    }

    public LiteralParseNode literal(Object value, PDataType expectedType) throws SQLException {
        PDataType actualType = PDataType.fromLiteral(value);
        if (actualType != null && actualType != expectedType) {
            this.checkTypeMatch(expectedType, actualType);
            value = expectedType.toObject(value, actualType);
        }
        return new LiteralParseNode(value);
    }

    public LiteralParseNode literal(String value, String sqlTypeName) throws SQLException {
        PDataType expectedType;
        PDataType pDataType = expectedType = sqlTypeName == null ? null : PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(sqlTypeName));
        if (expectedType == null || !expectedType.isCoercibleTo(PTimestamp.INSTANCE)) {
            throw TypeMismatchException.newException(expectedType, PTimestamp.INSTANCE);
        }
        Object typedValue = expectedType.toObject(value);
        return new LiteralParseNode(typedValue);
    }

    public LiteralParseNode coerce(LiteralParseNode literalNode, PDataType expectedType) throws SQLException {
        PDataType actualType = literalNode.getType();
        if (actualType != null) {
            Object before = literalNode.getValue();
            this.checkTypeMatch(expectedType, actualType);
            Object after = expectedType.toObject(before, actualType);
            if (before != after) {
                literalNode = this.literal(after);
            }
        }
        return literalNode;
    }

    public ComparisonParseNode comparison(CompareOperator op, ParseNode lhs, ParseNode rhs) {
        switch (op) {
            case LESS: {
                return this.lt(lhs, rhs);
            }
            case LESS_OR_EQUAL: {
                return this.lte(lhs, rhs);
            }
            case EQUAL: {
                return this.equal(lhs, rhs);
            }
            case NOT_EQUAL: {
                return this.notEqual(lhs, rhs);
            }
            case GREATER_OR_EQUAL: {
                return this.gte(lhs, rhs);
            }
            case GREATER: {
                return this.gt(lhs, rhs);
            }
        }
        throw new IllegalArgumentException("Unexpcted CompareOp of " + op);
    }

    public ArrayAnyComparisonNode arrayAny(ParseNode rhs, ComparisonParseNode compareNode) {
        return new ArrayAnyComparisonNode(rhs, compareNode);
    }

    public ArrayAllComparisonNode arrayAll(ParseNode rhs, ComparisonParseNode compareNode) {
        return new ArrayAllComparisonNode(rhs, compareNode);
    }

    public ArrayAnyComparisonNode wrapInAny(CompareOperator op, ParseNode lhs, ParseNode rhs) {
        return new ArrayAnyComparisonNode(rhs, this.comparison(op, lhs, this.elementRef(Arrays.asList(rhs, this.literal(1)))));
    }

    public ArrayAllComparisonNode wrapInAll(CompareOperator op, ParseNode lhs, ParseNode rhs) {
        return new ArrayAllComparisonNode(rhs, this.comparison(op, lhs, this.elementRef(Arrays.asList(rhs, this.literal(1)))));
    }

    public ArrayElemRefNode elementRef(List<ParseNode> parseNode) {
        return new ArrayElemRefNode(parseNode);
    }

    public GreaterThanParseNode gt(ParseNode lhs, ParseNode rhs) {
        return new GreaterThanParseNode(lhs, rhs);
    }

    public GreaterThanOrEqualParseNode gte(ParseNode lhs, ParseNode rhs) {
        return new GreaterThanOrEqualParseNode(lhs, rhs);
    }

    public LessThanParseNode lt(ParseNode lhs, ParseNode rhs) {
        return new LessThanParseNode(lhs, rhs);
    }

    public LessThanOrEqualParseNode lte(ParseNode lhs, ParseNode rhs) {
        return new LessThanOrEqualParseNode(lhs, rhs);
    }

    public EqualParseNode equal(ParseNode lhs, ParseNode rhs) {
        return new EqualParseNode(lhs, rhs);
    }

    public ArrayConstructorNode upsertStmtArrayNode(List<ParseNode> upsertStmtArray) {
        return new ArrayConstructorNode(upsertStmtArray);
    }

    public ParseNode negate(ParseNode child) {
        if (LiteralParseNode.ONE.equals(child) && ((LiteralParseNode)child).getType().isCoercibleTo(PLong.INSTANCE)) {
            return LiteralParseNode.MINUS_ONE;
        }
        if (LiteralParseNode.MIN_LONG_AS_BIG_DECIMAL.equals(child)) {
            return LiteralParseNode.MIN_LONG;
        }
        return new MultiplyParseNode(Arrays.asList(child, LiteralParseNode.MINUS_ONE));
    }

    public NotEqualParseNode notEqual(ParseNode lhs, ParseNode rhs) {
        return new NotEqualParseNode(lhs, rhs);
    }

    public ParseNode not(ParseNode child) {
        if (child instanceof ExistsParseNode) {
            return this.exists(child.getChildren().get(0), !((ExistsParseNode)child).isNegate());
        }
        return new NotParseNode(child);
    }

    public OrParseNode or(List<ParseNode> children) {
        return new OrParseNode(children);
    }

    public OrderByNode orderBy(ParseNode expression, boolean nullsLast, boolean orderAscending) {
        return new OrderByNode(expression, nullsLast, orderAscending);
    }

    public SelectStatement select(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, List<SelectStatement> selects, Map<String, UDFParseNode> udfParseNodes) {
        return new SelectStatement(from, hint, isDistinct, select, where, groupBy == null ? Collections.emptyList() : groupBy, having, orderBy == null ? Collections.emptyList() : orderBy, limit, offset, bindCount, isAggregate, hasSequence, selects == null ? Collections.emptyList() : selects, udfParseNodes);
    }

    public UpsertStatement upsert(NamedTableNode table, HintNode hint, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount, Map<String, UDFParseNode> udfParseNodes, List<Pair<ColumnName, ParseNode>> onDupKeyPairs, UpsertStatement.OnDuplicateKeyType onDupKeyType, boolean returningRow) {
        return new UpsertStatement(table, hint, columns, values, select, bindCount, udfParseNodes, onDupKeyPairs, onDupKeyType, returningRow);
    }

    public CursorName cursorName(String name) {
        return new CursorName(name);
    }

    public DeclareCursorStatement declareCursor(CursorName cursor, SelectStatement select) {
        return new DeclareCursorStatement(cursor, select);
    }

    public FetchStatement fetch(CursorName cursor, boolean isNext, int fetchLimit) {
        return new FetchStatement(cursor, isNext, fetchLimit);
    }

    public OpenStatement open(CursorName cursor) {
        return new OpenStatement(cursor);
    }

    public CloseStatement close(CursorName cursor) {
        return new CloseStatement(cursor);
    }

    public DeleteStatement delete(NamedTableNode table, HintNode hint, ParseNode node, List<OrderByNode> orderBy, LimitNode limit, int bindCount, Map<String, UDFParseNode> udfParseNodes, boolean returningRow) {
        return new DeleteStatement(table, hint, node, orderBy, limit, bindCount, udfParseNodes, returningRow);
    }

    public SelectStatement select(SelectStatement statement, ParseNode where) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), where, statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, ParseNode where, ParseNode having) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), where, statement.getGroupBy(), having, statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), select, where, groupBy, having, orderBy, statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, TableNode table) {
        return this.select(table, statement.getHint(), statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, TableNode table, ParseNode where) {
        return this.select(table, statement.getHint(), statement.isDistinct(), statement.getSelect(), where, statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, boolean isDistinct, List<AliasedNode> select) {
        return this.select(statement.getFrom(), statement.getHint(), isDistinct, select, statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, boolean isDistinct, List<AliasedNode> select, ParseNode where) {
        return this.select(statement.getFrom(), statement.getHint(), isDistinct, select, where, statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, boolean isAggregate) {
        return this.select(statement.getFrom(), statement.getHint(), isDistinct, select, where, groupBy, statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), isAggregate, statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, List<OrderByNode> orderBy) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), orderBy, statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, HintNode hint) {
        return hint == null || hint.isEmpty() ? statement : this.select(statement.getFrom(), hint, statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, HintNode hint, ParseNode where) {
        return this.select(statement.getFrom(), hint, statement.isDistinct(), statement.getSelect(), where, statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), orderBy, limit, offset, bindCount, isAggregate || statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, LimitNode limit) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), limit, statement.getOffset(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(SelectStatement statement, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), orderBy, limit, offset, statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    public SelectStatement select(List<SelectStatement> statements, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate) {
        ArrayList aliasedNodes;
        if (statements.size() == 1) {
            return this.select(statements.get(0), orderBy, limit, offset, bindCount, isAggregate);
        }
        ArrayList aliases = Lists.newArrayList();
        HashMap<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);
        for (int i = 0; i < statements.size() && aliases.isEmpty(); ++i) {
            SelectStatement subselect = statements.get(i);
            udfParseNodes.putAll(subselect.getUdfParseNodes());
            if (subselect.hasWildcard()) continue;
            for (AliasedNode aliasedNode : subselect.getSelect()) {
                String alias = aliasedNode.getAlias();
                if (alias == null) {
                    alias = SchemaUtil.normalizeIdentifier(aliasedNode.getNode().getAlias());
                }
                aliases.add(alias == null ? ParseNodeFactory.createTempAlias() : alias);
            }
        }
        if (aliases.isEmpty()) {
            aliasedNodes = Lists.newArrayList((Object[])new AliasedNode[]{this.aliasedNode(null, this.wildcard())});
        } else {
            aliasedNodes = Lists.newArrayListWithExpectedSize((int)aliases.size());
            for (String alias : aliases) {
                aliasedNodes.add(this.aliasedNode(alias, this.column(null, alias, alias)));
            }
        }
        return this.select(null, HintNode.EMPTY_HINT_NODE, false, aliasedNodes, null, null, null, orderBy, limit, offset, bindCount, false, false, statements, udfParseNodes);
    }

    public SubqueryParseNode subquery(SelectStatement select, boolean expectSingleRow) {
        return new SubqueryParseNode(select, expectSingleRow);
    }

    public LimitNode limit(BindParseNode b) {
        return new LimitNode(b);
    }

    public LimitNode limit(LiteralParseNode l) {
        return new LimitNode(l);
    }

    public OffsetNode offset(BindParseNode b) throws SQLException {
        return new OffsetNode(b);
    }

    public OffsetNode offset(LiteralParseNode l) throws SQLException {
        return new OffsetNode(l);
    }

    public OffsetNode offset(ComparisonParseNode r) throws SQLException {
        return new OffsetNode(r);
    }

    public DropSchemaStatement dropSchema(String schemaName, boolean ifExists, boolean cascade) {
        return new DropSchemaStatement(schemaName, ifExists, cascade);
    }

    public UseSchemaStatement useSchema(String schemaName) {
        return new UseSchemaStatement(schemaName);
    }

    public ChangePermsStatement changePermsStatement(String permsString, boolean isSchemaName, TableName tableName, String schemaName, boolean isGroupName, LiteralParseNode userOrGroup, boolean isGrantStatement) {
        return new ChangePermsStatement(permsString, isSchemaName, tableName, schemaName, isGroupName, userOrGroup, isGrantStatement);
    }

    public ShowTablesStatement showTablesStatement(String schema, String pattern) {
        return new ShowTablesStatement(schema, pattern);
    }

    public ShowSchemasStatement showSchemasStatement(String pattern) {
        return new ShowSchemasStatement(pattern);
    }

    public ShowCreateTable showCreateTable(TableName tableName) {
        return new ShowCreateTableStatement(tableName);
    }

    public static class BuiltInFunctionKey {
        private final String upperName;
        private final int argCount;

        public BuiltInFunctionKey(String lowerName, int argCount) {
            this.upperName = lowerName;
            this.argCount = argCount;
        }

        public String toString() {
            return this.upperName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.argCount;
            result = 31 * result + (this.upperName == null ? 0 : this.upperName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BuiltInFunctionKey other = (BuiltInFunctionKey)obj;
            if (this.argCount != other.argCount) {
                return false;
            }
            return this.upperName.equals(other.upperName);
        }
    }
}

