/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;

public class IndexKeyConstraint {
    public static final IndexKeyConstraint EMPTY = new IndexKeyConstraint(Collections.emptyList());
    private final List<Pair<ParseNode, SortOrder>> columnNameToSortOrder;

    IndexKeyConstraint(List<Pair<ParseNode, SortOrder>> parseNodeAndSortOrder) {
        this.columnNameToSortOrder = ImmutableList.copyOf(parseNodeAndSortOrder);
    }

    public List<Pair<ParseNode, SortOrder>> getParseNodeAndSortOrderList() {
        return this.columnNameToSortOrder;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Pair<ParseNode, SortOrder> entry : this.columnNameToSortOrder) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(((ParseNode)entry.getFirst()).toString());
            if (entry.getSecond() == SortOrder.getDefault()) continue;
            sb.append(" " + entry.getSecond());
        }
        return sb.toString();
    }
}

