/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.NamedParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class FamilyWildcardParseNode
extends NamedParseNode {
    private final boolean isRewrite;

    public FamilyWildcardParseNode(String familyName, boolean isRewrite) {
        super(familyName);
        this.isRewrite = isRewrite;
    }

    public FamilyWildcardParseNode(FamilyWildcardParseNode familyName, boolean isRewrite) {
        super(familyName);
        this.isRewrite = isRewrite;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public boolean isRewrite() {
        return this.isRewrite;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isRewrite ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FamilyWildcardParseNode other = (FamilyWildcardParseNode)obj;
        return this.isRewrite == other.isRewrite;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        this.toSQL(buf);
        buf.append(".*");
    }

    @Override
    public boolean isWildcardNode() {
        return true;
    }

    @Override
    public FamilyWildcardParseNode getRewritten() {
        return new FamilyWildcardParseNode(this.getName(), true);
    }
}

