/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class DocumentFieldExistsParseNode
extends CompoundParseNode {
    private final boolean exists;

    DocumentFieldExistsParseNode(ParseNode children, boolean exists) {
        super(Collections.singletonList(children));
        this.exists = exists;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        if (this.exists) {
            buf.append("field_exists(");
        } else {
            buf.append("field_not_exists(");
        }
        children.get(0).toSQL(resolver, buf);
        buf.append(")");
    }

    public boolean isExists() {
        return this.exists;
    }
}

