/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Set;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.MutableStatement;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;

public class CreateCDCStatement
extends MutableStatement {
    private final NamedNode cdcObjName;
    private final TableName dataTable;
    private final Set<PTable.CDCChangeScope> includeScopes;
    private final ListMultimap<String, Pair<String, Object>> props;
    private final boolean ifNotExists;
    private final int bindCount;

    public CreateCDCStatement(NamedNode cdcObjName, TableName dataTable, Set<PTable.CDCChangeScope> includeScopes, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
        this.cdcObjName = cdcObjName;
        this.dataTable = dataTable;
        this.includeScopes = includeScopes;
        this.props = props == null ? ArrayListMultimap.create() : props;
        this.ifNotExists = ifNotExists;
        this.bindCount = bindCount;
    }

    public NamedNode getCdcObjName() {
        return this.cdcObjName;
    }

    public TableName getDataTable() {
        return this.dataTable;
    }

    public Set<PTable.CDCChangeScope> getIncludeScopes() {
        return this.includeScopes;
    }

    public ListMultimap<String, Pair<String, Object>> getProps() {
        return this.props;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }
}

