/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PhoenixBsonExpressionLexer;
import org.apache.phoenix.parse.PhoenixBsonExpressionParser;

public class BsonExpressionParser {
    private static final ParseNodeFactory DEFAULT_NODE_FACTORY = new ParseNodeFactory();
    private final PhoenixBsonExpressionParser parser;

    public BsonExpressionParser(String query) {
        this(query, DEFAULT_NODE_FACTORY);
    }

    public BsonExpressionParser(String query, ParseNodeFactory factory) {
        PhoenixBsonExpressionLexer lexer;
        try {
            lexer = new PhoenixBsonExpressionLexer((CharStream)new CaseInsensitiveReaderStream(new StringReader(query)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommonTokenStream cts = new CommonTokenStream((TokenSource)lexer);
        this.parser = new PhoenixBsonExpressionParser((TokenStream)cts);
        this.parser.setParseNodeFactory(factory);
    }

    public ParseNode parseExpression() throws SQLException {
        try {
            return this.parser.expression();
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    private static class CaseInsensitiveReaderStream
    extends ANTLRReaderStream {
        CaseInsensitiveReaderStream(Reader script) throws IOException {
            super(script);
        }

        public int LA(int i) {
            if (i == 0) {
                return 0;
            }
            if (i < 0) {
                ++i;
            }
            if (this.p + i - 1 >= this.n) {
                return -1;
            }
            return Character.toLowerCase(this.data[this.p + i - 1]);
        }
    }
}

