/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.monitoring.ConnectionQueryServicesMetric;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.MetricPublisherSupplierFactory;
import org.apache.phoenix.monitoring.MetricServiceResolver;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesHistogram;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetrics;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetricsHistograms;
import org.apache.phoenix.monitoring.connectionqueryservice.NoOpConnectionQueryServicesMetricsManager;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesMetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionQueryServicesMetricsManager.class);
    private static volatile boolean isConnectionQueryServiceMetricsEnabled;
    private static volatile boolean isConnectionQueryServiceMetricPublisherEnabled;
    private static ConcurrentMap<String, ConnectionQueryServicesMetrics> connectionQueryServiceMetricsMapping;
    private static volatile ConnectionQueryServicesMetricsManager connectionQueryServicesMetricsManager;
    private static volatile MetricPublisherSupplierFactory mPublisher;
    private static volatile QueryServicesOptions options;

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This Object is only created once for the JVM")
    public ConnectionQueryServicesMetricsManager(QueryServicesOptions opts) {
        options = opts;
        connectionQueryServiceMetricsMapping = new ConcurrentHashMap<String, ConnectionQueryServicesMetrics>();
        isConnectionQueryServiceMetricsEnabled = options.isConnectionQueryServiceMetricsEnabled();
        isConnectionQueryServiceMetricPublisherEnabled = options.isConnectionQueryServiceMetricsPublisherEnabled();
        LOGGER.info("Connection query service metrics enabled : " + isConnectionQueryServiceMetricsEnabled + " publisher enabled : " + isConnectionQueryServiceMetricPublisherEnabled);
    }

    @SuppressWarnings(value={"EI_EXPOSE_STATIC_REP2"}, justification="Only used for testing")
    public static void setInstance(ConnectionQueryServicesMetricsManager metricsManager) {
        connectionQueryServicesMetricsManager = metricsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="Only used internally, not exposed to external client")
    public static ConnectionQueryServicesMetricsManager getInstance() {
        if (connectionQueryServicesMetricsManager != null) return connectionQueryServicesMetricsManager;
        Class<ConnectionQueryServicesMetricsManager> clazz = ConnectionQueryServicesMetricsManager.class;
        synchronized (ConnectionQueryServicesMetricsManager.class) {
            if (connectionQueryServicesMetricsManager != null) return connectionQueryServicesMetricsManager;
            QueryServicesOptions options = QueryServicesOptions.withDefaults();
            if (!options.isConnectionQueryServiceMetricsEnabled()) {
                connectionQueryServicesMetricsManager = NoOpConnectionQueryServicesMetricsManager.NO_OP_CONN_QUERY_SERVICES_METRICS_MANAGER;
                LOGGER.info("Created object for NoOp Connection query service metrics manager");
                // ** MonitorExit[var0] (shouldn't be in output)
                return connectionQueryServicesMetricsManager;
            }
            connectionQueryServicesMetricsManager = new ConnectionQueryServicesMetricsManager(options);
            LOGGER.info("Created object for Connection query service metrics manager");
            ConnectionQueryServicesMetricsManager.registerMetricsPublisher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectionQueryServicesMetricsManager;
        }
    }

    ConnectionQueryServicesMetricsManager() {
    }

    public static void registerMetricsPublisher() {
        if (isConnectionQueryServiceMetricPublisherEnabled) {
            String className = options.getConnectionQueryServiceMetricsPublisherClass();
            if (className != null) {
                MetricServiceResolver mResolver = new MetricServiceResolver();
                LOGGER.info("Connection query service metrics publisher className " + className);
                try {
                    mPublisher = mResolver.instantiate(className);
                    mPublisher.registerMetricProvider();
                }
                catch (Throwable e) {
                    LOGGER.error("The exception from metric publish Function", e);
                }
            } else {
                LOGGER.warn("Connection query service metrics publisher className can't be null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ConnectionQueryServicesMetrics getConnectionQueryServiceMetricsInstance(String connectionQueryServiceName) {
        if (Strings.isNullOrEmpty((String)connectionQueryServiceName)) {
            LOGGER.warn("Connection query service Name can't be null or empty");
            return null;
        }
        ConnectionQueryServicesMetrics cqsInstance = (ConnectionQueryServicesMetrics)connectionQueryServiceMetricsMapping.get(connectionQueryServiceName);
        if (cqsInstance != null) return cqsInstance;
        Class<ConnectionQueryServicesMetricsManager> clazz = ConnectionQueryServicesMetricsManager.class;
        synchronized (ConnectionQueryServicesMetricsManager.class) {
            cqsInstance = (ConnectionQueryServicesMetrics)connectionQueryServiceMetricsMapping.get(connectionQueryServiceName);
            if (cqsInstance != null) return cqsInstance;
            LOGGER.info("Creating connection query service metrics object for : " + connectionQueryServiceName);
            cqsInstance = new ConnectionQueryServicesMetrics(connectionQueryServiceName, options.getConfiguration());
            connectionQueryServiceMetricsMapping.put(connectionQueryServiceName, cqsInstance);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cqsInstance;
        }
    }

    void updateMetricsValue(String connectionQueryServiceName, MetricType type, long value) {
        long startTime = EnvironmentEdgeManager.currentTime();
        ConnectionQueryServicesMetrics cqsInstance = this.getConnectionQueryServiceMetricsInstance(connectionQueryServiceName);
        if (cqsInstance == null) {
            return;
        }
        cqsInstance.setMetricValue(type, value);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Connection query service metrics completed updating metric " + type + " to value " + value + ", timetaken = " + (EnvironmentEdgeManager.currentTime() - startTime));
        }
    }

    public static void updateMetrics(String connectionQueryServiceName, MetricType type, long value) {
        try {
            ConnectionQueryServicesMetricsManager.getInstance().updateMetricsValue(connectionQueryServiceName, type, value);
        }
        catch (Exception e) {
            LOGGER.error("Failed updating connection query service metrics", (Throwable)e);
        }
    }

    public static Map<String, List<ConnectionQueryServicesMetric>> getAllConnectionQueryServicesMetrics() {
        return ConnectionQueryServicesMetricsManager.getInstance().getConnectionQueryServicesMetrics();
    }

    Map<String, List<ConnectionQueryServicesMetric>> getConnectionQueryServicesMetrics() {
        try {
            long startTime = EnvironmentEdgeManager.currentTime();
            HashMap<String, List<ConnectionQueryServicesMetric>> map = new HashMap<String, List<ConnectionQueryServicesMetric>>();
            for (Map.Entry entry : connectionQueryServiceMetricsMapping.entrySet()) {
                map.put((String)entry.getKey(), ((ConnectionQueryServicesMetrics)entry.getValue()).getAllMetrics());
            }
            long timeTakenForMetricConversion = EnvironmentEdgeManager.currentTime() - startTime;
            LOGGER.info("Connection query service metrics fetching complete, timeTaken: " + timeTakenForMetricConversion);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("Failed retrieving connection query service Metrics", (Throwable)e);
            return null;
        }
    }

    public static Map<String, List<HistogramDistribution>> getHistogramsForAllConnectionQueryServices() {
        return ConnectionQueryServicesMetricsManager.getInstance().getHistogramsForConnectionQueryServices();
    }

    Map<String, List<HistogramDistribution>> getHistogramsForConnectionQueryServices() {
        HashMap<String, List<HistogramDistribution>> map = new HashMap<String, List<HistogramDistribution>>();
        for (Map.Entry entry : connectionQueryServiceMetricsMapping.entrySet()) {
            ConnectionQueryServicesMetricsHistograms connectionQueryServiceHistogramsHistograms = ((ConnectionQueryServicesMetrics)entry.getValue()).getConnectionQueryServiceHistograms();
            map.put((String)entry.getKey(), connectionQueryServiceHistogramsHistograms.getConnectionQueryServicesHistogramsDistribution());
        }
        return map;
    }

    public static void updateConnectionQueryServiceOpenConnectionHistogram(long connCount, String connectionQueryServiceName) {
        ConnectionQueryServicesMetrics metrics = ConnectionQueryServicesMetricsManager.getInstance().getConnectionQueryServiceMetricsInstance(connectionQueryServiceName);
        if (metrics == null) {
            return;
        }
        metrics.getConnectionQueryServiceHistograms().getConnectionQueryServicesOpenConnHisto().add(connCount);
    }

    public static void updateConnectionQueryServiceOpenInternalConnectionHistogram(long connCount, String connectionQueryServiceName) {
        ConnectionQueryServicesMetrics metrics = ConnectionQueryServicesMetricsManager.getInstance().getConnectionQueryServiceMetricsInstance(connectionQueryServiceName);
        if (metrics == null) {
            return;
        }
        metrics.getConnectionQueryServiceHistograms().getConnectionQueryServicesInternalOpenConnHisto().add(connCount);
    }

    public static ConnectionQueryServicesHistogram getConnectionQueryServiceOpenInternalConnectionHistogram(String connectionQueryServiceName) {
        ConnectionQueryServicesMetrics metrics = ConnectionQueryServicesMetricsManager.getInstance().getConnectionQueryServiceMetricsInstance(connectionQueryServiceName);
        if (metrics == null) {
            return null;
        }
        return metrics.getConnectionQueryServiceHistograms().getConnectionQueryServicesInternalOpenConnHisto();
    }

    public static ConnectionQueryServicesHistogram getConnectionQueryServiceOpenConnectionHistogram(String connectionQueryServiceName) {
        ConnectionQueryServicesMetrics metrics = ConnectionQueryServicesMetricsManager.getInstance().getConnectionQueryServiceMetricsInstance(connectionQueryServiceName);
        if (metrics == null) {
            return null;
        }
        return metrics.getConnectionQueryServiceHistograms().getConnectionQueryServicesOpenConnHisto();
    }

    void clearConnectionQueryServiceMetrics() {
        if (connectionQueryServiceMetricsMapping != null) {
            connectionQueryServiceMetricsMapping.clear();
        }
        LOGGER.info("Connection query service metrics clearing complete");
    }

    public static void clearAllConnectionQueryServiceMetrics() {
        try {
            ConnectionQueryServicesMetricsManager.getInstance().clearConnectionQueryServiceMetrics();
        }
        catch (Exception e) {
            LOGGER.error("Failed resetting connection query service Metrics", (Throwable)e);
        }
    }

    static {
        connectionQueryServicesMetricsManager = null;
        mPublisher = null;
    }
}

