/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesHistogram;

public class ConnectionQueryServicesMetricsHistograms {
    private String connectionQueryServicesName;
    private ConnectionQueryServicesHistogram connectionQueryServiceOpenInternalSizeHistogram;
    private ConnectionQueryServicesHistogram connectionQueryServicesOpenConnSizeHistogram;

    public ConnectionQueryServicesMetricsHistograms(String connectionQueryServiceName, Configuration conf) {
        this.connectionQueryServicesName = connectionQueryServiceName;
        this.connectionQueryServiceOpenInternalSizeHistogram = new ConnectionQueryServicesHistogram("PhoenixInternalOpenConn", "histogram for number of open internal phoenix connections", conf);
        this.connectionQueryServicesOpenConnSizeHistogram = new ConnectionQueryServicesHistogram("PhoenixOpenConn", "histogram for number of open phoenix connections", conf);
    }

    public String getConnectionQueryServicesName() {
        return this.connectionQueryServicesName;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="It's only used in internally for metrics storage")
    public ConnectionQueryServicesHistogram getConnectionQueryServicesInternalOpenConnHisto() {
        return this.connectionQueryServiceOpenInternalSizeHistogram;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="It's only used in internally for metrics storage")
    public ConnectionQueryServicesHistogram getConnectionQueryServicesOpenConnHisto() {
        return this.connectionQueryServicesOpenConnSizeHistogram;
    }

    public List<HistogramDistribution> getConnectionQueryServicesHistogramsDistribution() {
        ArrayList<HistogramDistribution> list = new ArrayList<HistogramDistribution>(Arrays.asList(this.connectionQueryServiceOpenInternalSizeHistogram.getRangeHistogramDistribution(), this.connectionQueryServicesOpenConnSizeHistogram.getRangeHistogramDistribution()));
        return Collections.unmodifiableList(list);
    }
}

