/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.HdrHistogram.Histogram;
import org.apache.phoenix.monitoring.PercentileHistogram;

class UtilizationHistogram
extends PercentileHistogram {
    UtilizationHistogram(long maxUtil, String name) {
        super(maxUtil, name);
    }

    @Override
    protected Map<String, Long> generateDistributionMap(Histogram snapshot) {
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        metrics.put("_num_ops", snapshot.getTotalCount());
        metrics.put("_min", snapshot.getMinValue());
        metrics.put("_max", snapshot.getMaxValue());
        metrics.put("_25th_percentile", snapshot.getValueAtPercentile(25.0));
        metrics.put("_median", snapshot.getValueAtPercentile(50.0));
        metrics.put("_75th_percentile", snapshot.getValueAtPercentile(75.0));
        metrics.put("_90th_percentile", snapshot.getValueAtPercentile(90.0));
        metrics.put("_95th_percentile", snapshot.getValueAtPercentile(95.0));
        return metrics;
    }
}

