/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.LatencyHistogram;
import org.apache.phoenix.monitoring.SizeHistogram;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;

public class TableHistograms {
    private String tableName;
    private LatencyHistogram queryLatencyHisto;
    private SizeHistogram querySizeHisto;
    private LatencyHistogram upsertLatencyHisto;
    private SizeHistogram upsertSizeHisto;
    private LatencyHistogram deleteLatencyHisto;
    private SizeHistogram deleteSizeHisto;
    private LatencyHistogram pointLookupLatencyHisto;
    private SizeHistogram pointLookupSizeHisto;
    private LatencyHistogram rangeScanLatencyHisto;
    private SizeHistogram rangeScanSizeHisto;

    public TableHistograms(String tableName, Configuration conf) {
        this.tableName = tableName;
        this.queryLatencyHisto = new LatencyHistogram("QueryTime", "Query time latency", conf);
        this.querySizeHisto = new SizeHistogram("QuerySize", "Query size", conf);
        this.upsertLatencyHisto = new LatencyHistogram("UpsertTime", "Upsert time latency", conf);
        this.upsertSizeHisto = new SizeHistogram("UpsertSize", "Upsert size", conf);
        this.deleteLatencyHisto = new LatencyHistogram("DeleteTime", "Delete time latency", conf);
        this.deleteSizeHisto = new SizeHistogram("DeleteSize", "Delete size", conf);
        this.pointLookupLatencyHisto = new LatencyHistogram("PointLookupTime", "Point Lookup Query time latency", conf);
        this.pointLookupSizeHisto = new SizeHistogram("PointLookupSize", "Point Lookup Query Size", conf);
        this.rangeScanLatencyHisto = new LatencyHistogram("RangeScanTime", "Range Scan Query time latency", conf);
        this.rangeScanSizeHisto = new SizeHistogram("RangeScanSize", "Range Scan Query size", conf);
    }

    public String getTableName() {
        return this.tableName;
    }

    public LatencyHistogram getQueryLatencyHisto() {
        return this.queryLatencyHisto;
    }

    public SizeHistogram getQuerySizeHisto() {
        return this.querySizeHisto;
    }

    public LatencyHistogram getPointLookupLatencyHisto() {
        return this.pointLookupLatencyHisto;
    }

    public SizeHistogram getPointLookupSizeHisto() {
        return this.pointLookupSizeHisto;
    }

    public LatencyHistogram getRangeScanLatencyHisto() {
        return this.rangeScanLatencyHisto;
    }

    public SizeHistogram getRangeScanSizeHisto() {
        return this.rangeScanSizeHisto;
    }

    public LatencyHistogram getUpsertLatencyHisto() {
        return this.upsertLatencyHisto;
    }

    public SizeHistogram getUpsertSizeHisto() {
        return this.upsertSizeHisto;
    }

    public LatencyHistogram getDeleteLatencyHisto() {
        return this.deleteLatencyHisto;
    }

    public SizeHistogram getDeleteSizeHisto() {
        return this.deleteSizeHisto;
    }

    public List<HistogramDistribution> getTableLatencyHistogramsDistribution() {
        return ImmutableList.of((Object)this.queryLatencyHisto.getRangeHistogramDistribution(), (Object)this.upsertLatencyHisto.getRangeHistogramDistribution(), (Object)this.deleteLatencyHisto.getRangeHistogramDistribution(), (Object)this.pointLookupLatencyHisto.getRangeHistogramDistribution(), (Object)this.rangeScanLatencyHisto.getRangeHistogramDistribution());
    }

    public List<HistogramDistribution> getTableSizeHistogramsDistribution() {
        return ImmutableList.of((Object)this.querySizeHisto.getRangeHistogramDistribution(), (Object)this.upsertSizeHisto.getRangeHistogramDistribution(), (Object)this.deleteSizeHisto.getRangeHistogramDistribution(), (Object)this.pointLookupSizeHisto.getRangeHistogramDistribution(), (Object)this.rangeScanSizeHisto.getRangeHistogramDistribution());
    }
}

