/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.PhoenixTableMetric;
import org.apache.phoenix.monitoring.PhoenixTableMetricImpl;
import org.apache.phoenix.monitoring.TableHistograms;

public class TableClientMetrics {
    private final String tableName;
    private Map<MetricType, PhoenixTableMetric> metricRegister;
    private TableHistograms tableHistograms;

    public TableClientMetrics(String tableName, Configuration conf) {
        this.tableName = tableName;
        this.metricRegister = new HashMap<MetricType, PhoenixTableMetric>();
        for (TableMetrics tableMetric : TableMetrics.values()) {
            tableMetric.metric = new PhoenixTableMetricImpl(tableMetric.metricType);
            this.metricRegister.put(tableMetric.metricType, tableMetric.metric);
        }
        this.tableHistograms = new TableHistograms(tableName, conf);
    }

    public void changeMetricValue(MetricType type, long val) {
        if (!this.metricRegister.containsKey((Object)type)) {
            return;
        }
        PhoenixTableMetric metric = this.metricRegister.get((Object)type);
        metric.change(val);
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<PhoenixTableMetric> getMetricMap() {
        ArrayList<PhoenixTableMetric> metricsList = new ArrayList<PhoenixTableMetric>();
        for (PhoenixTableMetric value : this.metricRegister.values()) {
            metricsList.add(value);
        }
        return metricsList;
    }

    public Map<MetricType, PhoenixTableMetric> getMetricRegistry() {
        return this.metricRegister;
    }

    public TableHistograms getTableHistograms() {
        return this.tableHistograms;
    }

    public static enum TableMetrics {
        TABLE_MUTATION_BATCH_FAILED_SIZE(MetricType.MUTATION_BATCH_FAILED_SIZE),
        TABLE_MUTATION_BATCH_SIZE(MetricType.MUTATION_BATCH_SIZE),
        TABLE_MUTATION_BYTES(MetricType.MUTATION_BYTES),
        TABLE_UPSERT_MUTATION_BYTES(MetricType.UPSERT_MUTATION_BYTES),
        TABLE_UPSERT_MUTATION_SQL_COUNTER(MetricType.UPSERT_MUTATION_SQL_COUNTER),
        TABLE_DELETE_MUTATION_BYTES(MetricType.DELETE_MUTATION_BYTES),
        TABLE_DELETE_MUTATION_SQL_COUNTER(MetricType.DELETE_MUTATION_SQL_COUNTER),
        TABLE_MUTATION_SQL_COUNTER(MetricType.MUTATION_SQL_COUNTER),
        TABLE_MUTATION_COMMIT_TIME(MetricType.MUTATION_COMMIT_TIME),
        TABLE_UPSERT_SQL_COUNTER(MetricType.UPSERT_SQL_COUNTER),
        TABLE_UPSERT_SQL_QUERY_TIME(MetricType.UPSERT_SQL_QUERY_TIME),
        TABLE_SUCCESS_UPSERT_SQL_COUNTER(MetricType.UPSERT_SUCCESS_SQL_COUNTER),
        TABLE_FAILED_UPSERT_SQL_COUNTER(MetricType.UPSERT_FAILED_SQL_COUNTER),
        TABLE_UPSERT_BATCH_FAILED_SIZE(MetricType.UPSERT_BATCH_FAILED_SIZE),
        TABLE_UPSERT_BATCH_FAILED_COUNTER(MetricType.UPSERT_BATCH_FAILED_COUNTER),
        TABLE_DELETE_SQL_COUNTER(MetricType.DELETE_SQL_COUNTER),
        TABLE_DELETE_SQL_QUERY_TIME(MetricType.DELETE_SQL_QUERY_TIME),
        TABLE_SUCCESS_DELETE_SQL_COUNTER(MetricType.DELETE_SUCCESS_SQL_COUNTER),
        TABLE_FAILED_DELETE_SQL_COUNTER(MetricType.DELETE_FAILED_SQL_COUNTER),
        TABLE_DELETE_BATCH_FAILED_SIZE(MetricType.DELETE_BATCH_FAILED_SIZE),
        TABLE_DELETE_BATCH_FAILED_COUNTER(MetricType.DELETE_BATCH_FAILED_COUNTER),
        TABLE_UPSERT_COMMIT_TIME(MetricType.UPSERT_COMMIT_TIME),
        TABLE_DELETE_COMMIT_TIME(MetricType.DELETE_COMMIT_TIME),
        TABLE_TASK_END_TO_END_TIME(MetricType.TASK_END_TO_END_TIME),
        TABLE_COUNT_ROWS_SCANNED(MetricType.COUNT_ROWS_SCANNED),
        TABLE_QUERY_FAILED_COUNTER(MetricType.QUERY_FAILED_COUNTER),
        TABLE_QUERY_POINTLOOKUP_FAILED_COUNTER(MetricType.QUERY_POINTLOOKUP_FAILED_COUNTER),
        TABLE_QUERY_SCAN_FAILED_COUNTER(MetricType.QUERY_SCAN_FAILED_COUNTER),
        TABLE_QUERY_TIMEOUT_COUNTER(MetricType.QUERY_TIMEOUT_COUNTER),
        TABLE_QUERY_POINTLOOKUP_TIMEOUT_COUNTER(MetricType.QUERY_POINTLOOKUP_TIMEOUT_COUNTER),
        TABLE_QUERY_SCAN_TIMEOUT_COUNTER(MetricType.QUERY_SCAN_TIMEOUT_COUNTER),
        TABLE_SELECT_QUERY_RESULT_SET_MS(MetricType.RESULT_SET_TIME_MS),
        TABLE_SCANBYTES(MetricType.SCAN_BYTES),
        TABLE_SELECT_SQL_COUNTER(MetricType.SELECT_SQL_COUNTER),
        TABLE_SELECT_SQL_QUERY_TIME(MetricType.SELECT_SQL_QUERY_TIME),
        TABLE_SUCCESS_SELECT_SQL_COUNTER(MetricType.SELECT_SUCCESS_SQL_COUNTER),
        TABLE_FAILED_SELECT_SQL_COUNTER(MetricType.SELECT_FAILED_SQL_COUNTER),
        TABLE_SELECT_POINTLOOKUP_COUNTER_SUCCESS(MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER),
        TABLE_SELECT_POINTLOOKUP_COUNTER_FAILED(MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER),
        TABLE_SELECT_SCAN_COUNTER_SUCCESS(MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER),
        TABLE_SELECT_SCAN_COUNTER_FAILED(MetricType.SELECT_SCAN_FAILED_SQL_COUNTER),
        TABLE_UPSERT_AGGREGATE_SUCCESS_SQL_COUNTER(MetricType.UPSERT_AGGREGATE_SUCCESS_SQL_COUNTER),
        TABLE_UPSERT_AGGREGATE_FAILURE_SQL_COUNTER(MetricType.UPSERT_AGGREGATE_FAILURE_SQL_COUNTER),
        TABLE_DELETE_AGGREGATE_SUCCESS_SQL_COUNTER(MetricType.DELETE_AGGREGATE_SUCCESS_SQL_COUNTER),
        TABLE_DELETE_AGGREGATE_FAILURE_SQL_COUNTER(MetricType.DELETE_AGGREGATE_FAILURE_SQL_COUNTER),
        TABLE_SELECT_AGGREGATE_SUCCESS_SQL_COUNTER(MetricType.SELECT_AGGREGATE_SUCCESS_SQL_COUNTER),
        TABLE_SELECT_AGGREGATE_FAILURE_SQL_COUNTER(MetricType.SELECT_AGGREGATE_FAILURE_SQL_COUNTER),
        TABLE_ATOMIC_UPSERT_SQL_COUNTER(MetricType.ATOMIC_UPSERT_SQL_COUNTER),
        TABLE_ATOMIC_UPSERT_COMMIT_TIME(MetricType.ATOMIC_UPSERT_COMMIT_TIME),
        TABLE_ATOMIC_UPSERT_SQL_QUERY_TIME(MetricType.ATOMIC_UPSERT_SQL_QUERY_TIME),
        TABLE_NUM_SYSTEM_TABLE_RPC_SUCCESS(MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS),
        TABLE_NUM_SYSTEM_TABLE_RPC_FAILURES(MetricType.NUM_SYSTEM_TABLE_RPC_FAILURES),
        TABLE_NUM_METADATA_LOOKUP_FAILURES(MetricType.NUM_METADATA_LOOKUP_FAILURES),
        TABLE_TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS(MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS),
        TABLE_MUTATION_BATCH_SUCCESS_COUNTER(MetricType.MUTATION_BATCH_COUNTER);

        private MetricType metricType;
        private PhoenixTableMetric metric;

        private TableMetrics(MetricType metricType) {
            this.metricType = metricType;
        }
    }
}

