/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.PercentileHistogramDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PercentileHistogram {
    private static final Logger LOGGER = LoggerFactory.getLogger(PercentileHistogram.class);
    static final String NUM_OPS_METRIC_NAME = "_num_ops";
    static final String MIN_METRIC_NAME = "_min";
    static final String MAX_METRIC_NAME = "_max";
    static final String MEDIAN_METRIC_NAME = "_median";
    static final String TWENTY_FIFTH_PERCENTILE_METRIC_NAME = "_25th_percentile";
    static final String SEVENTY_FIFTH_PERCENTILE_METRIC_NAME = "_75th_percentile";
    static final String NINETIETH_PERCENTILE_METRIC_NAME = "_90th_percentile";
    static final String NINETY_FIFTH_PERCENTILE_METRIC_NAME = "_95th_percentile";
    private Histogram prevHistogram = null;
    private final Recorder recorder;
    private final String name;
    private final long maxUtil;
    private Map<String, String> tags = null;

    PercentileHistogram(long maxUtil, String name) {
        this.name = name;
        this.maxUtil = maxUtil;
        this.recorder = new Recorder(maxUtil, 2);
    }

    void addValue(long value) {
        if (value > this.maxUtil) {
            LOGGER.warn("Histogram recording higher value than maximum. Ignoring it.");
            return;
        }
        this.recorder.recordValue(value);
    }

    HistogramDistribution getPercentileHistogramDistribution() {
        Histogram histogram = this.recorder.getIntervalHistogram(this.prevHistogram);
        PercentileHistogramDistribution distribution = this.tags == null ? new PercentileHistogramDistribution(this.name, histogram.getMinValue(), histogram.getMaxValue(), histogram.getTotalCount(), this.generateDistributionMap(histogram)) : new PercentileHistogramDistribution(this.name, histogram.getMinValue(), histogram.getMaxValue(), histogram.getTotalCount(), this.generateDistributionMap(histogram), this.tags);
        this.prevHistogram = histogram;
        return distribution;
    }

    void addTag(String key, String value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, value);
    }

    protected abstract Map<String, Long> generateDistributionMap(Histogram var1);
}

