/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.MetricUtil;
import org.apache.phoenix.monitoring.MetricsStopWatch;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public class OverAllQueryMetrics {
    private final MetricsStopWatch queryWatch;
    private final MetricsStopWatch resultSetWatch;
    private final CombinableMetric numParallelScans;
    private final CombinableMetric wallClockTimeMS;
    private final CombinableMetric resultSetTimeMS;
    private final CombinableMetric queryCompilerTimeMS;
    private final CombinableMetric queryOptimizerTimeMS;
    private final CombinableMetric queryResultItrSetTimeMS;
    private final CombinableMetric queryTimedOut;
    private final CombinableMetric queryPointLookupTimedOut;
    private final CombinableMetric queryScanTimedOut;
    private final CombinableMetric queryFailed;
    private final CombinableMetric queryPointLookupFailed;
    private final CombinableMetric queryScanFailed;
    private final CombinableMetric cacheRefreshedDueToSplits;
    private final CombinableMetric queryParsingTimeMS;

    public OverAllQueryMetrics(boolean isRequestMetricsEnabled, LogLevel connectionLogLevel) {
        this.queryWatch = MetricUtil.getMetricsStopWatch(isRequestMetricsEnabled, connectionLogLevel, MetricType.WALL_CLOCK_TIME_MS);
        this.resultSetWatch = MetricUtil.getMetricsStopWatch(isRequestMetricsEnabled, connectionLogLevel, MetricType.RESULT_SET_TIME_MS);
        this.queryCompilerTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_COMPILER_TIME_MS);
        this.queryOptimizerTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_OPTIMIZER_TIME_MS);
        this.queryResultItrSetTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_RESULT_ITR_TIME_MS);
        this.numParallelScans = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.NUM_PARALLEL_SCANS);
        this.wallClockTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.WALL_CLOCK_TIME_MS);
        this.resultSetTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.RESULT_SET_TIME_MS);
        this.queryTimedOut = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_TIMEOUT_COUNTER);
        this.queryPointLookupTimedOut = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_POINTLOOKUP_TIMEOUT_COUNTER);
        this.queryScanTimedOut = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_SCAN_TIMEOUT_COUNTER);
        this.queryFailed = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_FAILED_COUNTER);
        this.queryPointLookupFailed = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_POINTLOOKUP_FAILED_COUNTER);
        this.queryScanFailed = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_SCAN_FAILED_COUNTER);
        this.cacheRefreshedDueToSplits = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.CACHE_REFRESH_SPLITS_COUNTER);
        this.queryParsingTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.SQL_QUERY_PARSING_TIME_MS);
    }

    public void updateNumParallelScans(long numParallelScans) {
        this.numParallelScans.change(numParallelScans);
    }

    public void queryTimedOut() {
        this.queryTimedOut.increment();
    }

    public void queryPointLookupTimedOut() {
        this.queryPointLookupTimedOut.increment();
    }

    public void queryScanTimedOut() {
        this.queryScanTimedOut.increment();
    }

    public void queryFailed() {
        this.queryFailed.increment();
    }

    public void queryPointLookupFailed() {
        this.queryPointLookupFailed.increment();
    }

    public void queryScanFailed() {
        this.queryScanFailed.increment();
    }

    public void cacheRefreshedDueToSplits() {
        this.cacheRefreshedDueToSplits.increment();
    }

    public void setQueryCompilerTimeMS(long time) {
        this.queryCompilerTimeMS.set(time);
    }

    public void setQueryOptimizerTimeMS(long time) {
        this.queryOptimizerTimeMS.set(time);
    }

    public void setQueryResultItrTimeMS(long time) {
        this.queryResultItrSetTimeMS.set(time);
    }

    public void startQuery() {
        if (!this.queryWatch.isRunning()) {
            this.queryWatch.start();
        }
    }

    public void endQuery() {
        boolean wasRunning = this.queryWatch.isRunning();
        this.queryWatch.stop();
        if (wasRunning) {
            this.wallClockTimeMS.change(this.queryWatch.getElapsedTimeInMs());
        }
    }

    public void startResultSetWatch() {
        this.resultSetWatch.start();
    }

    public void stopResultSetWatch() {
        boolean wasRunning = this.resultSetWatch.isRunning();
        this.resultSetWatch.stop();
        if (wasRunning) {
            this.resultSetTimeMS.change(this.resultSetWatch.getElapsedTimeInMs());
        }
    }

    @VisibleForTesting
    long getWallClockTimeMs() {
        return this.wallClockTimeMS.getValue();
    }

    @VisibleForTesting
    long getResultSetTimeMs() {
        return this.resultSetTimeMS.getValue();
    }

    public void setQueryParsingTimeMS(long time) {
        this.queryParsingTimeMS.set(time);
    }

    public Map<MetricType, Long> publish() {
        HashMap<MetricType, Long> metricsForPublish = new HashMap<MetricType, Long>();
        metricsForPublish.put(this.numParallelScans.getMetricType(), this.numParallelScans.getValue());
        metricsForPublish.put(this.wallClockTimeMS.getMetricType(), this.wallClockTimeMS.getValue());
        metricsForPublish.put(this.resultSetTimeMS.getMetricType(), this.resultSetTimeMS.getValue());
        metricsForPublish.put(this.queryCompilerTimeMS.getMetricType(), this.queryCompilerTimeMS.getValue());
        metricsForPublish.put(this.queryOptimizerTimeMS.getMetricType(), this.queryOptimizerTimeMS.getValue());
        metricsForPublish.put(this.queryResultItrSetTimeMS.getMetricType(), this.queryResultItrSetTimeMS.getValue());
        metricsForPublish.put(this.queryTimedOut.getMetricType(), this.queryTimedOut.getValue());
        metricsForPublish.put(this.queryPointLookupTimedOut.getMetricType(), this.queryPointLookupTimedOut.getValue());
        metricsForPublish.put(this.queryScanTimedOut.getMetricType(), this.queryScanTimedOut.getValue());
        metricsForPublish.put(this.queryFailed.getMetricType(), this.queryFailed.getValue());
        metricsForPublish.put(this.queryPointLookupFailed.getMetricType(), this.queryPointLookupFailed.getValue());
        metricsForPublish.put(this.queryScanFailed.getMetricType(), this.queryScanFailed.getValue());
        metricsForPublish.put(this.cacheRefreshedDueToSplits.getMetricType(), this.cacheRefreshedDueToSplits.getValue());
        metricsForPublish.put(this.queryParsingTimeMS.getMetricType(), this.queryParsingTimeMS.getValue());
        return metricsForPublish;
    }

    public void reset() {
        this.numParallelScans.reset();
        this.wallClockTimeMS.reset();
        this.resultSetTimeMS.reset();
        this.queryCompilerTimeMS.reset();
        this.queryOptimizerTimeMS.reset();
        this.queryResultItrSetTimeMS.reset();
        this.queryTimedOut.reset();
        this.queryPointLookupTimedOut.reset();
        this.queryScanTimedOut.reset();
        this.queryFailed.reset();
        this.queryPointLookupFailed.reset();
        this.queryScanFailed.reset();
        this.cacheRefreshedDueToSplits.reset();
        this.queryParsingTimeMS.reset();
        this.queryWatch.stop();
        this.resultSetWatch.stop();
    }

    public OverAllQueryMetrics combine(OverAllQueryMetrics metric) {
        this.cacheRefreshedDueToSplits.combine(metric.cacheRefreshedDueToSplits);
        this.queryFailed.combine(metric.queryFailed);
        this.queryPointLookupFailed.combine(metric.queryPointLookupFailed);
        this.queryScanFailed.combine(metric.queryScanFailed);
        this.queryTimedOut.combine(metric.queryTimedOut);
        this.queryPointLookupTimedOut.combine(metric.queryPointLookupTimedOut);
        this.queryScanTimedOut.combine(metric.queryScanTimedOut);
        this.numParallelScans.combine(metric.numParallelScans);
        this.wallClockTimeMS.combine(metric.wallClockTimeMS);
        this.resultSetTimeMS.combine(metric.resultSetTimeMS);
        this.queryCompilerTimeMS.combine(this.queryCompilerTimeMS);
        this.queryOptimizerTimeMS.combine(this.queryOptimizerTimeMS);
        this.queryResultItrSetTimeMS.combine(this.queryResultItrSetTimeMS);
        this.queryParsingTimeMS.combine(metric.queryParsingTimeMS);
        return this;
    }
}

