/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;

class NonAtomicMetric
implements Metric {
    private final MetricType type;
    private long value;

    public NonAtomicMetric(MetricType type) {
        this.type = type;
    }

    @Override
    public MetricType getMetricType() {
        return this.type;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void change(long delta) {
        this.value += delta;
    }

    @Override
    public void increment() {
        ++this.value;
    }

    @Override
    public String getCurrentMetricState() {
        return this.type.shortName() + ": " + this.value;
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @Override
    public void set(long value) {
        this.value = value;
    }

    @Override
    public void decrement() {
        --this.value;
    }
}

