/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.MetricType;

public class MutationMetricQueue {
    private Map<String, MutationMetric> tableMutationMetric = new HashMap<String, MutationMetric>();

    public void addMetricsForTable(String tableName, MutationMetric metric) {
        MutationMetric tableMetric = this.tableMutationMetric.get(tableName);
        if (tableMetric == null) {
            this.tableMutationMetric.put(tableName, metric);
        } else {
            tableMetric.combineMetric(metric);
        }
    }

    public void combineMetricQueues(MutationMetricQueue other) {
        Map<String, MutationMetric> tableMetricMap = other.tableMutationMetric;
        for (Map.Entry<String, MutationMetric> entry : tableMetricMap.entrySet()) {
            this.addMetricsForTable(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Map<MetricType, Long>> aggregate() {
        HashMap<String, Map<MetricType, Long>> publishedMetrics = new HashMap<String, Map<MetricType, Long>>();
        for (Map.Entry<String, MutationMetric> entry : this.tableMutationMetric.entrySet()) {
            String tableName = entry.getKey();
            MutationMetric metric = entry.getValue();
            HashMap<MetricType, Long> publishedMetricsForTable = (HashMap<MetricType, Long>)publishedMetrics.get(tableName);
            if (publishedMetricsForTable == null) {
                publishedMetricsForTable = new HashMap<MetricType, Long>();
                publishedMetrics.put(tableName, publishedMetricsForTable);
            }
            publishedMetricsForTable.put(metric.getNumMutations().getMetricType(), metric.getNumMutations().getValue());
            publishedMetricsForTable.put(metric.getUpsertMutationsSizeBytes().getMetricType(), metric.getUpsertMutationsSizeBytes().getValue());
            publishedMetricsForTable.put(metric.getDeleteMutationsSizeBytes().getMetricType(), metric.getDeleteMutationsSizeBytes().getValue());
            publishedMetricsForTable.put(metric.getCommitTimeForMutations().getMetricType(), metric.getCommitTimeForMutations().getValue());
            publishedMetricsForTable.put(metric.getTotalCommitTimeForUpserts().getMetricType(), metric.getTotalCommitTimeForUpserts().getValue());
            publishedMetricsForTable.put(metric.getTotalCommitTimeForAtomicUpserts().getMetricType(), metric.getTotalCommitTimeForAtomicUpserts().getValue());
            publishedMetricsForTable.put(metric.getTotalCommitTimeForDeletes().getMetricType(), metric.getTotalCommitTimeForDeletes().getValue());
            publishedMetricsForTable.put(metric.getNumFailedMutations().getMetricType(), metric.getNumFailedMutations().getValue());
            publishedMetricsForTable.put(metric.getNumOfIndexCommitFailedMutations().getMetricType(), metric.getNumOfIndexCommitFailedMutations().getValue());
            publishedMetricsForTable.put(metric.getUpsertMutationSqlCounterSuccess().getMetricType(), metric.getUpsertMutationSqlCounterSuccess().getValue());
            publishedMetricsForTable.put(metric.getDeleteMutationSqlCounterSuccess().getMetricType(), metric.getDeleteMutationSqlCounterSuccess().getValue());
            publishedMetricsForTable.put(metric.getTotalMutationsSizeBytes().getMetricType(), metric.getTotalMutationsSizeBytes().getValue());
            publishedMetricsForTable.put(metric.getUpsertBatchFailedSize().getMetricType(), metric.getUpsertBatchFailedSize().getValue());
            publishedMetricsForTable.put(metric.getUpsertBatchFailedCounter().getMetricType(), metric.getUpsertBatchFailedCounter().getValue());
            publishedMetricsForTable.put(metric.getDeleteBatchFailedSize().getMetricType(), metric.getDeleteBatchFailedSize().getValue());
            publishedMetricsForTable.put(metric.getDeleteBatchFailedCounter().getMetricType(), metric.getDeleteBatchFailedCounter().getValue());
            publishedMetricsForTable.put(metric.getMutationBatchCounter().getMetricType(), metric.getMutationBatchCounter().getValue());
            publishedMetricsForTable.put(metric.getMutationQueryParsingTimeMS().getMetricType(), metric.getMutationQueryParsingTimeMS().getValue());
        }
        return publishedMetrics;
    }

    public void clearMetrics() {
        this.tableMutationMetric.clear();
    }

    public static class MutationMetric {
        private final CombinableMetric numMutations = new CombinableMetricImpl(MetricType.MUTATION_BATCH_SIZE);
        private final CombinableMetric totalMutationsSizeBytes = new CombinableMetricImpl(MetricType.MUTATION_BYTES);
        private final CombinableMetric totalCommitTimeForMutations = new CombinableMetricImpl(MetricType.MUTATION_COMMIT_TIME);
        private final CombinableMetric numFailedMutations = new CombinableMetricImpl(MetricType.MUTATION_BATCH_FAILED_SIZE);
        private final CombinableMetric totalCommitTimeForUpserts = new CombinableMetricImpl(MetricType.UPSERT_COMMIT_TIME);
        private final CombinableMetric totalCommitTimeForAtomicUpserts = new CombinableMetricImpl(MetricType.ATOMIC_UPSERT_COMMIT_TIME);
        private final CombinableMetric totalCommitTimeForDeletes = new CombinableMetricImpl(MetricType.DELETE_COMMIT_TIME);
        private final CombinableMetric upsertMutationsSizeBytes = new CombinableMetricImpl(MetricType.UPSERT_MUTATION_BYTES);
        private final CombinableMetric deleteMutationsSizeBytes = new CombinableMetricImpl(MetricType.DELETE_MUTATION_BYTES);
        private final CombinableMetric upsertMutationSqlCounterSuccess = new CombinableMetricImpl(MetricType.UPSERT_MUTATION_SQL_COUNTER);
        private final CombinableMetric deleteMutationSqlCounterSuccess = new CombinableMetricImpl(MetricType.DELETE_MUTATION_SQL_COUNTER);
        private final CombinableMetric upsertBatchFailedSize = new CombinableMetricImpl(MetricType.UPSERT_BATCH_FAILED_SIZE);
        private final CombinableMetric upsertBatchFailedCounter = new CombinableMetricImpl(MetricType.UPSERT_BATCH_FAILED_COUNTER);
        private final CombinableMetric deleteBatchFailedSize = new CombinableMetricImpl(MetricType.DELETE_BATCH_FAILED_SIZE);
        private final CombinableMetric deleteBatchFailedCounter = new CombinableMetricImpl(MetricType.DELETE_BATCH_FAILED_COUNTER);
        private final CombinableMetric mutationQueryParsingTimeMS = new CombinableMetricImpl(MetricType.SQL_QUERY_PARSING_TIME_MS);
        private final CombinableMetric numOfIndexCommitFailMutations = new CombinableMetricImpl(MetricType.INDEX_COMMIT_FAILURE_SIZE);
        private final CombinableMetric mutationBatchCounter = new CombinableMetricImpl(MetricType.MUTATION_BATCH_COUNTER);
        public static final MutationMetric EMPTY_METRIC = new MutationMetric(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);

        public MutationMetric(long numMutations, long upsertMutationsSizeBytes, long deleteMutationsSizeBytes, long commitTimeForUpserts, long commitTimeForAtomicUpserts, long commitTimeForDeletes, long numFailedMutations, long upsertMutationSqlCounterSuccess, long deleteMutationSqlCounterSuccess, long totalMutationBytes, long numOfPhase3Failed, long upsertBatchFailedSize, long upsertBatchFailedCounter, long deleteBatchFailedSize, long deleteBatchFailedCounter, long mutationBatchCounter, long mutationParsingTimeMS) {
            this.numMutations.change(numMutations);
            this.totalCommitTimeForUpserts.change(commitTimeForUpserts);
            this.totalCommitTimeForAtomicUpserts.change(commitTimeForAtomicUpserts);
            this.totalCommitTimeForDeletes.change(commitTimeForDeletes);
            this.totalCommitTimeForMutations.change(commitTimeForUpserts + commitTimeForDeletes);
            this.numFailedMutations.change(numFailedMutations);
            this.numOfIndexCommitFailMutations.change(numOfPhase3Failed);
            this.upsertMutationsSizeBytes.change(upsertMutationsSizeBytes);
            this.deleteMutationsSizeBytes.change(deleteMutationsSizeBytes);
            this.totalMutationsSizeBytes.change(totalMutationBytes);
            this.upsertMutationSqlCounterSuccess.change(upsertMutationSqlCounterSuccess);
            this.deleteMutationSqlCounterSuccess.change(deleteMutationSqlCounterSuccess);
            this.upsertBatchFailedSize.change(upsertBatchFailedSize);
            this.upsertBatchFailedCounter.change(upsertBatchFailedCounter);
            this.deleteBatchFailedSize.change(deleteBatchFailedSize);
            this.deleteBatchFailedCounter.change(deleteBatchFailedCounter);
            this.mutationBatchCounter.change(mutationBatchCounter);
            this.mutationQueryParsingTimeMS.change(mutationParsingTimeMS);
        }

        public CombinableMetric getTotalCommitTimeForUpserts() {
            return this.totalCommitTimeForUpserts;
        }

        public CombinableMetric getTotalCommitTimeForAtomicUpserts() {
            return this.totalCommitTimeForAtomicUpserts;
        }

        public CombinableMetric getTotalCommitTimeForDeletes() {
            return this.totalCommitTimeForDeletes;
        }

        public CombinableMetric getCommitTimeForMutations() {
            return this.totalCommitTimeForMutations;
        }

        public CombinableMetric getNumMutations() {
            return this.numMutations;
        }

        public CombinableMetric getTotalMutationsSizeBytes() {
            return this.totalMutationsSizeBytes;
        }

        public CombinableMetric getNumFailedMutations() {
            return this.numFailedMutations;
        }

        public CombinableMetric getNumOfIndexCommitFailedMutations() {
            return this.numOfIndexCommitFailMutations;
        }

        public CombinableMetric getUpsertMutationsSizeBytes() {
            return this.upsertMutationsSizeBytes;
        }

        public CombinableMetric getDeleteMutationsSizeBytes() {
            return this.deleteMutationsSizeBytes;
        }

        public CombinableMetric getUpsertMutationSqlCounterSuccess() {
            return this.upsertMutationSqlCounterSuccess;
        }

        public CombinableMetric getDeleteMutationSqlCounterSuccess() {
            return this.deleteMutationSqlCounterSuccess;
        }

        public CombinableMetric getUpsertBatchFailedSize() {
            return this.upsertBatchFailedSize;
        }

        public CombinableMetric getUpsertBatchFailedCounter() {
            return this.upsertBatchFailedCounter;
        }

        public CombinableMetric getDeleteBatchFailedSize() {
            return this.deleteBatchFailedSize;
        }

        public CombinableMetric getDeleteBatchFailedCounter() {
            return this.deleteBatchFailedCounter;
        }

        public CombinableMetric getMutationBatchCounter() {
            return this.mutationBatchCounter;
        }

        public CombinableMetric getMutationQueryParsingTimeMS() {
            return this.mutationQueryParsingTimeMS;
        }

        public void combineMetric(MutationMetric other) {
            this.numMutations.combine(other.numMutations);
            this.totalCommitTimeForUpserts.combine(other.totalCommitTimeForUpserts);
            this.totalCommitTimeForAtomicUpserts.combine(other.totalCommitTimeForAtomicUpserts);
            this.totalCommitTimeForDeletes.combine(other.totalCommitTimeForDeletes);
            this.totalCommitTimeForMutations.combine(other.totalCommitTimeForMutations);
            this.numFailedMutations.combine(other.numFailedMutations);
            this.numOfIndexCommitFailMutations.combine(other.numOfIndexCommitFailMutations);
            this.upsertMutationsSizeBytes.combine(other.upsertMutationsSizeBytes);
            this.deleteMutationsSizeBytes.combine(other.deleteMutationsSizeBytes);
            this.totalMutationsSizeBytes.combine(other.totalMutationsSizeBytes);
            this.upsertMutationSqlCounterSuccess.combine(other.upsertMutationSqlCounterSuccess);
            this.deleteMutationSqlCounterSuccess.combine(other.deleteMutationSqlCounterSuccess);
            this.upsertBatchFailedSize.combine(other.upsertBatchFailedSize);
            this.upsertBatchFailedCounter.combine(other.upsertBatchFailedCounter);
            this.deleteBatchFailedSize.combine(other.deleteBatchFailedSize);
            this.deleteBatchFailedCounter.combine(other.deleteBatchFailedCounter);
            this.mutationBatchCounter.combine(other.mutationBatchCounter);
            this.mutationQueryParsingTimeMS.combine(other.mutationQueryParsingTimeMS);
        }
    }

    public static class NoOpMutationMetricsQueue
    extends MutationMetricQueue {
        public static final NoOpMutationMetricsQueue NO_OP_MUTATION_METRICS_QUEUE = new NoOpMutationMetricsQueue();

        private NoOpMutationMetricsQueue() {
        }

        @Override
        public void addMetricsForTable(String tableName, MutationMetric metric) {
        }

        @Override
        public Map<String, Map<MetricType, Long>> aggregate() {
            return Collections.emptyMap();
        }
    }
}

